/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.filter;

import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentableClassManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentableClassManager");
    private final List<ClassLevelFilter> classFilter;
    private final List<String> mandatoryStructure;

    public InstrumentableClassManager(List<ClassLevelFilter> classFilter, List<String> mandatoryStructure) {
        this.mandatoryStructure = mandatoryStructure;
        this.classFilter = classFilter;
    }

    public boolean isInstrumentable(String name) {
        if (this.isMandatoryToBeInstrumented(name) || this.classFilter.stream().noneMatch(filter -> filter.filter(name))) {
            return true;
        }
        this.logExclusion(name);
        return false;
    }

    private boolean isMandatoryToBeInstrumented(String name) {
        return this.mandatoryStructure.contains(name);
    }

    private void logExclusion(String name) {
        logger.debug("excluded {} from instrumentation", (Object)name);
    }
}

