/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayLazyGridSensor
implements SensorGroup<MethodSensor> {
    private static final String LAZY_GRID_SOURCE = "androidx.compose.foundation.lazy.grid.LazyGridKt";
    private static final String LAZY_GRID_FUNCTION_NAME = "LazyGrid";
    private static final String LAZY_GRID_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/lazy/grid/LazyGridState;Landroidx/compose/foundation/lazy/grid/LazyGridSlotsProvider;Landroidx/compose/foundation/layout/PaddingValues;ZZLandroidx/compose/foundation/gestures/FlingBehavior;ZLandroidx/compose/foundation/layout/Arrangement$Vertical;Landroidx/compose/foundation/layout/Arrangement$Horizontal;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private static final String LAZY_GRID_DESCRIPTION_1_5 = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/lazy/grid/LazyGridState;Lkotlin/jvm/functions/Function2;Landroidx/compose/foundation/layout/PaddingValues;ZZLandroidx/compose/foundation/gestures/FlingBehavior;ZLandroidx/compose/foundation/layout/Arrangement$Vertical;Landroidx/compose/foundation/layout/Arrangement$Horizontal;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private static final String LAZY_GRID_DESCRIPTION_1_8 = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/lazy/grid/LazyGridState;Landroidx/compose/foundation/lazy/grid/LazyGridSlotsProvider;Landroidx/compose/foundation/layout/PaddingValues;ZZLandroidx/compose/foundation/gestures/FlingBehavior;ZLandroidx/compose/foundation/OverscrollEffect;Landroidx/compose/foundation/layout/Arrangement$Vertical;Landroidx/compose/foundation/layout/Arrangement$Horizontal;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private final String tableModifier;

    public SessionReplayLazyGridSensor(ClassResolver classResolver) {
        String composePackage = ComposeUi.getVersionPackage(classResolver);
        this.tableModifier = composePackage + "/model/DTTableModifier";
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return LAZY_GRID_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateLazyGridSensor(LAZY_GRID_DESCRIPTION), this.generateLazyGridSensor(LAZY_GRID_DESCRIPTION_1_5), this.generateLazyGridSensor(LAZY_GRID_DESCRIPTION_1_8));
    }

    private MethodSensor generateLazyGridSensor(String lazyGridDescription) {
        MethodInfo methodInfo = new MethodInfo(LAZY_GRID_FUNCTION_NAME, lazyGridDescription, 25, null, new ArrayList<String>());
        MethodTransformation lazyGridTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, this.tableModifier));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.tableModifier, "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, startParameterIndex));
        });
        return new MethodSensorImpl(methodInfo, lazyGridTransformation);
    }
}

