/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class AndroidComposeViewSensor
implements SensorGroup<MethodSensor> {
    private static final String ANDROID_COMPOSE_VIEW_SOURCE = "androidx.compose.ui.platform.AndroidComposeView";
    private static final String ON_ATTACH_FUNCTION_NAME = "onAttach";
    private static final String ON_ATTACH_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private static final String ON_DETACH_FUNCTION_NAME = "onDetach";
    private static final String ON_DETACH_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return ANDROID_COMPOSE_VIEW_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        ArrayList<MethodSensor> methodSensorList = new ArrayList<MethodSensor>();
        methodSensorList.add(this.generateOnAttachSensor());
        methodSensorList.add(this.generateOnDetachSensor());
        return methodSensorList;
    }

    private MethodSensor generateOnAttachSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_ATTACH_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.compose.userinteraction.UserInteractionsApi"), ON_ATTACH_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnDetachSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.compose.userinteraction.UserInteractionsApi"), ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }
}

