/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeAccessibilityNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeAccessibilityNodeTransformation_1_5;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeAccessibilityNodeTransformation_1_6;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeAccessibilityNodeTransformation_1_7;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeCheckboxTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeCombinedClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeCombinedClickTransformation_1_8;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeDependencyCheckerTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeNodeTransformation_1_5;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposePullRefreshTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeRangeSliderTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeSliderTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeSwipeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeToggleTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeToggleTransformation_1_7;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposeTriToggleTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUiVersion;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ComposeTransformFactory
implements TransformerFactory {
    private static final String CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String CLICK_FUNCTION_NAME = "clickable-O2vRcR0";
    private static final String CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMBINED_CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String COMBINED_CLICK_FUNCTION_NAME = "combinedClickable-XVZzFYc";
    private static final String COMBINED_CLICK_FUNCTION_NAME_1_8 = "combinedClickable-auXiCPI";
    private static final String COMBINED_CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMBINED_CLICK_DESCRIPTION_1_8 = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ZLkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String CHECKBOX_SOURCE = "androidx.compose.material.CheckboxKt";
    private static final String CHECKBOX_FUNCTION_NAME = "Checkbox";
    private static final String CHECKBOX_DESCRIPTION = "(ZLkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/material/CheckboxColors;Landroidx/compose/runtime/Composer;II)V";
    private static final String TOGGLE_SOURCE = "androidx.compose.foundation.selection.ToggleableKt";
    private static final String TRI_TOGGLE_FUNCTION_NAME = "triStateToggleable-O2vRcR0";
    private static final String TRI_TOGGLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/ui/state/ToggleableState;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String TOGGLE_FUNCTION_NAME = "toggleable-O2vRcR0";
    private static final String TOGGLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function1;)Landroidx/compose/ui/Modifier;";
    private static final String SWIPE_SOURCE = "androidx.compose.material.SwipeableState";
    private static final String SWIPE_FUNCTION_NAME = "performFling";
    private static final String SWIPE_DESCRIPTION = "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;";
    private static final String NODE_SOURCE = "androidx.compose.ui.node.BackwardsCompatNode";
    private static final String NODE_FUNCTION_NAME = "onPointerEvent-H0pRuoY";
    private static final String NODE_DESCRIPTION = "(Landroidx/compose/ui/input/pointer/PointerEvent;Landroidx/compose/ui/input/pointer/PointerEventPass;J)V";
    private static final String ACCESSIBILITY_NODE_SOURCE = "androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat";
    private static final String ACCESSIBILITY_NODE_FUNCTION_NAME = "performActionHelper";
    private static final String ACCESSIBILITY_NODE_DESCRIPTION = "(IILandroid/os/Bundle;)Z";
    private static final String DEPENDENCY_SOURCE = "com.dynatrace.android.agent.conf.ComposeDependencyChecker";
    private static final String DEPENDENCY_FUNCTION_NAME = "hasComposeDependency";
    private static final String DEPENDENCY_FUNCTION_DESCRIPTION = "()Z";
    private static final String SLIDER_SOURCE = "androidx.compose.material.SliderKt";
    private static final String SLIDER_FUNCTION_NAME = "Slider";
    private static final String SLIDER_DESCRIPTION = "(FLkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;ZLkotlin/ranges/ClosedFloatingPointRange;ILkotlin/jvm/functions/Function0;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/material/SliderColors;Landroidx/compose/runtime/Composer;II)V";
    private static final String RANGE_SLIDER_FUNCTION_NAME = "RangeSlider";
    private static final String RANGE_SLIDER_DESCRIPTION = "(Lkotlin/ranges/ClosedFloatingPointRange;Lkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;ZLkotlin/ranges/ClosedFloatingPointRange;ILkotlin/jvm/functions/Function0;Landroidx/compose/material/SliderColors;Landroidx/compose/runtime/Composer;II)V";
    private static final String PULL_REFRESH_SOURCE = "androidx.compose.material.pullrefresh.PullRefreshStateKt";
    private static final String PULL_REFRESH_FUNCTION_NAME = "rememberPullRefreshState-UuyPYSY";
    private static final String PULL_REFRESH_DESCRIPTION = "(ZLkotlin/jvm/functions/Function0;FFLandroidx/compose/runtime/Composer;II)Landroidx/compose/material/pullrefresh/PullRefreshState;";
    private static final String CLICKABLE_NODE_SOURCE = "androidx.compose.foundation.AbstractClickableNode";
    private static final String DRAGGABLE_NODE_SOURCE = "androidx.compose.foundation.gestures.DraggableNode";
    private final Sensors definedSensors;

    public ComposeTransformFactory(Sensors definedSensors) {
        this.definedSensors = definedSensors;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ComposeUiVersion composeUiVersion = ComposeUi.getVersion(classResolver);
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        if (this.definedSensors.composeClickable) {
            sensors.add(this.generateClickableSensor());
            if (composeUiVersion == ComposeUiVersion.V1_8) {
                sensors.add(this.generateCombinedClickableSensor_1_8());
            }
            sensors.add(this.generateCombinedClickableSensor());
            sensors.add(this.generateCheckboxSensor(composeUiVersion));
            sensors.add(this.generateTriToggleableSensor(composeUiVersion));
            sensors.add(this.generateToggleableSensor(composeUiVersion));
        }
        if (this.definedSensors.composeSwipeable) {
            sensors.add(this.generateSwipeableSensor(this.definedSensors.composeSemantics));
        }
        if (this.definedSensors.composeSemantics) {
            if (composeUiVersion == ComposeUiVersion.V1_7 || composeUiVersion == ComposeUiVersion.V1_8) {
                sensors.add(this.generateAccessibilitySemanticsNodeSensor_1_7());
                sensors.add(this.generateClickableSemanticsNodeSensor());
                sensors.add(this.generateDraggableSemanticsNodeSensor());
            } else if (composeUiVersion == ComposeUiVersion.V1_6) {
                sensors.add(this.generateAccessibilitySemanticsNodeSensor_1_6());
                sensors.add(this.generateClickableSemanticsNodeSensor());
                sensors.add(this.generateDraggableSemanticsNodeSensor());
            } else if (composeUiVersion == ComposeUiVersion.V1_4) {
                sensors.add(this.generateAccessibilitySemanticsNodeSensor_1_4());
                sensors.add(this.generateSemanticsNodeSensor());
            } else if (composeUiVersion == ComposeUiVersion.V1_5) {
                sensors.add(this.generateAccessibilitySemanticsNodeSensor_1_5());
                sensors.add(this.generateClickableSemanticsNodeSensor());
                sensors.add(this.generateDraggableSemanticsNodeSensor());
            } else {
                throw new UnsupportedOperationException("Please add logic into ComposeVersion");
            }
        }
        if (this.definedSensors.composeSlider) {
            sensors.add(this.generateSliderSensor());
            sensors.add(this.generateRangeSliderSensor());
        }
        if (this.definedSensors.composePullRefresh) {
            sensors.add(this.generatePullRefreshSensor());
        }
        sensors.add(this.generateDependencySensor());
        return new DefaultSubTransformer("ComposeTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(CLICK_FUNCTION_NAME, CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCombinedClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMBINED_CLICK_FUNCTION_NAME, COMBINED_CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCombinedClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCombinedClickableSensor_1_8() {
        MethodInfo methodInfo = new MethodInfo(COMBINED_CLICK_FUNCTION_NAME_1_8, COMBINED_CLICK_DESCRIPTION_1_8, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCombinedClickTransformation_1_8()));
    }

    private SensorGroup<MethodSensor> generateCheckboxSensor(ComposeUiVersion composeUiVersion) {
        MethodInfo methodInfo = new MethodInfo(CHECKBOX_FUNCTION_NAME, CHECKBOX_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CHECKBOX_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCheckboxTransformation(composeUiVersion)));
    }

    private SensorGroup<MethodSensor> generateTriToggleableSensor(ComposeUiVersion composeUiVersion) {
        MethodInfo methodInfo = new MethodInfo(TRI_TOGGLE_FUNCTION_NAME, TRI_TOGGLE_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeTriToggleTransformation(composeUiVersion)));
    }

    private SensorGroup<MethodSensor> generateToggleableSensor(ComposeUiVersion composeUiVersion) {
        MethodInfo methodInfo = new MethodInfo(TOGGLE_FUNCTION_NAME, TOGGLE_DESCRIPTION, 25, null, new ArrayList<String>());
        MethodTransformation methodTransformation = composeUiVersion == ComposeUiVersion.V1_7 || composeUiVersion == ComposeUiVersion.V1_8 ? new ComposeToggleTransformation_1_7() : new ComposeToggleTransformation();
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, methodTransformation));
    }

    private SensorGroup<MethodSensor> generateSwipeableSensor(boolean useSemantics) {
        MethodInfo methodInfo = new MethodInfo(SWIPE_FUNCTION_NAME, SWIPE_DESCRIPTION, 17, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> SWIPE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeSwipeTransformation(useSemantics)));
    }

    private SensorGroup<MethodSensor> generateSliderSensor() {
        MethodInfo methodInfo = new MethodInfo(SLIDER_FUNCTION_NAME, SLIDER_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> SLIDER_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeSliderTransformation(this.definedSensors.composeSemantics)));
    }

    private SensorGroup<MethodSensor> generateRangeSliderSensor() {
        MethodInfo methodInfo = new MethodInfo(RANGE_SLIDER_FUNCTION_NAME, RANGE_SLIDER_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> SLIDER_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeRangeSliderTransformation(this.definedSensors.composeSemantics)));
    }

    private SensorGroup<MethodSensor> generateSemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(NODE_FUNCTION_NAME, NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeNodeTransformation()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor_1_4() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor_1_5() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation_1_5()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor_1_7() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation_1_7()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor_1_6() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation_1_6()));
    }

    private SensorGroup<MethodSensor> generateDependencySensor() {
        MethodInfo methodInfo = new MethodInfo(DEPENDENCY_FUNCTION_NAME, DEPENDENCY_FUNCTION_DESCRIPTION, 9, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> DEPENDENCY_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeDependencyCheckerTransformation()));
    }

    private SensorGroup<MethodSensor> generatePullRefreshSensor() {
        MethodInfo methodInfo = new MethodInfo(PULL_REFRESH_FUNCTION_NAME, PULL_REFRESH_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> PULL_REFRESH_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposePullRefreshTransformation()));
    }

    private SensorGroup<MethodSensor> generateClickableSemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(NODE_FUNCTION_NAME, NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CLICKABLE_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeNodeTransformation_1_5()));
    }

    private SensorGroup<MethodSensor> generateDraggableSemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(NODE_FUNCTION_NAME, NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> DRAGGABLE_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeNodeTransformation_1_5()));
    }

    @Override
    public List<String> mandatoryClasses() {
        return List.of(DEPENDENCY_SOURCE);
    }

    public static class Sensors
    implements Serializable {
        private final boolean composeClickable;
        private final boolean composeSwipeable;
        private final boolean composeSemantics;
        private final boolean composeSlider;
        private final boolean composePullRefresh;

        private Sensors(boolean composeClickable, boolean composeSwipeable, boolean composeSemantics, boolean composeSlider, boolean composePullRefresh) {
            this.composeClickable = composeClickable;
            this.composeSwipeable = composeSwipeable;
            this.composeSemantics = composeSemantics;
            this.composeSlider = composeSlider;
            this.composePullRefresh = composePullRefresh;
        }

        public static Sensors allSensorsActivated() {
            return new Builder().withComposeClickable(true).withComposeSwipeable(true).withComposeSemantics(true).withComposeSlider(true).withComposePullRefresh(true).build();
        }

        public static class Builder {
            private boolean composeClickable;
            private boolean composeSwipeable;
            private boolean composeSemantics;
            private boolean composeSlider;
            private boolean composePullRefresh;

            public Builder withComposeClickable(boolean composeClickable) {
                this.composeClickable = composeClickable;
                return this;
            }

            public Builder withComposeSwipeable(boolean composeSwipeable) {
                this.composeSwipeable = composeSwipeable;
                return this;
            }

            public Builder withComposeSemantics(boolean composeSemantics) {
                this.composeSemantics = composeSemantics;
                return this;
            }

            public Builder withComposeSlider(boolean composeSlider) {
                this.composeSlider = composeSlider;
                return this;
            }

            public Builder withComposePullRefresh(boolean composePullRefresh) {
                this.composePullRefresh = composePullRefresh;
                return this;
            }

            public Sensors build() {
                return new Sensors(this.composeClickable, this.composeSwipeable, this.composeSemantics, this.composeSlider, this.composePullRefresh);
            }
        }
    }
}

