/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.InstrumentationFlavorParser;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class DynatraceGradleProperties {
    private final InstrumentationFlavor instrumentationFlavor;
    private final boolean sessionReplayComposeEnabled;
    private final boolean enableComposeVersionVerification;
    private final boolean enableUserInteraction;
    private final int eventThrottlingLimit;

    private DynatraceGradleProperties(PropertyFactory propertyFactory) {
        this.instrumentationFlavor = propertyFactory.instrumentationFlavor;
        this.sessionReplayComposeEnabled = propertyFactory.sessionReplayComposeEnabled;
        this.enableComposeVersionVerification = propertyFactory.enableComposeVersionVerification;
        this.enableUserInteraction = propertyFactory.enableUserInteraction;
        this.eventThrottlingLimit = propertyFactory.eventThrottlingLimit;
    }

    public InstrumentationFlavor getInstrumentationFlavor() {
        return this.instrumentationFlavor;
    }

    public boolean isSessionReplayComposeEnabled() {
        return this.sessionReplayComposeEnabled;
    }

    public boolean isComposeVersionVerificationEnabled() {
        return this.enableComposeVersionVerification;
    }

    public boolean isUserInteractionEnabled() {
        return this.enableUserInteraction;
    }

    public int eventThrottlingLimit() {
        return this.eventThrottlingLimit;
    }

    public String toString() {
        return "DynatraceGradleProperties{instrumentationFlavor=" + this.instrumentationFlavor + ", sessionReplayComposeEnabled=" + this.sessionReplayComposeEnabled + ", enableComposeVersionVerification=" + this.enableComposeVersionVerification + ", enableUserInteraction=" + this.enableUserInteraction + "}";
    }

    public static class PropertyFactory {
        private static final String INSTRUMENTATION_FLAVOR = "dynatrace.instrumentationFlavor";
        private static final String ENABLE_SESSION_REPLAY_COMPOSE_INSTRUMENTATION = "dynatrace.instrumentSessionReplayCompose";
        private static final String ENABLE_COMPOSE_VERSION_VERIFICATION = "dynatrace.enableComposeVersionVerification";
        private static final String ENABLE_USER_INTERACTION = "dynatrace.enableUserInteraction";
        private static final String EVENT_THROTTLING_LIMIT = "dynatrace.eventThrottlingLimit";
        private InstrumentationFlavor instrumentationFlavor = InstrumentationFlavor.PLAIN;
        private boolean sessionReplayComposeEnabled = false;
        private boolean enableComposeVersionVerification = true;
        private boolean enableUserInteraction = false;
        private int eventThrottlingLimit = 200;

        public PropertyFactory withInstrumentationFlavor(InstrumentationFlavor instrumentationFlavor) {
            if (instrumentationFlavor == null) {
                instrumentationFlavor = InstrumentationFlavor.PLAIN;
            }
            this.instrumentationFlavor = instrumentationFlavor;
            return this;
        }

        public PropertyFactory withSessionReplayComposeEnabled(boolean sessionReplayComposeEnabled) {
            this.sessionReplayComposeEnabled = sessionReplayComposeEnabled;
            return this;
        }

        public PropertyFactory withComposeVersionVerificationEnabled(boolean enableComposeVersionVerification) {
            this.enableComposeVersionVerification = enableComposeVersionVerification;
            return this;
        }

        public PropertyFactory withUserInteractionEnabled(boolean enableUserInteraction) {
            this.enableUserInteraction = enableUserInteraction;
            return this;
        }

        public PropertyFactory withEventThrottlingLimit(int eventThrottlingLimit) {
            this.eventThrottlingLimit = eventThrottlingLimit;
            return this;
        }

        public PropertyFactory fromProject(Project project) {
            String eventThrottlingLimitProperty;
            String isUserInteractionEnabled;
            String composeVerification;
            try {
                this.withInstrumentationFlavor(new InstrumentationFlavorParser().parse((String)project.findProperty(INSTRUMENTATION_FLAVOR)));
            }
            catch (IllegalArgumentException e) {
                throw new GradleException("Can't parse value from property 'dynatrace.instrumentationFlavor'", (Throwable)e);
            }
            String srComposeInstrumentation = (String)project.findProperty(ENABLE_SESSION_REPLAY_COMPOSE_INSTRUMENTATION);
            if (srComposeInstrumentation != null && !srComposeInstrumentation.isEmpty()) {
                this.withSessionReplayComposeEnabled(Boolean.parseBoolean(srComposeInstrumentation));
            }
            if ((composeVerification = (String)project.findProperty(ENABLE_COMPOSE_VERSION_VERIFICATION)) != null && !composeVerification.isEmpty()) {
                this.withComposeVersionVerificationEnabled(Boolean.parseBoolean(composeVerification));
            }
            if ((isUserInteractionEnabled = (String)project.findProperty(ENABLE_USER_INTERACTION)) != null && !isUserInteractionEnabled.isEmpty()) {
                this.withUserInteractionEnabled(Boolean.parseBoolean(isUserInteractionEnabled));
            }
            if ((eventThrottlingLimitProperty = (String)project.findProperty(EVENT_THROTTLING_LIMIT)) != null && !eventThrottlingLimitProperty.isEmpty()) {
                try {
                    int specifiedLimit = Integer.parseInt(eventThrottlingLimitProperty);
                    if (specifiedLimit < 50 || specifiedLimit > 300) {
                        throw new GradleException("Value of property 'dynatrace.eventThrottlingLimit' is beyond its valid range of 50..300");
                    }
                    this.withEventThrottlingLimit(specifiedLimit);
                }
                catch (NumberFormatException e) {
                    throw new GradleException("The specified property 'dynatrace.eventThrottlingLimit' is not a number");
                }
            }
            return this;
        }

        public DynatraceGradleProperties build() {
            return new DynatraceGradleProperties(this);
        }
    }
}

