/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.sensor.material;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material.ComposeReplayBottomDrawerTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material.ComposeReplayModalDrawerTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import java.util.ArrayList;
import java.util.List;

public class SessionReplayDrawerSensor
implements SensorGroup<MethodSensor> {
    private static final String DRAWER_SOURCE = "androidx.compose.material.DrawerKt";
    private static final String MODAL_DRAWER_FUNCTION_NAME = "ModalDrawer-Gs3lGvM";
    private static final String MODAL_DRAWER_DESCRIPTION = "(Lkotlin/jvm/functions/Function3;Landroidx/compose/ui/Modifier;Landroidx/compose/material/DrawerState;ZLandroidx/compose/ui/graphics/Shape;FJJJLkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;II)V";
    private static final String BOTTOM_DRAWER_FUNCTION_NAME = "BottomDrawer-Gs3lGvM";
    private static final String BOTTOM_DRAWER_DESCRIPTION = "(Lkotlin/jvm/functions/Function3;Landroidx/compose/ui/Modifier;Landroidx/compose/material/BottomDrawerState;ZLandroidx/compose/ui/graphics/Shape;FJJJLkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;II)V";
    private final ClassResolver classResolver;

    public SessionReplayDrawerSensor(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return DRAWER_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.getModalDrawerSensor(), this.getBottomDrawerSensor());
    }

    private MethodSensor getModalDrawerSensor() {
        MethodInfo methodInfo = new MethodInfo(MODAL_DRAWER_FUNCTION_NAME, MODAL_DRAWER_DESCRIPTION, 25, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new ComposeReplayModalDrawerTransformation(this.classResolver));
    }

    private MethodSensor getBottomDrawerSensor() {
        MethodInfo methodInfo = new MethodInfo(BOTTOM_DRAWER_FUNCTION_NAME, BOTTOM_DRAWER_DESCRIPTION, 25, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new ComposeReplayBottomDrawerTransformation(this.classResolver));
    }
}

