/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.version;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterialVersion;

public abstract class ComposeMaterial {
    private static final String LAYOUT_UTIL_KT_1_9 = "androidx.compose.material.internal.LayoutUtilKt";
    private static final String WINDOW_BOUNDS_CALCULATOR_1_8 = "androidx.compose.material.WindowBoundsCalculator";
    private static final String ANCHORED_DRAGGABLE_DEFAULTS_1_5 = "androidx.compose.material.AnchoredDraggableDefaults";
    private static final String ANCHORED_DRAG_FINISHED_SIGNAL = "androidx.compose.material.AnchoredDragFinishedSignal";
    private static final String BOTTOM_DRAWER = "androidx.compose.material.DrawerKt$BottomDrawer$2";
    private static final String FUNCTION_2 = "kotlin.jvm.functions.Function2";

    public static ComposeMaterialVersion getVersion(ClassResolver classResolver) {
        if (classResolver.resolveClass(LAYOUT_UTIL_KT_1_9).isComplete()) {
            return ComposeMaterialVersion.V1_9;
        }
        if (classResolver.resolveClass(WINDOW_BOUNDS_CALCULATOR_1_8).isComplete()) {
            return ComposeMaterialVersion.V1_8;
        }
        if (classResolver.resolveClass(ANCHORED_DRAG_FINISHED_SIGNAL).isComplete()) {
            return ComposeMaterial.getBottomDrawerVersion(classResolver);
        }
        if (classResolver.resolveClass(ANCHORED_DRAGGABLE_DEFAULTS_1_5).isComplete()) {
            return ComposeMaterialVersion.V1_5;
        }
        return ComposeMaterialVersion.V1_4;
    }

    private static ComposeMaterialVersion getBottomDrawerVersion(ClassResolver classResolver) {
        ClassInfo bottomDrawerInfo = classResolver.resolveClass(BOTTOM_DRAWER);
        ClassInfo function2Info = classResolver.resolveClass(FUNCTION_2);
        if (bottomDrawerInfo.isComplete() && function2Info.isComplete() && bottomDrawerInfo.getInterfaces().contains(function2Info.getName())) {
            return ComposeMaterialVersion.V1_7;
        }
        return ComposeMaterialVersion.V1_6;
    }
}

