/*
 * Decompiled with CFR 0.152.
 */
package com.dyngr;

import com.dyngr.Poller;
import com.dyngr.PollerBuilder;
import com.dyngr.core.AttemptMaker;
import com.dyngr.core.StopStrategies;
import com.dyngr.core.StopStrategy;
import com.dyngr.core.WaitStrategies;
import com.dyngr.core.WaitStrategy;
import com.dyngr.exception.PollerException;
import com.dyngr.exception.PollerUnknownException;
import com.dyngr.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class Polling {
    public static PollingOptions waitPeriodly(long sleepTime, TimeUnit timeUnit) {
        PollingOptions options = Polling.newOptions();
        return options.waitPeriodly(sleepTime, timeUnit);
    }

    public static PollingOptions waitRandomly(long maximumTime, TimeUnit timeUnit) {
        PollingOptions options = Polling.newOptions();
        return options.waitRandomly(maximumTime, timeUnit);
    }

    public static PollingOptions stopAfterDelay(long duration, @Nonnull TimeUnit timeUnit) {
        PollingOptions options = Polling.newOptions();
        return options.stopAfterDelay(duration, timeUnit);
    }

    public static PollingOptions stopAfterAttempt(int attemptNumber) {
        PollingOptions options = Polling.newOptions();
        return options.stopAfterAttempt(attemptNumber);
    }

    private static PollingOptions newOptions() {
        return new PollingOptions();
    }

    public static class PollingOptions {
        private Boolean stopIfException = null;
        private List<StopStrategy> stopStrategies = new ArrayList<StopStrategy>();
        private List<WaitStrategy> waitStrategies = new ArrayList<WaitStrategy>();

        private PollingOptions() {
        }

        public PollingOptions waitPeriodly(long sleepTime, TimeUnit timeUnit) {
            this.waitStrategies.add(WaitStrategies.fixedWait(sleepTime, timeUnit));
            return this;
        }

        public PollingOptions waitRandomly(long maximumTime, TimeUnit timeUnit) {
            this.waitStrategies.add(WaitStrategies.randomWait(maximumTime, timeUnit));
            return this;
        }

        public PollingOptions stopAfterDelay(long duration, @Nonnull TimeUnit timeUnit) {
            this.stopStrategies.add(StopStrategies.stopAfterDelay(duration, timeUnit));
            return this;
        }

        public PollingOptions stopAfterAttempt(int attemptNumber) {
            this.stopStrategies.add(StopStrategies.stopAfterAttempt(attemptNumber));
            return this;
        }

        public PollingOptions stopIfException(boolean stopIfException) {
            this.stopIfException = stopIfException;
            return this;
        }

        public <V> V run(AttemptMaker<V> attemptMaker) {
            Preconditions.checkNotNull(attemptMaker, "attemptMake should not be null");
            try {
                return this.build(attemptMaker).start().get();
            }
            catch (InterruptedException e) {
                throw new PollerUnknownException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof PollerException) {
                    throw (PollerException)cause;
                }
                throw new PollerUnknownException(e);
            }
        }

        private <V> Poller<V> build(AttemptMaker<V> attemptMaker) {
            PollerBuilder<V> builder = new PollerBuilder<V>();
            if (this.stopIfException != null) {
                builder.stopIfException(this.stopIfException);
            }
            if (!this.stopStrategies.isEmpty()) {
                builder.withStopStrategy(this.stopStrategies.toArray(new StopStrategy[0]));
            }
            if (!this.waitStrategies.isEmpty()) {
                builder.withWaitStrategy(this.waitStrategies.toArray(new WaitStrategy[0]));
            }
            builder.polling(attemptMaker);
            return builder.build();
        }
    }
}

