/*
 * Decompiled with CFR 0.152.
 */
package com.dyngr.core;

import com.dyngr.core.StopStrategy;
import com.dyngr.core.strategy.CompositeStopStrategy;
import com.dyngr.core.strategy.NeverStopStrategy;
import com.dyngr.core.strategy.StopAfterAttemptStrategy;
import com.dyngr.core.strategy.StopAfterDelayStrategy;
import com.dyngr.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class StopStrategies {
    private static final StopStrategy NEVER_STOP = new NeverStopStrategy();

    private StopStrategies() {
    }

    public static StopStrategy neverStop() {
        return NEVER_STOP;
    }

    public static StopStrategy stopAfterAttempt(int attemptNumber) {
        return new StopAfterAttemptStrategy(attemptNumber);
    }

    public static StopStrategy stopAfterDelay(long duration, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(timeUnit, "The time unit may not be null");
        return new StopAfterDelayStrategy(timeUnit.toMillis(duration));
    }

    public static StopStrategy join(StopStrategy ... stopStrategies) {
        Preconditions.checkState(stopStrategies.length > 0, "Must have at least one stop strategy");
        ArrayList<StopStrategy> stopStrategyList = new ArrayList<StopStrategy>(Arrays.asList(stopStrategies));
        Preconditions.checkState(!stopStrategyList.contains(null), "Cannot have a null stop strategy");
        return new CompositeStopStrategy(stopStrategyList);
    }
}

