/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.StringSerializer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class ByteString {
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private volatile int hash = 0;

    static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public static void writeTo(OutputStream out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static void writeTo(DataOutput out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static void writeTo(Output output, ByteString bs, int fieldNumber, boolean repeated) throws IOException {
        output.writeByteArray(fieldNumber, bs.bytes, repeated);
    }

    public String toString() {
        return this.toStringUtf8();
    }

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(String text, String charsetName) {
        try {
            return new ByteString(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(charsetName + " not supported?", e);
        }
    }

    public static ByteString copyFromUtf8(String text) {
        return new ByteString(StringSerializer.STRING.ser(text));
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int size) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, size);
    }

    public byte[] toByteArray() {
        int size = this.bytes.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.bytes, 0, copy, 0, size);
        return copy;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toStringUtf8() {
        return StringSerializer.STRING.deser(this.bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)o;
        int size = this.bytes.length;
        if (size != other.bytes.length) {
            return false;
        }
        byte[] thisBytes = this.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int size;
            byte[] thisBytes = this.bytes;
            h = size = this.bytes.length;
            for (int i = 0; i < size; ++i) {
                h = h * 31 + thisBytes[i];
            }
            if (h == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }

    public static String stringDefaultValue(String bytes) {
        try {
            return new String(bytes.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    public static ByteString bytesDefaultValue(String bytes) {
        try {
            return ByteString.wrap(bytes.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }
}

