/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;
import java.io.OutputStream;

public final class StreamedStringSerializer {
    private StreamedStringSerializer() {
    }

    public static LinkedBuffer writeInt(int value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int size;
        if (value == Integer.MIN_VALUE) {
            int valueLen = StringSerializer.INT_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            System.arraycopy(StringSerializer.INT_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0 ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
        }
        StringSerializer.putBytesFromInt(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeLong(long value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int size;
        if (value == Long.MIN_VALUE) {
            int valueLen = StringSerializer.LONG_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            System.arraycopy(StringSerializer.LONG_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0L ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
        }
        StringSerializer.putBytesFromLong(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeFloat(float value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        return StreamedStringSerializer.writeAscii(Float.toString(value), session, out, lb);
    }

    public static LinkedBuffer writeDouble(double value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        return StreamedStringSerializer.writeAscii(Double.toString(value), session, out, lb);
    }

    private static LinkedBuffer writeUTF8(String str, int index, int len, byte[] buffer, int offset, int limit, WriteSession session, LinkedBuffer lb) {
        int start = offset;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    if (lb.next == null) {
                        start = 0;
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = (start = lb.start);
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    if (lb.next == null) {
                        start = 0;
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = (start = lb.start);
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    if (lb.next == null) {
                        start = 0;
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = (start = lb.start);
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                if (lb.next == null) {
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                } else {
                    lb = lb.next;
                    lb.offset = offset = (start = lb.start);
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                if (lb.next == null) {
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                } else {
                    lb = lb.next;
                    lb.offset = offset = (start = lb.start);
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
            }
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                if (lb.next == null) {
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                } else {
                    lb = lb.next;
                    lb.offset = offset = (start = lb.start);
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
            }
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        lb.offset = offset;
        session.size += offset - start;
        return lb;
    }

    private static LinkedBuffer writeUTF8(String str, int index, int len, WriteSession session, LinkedBuffer lb) {
        int start;
        byte[] buffer = lb.buffer;
        int limit = buffer.length;
        int offset = start = lb.offset;
        int adjustableLimit = offset + len;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (++adjustableLimit > limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    return StreamedStringSerializer.writeUTF8(str, i, len, buffer, offset, limit, session, lb);
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if ((adjustableLimit += 2) > limit) {
                lb.offset = offset;
                session.size += offset - start;
                return StreamedStringSerializer.writeUTF8(str, i, len, buffer, offset, limit, session, lb);
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        lb.offset = offset;
        session.size += offset - start;
        return lb;
    }

    public static LinkedBuffer writeUTF8(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        byte[] buffer = lb.buffer;
        int limit = buffer.length;
        int start = lb.start;
        int offset = lb.offset;
        int size = len;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                if (offset == limit) {
                    out.write(buffer, start, offset - start);
                    offset = start;
                }
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (offset + 2 > limit) {
                    out.write(buffer, start, offset - start);
                    offset = start;
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                ++size;
                continue;
            }
            if (offset + 3 > limit) {
                out.write(buffer, start, offset - start);
                offset = start;
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            size += 2;
        }
        session.size += size;
        lb.offset = offset;
        return lb;
    }

    public static LinkedBuffer writeAscii(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        int offset = lb.offset;
        int limit = lb.buffer.length;
        byte[] buffer = lb.buffer;
        session.size += len;
        if (offset + len > limit) {
            int index = 0;
            int start = lb.start;
            int bufSize = limit - start;
            int available = limit - offset;
            int remaining = len - available;
            int loops = remaining / bufSize;
            int extra = remaining % bufSize;
            while (available-- > 0) {
                buffer[offset++] = (byte)str.charAt(index++);
            }
            out.write(buffer, start, bufSize);
            offset = start;
            while (loops-- > 0) {
                for (int i = 0; i < bufSize; ++i) {
                    buffer[offset++] = (byte)str.charAt(index++);
                }
                out.write(buffer, start, bufSize);
                offset = start;
            }
            while (extra-- > 0) {
                buffer[offset++] = (byte)str.charAt(index++);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                buffer[offset++] = (byte)str.charAt(i);
            }
        }
        lb.offset = offset;
        return lb;
    }

    private static void flushAndReset(LinkedBuffer head, OutputStream out) throws IOException {
        LinkedBuffer node = head;
        while (node != null) {
            int len = node.offset - node.start;
            if (len > 0) {
                out.write(node.buffer, node.start, len);
                node.offset = node.start;
            }
            node = node.next;
        }
    }

    public static LinkedBuffer writeUTF8FixedDelimited(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        return StreamedStringSerializer.writeUTF8FixedDelimited(str, false, session, out, lb);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(String str, boolean littleEndian, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int lastSize = session.size;
        int len = str.length();
        int offset = lb.offset;
        int withIntOffset = offset + 2;
        if (withIntOffset > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            offset = lb.start;
            withIntOffset = offset + 2;
        }
        if (len == 0) {
            StringSerializer.writeFixed2ByteInt(0, lb.buffer, offset, littleEndian);
            lb.offset = withIntOffset;
            session.size += 2;
            return lb;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, 0, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            StringSerializer.writeFixed2ByteInt(size, buffer, offset, littleEndian);
            session.size += 2;
            assert (rb != lb);
            StreamedStringSerializer.flushAndReset(lb, out);
            return lb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, 0, len, session, lb);
        int size = session.size - lastSize;
        StringSerializer.writeFixed2ByteInt(size, lb.buffer, offset, littleEndian);
        session.size += 2;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(String str, int index, int len, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int withIntOffset;
        int lastSize = session.size;
        int offset = lb.offset;
        if (offset == lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            offset = lb.start;
        }
        if ((withIntOffset = offset + 1) + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, index, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            lb.buffer[offset] = (byte)size;
            ++session.size;
            assert (rb != lb);
            StreamedStringSerializer.flushAndReset(lb, out);
            return lb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        lb.buffer[offset] = (byte)size;
        ++session.size;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    private static LinkedBuffer writeUTF8VarDelimited(String str, int index, int len, int lowerLimit, int expectedSize, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int lastSize = session.size;
        int offset = lb.offset;
        int withIntOffset = offset + expectedSize;
        if (withIntOffset > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            offset = lb.start;
            withIntOffset = offset + expectedSize;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, index, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            int last = expectedSize - 1;
            if (size < lowerLimit) {
                System.arraycopy(buffer, withIntOffset, buffer, withIntOffset - 1, lb.offset - withIntOffset);
                session.size += last;
                --lb.offset;
                --last;
            } else {
                session.size += expectedSize;
            }
            int i = 0;
            while (i < last) {
                buffer[offset++] = (byte)(size & 0x7F | 0x80);
                ++i;
                size >>>= 7;
            }
            buffer[offset] = (byte)size;
            assert (rb != lb);
            StreamedStringSerializer.flushAndReset(lb, out);
            return lb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StreamedStringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        byte[] buffer = lb.buffer;
        int last = expectedSize - 1;
        if (size < lowerLimit) {
            System.arraycopy(buffer, withIntOffset, buffer, withIntOffset - 1, lb.offset - withIntOffset);
            session.size += last;
            --lb.offset;
            --last;
        } else {
            session.size += expectedSize;
        }
        int i = 0;
        while (i < last) {
            buffer[offset++] = (byte)(size & 0x7F | 0x80);
            ++i;
            size >>>= 7;
        }
        buffer[offset] = (byte)size;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    public static LinkedBuffer writeUTF8VarDelimited(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            if (lb.offset == lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            lb.buffer[lb.offset++] = 0;
            ++session.size;
            return lb;
        }
        if (len < 43) {
            return StreamedStringSerializer.writeUTF8OneByteDelimited(str, 0, len, session, out, lb);
        }
        if (len < 683) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 128, 2, session, out, lb);
        }
        if (len < 10923) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 2048, 3, session, out, lb);
        }
        if (len < 174763) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 32768, 4, session, out, lb);
        }
        return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 524288, 5, session, out, lb);
    }
}

