/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.WriteSession;
import java.io.UnsupportedEncodingException;

public final class StringSerializer {
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] INT_MIN_VALUE = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    static final byte[] LONG_MIN_VALUE = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    static final int ONE_BYTE_EXCLUSIVE = 43;
    static final int TWO_BYTE_LOWER_LIMIT = 128;
    static final int TWO_BYTE_EXCLUSIVE = 683;
    static final int THREE_BYTE_LOWER_LIMIT = 2048;
    static final int THREE_BYTE_EXCLUSIVE = 10923;
    static final int FOUR_BYTE_LOWER_LIMIT = 32768;
    static final int FOUR_BYTE_EXCLUSIVE = 174763;
    static final int FIVE_BYTE_LOWER_LIMIT = 524288;

    private StringSerializer() {
    }

    static void putBytesFromInt(int i, int offset, int size, byte[] buf) {
        int r;
        int q;
        int charPos = offset + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = (byte)sign;
        }
    }

    static void putBytesFromLong(long i, int offset, int size, byte[] buf) {
        int q2;
        int r;
        int charPos = offset + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = (byte)digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = (byte)sign;
        }
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static LinkedBuffer writeInt(int value, WriteSession session, LinkedBuffer lb) {
        int size;
        if (value == Integer.MIN_VALUE) {
            int valueLen = INT_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            System.arraycopy(INT_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0 ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        StringSerializer.putBytesFromInt(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeLong(long value, WriteSession session, LinkedBuffer lb) {
        int size;
        if (value == Long.MIN_VALUE) {
            int valueLen = LONG_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            System.arraycopy(LONG_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0L ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        StringSerializer.putBytesFromLong(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeFloat(float value, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeAscii(Float.toString(value), session, lb);
    }

    public static LinkedBuffer writeDouble(double value, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeAscii(Double.toString(value), session, lb);
    }

    public static int computeUTF8Size(String str, int index, int len) {
        int size = len;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') continue;
            if (c < '\u0800') {
                ++size;
                continue;
            }
            size += 2;
        }
        return size;
    }

    private static LinkedBuffer writeUTF8(String str, int index, int len, byte[] buffer, int offset, int limit, WriteSession session, LinkedBuffer lb) {
        int start = offset;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                }
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                if (offset == limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    start = 0;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                }
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                start = 0;
                offset = 0;
                limit = session.nextBufferSize;
                buffer = new byte[limit];
                lb = new LinkedBuffer(buffer, 0, lb);
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                start = 0;
                offset = 0;
                limit = session.nextBufferSize;
                buffer = new byte[limit];
                lb = new LinkedBuffer(buffer, 0, lb);
            }
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            if (offset == limit) {
                lb.offset = offset;
                session.size += offset - start;
                start = 0;
                offset = 0;
                limit = session.nextBufferSize;
                buffer = new byte[limit];
                lb = new LinkedBuffer(buffer, 0, lb);
            }
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        lb.offset = offset;
        session.size += offset - start;
        return lb;
    }

    private static LinkedBuffer writeUTF8(String str, int index, int len, WriteSession session, LinkedBuffer lb) {
        int start;
        byte[] buffer = lb.buffer;
        int limit = buffer.length;
        int offset = start = lb.offset;
        int adjustableLimit = offset + len;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (++adjustableLimit > limit) {
                    lb.offset = offset;
                    session.size += offset - start;
                    return StringSerializer.writeUTF8(str, i, len, buffer, offset, limit, session, lb);
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if ((adjustableLimit += 2) > limit) {
                lb.offset = offset;
                session.size += offset - start;
                return StringSerializer.writeUTF8(str, i, len, buffer, offset, limit, session, lb);
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        lb.offset = offset;
        session.size += offset - start;
        return lb;
    }

    public static LinkedBuffer writeUTF8(String str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        return lb.offset + len > lb.buffer.length ? StringSerializer.writeUTF8(str, 0, len, lb.buffer, lb.offset, lb.buffer.length, session, lb) : StringSerializer.writeUTF8(str, 0, len, session, lb);
    }

    public static LinkedBuffer writeAscii(String str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        int offset = lb.offset;
        int limit = lb.buffer.length;
        byte[] buffer = lb.buffer;
        session.size += len;
        if (offset + len > limit) {
            for (int i = 0; i < len; ++i) {
                if (offset == limit) {
                    lb.offset = offset;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                }
                buffer[offset++] = (byte)str.charAt(i);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                buffer[offset++] = (byte)str.charAt(i);
            }
        }
        lb.offset = offset;
        return lb;
    }

    static void writeFixed2ByteInt(int value, byte[] buffer, int offset, boolean littleEndian) {
        if (littleEndian) {
            buffer[offset++] = (byte)value;
            buffer[offset] = (byte)(value >>> 8 & 0xFF);
        } else {
            buffer[offset++] = (byte)(value >>> 8 & 0xFF);
            buffer[offset] = (byte)value;
        }
    }

    public static LinkedBuffer writeUTF8FixedDelimited(String str, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeUTF8FixedDelimited(str, false, session, lb);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(String str, boolean littleEndian, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        int len = str.length();
        int offset = lb.offset;
        int withIntOffset = offset + 2;
        if (withIntOffset > lb.buffer.length) {
            lb = new LinkedBuffer(len + 2 > session.nextBufferSize ? len + 2 : session.nextBufferSize, lb);
            offset = 0;
            lb.offset = 2;
            if (len == 0) {
                StringSerializer.writeFixed2ByteInt(0, lb.buffer, offset, littleEndian);
                session.size += 2;
                return lb;
            }
            LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, session, lb);
            int size = session.size - lastSize;
            StringSerializer.writeFixed2ByteInt(size, lb.buffer, offset, littleEndian);
            session.size += 2;
            return rb;
        }
        if (len == 0) {
            StringSerializer.writeFixed2ByteInt(0, lb.buffer, offset, littleEndian);
            lb.offset = withIntOffset;
            session.size += 2;
            return lb;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            StringSerializer.writeFixed2ByteInt(size, buffer, offset, littleEndian);
            session.size += 2;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, session, lb);
        int size = session.size - lastSize;
        StringSerializer.writeFixed2ByteInt(size, lb.buffer, offset, littleEndian);
        session.size += 2;
        return rb;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(String str, int index, int len, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        int offset = lb.offset;
        if (offset == lb.buffer.length) {
            lb = new LinkedBuffer(len + 1 > session.nextBufferSize ? len + 1 : session.nextBufferSize, lb);
            offset = 0;
            lb.offset = 1;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
            int size = session.size - lastSize;
            lb.buffer[offset] = (byte)size;
            ++session.size;
            return rb;
        }
        int withIntOffset = offset + 1;
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            buffer[offset] = (byte)size;
            ++session.size;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        lb.buffer[offset] = (byte)size;
        ++session.size;
        return rb;
    }

    private static LinkedBuffer writeUTF8VarDelimited(String str, int index, int len, int lowerLimit, int expectedSize, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        int offset = lb.offset;
        int withIntOffset = offset + expectedSize;
        if (withIntOffset > lb.buffer.length) {
            lb = new LinkedBuffer(len + expectedSize > session.nextBufferSize ? len + expectedSize : session.nextBufferSize, lb);
            offset = 0;
            lb.offset = expectedSize;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
            int size = session.size - lastSize;
            byte[] buffer = lb.buffer;
            int last = expectedSize - 1;
            if (size < lowerLimit) {
                System.arraycopy(buffer, expectedSize, buffer, expectedSize - 1, lb.offset - expectedSize);
                session.size += last;
                --lb.offset;
                --last;
            } else {
                session.size += expectedSize;
            }
            int i = 0;
            while (i < last) {
                buffer[offset++] = (byte)(size & 0x7F | 0x80);
                ++i;
                size >>>= 7;
            }
            buffer[offset] = (byte)size;
            return rb;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, buffer, withIntOffset, buffer.length, session, lb);
            int size = session.size - lastSize;
            int last = expectedSize - 1;
            if (size < lowerLimit) {
                System.arraycopy(buffer, withIntOffset, buffer, withIntOffset - 1, lb.offset - withIntOffset);
                session.size += last;
                --lb.offset;
                --last;
            } else {
                session.size += expectedSize;
            }
            int i = 0;
            while (i < last) {
                buffer[offset++] = (byte)(size & 0x7F | 0x80);
                ++i;
                size >>>= 7;
            }
            buffer[offset] = (byte)size;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        byte[] buffer = lb.buffer;
        int last = expectedSize - 1;
        if (size < lowerLimit) {
            System.arraycopy(buffer, withIntOffset, buffer, withIntOffset - 1, lb.offset - withIntOffset);
            session.size += last;
            --lb.offset;
            --last;
        } else {
            session.size += expectedSize;
        }
        int i = 0;
        while (i < last) {
            buffer[offset++] = (byte)(size & 0x7F | 0x80);
            ++i;
            size >>>= 7;
        }
        buffer[offset] = (byte)size;
        return rb;
    }

    public static LinkedBuffer writeUTF8VarDelimited(String str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            if (lb.offset == lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            lb.buffer[lb.offset++] = 0;
            ++session.size;
            return lb;
        }
        if (len < 43) {
            return StringSerializer.writeUTF8OneByteDelimited(str, 0, len, session, lb);
        }
        if (len < 683) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 128, 2, session, lb);
        }
        if (len < 10923) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 2048, 3, session, lb);
        }
        if (len < 174763) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 32768, 4, session, lb);
        }
        return StringSerializer.writeUTF8VarDelimited(str, 0, len, 524288, 5, session, lb);
    }

    public static final class STRING {
        private STRING() {
        }

        public static String deser(byte[] nonNullValue) {
            try {
                return new String(nonNullValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public static String deser(byte[] nonNullValue, int offset, int len) {
            try {
                return new String(nonNullValue, offset, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public static byte[] ser(String nonNullValue) {
            try {
                return nonNullValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

