/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;

public final class B64Code {
    public static final byte pad = 61;
    public static final byte padUrlSafe = 61;
    public static final byte[] nibble2code = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    public static final byte[] nibble2codeUrlSafe = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    public static final byte[] code2nibble = new byte[256];
    public static final byte[] code2nibbleUrlSafe = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            B64Code.code2nibble[i] = -1;
            B64Code.code2nibbleUrlSafe[i] = -1;
            ++i;
        }
        int b = 0;
        while (b < 64) {
            B64Code.code2nibble[B64Code.nibble2code[b]] = b;
            B64Code.code2nibbleUrlSafe[B64Code.nibble2codeUrlSafe[b]] = b;
            b = (byte)(b + 1);
        }
        B64Code.code2nibble[61] = 0;
        B64Code.code2nibbleUrlSafe[61] = 0;
    }

    private B64Code() {
    }

    public static byte[] encode(byte[] input) {
        return B64Code.encode(input, 0, input.length);
    }

    public static byte[] encode(byte[] input, int inOffset, int inLen) {
        byte[] output = new byte[(inLen + 2) / 3 * 4];
        B64Code.encode(input, inOffset, inLen, output, 0, nibble2code, (byte)61);
        return output;
    }

    public static byte[] encodeUS(byte[] input, int inOffset, int inLen) {
        byte[] output = new byte[(inLen + 2) / 3 * 4];
        B64Code.encode(input, inOffset, inLen, output, 0, nibble2codeUrlSafe, (byte)61);
        return output;
    }

    public static char[] cencode(byte[] input) {
        return B64Code.cencode(input, 0, input.length);
    }

    public static char[] cencode(byte[] input, int inOffset, int inLen) {
        char[] output = new char[(inLen + 2) / 3 * 4];
        B64Code.cencode(input, inOffset, inLen, output, 0, nibble2code, (byte)61);
        return output;
    }

    public static char[] cencodeUS(byte[] input, int inOffset, int inLen) {
        char[] output = new char[(inLen + 2) / 3 * 4];
        B64Code.cencode(input, inOffset, inLen, output, 0, nibble2codeUrlSafe, (byte)61);
        return output;
    }

    private static void encode(byte[] input, int inOffset, int inLen, byte[] output, int outOffset, byte[] nibble2code, byte pad) {
        byte b1;
        byte b0;
        int remaining = inLen % 3;
        int stop = inOffset + (inLen - remaining);
        while (inOffset < stop) {
            b0 = input[inOffset++];
            b1 = input[inOffset++];
            byte b2 = input[inOffset++];
            output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
            output[outOffset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            output[outOffset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            output[outOffset++] = nibble2code[b2 & 0x3F];
        }
        switch (remaining) {
            case 0: {
                break;
            }
            case 1: {
                b0 = input[inOffset++];
                output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = nibble2code[b0 << 4 & 0x3F];
                output[outOffset++] = pad;
                output[outOffset++] = pad;
                break;
            }
            case 2: {
                b0 = input[inOffset++];
                b1 = input[inOffset++];
                output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                output[outOffset++] = nibble2code[b1 << 2 & 0x3F];
                output[outOffset++] = pad;
                break;
            }
            default: {
                throw new IllegalStateException("should not happen");
            }
        }
    }

    private static void cencode(byte[] input, int inOffset, int inLen, char[] output, int outOffset, byte[] nibble2code, byte pad) {
        byte b1;
        byte b0;
        int remaining = inLen % 3;
        int stop = inOffset + (inLen - remaining);
        while (inOffset < stop) {
            b0 = input[inOffset++];
            b1 = input[inOffset++];
            byte b2 = input[inOffset++];
            output[outOffset++] = (char)nibble2code[b0 >>> 2 & 0x3F];
            output[outOffset++] = (char)nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            output[outOffset++] = (char)nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            output[outOffset++] = (char)nibble2code[b2 & 0x3F];
        }
        switch (remaining) {
            case 0: {
                break;
            }
            case 1: {
                b0 = input[inOffset++];
                output[outOffset++] = (char)nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = (char)nibble2code[b0 << 4 & 0x3F];
                output[outOffset++] = (char)pad;
                output[outOffset++] = (char)pad;
                break;
            }
            case 2: {
                b0 = input[inOffset++];
                b1 = input[inOffset++];
                output[outOffset++] = (char)nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = (char)nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                output[outOffset++] = (char)nibble2code[b1 << 2 & 0x3F];
                output[outOffset++] = (char)pad;
                break;
            }
            default: {
                throw new IllegalStateException("should not happen");
            }
        }
    }

    public static LinkedBuffer encode(byte[] input, int inOffset, int inLen, WriteSession session, LinkedBuffer lb) throws IOException {
        return B64Code.encode(input, inOffset, inLen, nibble2code, (byte)61, session, lb);
    }

    public static LinkedBuffer encode(byte[] input, int inOffset, int inLen, byte[] nibble2code, byte pad, WriteSession session, LinkedBuffer lb) throws IOException {
        int outputSize = (inLen + 2) / 3 * 4;
        session.size += outputSize;
        int available = lb.buffer.length - lb.offset;
        if (outputSize > available) {
            int chunks = available / 4;
            if (chunks == 0) {
                if (outputSize > session.nextBufferSize) {
                    byte[] encoded = new byte[outputSize];
                    B64Code.encode(input, inOffset, inLen, encoded, 0, nibble2code, pad);
                    return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(encoded, 0, outputSize, lb));
                }
                byte[] encoded = new byte[session.nextBufferSize];
                B64Code.encode(input, inOffset, inLen, encoded, 0, nibble2code, pad);
                return new LinkedBuffer(encoded, 0, outputSize, lb);
            }
            int inBefore = inOffset;
            byte[] buffer = lb.buffer;
            int offset = lb.offset;
            while (chunks-- > 0) {
                byte b0 = input[inOffset++];
                byte b1 = input[inOffset++];
                byte b2 = input[inOffset++];
                buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                buffer[offset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                buffer[offset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
                buffer[offset++] = nibble2code[b2 & 0x3F];
            }
            inLen -= inOffset - inBefore;
            lb.offset = offset;
            if ((outputSize -= offset - lb.offset) > session.nextBufferSize) {
                byte[] encoded = new byte[outputSize];
                B64Code.encode(input, inOffset, inLen, encoded, 0, nibble2code, pad);
                return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(encoded, 0, outputSize, lb));
            }
            byte[] encoded = new byte[session.nextBufferSize];
            B64Code.encode(input, inOffset, inLen, encoded, 0, nibble2code, pad);
            return new LinkedBuffer(encoded, 0, outputSize, lb);
        }
        B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset, nibble2code, pad);
        lb.offset += outputSize;
        return lb;
    }

    public static LinkedBuffer sencode(byte[] input, int inOffset, int inLen, WriteSession session, LinkedBuffer lb) throws IOException {
        return B64Code.sencode(input, inOffset, inLen, nibble2code, (byte)61, session, lb);
    }

    public static LinkedBuffer sencode(byte[] input, int inOffset, int inLen, byte[] nibble2code, byte pad, WriteSession session, LinkedBuffer lb) throws IOException {
        int outputSize = (inLen + 2) / 3 * 4;
        session.size += outputSize;
        int available = lb.buffer.length - lb.offset;
        if (outputSize > available) {
            byte b1;
            byte b0;
            byte[] buffer = lb.buffer;
            int offset = lb.offset;
            int remaining = inLen % 3;
            int chunks = available / 4;
            int stop = inOffset + (inLen - remaining);
            while (inOffset < stop) {
                if (chunks == 0) {
                    offset = session.flush(buffer, lb.start, offset - lb.start);
                    chunks = (buffer.length - offset) / 4;
                }
                b0 = input[inOffset++];
                b1 = input[inOffset++];
                byte b2 = input[inOffset++];
                buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                buffer[offset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                buffer[offset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
                buffer[offset++] = nibble2code[b2 & 0x3F];
                --chunks;
            }
            switch (remaining) {
                case 0: {
                    break;
                }
                case 1: {
                    if (chunks == 0) {
                        offset = session.flush(buffer, lb.start, offset - lb.start);
                    }
                    b0 = input[inOffset++];
                    buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                    buffer[offset++] = nibble2code[b0 << 4 & 0x3F];
                    buffer[offset++] = pad;
                    buffer[offset++] = pad;
                    break;
                }
                case 2: {
                    if (chunks == 0) {
                        offset = session.flush(buffer, lb.start, offset - lb.start);
                    }
                    b0 = input[inOffset++];
                    b1 = input[inOffset++];
                    buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                    buffer[offset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                    buffer[offset++] = nibble2code[b1 << 2 & 0x3F];
                    buffer[offset++] = pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not happen");
                }
            }
            lb.offset = offset;
            return lb;
        }
        B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset, nibble2code, pad);
        lb.offset += outputSize;
        return lb;
    }

    public static byte[] decode(byte[] b) {
        return B64Code.decode(b, 0, b.length);
    }

    public static byte[] cdecode(char[] b) {
        return B64Code.cdecode(b, 0, b.length);
    }

    public static byte[] decode(byte[] input, int inOffset, int inLen) {
        return B64Code.decode(input, inOffset, inLen, code2nibble, (byte)61);
    }

    public static byte[] decodeUS(byte[] input, int inOffset, int inLen) {
        return B64Code.decode(input, inOffset, inLen, code2nibbleUrlSafe, (byte)61);
    }

    public static byte[] decode(byte[] input, int inOffset, int inLen, byte[] code2nibble, byte pad) {
        if (inLen == 0) {
            return ByteString.EMPTY_BYTE_ARRAY;
        }
        if (inLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int withoutPaddingLen = inLen;
        int limit = inOffset + inLen;
        while (input[--limit] == pad) {
            --withoutPaddingLen;
        }
        int outLen = withoutPaddingLen * 3 / 4;
        byte[] output = new byte[outLen];
        B64Code.decode(input, inOffset, inLen, output, 0, outLen, code2nibble, pad);
        return output;
    }

    public static byte[] cdecode(char[] input, int inOffset, int inLen) {
        return B64Code.cdecode(input, inOffset, inLen, code2nibble, (byte)61);
    }

    public static byte[] cdecodeUS(char[] input, int inOffset, int inLen) {
        return B64Code.cdecode(input, inOffset, inLen, code2nibbleUrlSafe, (byte)61);
    }

    public static byte[] cdecode(char[] input, int inOffset, int inLen, byte[] code2nibble, byte pad) {
        if (inLen == 0) {
            return ByteString.EMPTY_BYTE_ARRAY;
        }
        if (inLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int withoutPaddingLen = inLen;
        int limit = inOffset + inLen;
        while (input[--limit] == pad) {
            --withoutPaddingLen;
        }
        int outLen = withoutPaddingLen * 3 / 4;
        byte[] output = new byte[outLen];
        B64Code.cdecode(input, inOffset, inLen, output, 0, outLen, code2nibble, pad);
        return output;
    }

    public static int decodeTo(byte[] output, int outOffset, byte[] input, int inOffset, int inLen, byte[] code2nibble, byte pad) {
        if (inLen == 0) {
            return 0;
        }
        if (inLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int withoutPaddingLen = inLen;
        int limit = inOffset + inLen;
        while (input[--limit] == pad) {
            --withoutPaddingLen;
        }
        int outLen = withoutPaddingLen * 3 / 4;
        assert (output.length - outOffset >= outLen);
        B64Code.decode(input, inOffset, inLen, output, outOffset, outLen, code2nibble, pad);
        return outLen;
    }

    private static void decode(byte[] input, int inOffset, int inLen, byte[] output, int outOffset, int outLen, byte[] code2nibble, byte pad) {
        block11: {
            int stop = outLen / 3 * 3;
            try {
                byte b2;
                byte b1;
                byte b0;
                while (outOffset < stop) {
                    b0 = code2nibble[input[inOffset++]];
                    b1 = code2nibble[input[inOffset++]];
                    b2 = code2nibble[input[inOffset++]];
                    byte b3 = code2nibble[input[inOffset++]];
                    if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                        throw new IllegalArgumentException("Not B64 encoded");
                    }
                    output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                    output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                    output[outOffset++] = (byte)(b2 << 6 | b3);
                }
                if (outLen == outOffset) break block11;
                switch (outLen % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        b0 = code2nibble[input[inOffset++]];
                        b1 = code2nibble[input[inOffset++]];
                        if (b0 < 0 || b1 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        break;
                    }
                    case 2: {
                        b0 = code2nibble[input[inOffset++]];
                        b1 = code2nibble[input[inOffset++]];
                        b2 = code2nibble[input[inOffset++]];
                        if (b0 < 0 || b1 < 0 || b2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("char " + inOffset + " was not B64 encoded");
            }
        }
    }

    private static void cdecode(char[] input, int inOffset, int inLen, byte[] output, int outOffset, int outLen, byte[] code2nibble, byte pad) {
        block11: {
            int stop = outLen / 3 * 3;
            try {
                byte b2;
                byte b1;
                byte b0;
                while (outOffset < stop) {
                    b0 = code2nibble[input[inOffset++]];
                    b1 = code2nibble[input[inOffset++]];
                    b2 = code2nibble[input[inOffset++]];
                    byte b3 = code2nibble[input[inOffset++]];
                    if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                        throw new IllegalArgumentException("Not B64 encoded");
                    }
                    output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                    output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                    output[outOffset++] = (byte)(b2 << 6 | b3);
                }
                if (outLen == outOffset) break block11;
                switch (outLen % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        b0 = code2nibble[input[inOffset++]];
                        b1 = code2nibble[input[inOffset++]];
                        if (b0 < 0 || b1 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        break;
                    }
                    case 2: {
                        b0 = code2nibble[input[inOffset++]];
                        b1 = code2nibble[input[inOffset++]];
                        b2 = code2nibble[input[inOffset++]];
                        if (b0 < 0 || b1 < 0 || b2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("char " + inOffset + " was not B64 encoded");
            }
        }
    }

    public static byte[] decode(String str) {
        return B64Code.decode(str, 0, str.length());
    }

    public static byte[] decode(String str, int inOffset, int inLen) {
        return B64Code.decode(str, inOffset, inLen, code2nibble, (byte)61);
    }

    public static byte[] decodeUS(String str, int inOffset, int inLen) {
        return B64Code.decode(str, inOffset, inLen, code2nibbleUrlSafe, (byte)61);
    }

    public static byte[] decode(String str, int inOffset, int inLen, byte[] code2nibble, byte pad) {
        if (inLen == 0) {
            return new byte[0];
        }
        if (inLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int withoutPaddingLen = inLen;
        int limit = inOffset + inLen;
        while (str.charAt(--limit) == pad) {
            --withoutPaddingLen;
        }
        int outLen = withoutPaddingLen * 3 / 4;
        byte[] output = new byte[outLen];
        B64Code.decode(str, inOffset, inLen, output, 0, outLen, code2nibble, pad);
        return output;
    }

    public static int decodeTo(byte[] output, int outOffset, String str, int inOffset, int inLen, byte[] code2nibble, byte pad) {
        if (inLen == 0) {
            return 0;
        }
        if (inLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int withoutPaddingLen = inLen;
        int limit = inOffset + inLen;
        while (str.charAt(--limit) == pad) {
            --withoutPaddingLen;
        }
        int outLen = withoutPaddingLen * 3 / 4;
        assert (output.length - outOffset >= outLen);
        B64Code.decode(str, inOffset, inLen, output, outOffset, outLen, code2nibble, pad);
        return outLen;
    }

    private static void decode(String str, int inOffset, int inLen, byte[] output, int outOffset, int outLen, byte[] code2nibble, byte pad) {
        block11: {
            int stop = outLen / 3 * 3;
            try {
                byte b2;
                byte b1;
                byte b0;
                while (outOffset < stop) {
                    b0 = code2nibble[str.charAt(inOffset++)];
                    b1 = code2nibble[str.charAt(inOffset++)];
                    b2 = code2nibble[str.charAt(inOffset++)];
                    byte b3 = code2nibble[str.charAt(inOffset++)];
                    if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                        throw new IllegalArgumentException("Not B64 encoded");
                    }
                    output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                    output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                    output[outOffset++] = (byte)(b2 << 6 | b3);
                }
                if (outLen == outOffset) break block11;
                switch (outLen % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        b0 = code2nibble[str.charAt(inOffset++)];
                        b1 = code2nibble[str.charAt(inOffset++)];
                        if (b0 < 0 || b1 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        break;
                    }
                    case 2: {
                        b0 = code2nibble[str.charAt(inOffset++)];
                        b1 = code2nibble[str.charAt(inOffset++)];
                        b2 = code2nibble[str.charAt(inOffset++)];
                        if (b0 < 0 || b1 < 0 || b2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        output[outOffset++] = (byte)(b0 << 2 | b1 >>> 4);
                        output[outOffset++] = (byte)(b1 << 4 | b2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("char " + inOffset + " was not B64 encoded");
            }
        }
    }
}

