/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.MapSchema;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import java.io.IOException;

public class StringMapSchema<V>
extends MapSchema<String, V> {
    public static final StringMapSchema<String> VALUE_STRING = new StringMapSchema<String>(null){

        @Override
        protected void putValueFrom(Input input, MapSchema.MapWrapper<String, String> wrapper, String key) throws IOException {
            wrapper.put(key, input.readString());
        }

        @Override
        protected void writeValueTo(Output output, int fieldNumber, String value, boolean repeated) throws IOException {
            output.writeString(fieldNumber, value, repeated);
        }

        @Override
        protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, true, number, repeated);
        }
    };
    public final Schema<V> vSchema;
    public final Pipe.Schema<V> vPipeSchema;

    public StringMapSchema(Schema<V> vSchema) {
        this(vSchema, null);
    }

    public StringMapSchema(Schema<V> vSchema, Pipe.Schema<V> vPipeSchema) {
        this.vSchema = vSchema;
        this.vPipeSchema = vPipeSchema;
    }

    @Override
    protected final String readKeyFrom(Input input, MapSchema.MapWrapper<String, V> wrapper) throws IOException {
        return input.readString();
    }

    @Override
    protected void putValueFrom(Input input, MapSchema.MapWrapper<String, V> wrapper, String key) throws IOException {
        wrapper.put(key, input.mergeObject(null, this.vSchema));
    }

    @Override
    protected final void writeKeyTo(Output output, int fieldNumber, String value, boolean repeated) throws IOException {
        output.writeString(fieldNumber, value, repeated);
    }

    @Override
    protected void writeValueTo(Output output, int fieldNumber, V value, boolean repeated) throws IOException {
        output.writeObject(fieldNumber, value, this.vSchema, repeated);
    }

    @Override
    protected void transferKey(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
        input.transferByteRangeTo(output, true, number, repeated);
    }

    @Override
    protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
        if (this.vPipeSchema == null) {
            throw new RuntimeException("No pipe schema for value: " + this.vSchema.typeClass().getName());
        }
        output.writeObject(number, (Object)pipe, this.vPipeSchema, repeated);
    }
}

