/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.EnumMapping;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StatefulOutput;
import com.dyuproject.protostuff.StringSerializer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;

public final class JsonOutput
implements StatefulOutput {
    private final JsonGenerator generator;
    private Schema<?> schema;
    private final boolean numeric;
    private final boolean enumsByName;
    private boolean lastRepeated;
    private int lastNumber;

    public JsonOutput(JsonGenerator generator) {
        this(generator, 0);
    }

    public JsonOutput(JsonGenerator generator, int flags) {
        this.generator = generator;
        this.numeric = (flags & 1) != 0;
        this.enumsByName = (flags & 2) != 0;
    }

    public JsonOutput(JsonGenerator generator, int flags, Schema<?> schema) {
        this(generator, flags);
        this.schema = schema;
    }

    public JsonOutput reset() {
        this.lastRepeated = false;
        this.lastNumber = 0;
        return this;
    }

    public JsonOutput use(Schema<?> schema) {
        this.schema = schema;
        return this.reset();
    }

    public boolean isEnumsByName() {
        return this.enumsByName;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBoolean(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBoolean(value);
        } else {
            generator.writeBooleanField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBinary(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBinary(value);
        } else {
            generator.writeFieldName(name);
            generator.writeBinary(value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        String name;
        if (utf8String) {
            this.writeString(fieldNumber, StringSerializer.STRING.deser((byte[])value, (int)offset, (int)length), repeated);
            return;
        }
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBinary(value, offset, length);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBinary(value, offset, length);
        } else {
            generator.writeFieldName(name);
            generator.writeBinary(value, offset, length);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeEnumFromIdx(int fieldNumber, int idx, EnumMapping mapping, boolean repeated) throws IOException {
        if (this.enumsByName) {
            this.writeString(fieldNumber, mapping.names[idx], repeated);
        } else {
            this.writeInt32(fieldNumber, mapping.numbers[idx], repeated);
        }
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeString(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeString(value);
        } else {
            generator.writeStringField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        JsonGenerator generator = this.generator;
        Schema<?> lastSchema = this.schema;
        if (this.lastNumber != fieldNumber) {
            String name;
            if (this.lastRepeated) {
                generator.writeEndArray();
            }
            String string = name = this.numeric ? Integer.toString(fieldNumber) : lastSchema.getFieldName(fieldNumber);
            if (repeated) {
                generator.writeArrayFieldStart(name);
            } else {
                generator.writeFieldName(name);
            }
        }
        this.schema = schema;
        this.lastNumber = 0;
        this.lastRepeated = false;
        generator.writeStartObject();
        schema.writeTo((Output)this, value);
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
        this.schema = lastSchema;
    }
}

