/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.B64Code;
import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.EnumMapping;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.JsonInputException;
import com.dyuproject.protostuff.NumberParser;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.UninitializedMessageException;
import java.io.IOException;

public final class JsonXByteArrayInput
implements Input {
    static final byte VALUE_NUM = 0;
    static final byte VALUE_NULL = 110;
    static final byte START_OBJECT = 123;
    static final byte END_OBJECT = 125;
    static final byte START_ARRAY = 91;
    static final byte END_ARRAY = 93;
    static final byte COMMA = 44;
    static final byte COLON = 58;
    static final byte QUOTE = 34;
    private static final int[] intDigits = new int[127];
    private static final int[] floatDigits = new int[127];
    static final int END_OF_NUMBER = -2;
    static final int DOT_IN_NUMBER = -3;
    static final int INVALID_CHAR_FOR_NUMBER = -1;
    private static final int[] hexDigits = new int[103];
    private static final byte[] breaks = new byte[256];
    private byte[] buf;
    private int start;
    private int offset;
    private int limit;
    final boolean allowQuotedInt64;
    final char[] charBuf;
    final int charOffset;
    final int charLimit;
    final boolean charBufAsLimit;
    final int previewMaxLen;
    private byte token = 0;
    private boolean lastRepeated;
    private int lastNumber;

    static {
        int i = 0;
        while (i < floatDigits.length) {
            JsonXByteArrayInput.floatDigits[i] = -1;
            JsonXByteArrayInput.intDigits[i] = -1;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            JsonXByteArrayInput.floatDigits[i] = i - 48;
            JsonXByteArrayInput.intDigits[i] = i - 48;
            ++i;
        }
        JsonXByteArrayInput.floatDigits[44] = -2;
        JsonXByteArrayInput.floatDigits[93] = -2;
        JsonXByteArrayInput.floatDigits[125] = -2;
        JsonXByteArrayInput.floatDigits[32] = -2;
        JsonXByteArrayInput.floatDigits[46] = -3;
        i = 0;
        while (i < hexDigits.length) {
            JsonXByteArrayInput.hexDigits[i] = -1;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            JsonXByteArrayInput.hexDigits[i] = i - 48;
            ++i;
        }
        i = 97;
        while (i <= 102) {
            JsonXByteArrayInput.hexDigits[i] = i - 97 + 10;
            ++i;
        }
        i = 65;
        while (i <= 70) {
            JsonXByteArrayInput.hexDigits[i] = i - 65 + 10;
            ++i;
        }
        JsonXByteArrayInput.breaks[32] = 1;
        JsonXByteArrayInput.breaks[9] = 1;
        JsonXByteArrayInput.breaks[10] = 1;
        JsonXByteArrayInput.breaks[13] = 1;
        JsonXByteArrayInput.breaks[44] = 2;
        JsonXByteArrayInput.breaks[125] = 2;
        JsonXByteArrayInput.breaks[93] = 2;
    }

    public JsonXByteArrayInput(byte[] buf, int offset, int len, boolean allowQuotedInt64, char[] charBuf, int charOffset, int charLen, boolean charBufAsLimit, int previewMaxLen) {
        this.buf = buf;
        this.start = offset;
        this.offset = offset;
        this.limit = offset + len;
        this.allowQuotedInt64 = allowQuotedInt64;
        this.charBuf = charBuf;
        this.charOffset = charOffset;
        this.charLimit = charOffset + charLen;
        this.charBufAsLimit = charBufAsLimit;
        this.previewMaxLen = previewMaxLen;
    }

    int currentOffset() {
        return this.offset;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public JsonXByteArrayInput reset() {
        this.token = 0;
        this.lastRepeated = false;
        this.lastNumber = 0;
        return this;
    }

    public JsonXByteArrayInput reset(int offset) {
        this.start = offset;
        this.offset = offset;
        return this.reset();
    }

    public JsonXByteArrayInput reset(int offset, int len) {
        this.start = offset;
        this.offset = offset;
        this.limit = offset + len;
        return this.reset();
    }

    public JsonXByteArrayInput setBounds(int offset, int limit) {
        this.start = offset;
        this.offset = offset;
        this.limit = limit;
        return this.reset();
    }

    public JsonXByteArrayInput reset(byte[] buf, int offset, int len) {
        this.buf = buf;
        return this.reset(offset, len);
    }

    private static int findTokenOrEnd(byte token, int offset, int max, byte[] buf, int limit) {
        if (offset == limit) {
            return limit;
        }
        int i = 0;
        int remaining = Math.min(limit - offset, max);
        while (i < remaining && token != buf[offset]) {
            ++i;
            ++offset;
        }
        return offset;
    }

    private static int rfindTokenOrStart(byte token, int offset, int max, int maxCount, int diff, byte[] buf, int start, char[] out, int outOffset) {
        out[outOffset] = '\u0000';
        int remaining = Math.min(offset - start, max);
        if (remaining == 0) {
            return 0;
        }
        int i = 0;
        int seenCount = 0;
        int end = offset;
        while (i < remaining) {
            if (token == buf[offset]) {
                if (1 == ++seenCount) {
                    out[outOffset] = (char)(end - offset + diff);
                }
                if (seenCount == maxCount) break;
            }
            ++i;
            --offset;
        }
        return i == remaining ? 0 : offset + diff;
    }

    private final JsonInputException reportError(String op, String msg) {
        String preview;
        int start;
        StringBuilder sb = new StringBuilder().append(op).append(':').append(' ').append(msg).append(" at offset: ").append(this.offset - 1).append('\n');
        if (this.previewMaxLen == 0) {
            return new JsonInputException(sb.toString());
        }
        boolean diff = true;
        int end = JsonXByteArrayInput.findTokenOrEnd((byte)10, this.offset, 16, this.buf, this.limit);
        int len = end - (start = JsonXByteArrayInput.rfindTokenOrStart((byte)10, this.offset - 1, 250, 5, 1, this.buf, this.start, this.charBuf, this.charOffset));
        if (len > this.previewMaxLen) {
            return new JsonInputException(sb.toString());
        }
        try {
            preview = new String(this.buf, start, len, "UTF-8");
        }
        catch (Exception e) {
            preview = "";
        }
        if (!preview.isEmpty()) {
            sb.append(preview).append('\n');
            len = 0xFFFF & this.charBuf[this.charOffset];
            if (len == 0) {
                end = this.offset;
                while (end != ++start) {
                    sb.append('-');
                }
            } else {
                --len;
                while (--len > 0) {
                    sb.append('-');
                }
            }
            sb.append('^');
        }
        return new JsonInputException(sb.toString());
    }

    private String tokenToString() {
        return new String(new char[]{(char)this.token});
    }

    byte currentToken() {
        return this.token;
    }

    byte nextToken() throws IOException {
        byte c;
        int i = this.offset;
        block3: while (true) {
            c = this.buf[i++];
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (i != this.limit) continue block3;
                    throw this.reportError("nextToken", "Missing \"}\"");
                }
            }
            break;
        }
        this.offset = i;
        this.token = c;
        return c;
    }

    private byte skip() throws IOException {
        switch (this.token) {
            case 34: {
                return this.skipUntilBreakToken(this.skipString(this.offset), true);
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.skipUntilBreakToken(this.offset, true);
            }
            case 110: 
            case 116: {
                return this.skipUntilBreakToken(this.offset + 3, true);
            }
            case 102: {
                return this.skipUntilBreakToken(this.offset + 4, true);
            }
            case 91: {
                return this.skipUntilBreakToken(this.skipArray(this.offset), true);
            }
            case 123: {
                return this.skipUntilBreakToken(this.skipObject(this.offset), true);
            }
        }
        throw this.reportError("skip", "could not skip: " + this.tokenToString());
    }

    private int skipArray(int offset) throws IOException {
        int level = 1;
        int i = offset;
        while (i < this.limit) {
            switch (this.buf[i++]) {
                case 34: {
                    i = this.skipString(i);
                    break;
                }
                case 91: {
                    ++level;
                    break;
                }
                case 93: {
                    if (--level != 0) break;
                    return i;
                }
            }
        }
        throw this.reportError("skipArray", "incomplete array");
    }

    private int skipObject(int offset) throws IOException {
        int level = 1;
        int i = offset;
        while (i < this.limit) {
            switch (this.buf[i++]) {
                case 34: {
                    i = this.skipString(i);
                    break;
                }
                case 123: {
                    ++level;
                    break;
                }
                case 125: {
                    if (--level != 0) break;
                    return i;
                }
            }
        }
        throw this.reportError("skipObject", "Incomplete object");
    }

    private byte skipUntilBreakToken(int offset, boolean nextTokenOnComma) throws IOException {
        while (offset < this.limit && 2 != breaks[0xFF & this.buf[offset]]) {
            ++offset;
        }
        if (offset >= this.limit) {
            throw this.reportError("skipUntilBreakToken", "Truncated");
        }
        byte c = this.buf[offset];
        this.offset = ++offset;
        if (!nextTokenOnComma || 44 != c) {
            this.token = c;
        } else if (offset != this.limit) {
            c = this.nextToken();
        } else {
            throw this.reportError("skipUntilBreakToken", "Truncated");
        }
        return c;
    }

    private int skipString(int start) throws IOException {
        int end = JsonXByteArrayInput.findStringEnd(this.buf, start, this.limit);
        if (end == -1) {
            throw this.reportError("skipString", "Incomplete string");
        }
        return end + 1;
    }

    static int findStringEnd(byte[] input, int offset, int limit) {
        boolean escaped = false;
        int i = offset;
        int j = 0;
        while (i < limit) {
            byte c = input[i];
            if (34 != c) {
                escaped = c == 92;
            } else {
                if (!escaped) {
                    return i;
                }
                j = i - 1;
                do {
                    if (j >= offset && 92 == input[j--]) continue;
                    return i;
                } while (j >= offset && 92 == input[j--]);
            }
            ++i;
        }
        return -1;
    }

    int readNumericField() throws IOException {
        byte b;
        if (this.offset == this.limit) {
            throw this.reportError("readField", "Truncated");
        }
        int value = this.parseInt(this.buf[this.offset++]);
        if (34 != this.token) {
            throw this.reportError("readField", "Invalid field number");
        }
        if (58 != this.nextToken() || this.offset == this.limit) {
            throw this.reportError("readField", "Invalid field value for the field: " + value);
        }
        int c = 0xFF & this.nextToken();
        while ((b = breaks[c]) != 0) {
            if (b == 2 || this.offset == this.limit) {
                throw this.reportError("readField", "Invalid field value for the field: " + value);
            }
            c = 0xFF & this.nextToken();
        }
        return value;
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        if (this.lastRepeated) {
            this.lastRepeated = false;
            this.skipUntilBreakToken(this.skipArray(this.offset - 1), true);
        } else {
            this.skip();
        }
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        int fieldNumber;
        byte c = this.token;
        if (this.lastRepeated) {
            if (110 != c) {
                return this.lastNumber;
            }
            while (110 == (c = this.skipUntilBreakToken(this.offset, true))) {
            }
            if (93 != c) {
                return this.lastNumber;
            }
            this.lastNumber = 0;
            this.lastRepeated = false;
        }
        while (true) {
            if (125 == c) {
                return 0;
            }
            if (34 != c) {
                throw this.reportError("readFieldNumber", "Expected token: $field: but was " + this.tokenToString() + " on message " + schema.messageFullName());
            }
            fieldNumber = this.readNumericField();
            c = this.token;
            if (110 == c) {
                c = this.skipUntilBreakToken(this.offset + 3, true);
                continue;
            }
            if (fieldNumber < 1) {
                c = this.skip();
                continue;
            }
            if (91 != c) {
                this.lastRepeated = false;
                break;
            }
            if (93 != this.nextToken()) {
                this.lastRepeated = true;
                break;
            }
            c = this.skipUntilBreakToken(this.offset, true);
        }
        this.lastNumber = fieldNumber;
        return fieldNumber;
    }

    private int parseInt(byte b) throws IOException {
        boolean isNeg;
        boolean bl = isNeg = b == 45;
        if (isNeg) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt32", "Truncated");
            }
            this.token = b = this.buf[this.offset++];
        }
        if (b < 48 || b > 57) {
            throw this.reportError("readInt32", "Expected 0~9");
        }
        int x = 48 - b;
        if (x == 0) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt32", "Truncated");
            }
            this.token = b = this.buf[this.offset++];
            if (b == 46) {
                throw this.reportError("readInt32", "Invalid integer");
            }
            if (b >= 48 && b <= 57) {
                throw this.reportError("readInt32", "Leading zero invalid");
            }
            return x;
        }
        int pos = this.offset;
        while (pos < this.limit && 48 <= (b = this.buf[pos]) && b <= 57) {
            if (x < -214748364 || (x = x * 10 + (48 - b)) > 0) {
                throw this.reportError("readInt32", "Invalid number (overflow)");
            }
            ++pos;
        }
        if (pos == this.limit) {
            throw this.reportError("readInt32", "Truncated");
        }
        this.token = b;
        this.offset = pos + 1;
        if ((b | 0x20) == 101 || b == 46) {
            throw this.reportError("readInt32", "Invalid integer");
        }
        if (!isNeg) {
            if (x == Integer.MIN_VALUE) {
                throw this.reportError("readInt32", "Invalid integer (overflow)");
            }
            x = -x;
        }
        return x;
    }

    private long parseLong(byte b) throws IOException {
        boolean isNeg;
        boolean bl = isNeg = b == 45;
        if (isNeg) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt64", "Truncated");
            }
            this.token = b = this.buf[this.offset++];
        }
        if (b < 48 || b > 57) {
            throw this.reportError("readInt64", "Expected 0~9");
        }
        long x = 48 - b;
        if (x == 0L) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt64", "Truncated");
            }
            this.token = b = this.buf[this.offset++];
            if (b == 46) {
                throw this.reportError("readInt64", "Invalid integer");
            }
            if (b >= 48 && b <= 57) {
                throw this.reportError("readInt64", "Leading zero invalid");
            }
            return x;
        }
        int pos = this.offset;
        while (pos < this.limit && 48 <= (b = this.buf[pos]) && b <= 57) {
            if (x < -922337203685477580L || 0L < (x = x * 10L + (long)(48 - b))) {
                throw this.reportError("readInt64", "Invalid integer (overflow)");
            }
            ++pos;
        }
        if (pos == this.limit) {
            throw this.reportError("readInt64", "Truncated");
        }
        this.token = b;
        this.offset = pos + 1;
        if ((b | 0x20) == 101 || b == 46) {
            throw this.reportError("readInt64", "Invalid integer");
        }
        if (!isNeg) {
            if (x == Long.MIN_VALUE) {
                throw this.reportError("readInt64", "Invalid integer (overflow)");
            }
            x = -x;
        }
        return x;
    }

    public boolean readBool() throws IOException {
        boolean value;
        byte c;
        switch (this.token) {
            case 102: {
                c = this.skipUntilBreakToken(this.offset + 4, true);
                value = false;
                break;
            }
            case 116: {
                c = this.skipUntilBreakToken(this.offset + 3, true);
                value = true;
                break;
            }
            default: {
                throw this.reportError("readBool", "Expected token: true/false but was " + this.tokenToString());
            }
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public double readDouble() throws IOException {
        String str;
        int start = this.offset - 1;
        byte c = this.skipUntilBreakToken(this.offset, false);
        int lastIdx = this.offset - 1 - 1;
        while (Character.isWhitespace((char)this.buf[lastIdx])) {
            --lastIdx;
        }
        if (34 != this.buf[start]) {
            str = new String(this.buf, start, lastIdx + 1 - start);
        } else if (34 == this.buf[lastIdx]) {
            str = new String(this.buf, start + 1, lastIdx - 1 - start);
        } else {
            throw this.reportError("readDouble", "Invalid number/string");
        }
        double value = "infinity".equals(str) ? Double.POSITIVE_INFINITY : ("-infinity".equals(str) ? Double.NEGATIVE_INFINITY : Double.parseDouble(str));
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readDouble", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public int readEnum() throws IOException {
        return this.readInt32();
    }

    public int readEnumIdx(EnumMapping mapping) throws IOException {
        Integer idx;
        int start = this.offset - 1;
        byte c = this.skipUntilBreakToken(this.offset, false);
        int lastIdx = this.offset - 1 - 1;
        while (Character.isWhitespace((char)this.buf[lastIdx])) {
            --lastIdx;
        }
        if (34 != this.buf[start]) {
            idx = (Integer)mapping.numberIdxMap.get(NumberParser.parseInt((byte[])this.buf, (int)start, (int)(lastIdx + 1 - start), (int)10));
        } else if (34 == this.buf[lastIdx]) {
            idx = (Integer)mapping.nameIdxMap.get(new String(this.buf, start + 1, lastIdx - 1 - start));
        } else {
            throw this.reportError("readEnumIdx", "Invalid number/string");
        }
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readEnumIdx", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return idx == null ? -1 : idx;
    }

    public int readFixed32() throws IOException {
        return this.readInt32();
    }

    public long readFixed64() throws IOException {
        return this.readInt64();
    }

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public int readInt32() throws IOException {
        int value = this.parseInt(this.token);
        byte c = this.token;
        if (breaks[0xFF & c] == 0) {
            throw this.reportError("readInt32", "Expected ',]}' but was " + this.tokenToString());
        }
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt32", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public long readInt64() throws IOException {
        if (this.allowQuotedInt64) {
            return this.flexReadInt64();
        }
        long value = this.parseLong(this.token);
        byte c = this.token;
        if (breaks[0xFF & c] == 0) {
            throw this.reportError("readInt64", "Expected ',]}' but was " + this.tokenToString());
        }
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readInt64", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    private long flexReadInt64() throws IOException {
        long value;
        int start = this.offset - 1;
        byte c = this.skipUntilBreakToken(this.offset, false);
        int lastIdx = this.offset - 1 - 1;
        while (Character.isWhitespace((char)this.buf[lastIdx])) {
            --lastIdx;
        }
        if (34 != this.buf[start]) {
            value = NumberParser.parseLong((byte[])this.buf, (int)start, (int)(lastIdx + 1 - start), (int)10);
        } else if (34 == this.buf[lastIdx]) {
            value = Double.doubleToRawLongBits(Double.parseDouble(new String(this.buf, start + 1, lastIdx - 1 - start)));
        } else {
            throw this.reportError("readLong", "Invalid number/string");
        }
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readLong", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public int readSFixed32() throws IOException {
        return this.readInt32();
    }

    public long readSFixed64() throws IOException {
        return this.readInt64();
    }

    public int readSInt32() throws IOException {
        return this.readInt32();
    }

    public long readSInt64() throws IOException {
        return this.readInt64();
    }

    public int readUInt32() throws IOException {
        return this.readInt32();
    }

    public long readUInt64() throws IOException {
        return this.readInt64();
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    public byte[] readByteArray() throws IOException {
        if (34 != this.token) {
            throw this.reportError("readByteArray", "Expected base64 string");
        }
        int start = this.offset;
        this.offset = this.skipString(start);
        int len = this.offset - 1 - start;
        this.token = (byte)34;
        byte[] value = B64Code.decode((byte[])this.buf, (int)start, (int)len);
        byte b = this.skipUntilBreakToken(this.offset, true);
        if (this.lastRepeated && 93 == b) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public String readString() throws IOException {
        if (34 != this.token) {
            throw this.reportError("readString", "Expected string");
        }
        String value = this.parseString();
        byte b = this.skipUntilBreakToken(this.offset, true);
        if (this.lastRepeated && 93 == b) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (123 != this.token) {
            throw this.reportError("mergeObject", "Expected token: { but was " + this.tokenToString() + " on " + this.lastNumber + " of message " + schema.messageFullName());
        }
        this.nextToken();
        int lastNumber = this.lastNumber;
        boolean lastRepeated = this.lastRepeated;
        this.lastRepeated = false;
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (125 != this.token) {
            throw this.reportError("mergeObject", "Expected token: } but was " + this.tokenToString() + " on " + lastNumber + " of message " + schema.messageFullName());
        }
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.lastNumber = lastNumber;
        this.lastRepeated = lastRepeated;
        if (this.offset == this.limit) {
            throw this.reportError("readObject", "Truncated");
        }
        byte c = this.skipUntilBreakToken(this.offset, true);
        if (lastRepeated && 93 == c) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        return value;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        if (utf8String) {
            output.writeString(fieldNumber, this.readString(), repeated);
        } else {
            output.writeByteArray(fieldNumber, this.readByteArray(), repeated);
        }
    }

    public void transferEnumTo(Output output, EnumMapping mapping, int fieldNumber, boolean repeated) throws IOException {
        int start = this.offset - 1;
        byte c = this.skipUntilBreakToken(this.offset, false);
        int lastIdx = this.offset - 1 - 1;
        while (Character.isWhitespace((char)this.buf[lastIdx])) {
            --lastIdx;
        }
        int number = 0;
        String name = null;
        if (34 != this.buf[start]) {
            number = NumberParser.parseInt((byte[])this.buf, (int)start, (int)(lastIdx + 1 - start), (int)10);
        } else if (34 == this.buf[lastIdx]) {
            name = new String(this.buf, start + 1, lastIdx - 1 - start);
        } else {
            throw this.reportError("readEnumIdx", "Invalid number/string");
        }
        if (c == 44) {
            if (this.offset == this.limit) {
                throw this.reportError("readEnumIdx", "Truncated");
            }
            c = this.nextToken();
        }
        if (this.lastRepeated && c == 93) {
            this.skipUntilBreakToken(this.offset, true);
            this.lastRepeated = false;
        }
        if (name == null) {
            if (!output.isEnumsByName()) {
                output.writeEnum(fieldNumber, number, repeated);
            } else {
                Integer idx = (Integer)mapping.numberIdxMap.get(number);
                if (idx != null) {
                    output.writeEnumFromIdx(fieldNumber, idx.intValue(), mapping, repeated);
                }
            }
        } else if (output.isEnumsByName()) {
            output.writeString(fieldNumber, name, repeated);
        } else {
            Integer idx = (Integer)mapping.nameIdxMap.get(name);
            if (idx != null) {
                output.writeEnumFromIdx(fieldNumber, idx.intValue(), mapping, repeated);
            }
        }
    }

    private String parseString() throws IOException {
        int bb;
        byte[] buffer = this.buf;
        char[] chars = this.charBuf;
        int startIndex = this.offset;
        if (this.offset == this.limit) {
            throw this.reportError("readString", "Truncated");
        }
        int ci = startIndex;
        char[] _tmp = chars;
        int maxSize = this.charLimit - this.charOffset;
        int remaining = this.limit - this.offset;
        int tmpSize = maxSize < remaining ? maxSize : remaining;
        int i = 0;
        while (i < tmpSize) {
            if (34 == (bb = buffer[ci++])) {
                this.token = bb;
                this.offset = ci;
                return new String(chars, this.charOffset, i);
            }
            if ((bb ^ 0x5C) < 1) break;
            _tmp[this.charOffset + i] = (char)bb;
            ++i;
        }
        if (i == maxSize) {
            throw this.reportError("readString", "Maximum string buffer limit exceeded");
        }
        tmpSize = maxSize;
        this.offset = ci - 1;
        int soFar = this.offset - startIndex;
        int bc = 0;
        while (this.offset < this.limit) {
            block28: {
                block27: {
                    if (34 == (bb = buffer[this.offset++])) {
                        this.token = bb;
                        return new String(chars, this.charOffset, soFar);
                    }
                    bc = bb;
                    if (92 != bc) break block27;
                    if (soFar >= tmpSize - 6) {
                        throw this.reportError("readString", "Maximum string buffer limit exceeded");
                    }
                    bc = buffer[this.offset++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block28;
                        }
                        case 116: {
                            bc = 9;
                            break block28;
                        }
                        case 110: {
                            bc = 10;
                            break block28;
                        }
                        case 102: {
                            bc = 12;
                            break block28;
                        }
                        case 114: {
                            bc = 13;
                            break block28;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block28;
                        }
                        case 117: {
                            bc = (this.hexToInt(buffer[this.offset++]) << 12) + (this.hexToInt(buffer[this.offset++]) << 8) + (this.hexToInt(buffer[this.offset++]) << 4) + this.hexToInt(buffer[this.offset++]);
                            break block28;
                        }
                        default: {
                            throw this.reportError("readString", "Invalid escape combination detected");
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    if (soFar >= tmpSize - 4) {
                        throw this.reportError("readString", "Maximum string buffer limit exceeded");
                    }
                    byte u2 = buffer[this.offset++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = buffer[this.offset++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = buffer[this.offset++];
                            if ((bc & 0xF8) != 240) {
                                throw this.reportError("readString", "Invalid unicode character detected");
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw this.reportError("readString", "Invalid unicode character detected");
                                }
                                int sup = bc - 65536;
                                _tmp[this.charOffset + soFar] = (char)((sup >>> 10) + 55296);
                                _tmp[this.charOffset + soFar + 1] = (char)((sup & 0x3FF) + 56320);
                                soFar += 2;
                                continue;
                            }
                        }
                    }
                } else if (soFar >= tmpSize) {
                    throw this.reportError("readString", "Maximum string buffer limit exceeded");
                }
            }
            _tmp[this.charOffset + soFar] = (char)bc;
            ++soFar;
        }
        throw this.reportError("readString", "JSON string was not closed with a double quote");
    }

    private int hexToInt(byte value) throws IOException {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 65 && value <= 70) {
            return value - 55;
        }
        if (value >= 97 && value <= 102) {
            return value - 87;
        }
        throw this.reportError("readString", "Could not parse unicode escape, expected a hexadecimal digit");
    }
}

