/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.JsonInputException;
import com.dyuproject.protostuff.JsonXByteArrayInput;
import com.dyuproject.protostuff.JsonXOutput;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class JsonXIOUtil {
    private static final byte[] EMPTY_ARRAY = new byte[]{91, 93};
    static final int TMP_CBUF_LEN = Integer.getInteger("jsonx.tmp_cbuf_len", 256);
    static final int ERR_PREVIEW_MAX_LEN = Integer.getInteger("jsonx.err_preview_max_len", 90);

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        return JsonXIOUtil.toByteArray(message, schema, numeric ? 1 : 0, buffer);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, int flags, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, flags, schema);
        try {
            output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> void writeTo(LinkedBuffer buffer, T message, Schema<T> schema, boolean numeric) {
        JsonXIOUtil.writeTo(buffer, message, schema, numeric ? 1 : 0);
    }

    public static <T> void writeTo(LinkedBuffer buffer, T message, Schema<T> schema, int flags) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, flags, schema);
        try {
            output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T extends Message<T>> void writeTo(OutputStream out, T message, boolean numeric, LinkedBuffer buffer) throws IOException {
        JsonXIOUtil.writeTo(out, message, message.cachedSchema(), numeric, buffer);
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        JsonXIOUtil.writeTo(out, message, schema, numeric ? 1 : 0, buffer);
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, int flags, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, out, flags, schema);
        output.writeStartObject();
        schema.writeTo((Output)output, message);
        if (output.isLastRepeated()) {
            output.writeEndArray();
        }
        output.writeEndObject();
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public static <T> void writeListTo(LinkedBuffer buffer, List<T> messages, Schema<T> schema, boolean numeric) {
        JsonXIOUtil.writeListTo(buffer, messages, schema, numeric ? 1 : 0);
    }

    public static <T> void writeListTo(LinkedBuffer buffer, List<T> messages, Schema<T> schema, int flags) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, flags, schema);
        try {
            if (messages.isEmpty()) {
                output.tail = output.sink.writeByteArray(EMPTY_ARRAY, (WriteSession)output, output.tail);
                return;
            }
            output.writeStartArray();
            boolean first = true;
            for (T m : messages) {
                if (first) {
                    first = false;
                    output.writeStartObject();
                } else {
                    output.writeCommaAndStartObject();
                }
                schema.writeTo((Output)output, m);
                if (output.isLastRepeated()) {
                    output.writeEndArray();
                }
                output.writeEndObject().reset();
            }
            output.writeEndArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        JsonXIOUtil.writeListTo(out, messages, schema, numeric ? 1 : 0, buffer);
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, int flags, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        if (messages.isEmpty()) {
            out.write(EMPTY_ARRAY);
            return;
        }
        JsonXOutput output = new JsonXOutput(buffer, out, flags, schema);
        output.writeStartArray();
        boolean first = true;
        for (T m : messages) {
            if (first) {
                first = false;
                output.writeStartObject();
            } else {
                output.writeCommaAndStartObject();
            }
            schema.writeTo((Output)output, m);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject().reset();
        }
        output.writeEndArray();
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public static <T> List<T> parseListFrom(byte[] data, Schema<T> schema) throws IOException {
        return JsonXIOUtil.parseListFrom(data, 0, data.length, schema, TMP_CBUF_LEN, true);
    }

    public static <T> List<T> parseListFrom(byte[] data, int offset, int len, Schema<T> schema) throws IOException {
        return JsonXIOUtil.parseListFrom(data, offset, len, schema, TMP_CBUF_LEN, true);
    }

    public static <T> List<T> parseListFrom(byte[] data, int offset, int len, Schema<T> schema, int charBufSize, boolean charBufAsLimit) throws IOException {
        return JsonXIOUtil.parseListFrom(data, offset, len, schema, false, new char[charBufSize], 0, charBufSize, charBufAsLimit);
    }

    private static int nextOffset(byte[] data, int i, int limit) {
        while (i < limit && Character.isWhitespace((char)data[i])) {
            ++i;
        }
        return i;
    }

    public static <T> List<T> parseListFrom(byte[] data, int offset, int len, Schema<T> schema, boolean allowQuotedInt64, char[] cbuf, int coffset, int clen, boolean charBufAsLimit) throws IOException {
        int limit = offset + len;
        int i = JsonXIOUtil.nextOffset(data, offset, limit);
        if (i == limit) {
            throw new JsonInputException("Expected token: [ but was truncated on message: " + schema.messageFullName());
        }
        byte b = data[i];
        if (91 != b) {
            cbuf[coffset] = (char)b;
            throw new JsonInputException("Expected token: [ but was " + new String(cbuf, coffset, 1) + " on message: " + schema.messageFullName());
        }
        if (limit == (i = JsonXIOUtil.nextOffset(data, i + 1, limit))) {
            throw new JsonInputException("Input was truncated on message: " + schema.messageFullName());
        }
        ArrayList<Object> list = new ArrayList<Object>();
        b = data[i];
        if (93 == b) {
            return list;
        }
        JsonXByteArrayInput input = new JsonXByteArrayInput(data, i, limit - i, allowQuotedInt64, cbuf, coffset, clen, charBufAsLimit, ERR_PREVIEW_MAX_LEN);
        while (true) {
            if (123 != (b = input.nextToken())) {
                cbuf[coffset] = (char)b;
                throw new JsonInputException("Expected token: { but was " + new String(cbuf, coffset, 1) + " on message " + schema.messageFullName());
            }
            input.nextToken();
            Object message = schema.newMessage();
            schema.mergeFrom((Input)input, message);
            b = input.currentToken();
            if (125 != b) {
                cbuf[coffset] = (char)b;
                throw new JsonInputException("Expected token: } but was " + new String(cbuf, coffset, 1) + " on message " + schema.messageFullName());
            }
            list.add(message);
            i = JsonXIOUtil.nextOffset(data, input.currentOffset(), limit);
            if (limit <= i) {
                throw new JsonInputException("Input was truncated on message: " + schema.messageFullName());
            }
            b = data[i];
            if (93 == b) break;
            if (44 != b) {
                cbuf[coffset] = (char)b;
                throw new JsonInputException("Expected token: , but was " + new String(cbuf, coffset, 1) + " on message " + schema.messageFullName());
            }
            if (limit == (i = JsonXIOUtil.nextOffset(data, i + 1, limit))) {
                throw new JsonInputException("Input was truncated on message: " + schema.messageFullName());
            }
            input.reset(i);
            b = data[i];
        }
        return list;
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema) throws IOException {
        JsonXIOUtil.mergeFrom(data, 0, data.length, message, schema, TMP_CBUF_LEN, true);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int len, T message, Schema<T> schema) throws IOException {
        JsonXIOUtil.mergeFrom(data, offset, len, message, schema, TMP_CBUF_LEN, true);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int len, T message, Schema<T> schema, int charBufSize, boolean charBufAsLimit) throws IOException {
        JsonXIOUtil.mergeFrom(data, offset, len, message, schema, false, new char[charBufSize], 0, charBufSize, charBufAsLimit);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int len, T message, Schema<T> schema, boolean allowQuotedInt64, char[] cbuf, int coffset, int clen, boolean charBufAsLimit) throws IOException {
        if (len < 2) {
            throw new JsonInputException("Input must have a minimum length of 2: '{}' on message " + schema.messageFullName());
        }
        JsonXByteArrayInput input = new JsonXByteArrayInput(data, offset, len, allowQuotedInt64, cbuf, coffset, clen, charBufAsLimit, ERR_PREVIEW_MAX_LEN);
        JsonXIOUtil.mergeFrom(input, message, schema);
    }

    static <T> void mergeFrom(JsonXByteArrayInput input, T message, Schema<T> schema) throws IOException {
        if (123 != input.nextToken()) {
            throw new JsonInputException("Expected token: { but was " + (char)input.currentToken() + " on message " + schema.messageFullName());
        }
        input.nextToken();
        schema.mergeFrom((Input)input, message);
        if (125 != input.currentToken()) {
            throw new JsonInputException("Expected token: } but was " + (char)input.currentToken() + " on message " + schema.messageFullName());
        }
    }

    public static Pipe newPipe(byte[] data) throws IOException {
        return JsonXIOUtil.newPipe(data, 0, data.length, TMP_CBUF_LEN, true);
    }

    public static Pipe newPipe(byte[] data, int offset, int len) throws IOException {
        return JsonXIOUtil.newPipe(data, offset, len, TMP_CBUF_LEN, true);
    }

    public static Pipe newPipe(byte[] data, int offset, int len, int charBufSize, boolean charBufAsLimit) throws IOException {
        return JsonXIOUtil.newPipe(data, offset, len, false, new char[charBufSize], 0, charBufSize, charBufAsLimit);
    }

    public static Pipe newPipe(byte[] data, int offset, int len, boolean allowQuotedInt64, char[] cbuf, int coffset, int clen, boolean charBufAsLimit) throws IOException {
        if (len < 2) {
            throw new JsonInputException("Input must have a minimum length of 2: '{}'");
        }
        final JsonXByteArrayInput jsonInput = new JsonXByteArrayInput(data, offset, len, allowQuotedInt64, cbuf, coffset, clen, charBufAsLimit, ERR_PREVIEW_MAX_LEN);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                if (123 != jsonInput.nextToken()) {
                    throw new JsonInputException("Expected token: { but was " + (char)jsonInput.currentToken() + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
                jsonInput.nextToken();
                return jsonInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                if (!$assertionsDisabled && input != jsonInput) {
                    throw new AssertionError();
                }
                if (125 != jsonInput.currentToken()) {
                    throw new JsonInputException("Expected token: } but was " + (char)jsonInput.currentToken() + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
            }
        };
    }
}

