/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.MapSchema;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.Delegate;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.HasDelegate;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public abstract class NumericIdStrategy
extends IdStrategy {
    protected static final int CID_BOOL = 0;
    protected static final int CID_BYTE = 1;
    protected static final int CID_CHAR = 2;
    protected static final int CID_SHORT = 3;
    protected static final int CID_INT32 = 4;
    protected static final int CID_INT64 = 5;
    protected static final int CID_FLOAT = 6;
    protected static final int CID_DOUBLE = 7;
    protected static final int CID_STRING = 16;
    protected static final int CID_BYTES = 17;
    protected static final int CID_BYTE_ARRAY = 18;
    protected static final int CID_BIGDECIMAL = 19;
    protected static final int CID_BIGINTEGER = 20;
    protected static final int CID_DATE = 21;
    protected static final int CID_OBJECT = 22;
    protected static final int CID_ENUM_SET = 23;
    protected static final int CID_ENUM_MAP = 24;
    protected static final int CID_ENUM = 25;
    protected static final int CID_COLLECTION = 26;
    protected static final int CID_MAP = 27;
    protected static final int CID_POJO = 28;
    protected static final int CID_CLASS = 29;
    protected static final int CID_DELEGATE = 30;

    protected NumericIdStrategy(IdStrategy primaryGroup, int groupId) {
        super(primaryGroup, groupId);
    }

    protected void writeArrayIdTo(Output output, Class<?> componentType) throws IOException {
        assert (!componentType.isArray());
        RegisteredDelegate<?> rd = this.getRegisteredDelegate(componentType);
        if (rd != null) {
            output.writeUInt32(15, rd.id << 5 | 0x1E, false);
            return;
        }
        RuntimeFieldFactory inline = RuntimeFieldFactory.getInline(componentType);
        if (inline != null) {
            output.writeUInt32(15, NumericIdStrategy.getPrimitiveOrScalarId(componentType, inline.id), false);
        } else if (componentType.isEnum()) {
            output.writeUInt32(15, this.getEnumId(componentType), false);
        } else if (Object.class == componentType) {
            output.writeUInt32(15, 22, false);
        } else if (Class.class == componentType) {
            output.writeUInt32(15, 29, false);
        } else if (!componentType.isInterface() && !Modifier.isAbstract(componentType.getModifiers())) {
            output.writeUInt32(15, this.getId(componentType), false);
        } else {
            output.writeString(17, componentType.getName(), false);
        }
    }

    protected void transferArrayId(Input input, Output output, int fieldNumber, boolean mapped) throws IOException {
        if (mapped) {
            input.transferByteRangeTo(output, true, fieldNumber, false);
        } else {
            output.writeUInt32(fieldNumber, input.readUInt32(), false);
        }
    }

    protected Class<?> resolveArrayComponentTypeFrom(Input input, boolean mapped) throws IOException {
        return mapped ? RuntimeEnv.loadClass((String)input.readString()) : this.resolveClass(input.readUInt32());
    }

    protected void writeClassIdTo(Output output, Class<?> componentType, boolean array) throws IOException {
        assert (!componentType.isArray());
        int id = array ? 20 : 18;
        RegisteredDelegate<?> rd = this.getRegisteredDelegate(componentType);
        if (rd != null) {
            output.writeUInt32(id, rd.id << 5 | 0x1E, false);
            return;
        }
        RuntimeFieldFactory inline = RuntimeFieldFactory.getInline(componentType);
        if (inline != null) {
            output.writeUInt32(id, NumericIdStrategy.getPrimitiveOrScalarId(componentType, inline.id), false);
        } else if (componentType.isEnum()) {
            output.writeUInt32(id, this.getEnumId(componentType), false);
        } else if (Object.class == componentType) {
            output.writeUInt32(id, 22, false);
        } else if (Class.class == componentType) {
            output.writeUInt32(id, 29, false);
        } else if (!componentType.isInterface() && !Modifier.isAbstract(componentType.getModifiers())) {
            output.writeUInt32(id, this.getId(componentType), false);
        } else {
            output.writeString(id + 1, componentType.getName(), false);
        }
    }

    protected void transferClassId(Input input, Output output, int fieldNumber, boolean mapped, boolean array) throws IOException {
        if (mapped) {
            input.transferByteRangeTo(output, true, fieldNumber, false);
        } else {
            output.writeUInt32(fieldNumber, input.readUInt32(), false);
        }
    }

    protected Class<?> resolveClassFrom(Input input, boolean mapped, boolean array) throws IOException {
        return mapped ? RuntimeEnv.loadClass((String)input.readString()) : this.resolveClass(input.readUInt32());
    }

    private static int getPrimitiveOrScalarId(Class<?> clazz, int id) {
        if (clazz.isPrimitive()) {
            return id - 1;
        }
        return id < 9 ? id - 1 | 8 : id + 7;
    }

    private Class<?> resolveClass(int id) {
        int type = id & 0x1F;
        if (type < 16) {
            boolean primitive = type < 8;
            switch (type & 7) {
                case 0: {
                    return primitive ? Boolean.TYPE : Boolean.class;
                }
                case 1: {
                    return primitive ? Byte.TYPE : Byte.class;
                }
                case 2: {
                    return primitive ? Character.TYPE : Character.class;
                }
                case 3: {
                    return primitive ? Short.TYPE : Short.class;
                }
                case 4: {
                    return primitive ? Integer.TYPE : Integer.class;
                }
                case 5: {
                    return primitive ? Long.TYPE : Long.class;
                }
                case 6: {
                    return primitive ? Float.TYPE : Float.class;
                }
                case 7: {
                    return primitive ? Double.TYPE : Double.class;
                }
            }
            throw new RuntimeException("Should not happen.");
        }
        switch (type) {
            case 16: {
                return String.class;
            }
            case 17: {
                return ByteString.class;
            }
            case 18: {
                return byte[].class;
            }
            case 19: {
                return BigDecimal.class;
            }
            case 20: {
                return BigInteger.class;
            }
            case 21: {
                return Date.class;
            }
            case 22: {
                return Object.class;
            }
            case 23: {
                return EnumSet.class;
            }
            case 24: {
                return EnumMap.class;
            }
            case 25: {
                return this.enumClass(id >>> 5);
            }
            case 26: {
                return this.collectionClass(id >>> 5);
            }
            case 27: {
                return this.mapClass(id >>> 5);
            }
            case 28: {
                return this.pojoClass(id >>> 5);
            }
            case 29: {
                return Class.class;
            }
            case 30: {
                return this.delegateClass(id >>> 5);
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    protected abstract RegisteredDelegate<?> getRegisteredDelegate(Class<?> var1);

    protected abstract Class<?> enumClass(int var1);

    protected abstract Class<?> delegateClass(int var1);

    protected abstract Class<?> collectionClass(int var1);

    protected abstract Class<?> mapClass(int var1);

    protected abstract Class<?> pojoClass(int var1);

    protected abstract int getEnumId(Class<?> var1);

    protected abstract int getId(Class<?> var1);

    protected static <T> ArrayList<T> newList(int size) {
        List<Object> l = Collections.nCopies(size, null);
        return new ArrayList<Object>(l);
    }

    protected static <T> void grow(ArrayList<T> list, int size) {
        int previousSize = list.size();
        list.ensureCapacity(size);
        List<Object> l = Collections.nCopies(size - previousSize, null);
        list.addAll(l);
    }

    protected static final class RegisteredDelegate<T>
    extends HasDelegate<T> {
        public final int id;

        RegisteredDelegate(int id, Delegate<T> delegate, IdStrategy strategy) {
            super(delegate, strategy);
            this.id = id;
        }
    }

    public static interface Registry {
        public <T extends Collection<?>> Registry registerCollection(CollectionSchema.MessageFactory var1, int var2);

        public <T extends Map<?, ?>> Registry registerMap(MapSchema.MessageFactory var1, int var2);

        public <T extends Enum<T>> Registry registerEnum(Class<T> var1, int var2);

        public Registry registerEnum(EnumIO<?> var1, int var2);

        public <T> Registry registerPojo(Class<T> var1, int var2);

        public <T> Registry registerPojo(Schema<T> var1, Pipe.Schema<T> var2, int var3);

        public <T> Registry mapPojo(Class<? super T> var1, Class<T> var2);

        public <T> Registry registerDelegate(Delegate<T> var1, int var2);
    }
}

