/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.MapSchema;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.ProtostuffException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.HasSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultIdStrategy
extends IdStrategy {
    final ConcurrentHashMap<String, HasSchema<?>> pojoMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, EnumIO<?>> enumMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, CollectionSchema.MessageFactory> collectionMapping = new ConcurrentHashMap();
    final ConcurrentHashMap<String, MapSchema.MessageFactory> mapMapping = new ConcurrentHashMap();

    public <T> boolean register(Class<T> typeClass, Schema<T> schema) {
        assert (typeClass != null && schema != null);
        HasSchema last = this.pojoMapping.putIfAbsent(typeClass.getName(), new Registered<T>(schema));
        return last == null || last instanceof Registered && ((Registered)last).schema == schema;
    }

    public <T> boolean map(Class<? super T> baseClass, Class<T> typeClass) {
        assert (baseClass != null && typeClass != null);
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new IllegalArgumentException(typeClass + " cannot be an interface/abstract class.");
        }
        HasSchema last = this.pojoMapping.putIfAbsent(baseClass.getName(), new Mapped<T>(baseClass, typeClass, this));
        return last == null || last instanceof Mapped && ((Mapped)last).typeClass == typeClass;
    }

    @Override
    public boolean isRegistered(Class<?> typeClass) {
        HasSchema<?> last = this.pojoMapping.get(typeClass.getName());
        return last != null && !(last instanceof Lazy);
    }

    private <T> HasSchema<T> getSchemaWrapper(String className, boolean load) {
        HasSchema<?> hs = this.pojoMapping.get(className);
        if (hs == null) {
            if (!load) {
                return null;
            }
            Class typeClass = RuntimeEnv.loadClass(className);
            hs = new Lazy(typeClass, this);
            HasSchema<?> last = this.pojoMapping.putIfAbsent(typeClass.getName(), hs);
            if (last != null) {
                hs = last;
            }
        }
        return hs;
    }

    @Override
    public <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, boolean create) {
        HasSchema<?> hs = this.pojoMapping.get(typeClass.getName());
        if (hs == null && create) {
            hs = new Lazy(typeClass, this);
            HasSchema<?> last = this.pojoMapping.putIfAbsent(typeClass.getName(), hs);
            if (last != null) {
                hs = last;
            }
        }
        return hs;
    }

    private EnumIO<? extends Enum<?>> getEnumIO(String className, boolean load) {
        EnumIO<Object> eio = this.enumMapping.get(className);
        if (eio == null) {
            if (!load) {
                return null;
            }
            Class enumClass = RuntimeEnv.loadClass(className);
            eio = EnumIO.newEnumIO(enumClass);
            EnumIO<?> existing = this.enumMapping.putIfAbsent(enumClass.getName(), eio);
            if (existing != null) {
                eio = existing;
            }
        }
        return eio;
    }

    @Override
    protected EnumIO<? extends Enum<?>> getEnumIO(Class<?> enumClass) {
        EnumIO<Object> eio = this.enumMapping.get(enumClass.getName());
        if (eio == null) {
            eio = EnumIO.newEnumIO(enumClass);
            EnumIO<?> existing = this.enumMapping.putIfAbsent(enumClass.getName(), eio);
            if (existing != null) {
                eio = existing;
            }
        }
        return eio;
    }

    @Override
    protected CollectionSchema.MessageFactory getCollectionFactory(Class<?> clazz) {
        String className = clazz.getName();
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(className);
        if (factory == null) {
            if (className.startsWith("java.util")) {
                factory = CollectionSchema.MessageFactories.valueOf((String)clazz.getSimpleName());
            } else {
                factory = new RuntimeCollectionFactory(clazz);
                CollectionSchema.MessageFactory f = this.collectionMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected MapSchema.MessageFactory getMapFactory(Class<?> clazz) {
        String className = clazz.getName();
        MapSchema.MessageFactory factory = this.mapMapping.get(className);
        if (factory == null) {
            if (className.startsWith("java.util")) {
                factory = MapSchema.MessageFactories.valueOf((String)clazz.getSimpleName());
            } else {
                factory = new RuntimeMapFactory(clazz);
                MapSchema.MessageFactory f = this.mapMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeCollectionIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(clazz);
        if (factory == null && clazz.getName().startsWith("java.util")) {
            output.writeString(fieldNumber, clazz.getSimpleName(), false);
        } else {
            output.writeString(fieldNumber, clazz.getName(), false);
        }
    }

    @Override
    protected void transferCollectionId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected CollectionSchema.MessageFactory resolveCollectionFrom(Input input) throws IOException {
        String className = input.readString();
        CollectionSchema.MessageFactory factory = this.collectionMapping.get(className);
        if (factory == null) {
            if (className.indexOf(46) == -1) {
                factory = CollectionSchema.MessageFactories.valueOf((String)className);
            } else {
                factory = new RuntimeCollectionFactory(RuntimeEnv.loadClass(className));
                CollectionSchema.MessageFactory f = this.collectionMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeMapIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        MapSchema.MessageFactory factory = this.mapMapping.get(clazz);
        if (factory == null && clazz.getName().startsWith("java.util")) {
            output.writeString(fieldNumber, clazz.getSimpleName(), false);
        } else {
            output.writeString(fieldNumber, clazz.getName(), false);
        }
    }

    @Override
    protected void transferMapId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected MapSchema.MessageFactory resolveMapFrom(Input input) throws IOException {
        String className = input.readString();
        MapSchema.MessageFactory factory = this.mapMapping.get(className);
        if (factory == null) {
            if (className.indexOf(46) == -1) {
                factory = MapSchema.MessageFactories.valueOf((String)className);
            } else {
                factory = new RuntimeMapFactory(RuntimeEnv.loadClass(className));
                MapSchema.MessageFactory f = this.mapMapping.putIfAbsent(className, factory);
                if (f != null) {
                    factory = f;
                }
            }
        }
        return factory;
    }

    @Override
    protected void writeEnumIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        output.writeString(fieldNumber, clazz.getName(), false);
    }

    @Override
    protected void transferEnumId(Input input, Output output, int fieldNumber) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected EnumIO<?> resolveEnumFrom(Input input) throws IOException {
        return this.getEnumIO(input.readString(), true);
    }

    @Override
    protected <T> Schema<T> writePojoIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        output.writeString(fieldNumber, clazz.getName(), false);
        return this.getSchemaWrapper(clazz, true).getSchema();
    }

    @Override
    protected <T> HasSchema<T> transferPojoId(Input input, Output output, int fieldNumber) throws IOException {
        String className = input.readString();
        HasSchema<T> wrapper = this.getSchemaWrapper(className, RuntimeEnv.AUTO_LOAD_POLYMORPHIC_CLASSES);
        if (wrapper == null) {
            throw new ProtostuffException("polymorphic pojo not registered: " + className);
        }
        output.writeString(fieldNumber, className, false);
        return wrapper;
    }

    @Override
    protected <T> HasSchema<T> resolvePojoFrom(Input input, int fieldNumber) throws IOException {
        String className = input.readString();
        HasSchema<T> wrapper = this.getSchemaWrapper(className, RuntimeEnv.AUTO_LOAD_POLYMORPHIC_CLASSES);
        if (wrapper == null) {
            throw new ProtostuffException("polymorphic pojo not registered: " + className);
        }
        return wrapper;
    }

    @Override
    protected <T> Schema<T> writeMessageIdTo(Output output, int fieldNumber, Message<T> message) throws IOException {
        output.writeString(fieldNumber, message.getClass().getName(), false);
        return message.cachedSchema();
    }

    @Override
    protected void writeArrayIdTo(Output output, Class<?> componentType) throws IOException {
        output.writeString(15, componentType.getName(), false);
    }

    @Override
    protected void transferArrayId(Input input, Output output, int fieldNumber, boolean nonConcrete) throws IOException {
        input.transferByteRangeTo(output, true, fieldNumber, false);
    }

    @Override
    protected Class<?> resolveArrayComponentTypeFrom(Input input, boolean nonConcrete) throws IOException {
        String className = input.readString();
        RuntimeFieldFactory inline = RuntimeFieldFactory.getInline(className);
        if (inline == null) {
            return RuntimeEnv.loadClass(className);
        }
        if (className.indexOf(46) != -1) {
            return inline.typeClass();
        }
        switch (inline.id) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Character.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Long.TYPE;
            }
            case 7: {
                return Float.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        throw new RuntimeException("Should never happen.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Registered<T>
    extends HasSchema<T> {
        final Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        Registered(Schema<T> schema) {
            this.schema = schema;
        }

        @Override
        public Schema<T> getSchema() {
            return this.schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                Registered registered = this;
                synchronized (registered) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.schema, this.schema.typeClass(), true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Mapped<T>
    extends HasSchema<T> {
        final IdStrategy strategy;
        final Class<? super T> baseClass;
        final Class<T> typeClass;
        private volatile HasSchema<T> wrapper;

        Mapped(Class<? super T> baseClass, Class<T> typeClass, IdStrategy strategy) {
            this.baseClass = baseClass;
            this.typeClass = typeClass;
            this.strategy = strategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            HasSchema<T> wrapper = this.wrapper;
            if (wrapper == null) {
                Mapped mapped = this;
                synchronized (mapped) {
                    wrapper = this.wrapper;
                    if (wrapper == null) {
                        wrapper = this.strategy.getSchemaWrapper(this.typeClass, true);
                        this.wrapper = wrapper;
                    }
                }
            }
            return wrapper.getSchema();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            HasSchema<T> wrapper = this.wrapper;
            if (wrapper == null) {
                Mapped mapped = this;
                synchronized (mapped) {
                    wrapper = this.wrapper;
                    if (wrapper == null) {
                        wrapper = this.strategy.getSchemaWrapper(this.typeClass, true);
                        this.wrapper = wrapper;
                    }
                }
            }
            return wrapper.getPipeSchema();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Lazy<T>
    extends HasSchema<T> {
        final IdStrategy strategy;
        final Class<T> typeClass;
        private volatile Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        Lazy(Class<T> typeClass, IdStrategy strategy) {
            this.typeClass = typeClass;
            this.strategy = strategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            Schema schema = this.schema;
            if (schema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    schema = this.schema;
                    if (schema == null) {
                        if (Message.class.isAssignableFrom(this.typeClass)) {
                            try {
                                Message m = (Message)this.typeClass.newInstance();
                                this.schema = schema = m.cachedSchema();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            schema = RuntimeSchema.createFrom(this.typeClass, this.strategy);
                            this.schema = schema;
                        }
                    }
                }
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.getSchema(), this.typeClass, true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RuntimeMapFactory
    implements MapSchema.MessageFactory {
        final Class<?> mapClass;
        final RuntimeEnv.Instantiator<?> instantiator;

        public RuntimeMapFactory(Class<?> mapClass) {
            this.mapClass = mapClass;
            this.instantiator = RuntimeEnv.newInstantiator(mapClass);
        }

        public <K, V> Map<K, V> newMessage() {
            return (Map)this.instantiator.newInstance();
        }

        public Class<?> typeClass() {
            return this.mapClass;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RuntimeCollectionFactory
    implements CollectionSchema.MessageFactory {
        final Class<?> collectionClass;
        final RuntimeEnv.Instantiator<?> instantiator;

        public RuntimeCollectionFactory(Class<?> collectionClass) {
            this.collectionClass = collectionClass;
            this.instantiator = RuntimeEnv.newInstantiator(collectionClass);
        }

        public <V> Collection<V> newMessage() {
            return (Collection)this.instantiator.newInstance();
        }

        public Class<?> typeClass() {
            return this.collectionClass;
        }
    }
}

