/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.MapSchema;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.ProtostuffException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.DerivativeSchema;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.HasSchema;
import com.dyuproject.protostuff.runtime.ObjectSchema;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdStrategy {
    final DerivativeSchema POLYMORPHIC_COLLECTION_VALUE_SCHEMA = new DerivativeSchema(this){

        @Override
        protected void doMergeFrom(Input input, Schema<Object> derivedSchema, Object owner) throws IOException {
            Object value = derivedSchema.newMessage();
            ((Collection)owner).add(value);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(value, owner);
            }
            derivedSchema.mergeFrom(input, value);
        }
    };
    final DerivativeSchema POLYMORPHIC_MAP_VALUE_SCHEMA = new DerivativeSchema(this){

        @Override
        protected void doMergeFrom(Input input, Schema<Object> derivedSchema, Object owner) throws IOException {
            Object value = derivedSchema.newMessage();
            ((MapSchema.MapWrapper)owner).setValue(value);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(value, owner);
            }
            derivedSchema.mergeFrom(input, value);
        }
    };
    final ObjectSchema OBJECT_COLLECTION_VALUE_SCHEMA = new ObjectSchema(this){

        protected void setValue(Object value, Object owner) {
            ((Collection)owner).add(value);
        }
    };
    final ObjectSchema OBJECT_MAP_VALUE_SCHEMA = new ObjectSchema(this){

        protected void setValue(Object value, Object owner) {
            ((MapSchema.MapWrapper)owner).setValue(value);
        }
    };
    final Schema<Object> DYNAMIC_VALUE_SCHEMA = new Schema<Object>(){

        public String getFieldName(int number) {
            return ObjectSchema.name(number);
        }

        public int getFieldNumber(String name) {
            return ObjectSchema.number(name);
        }

        public boolean isInitialized(Object owner) {
            return true;
        }

        public String messageFullName() {
            return Object.class.getName();
        }

        public String messageName() {
            return Object.class.getSimpleName();
        }

        public Object newMessage() {
            throw new UnsupportedOperationException();
        }

        public Class<? super Object> typeClass() {
            return Object.class;
        }

        public void mergeFrom(Input input, Object owner) throws IOException {
            if (PMapWrapper.class.isAssignableFrom(owner.getClass())) {
                ((PMapWrapper)owner).setValue(ObjectSchema.readObjectFrom(input, this, owner, IdStrategy.this));
            } else {
                ((Collection)owner).add(ObjectSchema.readObjectFrom(input, this, owner, IdStrategy.this));
            }
        }

        public void writeTo(Output output, Object message) throws IOException {
            ObjectSchema.writeObjectTo(output, message, this, IdStrategy.this);
        }
    };
    final Pipe.Schema<Object> DYNAMIC_VALUE_PIPE_SCHEMA = new Pipe.Schema<Object>(this.DYNAMIC_VALUE_SCHEMA){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            ObjectSchema.transferObject(this, pipe, input, output, IdStrategy.this);
        }
    };
    final Schema<Collection<Object>> COLLECTION_SCHEMA = new Schema<Collection<Object>>(){

        public String getFieldName(int number) {
            return number == 1 ? "v" : null;
        }

        public int getFieldNumber(String name) {
            return name.length() == 1 && name.charAt(0) == 'v' ? 1 : 0;
        }

        public boolean isInitialized(Collection<Object> owner) {
            return true;
        }

        public String messageFullName() {
            return Collection.class.getName();
        }

        public String messageName() {
            return Collection.class.getSimpleName();
        }

        public Collection<Object> newMessage() {
            throw new UnsupportedOperationException();
        }

        public Class<? super Collection<Object>> typeClass() {
            return Collection.class;
        }

        public void mergeFrom(Input input, Collection<Object> message) throws IOException {
            int number = input.readFieldNumber((Schema)this);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        Object value = input.mergeObject(message, IdStrategy.this.DYNAMIC_VALUE_SCHEMA);
                        if (!(input instanceof GraphInput) || !((GraphInput)input).isCurrentMessageReference()) break;
                        message.add(value);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("Corrupt input.");
                    }
                }
                number = input.readFieldNumber((Schema)this);
            }
        }

        public void writeTo(Output output, Collection<Object> message) throws IOException {
            for (Object value : message) {
                if (value == null) continue;
                output.writeObject(1, value, IdStrategy.this.DYNAMIC_VALUE_SCHEMA, true);
            }
        }
    };
    final Pipe.Schema<Collection<Object>> COLLECTION_PIPE_SCHEMA = new Pipe.Schema<Collection<Object>>(this.COLLECTION_SCHEMA){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(this.wrappedSchema);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        output.writeObject(number, (Object)pipe, IdStrategy.this.DYNAMIC_VALUE_PIPE_SCHEMA, true);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The collection was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(this.wrappedSchema);
            }
        }
    };
    final Schema<Object> ARRAY_SCHEMA = new Schema<Object>(){

        public String getFieldName(int number) {
            return number == 1 ? "v" : null;
        }

        public int getFieldNumber(String name) {
            return name.length() == 1 && name.charAt(0) == 'v' ? 1 : 0;
        }

        public boolean isInitialized(Object owner) {
            return true;
        }

        public String messageFullName() {
            return Array.class.getName();
        }

        public String messageName() {
            return Array.class.getSimpleName();
        }

        public Object newMessage() {
            throw new UnsupportedOperationException();
        }

        public Class<? super Object> typeClass() {
            return Object.class;
        }

        public void mergeFrom(Input input, Object message) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(Output output, Object message) throws IOException {
            int len = Array.getLength(message);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(message, i);
                if (value == null) continue;
                output.writeObject(1, value, IdStrategy.this.DYNAMIC_VALUE_SCHEMA, true);
            }
        }
    };
    final Pipe.Schema<Object> ARRAY_PIPE_SCHEMA = new Pipe.Schema<Object>(this.ARRAY_SCHEMA){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(this.wrappedSchema);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        output.writeObject(number, (Object)pipe, IdStrategy.this.DYNAMIC_VALUE_PIPE_SCHEMA, true);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The array was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(this.wrappedSchema);
            }
        }
    };
    final Schema<Map<Object, Object>> MAP_SCHEMA = new Schema<Map<Object, Object>>(){

        public final String getFieldName(int number) {
            return number == 1 ? "e" : null;
        }

        public final int getFieldNumber(String name) {
            return name.length() == 1 && name.charAt(0) == 'e' ? 1 : 0;
        }

        public boolean isInitialized(Map<Object, Object> owner) {
            return true;
        }

        public String messageFullName() {
            return Map.class.getName();
        }

        public String messageName() {
            return Map.class.getSimpleName();
        }

        public Map<Object, Object> newMessage() {
            throw new UnsupportedOperationException();
        }

        public Class<? super Map<Object, Object>> typeClass() {
            return Map.class;
        }

        public void mergeFrom(Input input, Map<Object, Object> message) throws IOException {
            PMapWrapper entry = null;
            int number = input.readFieldNumber((Schema)this);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        if (entry == null) {
                            entry = new PMapWrapper(message);
                        }
                        if (entry == input.mergeObject((Object)entry, IdStrategy.this.ENTRY_SCHEMA)) break;
                        throw new IllegalStateException("A Map.Entry will always be unique, hence it cannot be a reference obtained from " + input.getClass().getName());
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber((Schema)this);
            }
        }

        public void writeTo(Output output, Map<Object, Object> message) throws IOException {
            for (Map.Entry<Object, Object> entry : message.entrySet()) {
                output.writeObject(1, entry, IdStrategy.this.ENTRY_SCHEMA, true);
            }
        }
    };
    final Pipe.Schema<Map<Object, Object>> MAP_PIPE_SCHEMA = new Pipe.Schema<Map<Object, Object>>(this.MAP_SCHEMA){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(this.wrappedSchema);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        output.writeObject(number, (Object)pipe, IdStrategy.this.ENTRY_PIPE_SCHEMA, true);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(this.wrappedSchema);
            }
        }
    };
    final Schema<Map.Entry<Object, Object>> ENTRY_SCHEMA = new Schema<Map.Entry<Object, Object>>(){

        public final String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "k";
                }
                case 2: {
                    return "v";
                }
            }
            return null;
        }

        public final int getFieldNumber(String name) {
            if (name.length() != 1) {
                return 0;
            }
            switch (name.charAt(0)) {
                case 'k': {
                    return 1;
                }
                case 'v': {
                    return 2;
                }
            }
            return 0;
        }

        public boolean isInitialized(Map.Entry<Object, Object> message) {
            return true;
        }

        public String messageFullName() {
            return Map.Entry.class.getName();
        }

        public String messageName() {
            return Map.Entry.class.getSimpleName();
        }

        public Map.Entry<Object, Object> newMessage() {
            throw new UnsupportedOperationException();
        }

        public Class<? super Map.Entry<Object, Object>> typeClass() {
            return Map.Entry.class;
        }

        public void mergeFrom(Input input, Map.Entry<Object, Object> message) throws IOException {
            PMapWrapper entry = (PMapWrapper)message;
            Object key = null;
            Object value = null;
            int number = input.readFieldNumber((Schema)this);
            while (true) {
                switch (number) {
                    case 0: {
                        entry.map.put(key, value);
                        return;
                    }
                    case 1: {
                        if (key != null) {
                            throw new ProtostuffException("The map was incorrectly serialized.");
                        }
                        key = input.mergeObject((Object)entry, IdStrategy.this.DYNAMIC_VALUE_SCHEMA);
                        if (entry != key) {
                            assert (key != null);
                            break;
                        }
                        key = entry.setValue((Object)null);
                        assert (key != null);
                        break;
                    }
                    case 2: {
                        if (value != null) {
                            throw new ProtostuffException("The map was incorrectly serialized.");
                        }
                        value = input.mergeObject((Object)entry, IdStrategy.this.DYNAMIC_VALUE_SCHEMA);
                        if (entry != value) {
                            assert (value != null);
                            break;
                        }
                        value = entry.setValue((Object)null);
                        assert (value != null);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber((Schema)this);
            }
        }

        public void writeTo(Output output, Map.Entry<Object, Object> entry) throws IOException {
            if (entry.getKey() != null) {
                output.writeObject(1, entry.getKey(), IdStrategy.this.DYNAMIC_VALUE_SCHEMA, false);
            }
            if (entry.getValue() != null) {
                output.writeObject(2, entry.getValue(), IdStrategy.this.DYNAMIC_VALUE_SCHEMA, false);
            }
        }
    };
    final Pipe.Schema<Map.Entry<Object, Object>> ENTRY_PIPE_SCHEMA = new Pipe.Schema<Map.Entry<Object, Object>>(this.ENTRY_SCHEMA){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(this.wrappedSchema);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        output.writeObject(number, (Object)pipe, IdStrategy.this.DYNAMIC_VALUE_PIPE_SCHEMA, false);
                        break;
                    }
                    case 2: {
                        output.writeObject(number, (Object)pipe, IdStrategy.this.DYNAMIC_VALUE_PIPE_SCHEMA, false);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(this.wrappedSchema);
            }
        }
    };

    public abstract boolean isRegistered(Class<?> var1);

    public abstract <T> HasSchema<T> getSchemaWrapper(Class<T> var1, boolean var2);

    protected abstract EnumIO<? extends Enum<?>> getEnumIO(Class<?> var1);

    protected abstract CollectionSchema.MessageFactory getCollectionFactory(Class<?> var1);

    protected abstract MapSchema.MessageFactory getMapFactory(Class<?> var1);

    protected abstract void writeCollectionIdTo(Output var1, int var2, Class<?> var3) throws IOException;

    protected abstract void transferCollectionId(Input var1, Output var2, int var3) throws IOException;

    protected abstract CollectionSchema.MessageFactory resolveCollectionFrom(Input var1) throws IOException;

    protected abstract void writeMapIdTo(Output var1, int var2, Class<?> var3) throws IOException;

    protected abstract void transferMapId(Input var1, Output var2, int var3) throws IOException;

    protected abstract MapSchema.MessageFactory resolveMapFrom(Input var1) throws IOException;

    protected abstract void writeEnumIdTo(Output var1, int var2, Class<?> var3) throws IOException;

    protected abstract void transferEnumId(Input var1, Output var2, int var3) throws IOException;

    protected abstract EnumIO<?> resolveEnumFrom(Input var1) throws IOException;

    protected abstract <T> Schema<T> writePojoIdTo(Output var1, int var2, Class<T> var3) throws IOException;

    protected abstract <T> HasSchema<T> transferPojoId(Input var1, Output var2, int var3) throws IOException;

    protected abstract <T> HasSchema<T> resolvePojoFrom(Input var1, int var2) throws IOException;

    protected abstract <T> Schema<T> writeMessageIdTo(Output var1, int var2, Message<T> var3) throws IOException;

    protected abstract void writeArrayIdTo(Output var1, Class<?> var2) throws IOException;

    protected abstract void transferArrayId(Input var1, Output var2, int var3, boolean var4) throws IOException;

    protected abstract Class<?> resolveArrayComponentTypeFrom(Input var1, boolean var2) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PMapWrapper
    implements Map.Entry<Object, Object> {
        final Map<Object, Object> map;
        private Object value;

        PMapWrapper(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object last = this.value;
            this.value = value;
            return last;
        }
    }

    public static interface Factory {
        public IdStrategy create();

        public void postCreate();
    }

    public static class UnknownTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnknownTypeException(String msg) {
            super(msg);
        }
    }
}

