/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.ProtostuffException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.StatefulOutput;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectSchema
implements Schema<Object> {
    static final int ID_ENUM_VALUE = 1;
    static final int ID_ARRAY_LEN = 3;
    static final int ID_ARRAY_DIMENSION = 2;
    public final IdStrategy strategy;
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            ObjectSchema.transferObject(this, pipe, input, output, ObjectSchema.this.strategy);
        }
    };

    static String name(int number) {
        switch (number) {
            case 1: {
                return "a";
            }
            case 2: {
                return "b";
            }
            case 3: {
                return "c";
            }
            case 4: {
                return "d";
            }
            case 5: {
                return "e";
            }
            case 6: {
                return "f";
            }
            case 7: {
                return "g";
            }
            case 8: {
                return "h";
            }
            case 9: {
                return "i";
            }
            case 10: {
                return "j";
            }
            case 11: {
                return "k";
            }
            case 12: {
                return "l";
            }
            case 13: {
                return "m";
            }
            case 14: {
                return "n";
            }
            case 15: {
                return "o";
            }
            case 16: {
                return "p";
            }
            case 17: {
                return "q";
            }
            case 22: {
                return "v";
            }
            case 23: {
                return "w";
            }
            case 24: {
                return "x";
            }
            case 25: {
                return "y";
            }
            case 26: {
                return "z";
            }
            case 127: {
                return "_";
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case '_': {
                return 127;
            }
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'j': {
                return 10;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 12;
            }
            case 'm': {
                return 13;
            }
            case 'n': {
                return 14;
            }
            case 'o': {
                return 15;
            }
            case 'p': {
                return 16;
            }
            case 'q': {
                return 17;
            }
            case 'v': {
                return 22;
            }
            case 'w': {
                return 23;
            }
            case 'x': {
                return 24;
            }
            case 'y': {
                return 25;
            }
            case 'z': {
                return 26;
            }
        }
        return 0;
    }

    public ObjectSchema(IdStrategy strategy) {
        this.strategy = strategy;
    }

    public String getFieldName(int number) {
        return ObjectSchema.name(number);
    }

    public int getFieldNumber(String name) {
        return ObjectSchema.number(name);
    }

    public boolean isInitialized(Object owner) {
        return true;
    }

    public String messageFullName() {
        return Object.class.getName();
    }

    public String messageName() {
        return Object.class.getSimpleName();
    }

    public Object newMessage() {
        throw new UnsupportedOperationException();
    }

    public Class<? super Object> typeClass() {
        return Object.class;
    }

    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(ObjectSchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    public void writeTo(Output output, Object value) throws IOException {
        ObjectSchema.writeObjectTo(output, value, this, this.strategy);
    }

    static ArrayWrapper newArrayWrapper(Input input, Schema<?> schema, boolean mapped, IdStrategy strategy) throws IOException {
        Class<?> componentType = strategy.resolveArrayComponentTypeFrom(input, mapped);
        if (input.readFieldNumber(schema) != 3) {
            throw new ProtostuffException("Corrupt input.");
        }
        int len = input.readUInt32();
        if (input.readFieldNumber(schema) != 2) {
            throw new ProtostuffException("Corrupt input.");
        }
        int dimensions = input.readUInt32();
        if (dimensions == 1) {
            return new ArrayWrapper(Array.newInstance(componentType, len));
        }
        int[] arg = new int[dimensions];
        arg[0] = len;
        return new ArrayWrapper(Array.newInstance(componentType, arg));
    }

    static void transferArray(Pipe pipe, Input input, Output output, int number, Pipe.Schema<?> pipeSchema, boolean mapped, IdStrategy strategy) throws IOException {
        strategy.transferArrayId(input, output, number, mapped);
        if (input.readFieldNumber(pipeSchema.wrappedSchema) != 3) {
            throw new ProtostuffException("Corrupt input.");
        }
        output.writeUInt32(3, input.readUInt32(), false);
        if (input.readFieldNumber(pipeSchema.wrappedSchema) != 2) {
            throw new ProtostuffException("Corrupt input.");
        }
        output.writeUInt32(2, input.readUInt32(), false);
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(strategy.ARRAY_PIPE_SCHEMA, pipeSchema);
        }
        Pipe.transferDirect(strategy.ARRAY_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        Object value = null;
        int number = input.readFieldNumber(schema);
        switch (number) {
            case 1: {
                value = RuntimeFieldFactory.BOOL.readFrom(input);
                break;
            }
            case 2: {
                value = RuntimeFieldFactory.BYTE.readFrom(input);
                break;
            }
            case 3: {
                value = RuntimeFieldFactory.CHAR.readFrom(input);
                break;
            }
            case 4: {
                value = RuntimeFieldFactory.SHORT.readFrom(input);
                break;
            }
            case 5: {
                value = RuntimeFieldFactory.INT32.readFrom(input);
                break;
            }
            case 6: {
                value = RuntimeFieldFactory.INT64.readFrom(input);
                break;
            }
            case 7: {
                value = RuntimeFieldFactory.FLOAT.readFrom(input);
                break;
            }
            case 8: {
                value = RuntimeFieldFactory.DOUBLE.readFrom(input);
                break;
            }
            case 9: {
                value = RuntimeFieldFactory.STRING.readFrom(input);
                break;
            }
            case 10: {
                value = RuntimeFieldFactory.BYTES.readFrom(input);
                break;
            }
            case 11: {
                value = RuntimeFieldFactory.BYTE_ARRAY.readFrom(input);
                break;
            }
            case 12: {
                value = RuntimeFieldFactory.BIGDECIMAL.readFrom(input);
                break;
            }
            case 13: {
                value = RuntimeFieldFactory.BIGINTEGER.readFrom(input);
                break;
            }
            case 14: {
                value = RuntimeFieldFactory.DATE.readFrom(input);
                break;
            }
            case 15: {
                ArrayWrapper arrayWrapper = ObjectSchema.newArrayWrapper(input, schema, false, strategy);
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(arrayWrapper.array, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, (Object)arrayWrapper);
                return arrayWrapper.array;
            }
            case 16: {
                if (input.readUInt32() != 0) {
                    throw new ProtostuffException("Corrupt input.");
                }
                value = new Object();
                break;
            }
            case 17: {
                ArrayWrapper mArrayWrapper = ObjectSchema.newArrayWrapper(input, schema, true, strategy);
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(mArrayWrapper.array, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, (Object)mArrayWrapper);
                return mArrayWrapper.array;
            }
            case 24: {
                EnumIO<?> eio = strategy.resolveEnumFrom(input);
                if (input.readFieldNumber(schema) != 1) {
                    throw new ProtostuffException("Corrupt input.");
                }
                value = eio.readFrom(input);
                break;
            }
            case 22: {
                EnumSet<?> es = strategy.resolveEnumFrom(input).newEnumSet();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(es, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, es);
                return es;
            }
            case 23: {
                EnumMap em = strategy.resolveEnumFrom(input).newEnumMap();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(em, owner);
                }
                strategy.MAP_SCHEMA.mergeFrom(input, em);
                return em;
            }
            case 25: {
                Collection collection = strategy.resolveCollectionFrom(input).newMessage();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)collection, owner);
                }
                strategy.COLLECTION_SCHEMA.mergeFrom(input, (Object)collection);
                return collection;
            }
            case 26: {
                Map map = strategy.resolveMapFrom(input).newMessage();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)map, owner);
                }
                strategy.MAP_SCHEMA.mergeFrom(input, (Object)map);
                return map;
            }
            case 127: {
                Schema derivedSchema = strategy.resolvePojoFrom(input, number).getSchema();
                Object pojo = derivedSchema.newMessage();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(pojo, owner);
                }
                derivedSchema.mergeFrom(input, pojo);
                return pojo;
            }
            default: {
                throw new ProtostuffException("Corrupt input.  Unknown field number: " + number);
            }
        }
        if (input instanceof GraphInput) {
            ((GraphInput)input).updateLast(value, owner);
        }
        if (input.readFieldNumber(schema) != 0) {
            throw new ProtostuffException("Corrupt input.");
        }
        return value;
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Class<?> clazz = value.getClass();
        RuntimeFieldFactory<?> inline = RuntimeFieldFactory.getInline(clazz);
        if (inline != null) {
            inline.writeTo(output, inline.id, value, false);
            return;
        }
        if (Message.class.isAssignableFrom(clazz)) {
            Schema schema = strategy.writeMessageIdTo(output, 127, (Message)value);
            if (output instanceof StatefulOutput) {
                ((StatefulOutput)output).updateLast(schema, currentSchema);
            }
            schema.writeTo(output, value);
            return;
        }
        if (clazz.isEnum()) {
            strategy.writeEnumIdTo(output, 24, clazz);
            EnumIO.writeTo(output, 1, false, (Enum)value);
            return;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
            strategy.writeEnumIdTo(output, 24, clazz.getSuperclass());
            EnumIO.writeTo(output, 1, false, (Enum)value);
            return;
        }
        if (clazz.isArray()) {
            int dimensions = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimensions;
                componentType = componentType.getComponentType();
            }
            strategy.writeArrayIdTo(output, componentType);
            output.writeUInt32(3, Array.getLength(value), false);
            output.writeUInt32(2, dimensions, false);
            if (output instanceof StatefulOutput) {
                ((StatefulOutput)output).updateLast(strategy.ARRAY_SCHEMA, currentSchema);
            }
            strategy.ARRAY_SCHEMA.writeTo(output, value);
            return;
        }
        if (Object.class == clazz) {
            output.writeUInt32(16, 0, false);
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (EnumMap.class.isAssignableFrom(clazz)) {
                strategy.writeEnumIdTo(output, 23, EnumIO.getKeyTypeFromEnumMap(value));
            } else {
                strategy.writeMapIdTo(output, 26, clazz);
            }
            if (output instanceof StatefulOutput) {
                ((StatefulOutput)output).updateLast(strategy.MAP_SCHEMA, currentSchema);
            }
            strategy.MAP_SCHEMA.writeTo(output, (Object)((Map)value));
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (EnumSet.class.isAssignableFrom(clazz)) {
                strategy.writeEnumIdTo(output, 22, EnumIO.getElementTypeFromEnumSet(value));
            } else {
                strategy.writeCollectionIdTo(output, 25, clazz);
            }
            if (output instanceof StatefulOutput) {
                ((StatefulOutput)output).updateLast(strategy.COLLECTION_SCHEMA, currentSchema);
            }
            strategy.COLLECTION_SCHEMA.writeTo(output, (Object)((Collection)value));
            return;
        }
        Schema<?> schema = strategy.writePojoIdTo(output, 127, clazz);
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(schema, currentSchema);
        }
        schema.writeTo(output, value);
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        int number = input.readFieldNumber(pipeSchema.wrappedSchema);
        switch (number) {
            case 0: {
                return;
            }
            case 1: {
                RuntimeFieldFactory.BOOL.transfer(pipe, input, output, number, false);
                break;
            }
            case 2: {
                RuntimeFieldFactory.BYTE.transfer(pipe, input, output, number, false);
                break;
            }
            case 3: {
                RuntimeFieldFactory.CHAR.transfer(pipe, input, output, number, false);
                break;
            }
            case 4: {
                RuntimeFieldFactory.SHORT.transfer(pipe, input, output, number, false);
                break;
            }
            case 5: {
                RuntimeFieldFactory.INT32.transfer(pipe, input, output, number, false);
                break;
            }
            case 6: {
                RuntimeFieldFactory.INT64.transfer(pipe, input, output, number, false);
                break;
            }
            case 7: {
                RuntimeFieldFactory.FLOAT.transfer(pipe, input, output, number, false);
                break;
            }
            case 8: {
                RuntimeFieldFactory.DOUBLE.transfer(pipe, input, output, number, false);
                break;
            }
            case 9: {
                RuntimeFieldFactory.STRING.transfer(pipe, input, output, number, false);
                break;
            }
            case 10: {
                RuntimeFieldFactory.BYTES.transfer(pipe, input, output, number, false);
                break;
            }
            case 11: {
                RuntimeFieldFactory.BYTE_ARRAY.transfer(pipe, input, output, number, false);
                break;
            }
            case 12: {
                RuntimeFieldFactory.BIGDECIMAL.transfer(pipe, input, output, number, false);
                break;
            }
            case 13: {
                RuntimeFieldFactory.BIGINTEGER.transfer(pipe, input, output, number, false);
                break;
            }
            case 14: {
                RuntimeFieldFactory.DATE.transfer(pipe, input, output, number, false);
                break;
            }
            case 15: {
                ObjectSchema.transferArray(pipe, input, output, number, pipeSchema, false, strategy);
                return;
            }
            case 16: {
                output.writeUInt32(number, input.readUInt32(), false);
                break;
            }
            case 17: {
                ObjectSchema.transferArray(pipe, input, output, number, pipeSchema, true, strategy);
                return;
            }
            case 24: {
                strategy.transferEnumId(input, output, number);
                if (input.readFieldNumber(pipeSchema.wrappedSchema) != 1) {
                    throw new ProtostuffException("Corrupt input.");
                }
                EnumIO.transfer(pipe, input, output, 1, false);
                break;
            }
            case 22: {
                strategy.transferEnumId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.COLLECTION_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.COLLECTION_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            case 23: {
                strategy.transferEnumId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.MAP_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.MAP_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            case 25: {
                strategy.transferCollectionId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.COLLECTION_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.COLLECTION_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            case 26: {
                strategy.transferMapId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.MAP_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.MAP_PIPE_SCHEMA, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            case 127: {
                Pipe.Schema derivedPipeSchema = strategy.transferPojoId(input, output, number).getPipeSchema();
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(derivedPipeSchema, pipeSchema);
                }
                Pipe.transferDirect(derivedPipeSchema, (Pipe)pipe, (Input)input, (Output)output);
                return;
            }
            default: {
                throw new ProtostuffException("Corrupt input.  Unknown field number: " + number);
            }
        }
        if (input.readFieldNumber(pipeSchema.wrappedSchema) != 0) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    protected abstract void setValue(Object var1, Object var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayWrapper
    implements Collection<Object> {
        final Object array;
        int offset = 0;

        ArrayWrapper(Object array) {
            this.array = array;
        }

        @Override
        public boolean add(Object value) {
            Array.set(this.array, this.offset++, value);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Object> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Object> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

