/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.WireFormat;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.HasSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.MappedSchema;
import com.dyuproject.protostuff.runtime.RuntimeCollectionField;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RuntimeCollectionFieldFactory {
    private static final RuntimeFieldFactory<Collection<?>> COLLECTION = new RuntimeFieldFactory<Collection<?>>(25){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            if (EnumSet.class.isAssignableFrom(f.getType())) {
                Class<?> enumType = 6.getGenericType(f, 0, false);
                if (enumType == null) {
                    return RuntimeFieldFactory.OBJECT.create(number, name, f, strategy);
                }
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, strategy.getEnumIO(enumType).getEnumSetFactory(), enumType, strategy);
            }
            CollectionSchema.MessageFactory messageFactory = strategy.getCollectionFactory(f.getType());
            Class<?> genericType = 6.getGenericType(f, 0, true);
            if (genericType == null) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, strategy);
            }
            RuntimeFieldFactory<?> inline = 6.getInline(genericType);
            if (inline != null) {
                return RuntimeCollectionFieldFactory.createCollectionInlineV(number, name, f, messageFactory, inline);
            }
            if (Message.class.isAssignableFrom(genericType)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isEnum()) {
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, messageFactory, genericType, strategy);
            }
            if (6.isComplexComponentType(genericType)) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, strategy);
            }
            if (POJO == 6.pojo(genericType) || strategy.isRegistered(genericType)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isInterface()) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, strategy);
            }
            return RuntimeCollectionFieldFactory.createCollectionPolymorphicV(number, name, f, messageFactory, genericType, strategy);
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Collection<?> readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTo(Output output, int number, Collection<?> value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };

    private RuntimeCollectionFieldFactory() {
    }

    static RuntimeFieldFactory<Collection<?>> getFactory() {
        return COLLECTION;
    }

    private static <T> MappedSchema.Field<T> createCollectionInlineV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, final RuntimeFieldFactory<Object> inline) {
        return new RuntimeCollectionField<T, Object>(inline.getFieldType(), number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Object)((Collection)f.get(message)), (Schema)this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(inline.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                inline.writeTo(output, fieldNumber, value, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                inline.transfer(pipe, input, output, number, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionEnumV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, IdStrategy strategy) {
        final EnumIO<? extends Enum<?>> eio = strategy.getEnumIO(genericType);
        return new RuntimeCollectionField<T, Enum<?>>(WireFormat.FieldType.ENUM, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Object)((Collection)f.get(message)), (Schema)this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Enum<?>> collection) throws IOException {
                collection.add((Enum<?>)eio.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Enum<?> value, boolean repeated) throws IOException {
                EnumIO.writeTo(output, fieldNumber, repeated, value);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                EnumIO.transfer(pipe, input, output, number, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionPojoV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, IdStrategy strategy) {
        final HasSchema<Object> schemaV = strategy.getSchemaWrapper(genericType, true);
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Object)((Collection)f.get(message)), (Schema)this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(input.mergeObject(null, schemaV.getSchema()));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, schemaV.getSchema(), repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, schemaV.getPipeSchema(), repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionPolymorphicV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, final IdStrategy strategy) {
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Object)((Collection)f.get(message)), (Schema)this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Object value = input.mergeObject(collection, (Schema)strategy.POLYMORPHIC_COLLECTION_VALUE_SCHEMA);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, (Schema)strategy.POLYMORPHIC_COLLECTION_VALUE_SCHEMA, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_COLLECTION_VALUE_SCHEMA.pipeSchema, repeated);
            }
        };
    }

    private static <T> MappedSchema.Field<T> createCollectionObjectV(int number, String name, final Field f, CollectionSchema.MessageFactory messageFactory, final IdStrategy strategy) {
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, messageFactory){
            {
                super(x0, x1, x2, x3);
                f.setAccessible(true);
            }

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                try {
                    f.set(message, input.mergeObject((Object)((Collection)f.get(message)), (Schema)this.schema));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing;
                try {
                    existing = (Collection)f.get(message);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Object value = input.mergeObject(collection, (Schema)strategy.OBJECT_COLLECTION_VALUE_SCHEMA);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, (Schema)strategy.OBJECT_COLLECTION_VALUE_SCHEMA, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, strategy.OBJECT_COLLECTION_VALUE_SCHEMA.pipeSchema, repeated);
            }
        };
    }
}

