/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.ByteString;
import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.WireFormat;
import com.dyuproject.protostuff.runtime.EnumIO;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.MappedSchema;
import com.dyuproject.protostuff.runtime.RuntimeDerivativeField;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import com.dyuproject.protostuff.runtime.RuntimeMessageField;
import com.dyuproject.protostuff.runtime.RuntimeObjectField;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import sun.misc.Unsafe;

public final class RuntimeUnsafeFieldFactory {
    private static final Unsafe us = RuntimeUnsafeFieldFactory.initUnsafe();
    public static final RuntimeFieldFactory<Character> CHAR = new RuntimeFieldFactory<Character>(3){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.UINT32, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putChar(message, offset, (char)input.readUInt32());
                    } else {
                        us.putObject(message, offset, Character.valueOf((char)input.readUInt32()));
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeUInt32(this.number, (int)us.getChar(message, offset), false);
                    } else {
                        Character value = (Character)us.getObject(message, offset);
                        if (value != null) {
                            output.writeUInt32(this.number, (int)value.charValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        protected Character readFrom(Input input) throws IOException {
            return Character.valueOf((char)input.readUInt32());
        }

        @Override
        protected void writeTo(Output output, int number, Character value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.charValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        protected Class<?> typeClass() {
            return Character.class;
        }
    };
    public static final RuntimeFieldFactory<Short> SHORT = new RuntimeFieldFactory<Short>(4){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.UINT32, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putShort(message, offset, (short)input.readUInt32());
                    } else {
                        us.putObject(message, offset, (short)input.readUInt32());
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeUInt32(this.number, (int)us.getShort(message, offset), false);
                    } else {
                        Short value = (Short)us.getObject(message, offset);
                        if (value != null) {
                            output.writeUInt32(this.number, (int)value.shortValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        protected Short readFrom(Input input) throws IOException {
            return (short)input.readUInt32();
        }

        @Override
        protected void writeTo(Output output, int number, Short value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.shortValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        protected Class<?> typeClass() {
            return Short.class;
        }
    };
    public static final RuntimeFieldFactory<Byte> BYTE = new RuntimeFieldFactory<Byte>(2){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.UINT32, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putByte(message, offset, (byte)input.readUInt32());
                    } else {
                        us.putObject(message, offset, (byte)input.readUInt32());
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeUInt32(this.number, (int)us.getByte(message, offset), false);
                    } else {
                        Byte value = (Byte)us.getObject(message, offset);
                        if (value != null) {
                            output.writeUInt32(this.number, (int)value.byteValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        protected Byte readFrom(Input input) throws IOException {
            return (byte)input.readUInt32();
        }

        @Override
        protected void writeTo(Output output, int number, Byte value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.byteValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        protected Class<?> typeClass() {
            return Byte.class;
        }
    };
    public static final RuntimeFieldFactory<Integer> INT32 = new RuntimeFieldFactory<Integer>(5){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.INT32, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putInt(message, offset, input.readInt32());
                    } else {
                        us.putObject(message, offset, input.readInt32());
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeInt32(this.number, us.getInt(message, offset), false);
                    } else {
                        Integer value = (Integer)us.getObject(message, offset);
                        if (value != null) {
                            output.writeInt32(this.number, value.intValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeInt32(this.number, input.readInt32(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeInt32(number, input.readInt32(), repeated);
        }

        @Override
        protected Integer readFrom(Input input) throws IOException {
            return input.readInt32();
        }

        @Override
        protected void writeTo(Output output, int number, Integer value, boolean repeated) throws IOException {
            output.writeInt32(number, value.intValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.INT32;
        }

        @Override
        protected Class<?> typeClass() {
            return Integer.class;
        }
    };
    public static final RuntimeFieldFactory<Long> INT64 = new RuntimeFieldFactory<Long>(6){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.INT64, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putLong(message, offset, input.readInt64());
                    } else {
                        us.putObject(message, offset, input.readInt64());
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeInt64(this.number, us.getLong(message, offset), false);
                    } else {
                        Long value = (Long)us.getObject(message, offset);
                        if (value != null) {
                            output.writeInt64(this.number, value.longValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeInt64(this.number, input.readInt64(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeInt64(number, input.readInt64(), repeated);
        }

        @Override
        protected Long readFrom(Input input) throws IOException {
            return input.readInt64();
        }

        @Override
        protected void writeTo(Output output, int number, Long value, boolean repeated) throws IOException {
            output.writeInt64(number, value.longValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.INT64;
        }

        @Override
        protected Class<?> typeClass() {
            return Long.class;
        }
    };
    public static final RuntimeFieldFactory<Float> FLOAT = new RuntimeFieldFactory<Float>(7){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.FLOAT, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putFloat(message, offset, input.readFloat());
                    } else {
                        us.putObject(message, offset, new Float(input.readFloat()));
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeFloat(this.number, us.getFloat(message, offset), false);
                    } else {
                        Float value = (Float)us.getObject(message, offset);
                        if (value != null) {
                            output.writeFloat(this.number, value.floatValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeFloat(this.number, input.readFloat(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFloat(number, input.readFloat(), repeated);
        }

        @Override
        protected Float readFrom(Input input) throws IOException {
            return new Float(input.readFloat());
        }

        @Override
        protected void writeTo(Output output, int number, Float value, boolean repeated) throws IOException {
            output.writeFloat(number, value.floatValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FLOAT;
        }

        @Override
        protected Class<?> typeClass() {
            return Float.class;
        }
    };
    public static final RuntimeFieldFactory<Double> DOUBLE = new RuntimeFieldFactory<Double>(8){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.DOUBLE, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putDouble(message, offset, input.readDouble());
                    } else {
                        us.putObject(message, offset, new Double(input.readDouble()));
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeDouble(this.number, us.getDouble(message, offset), false);
                    } else {
                        Double value = (Double)us.getObject(message, offset);
                        if (value != null) {
                            output.writeDouble(this.number, value.doubleValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeDouble(this.number, input.readDouble(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeDouble(number, input.readDouble(), repeated);
        }

        @Override
        protected Double readFrom(Input input) throws IOException {
            return new Double(input.readDouble());
        }

        @Override
        protected void writeTo(Output output, int number, Double value, boolean repeated) throws IOException {
            output.writeDouble(number, value.doubleValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.DOUBLE;
        }

        @Override
        protected Class<?> typeClass() {
            return Double.class;
        }
    };
    public static final RuntimeFieldFactory<Boolean> BOOL = new RuntimeFieldFactory<Boolean>(1){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.BOOL, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    if (primitive) {
                        us.putBoolean(message, offset, input.readBool());
                    } else {
                        us.putObject(message, offset, input.readBool() ? Boolean.TRUE : Boolean.FALSE);
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    if (primitive) {
                        output.writeBool(this.number, us.getBoolean(message, offset), false);
                    } else {
                        Boolean value = (Boolean)us.getObject(message, offset);
                        if (value != null) {
                            output.writeBool(this.number, value.booleanValue(), false);
                        }
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeBool(this.number, input.readBool(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeBool(number, input.readBool(), repeated);
        }

        @Override
        protected Boolean readFrom(Input input) throws IOException {
            return input.readBool() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected void writeTo(Output output, int number, Boolean value, boolean repeated) throws IOException {
            output.writeBool(number, value.booleanValue(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BOOL;
        }

        @Override
        protected Class<?> typeClass() {
            return Boolean.class;
        }
    };
    public static final RuntimeFieldFactory<String> STRING = new RuntimeFieldFactory<String>(9){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.STRING, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, input.readString());
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    String value = (String)us.getObject(message, offset);
                    if (value != null) {
                        output.writeString(this.number, value, false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, true, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, true, number, repeated);
        }

        @Override
        protected String readFrom(Input input) throws IOException {
            return input.readString();
        }

        @Override
        protected void writeTo(Output output, int number, String value, boolean repeated) throws IOException {
            output.writeString(number, value, repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.STRING;
        }

        @Override
        protected Class<?> typeClass() {
            return String.class;
        }
    };
    public static final RuntimeFieldFactory<ByteString> BYTES = new RuntimeFieldFactory<ByteString>(10){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.BYTES, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, input.readBytes());
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    ByteString bs = (ByteString)us.getObject(message, offset);
                    if (bs != null) {
                        output.writeBytes(this.number, bs, false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        protected ByteString readFrom(Input input) throws IOException {
            return input.readBytes();
        }

        @Override
        protected void writeTo(Output output, int number, ByteString value, boolean repeated) throws IOException {
            output.writeBytes(number, value, repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        protected Class<?> typeClass() {
            return ByteString.class;
        }
    };
    public static final RuntimeFieldFactory<byte[]> BYTE_ARRAY = new RuntimeFieldFactory<byte[]>(11){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.BYTES, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, input.readByteArray());
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    byte[] array = (byte[])us.getObject(message, offset);
                    if (array != null) {
                        output.writeByteArray(this.number, array, false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        protected byte[] readFrom(Input input) throws IOException {
            return input.readByteArray();
        }

        @Override
        protected void writeTo(Output output, int number, byte[] value, boolean repeated) throws IOException {
            output.writeByteArray(number, value, repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        protected Class<?> typeClass() {
            return byte[].class;
        }
    };
    public static final RuntimeFieldFactory<Integer> ENUM = new RuntimeFieldFactory<Integer>(24){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final EnumIO<? extends Enum<?>> eio = strategy.getEnumIO(f.getType());
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.ENUM, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, eio.readFrom(input));
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    Enum existing = (Enum)us.getObject(message, offset);
                    if (existing != null) {
                        EnumIO.writeTo(output, this.number, this.repeated, existing);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    EnumIO.transfer(pipe, input, output, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Integer readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTo(Output output, int number, Integer value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> POJO = new RuntimeFieldFactory<Object>(127){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            Class<?> type = f.getType();
            final long offset = us.objectFieldOffset(f);
            return new RuntimeMessageField<T, Object>(type, strategy.getSchemaWrapper(type, true), WireFormat.FieldType.MESSAGE, number, name, false){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, input.mergeObject(us.getObject(message, offset), this.getSchema()));
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    Object existing = us.getObject(message, offset);
                    if (existing != null) {
                        output.writeObject(this.number, existing, this.getSchema(), false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.getPipeSchema(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> POLYMORPHIC_POJO = new RuntimeFieldFactory<Object>(0){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new RuntimeDerivativeField<T>(f.getType(), WireFormat.FieldType.MESSAGE, number, name, false, strategy){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    Object value = input.mergeObject(message, (Schema)this.schema);
                    if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                        us.putObject(message, offset, value);
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    Object existing = us.getObject(message, offset);
                    if (existing != null) {
                        output.writeObject(this.number, existing, (Schema)this.schema, false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.schema.pipeSchema, false);
                }

                @Override
                protected void doMergeFrom(Input input, Schema<Object> schema, Object message) throws IOException {
                    Object value;
                    Object existing = us.getObject(message, offset);
                    Object object = value = existing == null || existing.getClass() != schema.typeClass() ? schema.newMessage() : existing;
                    if (input instanceof GraphInput) {
                        ((GraphInput)input).updateLast(value, message);
                    }
                    schema.mergeFrom(input, value);
                    us.putObject(message, offset, value);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> OBJECT = new RuntimeFieldFactory<Object>(16){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new RuntimeObjectField<T>(WireFormat.FieldType.MESSAGE, number, name, false, strategy){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    Object value = input.mergeObject(message, (Schema)this.schema);
                    if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                        us.putObject(message, offset, value);
                    }
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    Object existing = us.getObject(message, offset);
                    if (existing != null) {
                        output.writeObject(this.number, existing, (Schema)this.schema, false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.schema.pipeSchema, false);
                }

                @Override
                protected void setValue(Object value, Object message) {
                    us.putObject(message, offset, value);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.MESSAGE;
        }

        @Override
        protected Class<?> typeClass() {
            return Object.class;
        }
    };
    public static final RuntimeFieldFactory<BigDecimal> BIGDECIMAL = new RuntimeFieldFactory<BigDecimal>(12){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.STRING, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, new BigDecimal(input.readString()));
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    BigDecimal value = (BigDecimal)us.getObject(message, offset);
                    if (value != null) {
                        output.writeString(this.number, value.toString(), false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, true, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, true, number, repeated);
        }

        @Override
        protected BigDecimal readFrom(Input input) throws IOException {
            return new BigDecimal(input.readString());
        }

        @Override
        protected void writeTo(Output output, int number, BigDecimal value, boolean repeated) throws IOException {
            output.writeString(number, value.toString(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.STRING;
        }

        @Override
        protected Class<?> typeClass() {
            return BigDecimal.class;
        }
    };
    public static final RuntimeFieldFactory<BigInteger> BIGINTEGER = new RuntimeFieldFactory<BigInteger>(13){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.BYTES, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, new BigInteger(input.readByteArray()));
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    BigInteger value = (BigInteger)us.getObject(message, offset);
                    if (value != null) {
                        output.writeByteArray(this.number, value.toByteArray(), false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        protected BigInteger readFrom(Input input) throws IOException {
            return new BigInteger(input.readByteArray());
        }

        @Override
        protected void writeTo(Output output, int number, BigInteger value, boolean repeated) throws IOException {
            output.writeByteArray(number, value.toByteArray(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        protected Class<?> typeClass() {
            return BigInteger.class;
        }
    };
    public static final RuntimeFieldFactory<Date> DATE = new RuntimeFieldFactory<Date>(14){

        @Override
        public <T> MappedSchema.Field<T> create(int number, String name, Field f, IdStrategy strategy) {
            final long offset = us.objectFieldOffset(f);
            return new MappedSchema.Field<T>(WireFormat.FieldType.FIXED64, number, name){

                @Override
                protected void mergeFrom(Input input, T message) throws IOException {
                    us.putObject(message, offset, new Date(input.readFixed64()));
                }

                @Override
                protected void writeTo(Output output, T message) throws IOException {
                    Date value = (Date)us.getObject(message, offset);
                    if (value != null) {
                        output.writeFixed64(this.number, value.getTime(), false);
                    }
                }

                @Override
                protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeFixed64(this.number, input.readFixed64(), repeated);
                }
            };
        }

        @Override
        protected void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        @Override
        protected Date readFrom(Input input) throws IOException {
            return new Date(input.readFixed64());
        }

        @Override
        protected void writeTo(Output output, int number, Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }

        @Override
        protected WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        @Override
        protected Class<?> typeClass() {
            return Date.class;
        }
    };

    private static Unsafe initUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception exception) {
            return Unsafe.getUnsafe();
        }
    }

    private RuntimeUnsafeFieldFactory() {
    }
}

