/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.CollectionSchema;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.MapSchema;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.runtime.ArraySchemas;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.PolymorphicSchema;
import com.dyuproject.protostuff.runtime.RuntimeEnv;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public abstract class EnumIO<E extends Enum<E>>
implements PolymorphicSchema.Factory {
    private static final Field __keyTypeFromEnumMap;
    private static final Field __elementTypeFromEnumSet;
    public final Class<E> enumClass;
    private volatile CollectionSchema.MessageFactory enumSetFactory;
    private volatile MapSchema.MessageFactory enumMapFactory;
    final ArraySchemas.Base genericElementSchema;

    static {
        boolean success = false;
        Field keyTypeFromMap = null;
        Field valueTypeFromSet = null;
        try {
            keyTypeFromMap = EnumMap.class.getDeclaredField("keyType");
            keyTypeFromMap.setAccessible(true);
            valueTypeFromSet = EnumSet.class.getDeclaredField("elementType");
            valueTypeFromSet.setAccessible(true);
            success = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        __keyTypeFromEnumMap = success ? keyTypeFromMap : null;
        __elementTypeFromEnumSet = success ? valueTypeFromSet : null;
    }

    static Class<?> getKeyTypeFromEnumMap(Object enumMap) {
        if (__keyTypeFromEnumMap == null) {
            throw new RuntimeException("Could not access (reflection) the private field *keyType* (enumClass) from: class java.util.EnumMap");
        }
        try {
            return (Class)__keyTypeFromEnumMap.get(enumMap);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> getElementTypeFromEnumSet(Object enumSet) {
        if (__elementTypeFromEnumSet == null) {
            throw new RuntimeException("Could not access (reflection) the private field *elementType* (enumClass) from: class java.util.EnumSet");
        }
        try {
            return (Class)__elementTypeFromEnumSet.get(enumSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static EnumIO<? extends Enum<?>> newEnumIO(Class<?> enumClass, IdStrategy strategy) {
        return RuntimeEnv.ENUMS_BY_NAME ? new ByName(enumClass, strategy) : new ByNumber(enumClass, strategy);
    }

    public static void writeTo(Output output, int number, boolean repeated, Enum<?> e) throws IOException {
        if (RuntimeEnv.ENUMS_BY_NAME) {
            output.writeString(number, e.name(), repeated);
        } else {
            output.writeEnum(number, e.ordinal(), repeated);
        }
    }

    public static void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
        if (RuntimeEnv.ENUMS_BY_NAME) {
            input.transferByteRangeTo(output, true, number, repeated);
        } else {
            output.writeEnum(number, input.readEnum(), repeated);
        }
    }

    private static <E extends Enum<E>> CollectionSchema.MessageFactory newEnumSetFactory(EnumIO<E> eio) {
        return new CollectionSchema.MessageFactory(){

            public <V> Collection<V> newMessage() {
                return EnumIO.this.newEnumSet();
            }

            public Class<?> typeClass() {
                return EnumSet.class;
            }
        };
    }

    private static <E extends Enum<E>> MapSchema.MessageFactory newEnumMapFactory(EnumIO<E> eio) {
        return new MapSchema.MessageFactory(){

            public <K, V> Map<K, V> newMessage() {
                return EnumIO.this.newEnumMap();
            }

            public Class<?> typeClass() {
                return EnumMap.class;
            }
        };
    }

    public EnumIO(Class<E> enumClass, IdStrategy strategy) {
        this.enumClass = enumClass;
        this.genericElementSchema = new ArraySchemas.EnumArray(strategy, null, this);
    }

    @Override
    public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, PolymorphicSchema.Handler handler) {
        return new ArraySchemas.EnumArray(strategy, handler, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSchema.MessageFactory getEnumSetFactory() {
        CollectionSchema.MessageFactory enumSetFactory = this.enumSetFactory;
        if (enumSetFactory == null) {
            EnumIO enumIO = this;
            synchronized (enumIO) {
                enumSetFactory = this.enumSetFactory;
                if (enumSetFactory == null) {
                    this.enumSetFactory = enumSetFactory = EnumIO.newEnumSetFactory(this);
                }
            }
        }
        return enumSetFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapSchema.MessageFactory getEnumMapFactory() {
        MapSchema.MessageFactory enumMapFactory = this.enumMapFactory;
        if (enumMapFactory == null) {
            EnumIO enumIO = this;
            synchronized (enumIO) {
                enumMapFactory = this.enumMapFactory;
                if (enumMapFactory == null) {
                    this.enumMapFactory = enumMapFactory = EnumIO.newEnumMapFactory(this);
                }
            }
        }
        return enumMapFactory;
    }

    public EnumSet<E> newEnumSet() {
        return EnumSet.noneOf(this.enumClass);
    }

    public <V> EnumMap<E, V> newEnumMap() {
        return new EnumMap(this.enumClass);
    }

    public abstract E readFrom(Input var1) throws IOException;

    public static final class ByName<E extends Enum<E>>
    extends EnumIO<E> {
        public ByName(Class<E> enumClass, IdStrategy strategy) {
            super(enumClass, strategy);
        }

        @Override
        public E readFrom(Input input) throws IOException {
            return (E)Enum.valueOf(this.enumClass, input.readString());
        }
    }

    public static final class ByNumber<E extends Enum<E>>
    extends EnumIO<E> {
        public ByNumber(Class<E> enumClass, IdStrategy strategy) {
            super(enumClass, strategy);
        }

        @Override
        public E readFrom(Input input) throws IOException {
            return (E)((Enum[])this.enumClass.getEnumConstants())[input.readEnum()];
        }
    }
}

