/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.runtime.ArraySchema;
import com.dyuproject.protostuff.runtime.ArraySchemas;
import com.dyuproject.protostuff.runtime.ClassSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.NumberSchema;
import com.dyuproject.protostuff.runtime.ObjectSchema;
import com.dyuproject.protostuff.runtime.PolymorphicCollectionSchema;
import com.dyuproject.protostuff.runtime.PolymorphicEnumSchema;
import com.dyuproject.protostuff.runtime.PolymorphicMapSchema;
import com.dyuproject.protostuff.runtime.PolymorphicSchema;
import com.dyuproject.protostuff.runtime.PolymorphicThrowableSchema;
import com.dyuproject.protostuff.runtime.RuntimeFieldFactory;
import java.util.Collection;
import java.util.Map;

public enum PolymorphicSchemaFactories implements PolymorphicSchema.Factory
{
    ARRAY{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            Class<?> ct = typeClass.getComponentType();
            RuntimeFieldFactory<?> rff = RuntimeFieldFactory.getFieldFactory(ct, strategy);
            if (rff == RuntimeFieldFactory.DELEGATE) {
                return strategy.getDelegateWrapper(ct).newSchema(typeClass, strategy, handler);
            }
            if (rff.id > 0 && rff.id < 15) {
                return ArraySchemas.newSchema(rff.id, ct, typeClass, strategy, handler);
            }
            if (ct.isEnum()) {
                return strategy.getEnumIO(ct).newSchema(typeClass, strategy, handler);
            }
            if (rff == RuntimeFieldFactory.POJO || rff == RuntimeFieldFactory.POLYMORPHIC_POJO && RuntimeFieldFactory.pojo(ct, null, strategy)) {
                return strategy.getSchemaWrapper(ct, true).newSchema(typeClass, strategy, handler);
            }
            return new ArraySchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    NUMBER{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new NumberSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    CLASS{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ClassSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    ENUM{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicEnumSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    COLLECTION{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicCollectionSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    MAP{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicMapSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    THROWABLE{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicThrowableSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    OBJECT{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ObjectSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    };


    private PolymorphicSchemaFactories() {
    }

    public static PolymorphicSchema.Factory getFactoryFromField(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MAP;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return COLLECTION;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        return OBJECT;
    }

    public static PolymorphicSchema.Factory getFactoryFromRepeatedValueGenericType(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        if (Object.class == clazz) {
            return OBJECT;
        }
        return null;
    }

    public static PolymorphicSchema getSchemaFromCollectionOrMapGenericType(Class<?> clazz, IdStrategy strategy) {
        if (clazz.isArray()) {
            Class<?> ct = clazz.getComponentType();
            RuntimeFieldFactory<?> rff = RuntimeFieldFactory.getFieldFactory(ct, strategy);
            if (rff == RuntimeFieldFactory.DELEGATE) {
                return strategy.getDelegateWrapper(ct).genericElementSchema;
            }
            if (rff.id > 0 && rff.id < 15) {
                return ArraySchemas.getGenericElementSchema(rff.id, strategy);
            }
            if (ct.isEnum()) {
                return strategy.getEnumIO(ct).genericElementSchema;
            }
            if (rff == RuntimeFieldFactory.POJO || rff == RuntimeFieldFactory.POLYMORPHIC_POJO && RuntimeFieldFactory.pojo(ct, null, strategy)) {
                return strategy.getSchemaWrapper(ct, (boolean)true).genericElementSchema;
            }
            return strategy.ARRAY_ELEMENT_SCHEMA;
        }
        if (Number.class == clazz) {
            return strategy.NUMBER_ELEMENT_SCHEMA;
        }
        if (Class.class == clazz) {
            return strategy.CLASS_ELEMENT_SCHEMA;
        }
        if (Enum.class == clazz) {
            return strategy.POLYMORPHIC_ENUM_ELEMENT_SCHEMA;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return strategy.POLYMORPHIC_THROWABLE_ELEMENT_SCHEMA;
        }
        if (Object.class == clazz) {
            return strategy.OBJECT_ELEMENT_SCHEMA;
        }
        return null;
    }

    /* synthetic */ PolymorphicSchemaFactories(String string, int n, PolymorphicSchemaFactories polymorphicSchemaFactories) {
        this();
    }
}

