/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.Tag;
import com.dyuproject.protostuff.WireFormat;
import com.dyuproject.protostuff.runtime.RuntimePipeSchema;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedSchema<T>
implements Schema<T> {
    protected final Class<T> typeClass;
    protected final Field<T>[] fields;
    protected final Field<T>[] fieldsByNumber;
    protected final Map<String, Field<T>> fieldsByName;
    protected final Pipe.Schema<T> pipeSchema;

    public MappedSchema(Class<T> typeClass, Field<T>[] fields, int lastFieldNumber) {
        if (fields.length == 0) {
            throw new IllegalStateException("At least one field is required.");
        }
        this.typeClass = typeClass;
        this.fields = fields;
        this.fieldsByName = new HashMap<String, Field<T>>();
        this.fieldsByNumber = new Field[lastFieldNumber + 1];
        for (Field<T> f : fields) {
            Field<T> last = this.fieldsByName.put(f.name, f);
            if (last != null) {
                throw new IllegalStateException(last + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber[f.number] != null) {
                throw new IllegalStateException(this.fieldsByNumber[f.number] + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber[f.number] = f;
        }
        this.pipeSchema = new RuntimePipeSchema<T>(this, this.fieldsByNumber);
    }

    public MappedSchema(Class<T> typeClass, Collection<Field<T>> fields, int lastFieldNumber) {
        if (fields.isEmpty()) {
            throw new IllegalStateException("At least one field is required.");
        }
        this.typeClass = typeClass;
        this.fieldsByName = new HashMap<String, Field<T>>();
        this.fieldsByNumber = new Field[lastFieldNumber + 1];
        for (Field<T> f : fields) {
            Field<T> last = this.fieldsByName.put(f.name, f);
            if (last != null) {
                throw new IllegalStateException(last + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber[f.number] != null) {
                throw new IllegalStateException(this.fieldsByNumber[f.number] + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber[f.number] = f;
        }
        this.fields = new Field[fields.size()];
        int j = 0;
        for (int i = 1; i < this.fieldsByNumber.length; ++i) {
            if (this.fieldsByNumber[i] == null) continue;
            this.fields[j++] = this.fieldsByNumber[i];
        }
        this.pipeSchema = new RuntimePipeSchema<T>(this, this.fieldsByNumber);
    }

    public MappedSchema(Class<T> typeClass, Map<String, Field<T>> fieldsByName, int lastFieldNumber) {
        if (fieldsByName.isEmpty()) {
            throw new IllegalStateException("At least one field is required.");
        }
        this.typeClass = typeClass;
        this.fieldsByName = fieldsByName;
        Collection<Field<T>> fields = fieldsByName.values();
        this.fieldsByNumber = new Field[lastFieldNumber + 1];
        for (Field<T> f : fields) {
            if (this.fieldsByNumber[f.number] != null) {
                throw new IllegalStateException(this.fieldsByNumber[f.number] + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber[f.number] = f;
        }
        this.fields = new Field[fields.size()];
        int j = 0;
        for (int i = 1; i < this.fieldsByNumber.length; ++i) {
            if (this.fieldsByNumber[i] == null) continue;
            this.fields[j++] = this.fieldsByNumber[i];
        }
        this.pipeSchema = new RuntimePipeSchema<T>(this, this.fieldsByNumber);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public Class<T> typeClass() {
        return this.typeClass;
    }

    @Override
    public String messageName() {
        return this.typeClass.getSimpleName();
    }

    @Override
    public String messageFullName() {
        return this.typeClass.getName();
    }

    @Override
    public String getFieldName(int number) {
        Field<T> field = number < this.fieldsByNumber.length ? this.fieldsByNumber[number] : null;
        return field == null ? null : field.name;
    }

    @Override
    public int getFieldNumber(String name) {
        Field<T> field = this.fieldsByName.get(name);
        return field == null ? 0 : field.number;
    }

    @Override
    public final void mergeFrom(Input input, T message) throws IOException {
        int number = input.readFieldNumber(this);
        while (number != 0) {
            Field<T> field;
            Field<T> field2 = field = number < this.fieldsByNumber.length ? this.fieldsByNumber[number] : null;
            if (field == null) {
                input.handleUnknownField(number, this);
            } else {
                field.mergeFrom(input, message);
            }
            number = input.readFieldNumber(this);
        }
    }

    @Override
    public final void writeTo(Output output, T message) throws IOException {
        for (Field<T> f : this.fields) {
            f.writeTo(output, message);
        }
    }

    public Pipe.Schema<T> getPipeSchema() {
        return this.pipeSchema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Field<T> {
        public final WireFormat.FieldType type;
        public final int number;
        public final String name;
        public final boolean repeated;
        public final int groupFilter;

        public Field(WireFormat.FieldType type, int number, String name, boolean repeated, Tag tag) {
            this.type = type;
            this.number = number;
            this.name = name;
            this.repeated = repeated;
            this.groupFilter = tag == null ? 0 : tag.groupFilter();
        }

        public Field(WireFormat.FieldType type, int number, String name, Tag tag) {
            this(type, number, name, false, tag);
        }

        protected abstract void writeTo(Output var1, T var2) throws IOException;

        protected abstract void mergeFrom(Input var1, T var2) throws IOException;

        protected abstract void transfer(Pipe var1, Input var2, Output var3, boolean var4) throws IOException;
    }
}

