/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import java.util.Collection;
import junit.extensions.PrivilegedAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PA {
    private final Object instanceOrClass;

    private PA(Object instanceOrClass) {
        this.instanceOrClass = instanceOrClass;
    }

    public static String toString(Object instanceOrClass) {
        return PrivilegedAccessor.toString(instanceOrClass);
    }

    public static Collection<String> getFieldNames(Object instanceOrClass) {
        return PrivilegedAccessor.getFieldNames(instanceOrClass);
    }

    public static Collection<String> getMethodSignatures(Object instanceOrClass) {
        return PrivilegedAccessor.getMethodSignatures(instanceOrClass);
    }

    public static Object getValue(Object instanceOrClass, String fieldName) {
        try {
            return PrivilegedAccessor.getValue(instanceOrClass, fieldName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't get value of " + fieldName + " from " + instanceOrClass, e);
        }
    }

    public Object getValue(String fieldName) {
        return PA.getValue(this.instanceOrClass, fieldName);
    }

    public static <T> T instantiate(Class<? extends T> fromClass, Class<?>[] argumentTypes, Object ... arguments) {
        try {
            return PrivilegedAccessor.instantiate(fromClass, argumentTypes, PA.correctVarargs(arguments));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't instantiate class " + fromClass + " with arguments " + arguments, e);
        }
    }

    public static <T> T instantiate(Class<? extends T> fromClass, Object ... arguments) {
        try {
            return PrivilegedAccessor.instantiate(fromClass, PA.correctVarargs(arguments));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't instantiate class " + fromClass + " with arguments " + arguments, e);
        }
    }

    public static Object invokeMethod(Object instanceOrClass, String methodSignature, Object ... arguments) {
        try {
            return PrivilegedAccessor.invokeMethod(instanceOrClass, methodSignature, PA.correctVarargs(arguments));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't invoke method " + methodSignature + " on " + instanceOrClass + " with arguments " + arguments, e);
        }
    }

    public Object invokeMethod(String methodSignature, Object ... arguments) {
        return PA.invokeMethod(this.instanceOrClass, methodSignature, arguments);
    }

    private static Object[] correctVarargs(Object ... arguments) {
        if (arguments == null || PA.changedByVararg(arguments)) {
            return new Object[]{arguments};
        }
        return arguments;
    }

    private static boolean changedByVararg(Object[] parameters) {
        if (parameters.length == 0 || parameters[0] == null) {
            return false;
        }
        return parameters.getClass() != Object[].class;
    }

    public static PA setValue(Object instanceOrClass, String fieldName, Object value) {
        try {
            PrivilegedAccessor.setValue(instanceOrClass, fieldName, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't set value " + value + " at " + fieldName + " in " + instanceOrClass, e);
        }
        return new PA(instanceOrClass);
    }

    public PA setValue(String fieldName, Object value) {
        PA.setValue(this.instanceOrClass, fieldName, value);
        return this;
    }
}

