/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class PrivilegedAccessor {
    private static final Map<String, Class<?>> PRIMITIVE_MAPPER = new HashMap(8);

    private PrivilegedAccessor() {
        assert (false) : "You mustn't instantiate PrivilegedAccessor, use its methods statically";
    }

    public static String toString(Object instanceOrClass) {
        Collection<String> fields = PrivilegedAccessor.getFieldNames(instanceOrClass);
        if (fields.isEmpty()) {
            return PrivilegedAccessor.getClass(instanceOrClass).getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PrivilegedAccessor.getClass(instanceOrClass).getName() + " {");
        for (String fieldName : fields) {
            try {
                stringBuffer.append(fieldName + "=" + PrivilegedAccessor.getValue(instanceOrClass, fieldName) + ", ");
            }
            catch (NoSuchFieldException e) {
                assert (false) : "It should always be possible to get a field that was just here";
            }
        }
        stringBuffer.replace(stringBuffer.lastIndexOf(", "), stringBuffer.length(), "}");
        return stringBuffer.toString();
    }

    public static Collection<String> getFieldNames(Object instanceOrClass) {
        if (instanceOrClass == null) {
            return Collections.EMPTY_LIST;
        }
        Class<?> clazz = PrivilegedAccessor.getClass(instanceOrClass);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        fieldNames.addAll(PrivilegedAccessor.getFieldNames(clazz.getSuperclass()));
        return fieldNames;
    }

    public static Collection<String> getMethodSignatures(Object instanceOrClass) {
        if (instanceOrClass == null) {
            return Collections.EMPTY_LIST;
        }
        Class<?> clazz = PrivilegedAccessor.getClass(instanceOrClass);
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<String> methodSignatures = new ArrayList<String>(methods.length + Object.class.getDeclaredMethods().length);
        for (Method method : methods) {
            methodSignatures.add(method.getName() + "(" + PrivilegedAccessor.getParameterTypesAsString(method.getParameterTypes()) + ")");
        }
        methodSignatures.addAll(PrivilegedAccessor.getMethodSignatures(clazz.getSuperclass()));
        return methodSignatures;
    }

    public static Object getValue(Object instanceOrClass, String fieldName) throws NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instanceOrClass, fieldName);
        try {
            return field.get(instanceOrClass);
        }
        catch (IllegalAccessException e) {
            assert (false) : "getField() should have setAccessible(true), so an IllegalAccessException should not occur in this place";
            return null;
        }
    }

    public static <T> T instantiate(Class<? extends T> fromClass, Object[] args) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PrivilegedAccessor.instantiate(fromClass, PrivilegedAccessor.getParameterTypes(args), args);
    }

    public static <T> T instantiate(Class<? extends T> fromClass, Class<?>[] argumentTypes, Object[] args) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PrivilegedAccessor.getConstructor(fromClass, argumentTypes).newInstance(args);
    }

    public static Object invokeMethod(Object instanceOrClass, String methodSignature, Object[] arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (methodSignature.indexOf(40) == -1 || methodSignature.indexOf(40) >= methodSignature.indexOf(41)) {
            throw new NoSuchMethodException(methodSignature);
        }
        Class<?>[] parameterTypes = PrivilegedAccessor.getParameterTypes(methodSignature);
        return PrivilegedAccessor.getMethod(instanceOrClass, PrivilegedAccessor.getMethodName(methodSignature), parameterTypes).invoke(instanceOrClass, PrivilegedAccessor.getCorrectedArguments(parameterTypes, arguments));
    }

    private static Object[] getCorrectedArguments(Class<?>[] parameterTypes, Object[] arguments) {
        if (arguments == null) {
            return arguments;
        }
        if (parameterTypes.length > arguments.length) {
            return arguments;
        }
        if (parameterTypes.length < arguments.length) {
            return PrivilegedAccessor.getCorrectedArguments(parameterTypes, new Object[]{arguments});
        }
        Object[] correctedArguments = new Object[arguments.length];
        int currentArgument = 0;
        for (Class<?> parameterType : parameterTypes) {
            correctedArguments[currentArgument] = PrivilegedAccessor.getCorrectedArgument(parameterType, arguments[currentArgument]);
            ++currentArgument;
        }
        return correctedArguments;
    }

    private static Object getCorrectedArgument(Class<?> parameterType, Object argument) {
        if (!parameterType.isArray() || argument == null) {
            return argument;
        }
        if (!argument.getClass().isArray()) {
            return new Object[]{argument};
        }
        if (parameterType.equals(argument.getClass())) {
            return argument;
        }
        Object correctedArrayArgument = Array.newInstance(parameterType.getComponentType(), Array.getLength(argument));
        for (int index = 0; index < Array.getLength(argument); ++index) {
            if (parameterType.getComponentType().isPrimitive()) {
                Array.set(correctedArrayArgument, index, Array.get(argument, index));
                continue;
            }
            try {
                Array.set(correctedArrayArgument, index, parameterType.getComponentType().cast(Array.get(argument, index)));
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Argument " + argument + " of type " + argument.getClass() + " does not match expected argument type " + parameterType + ".");
            }
        }
        return correctedArrayArgument;
    }

    public static void setValue(Object instanceOrClass, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = PrivilegedAccessor.getField(instanceOrClass, fieldName);
        if (Modifier.isFinal(field.getModifiers())) {
            PrivilegedAccessor.setValue(field, "modifiers", field.getModifiers() ^ 0x10);
        }
        field.set(instanceOrClass, value);
    }

    private static Class<?> getClassForName(String className) throws ClassNotFoundException {
        if (className.indexOf(91) > -1) {
            Class<?> clazz = PrivilegedAccessor.getClassForName(className.substring(0, className.indexOf(91)));
            return Array.newInstance(clazz, 0).getClass();
        }
        if (className.indexOf("...") > -1) {
            Class<?> clazz = PrivilegedAccessor.getClassForName(className.substring(0, className.indexOf("...")));
            return Array.newInstance(clazz, 0).getClass();
        }
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return PrivilegedAccessor.getSpecialClassForName(className);
        }
    }

    private static Class<?> getSpecialClassForName(String className) throws ClassNotFoundException {
        if (PRIMITIVE_MAPPER.containsKey(className)) {
            return PRIMITIVE_MAPPER.get(className);
        }
        if (PrivilegedAccessor.missesPackageName(className)) {
            return PrivilegedAccessor.getStandardClassForName(className);
        }
        throw new ClassNotFoundException(className);
    }

    private static Class<?> getStandardClassForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName("java.lang." + className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("java.util." + className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new ClassNotFoundException(className);
            }
        }
    }

    private static boolean missesPackageName(String className) {
        if (className.contains(".")) {
            return false;
        }
        return className.startsWith(className.substring(0, 1).toUpperCase());
    }

    private static <T> Constructor<T> getConstructor(Class<T> type, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Constructor<T> constructor = type.getDeclaredConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    private static Field getField(Object instanceOrClass, String fieldName) throws NoSuchFieldException, InvalidParameterException {
        if (instanceOrClass == null) {
            throw new InvalidParameterException("Can't get field on null object/class");
        }
        Class<?> type = PrivilegedAccessor.getClass(instanceOrClass);
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass() == null) {
                throw e;
            }
            return PrivilegedAccessor.getField(type.getSuperclass(), fieldName);
        }
    }

    private static Class<?> getClass(Object instanceOrClass) {
        if (instanceOrClass instanceof Class) {
            return (Class)instanceOrClass;
        }
        return instanceOrClass.getClass();
    }

    private static Method getMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (type.getSuperclass() == null) {
                throw e;
            }
            return PrivilegedAccessor.getMethod(type.getSuperclass(), methodName, parameterTypes);
        }
    }

    private static Method getMethod(Object instanceOrClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Class<?> type = PrivilegedAccessor.getClass(instanceOrClass);
        Method accessMethod = PrivilegedAccessor.getMethod(type, methodName, parameterTypes);
        accessMethod.setAccessible(true);
        return accessMethod;
    }

    private static String getMethodName(String methodSignature) {
        try {
            return methodSignature.substring(0, methodSignature.indexOf(40)).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            assert (false) : "Signature must have been checked before this method was called";
            return null;
        }
    }

    private static Class<?>[] getParameterTypes(Object[] parameters) {
        if (parameters == null) {
            return new Class[0];
        }
        Class[] typesOfParameters = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typesOfParameters[i] = parameters[i].getClass();
        }
        return typesOfParameters;
    }

    private static Class<?>[] getParameterTypes(String methodSignature) throws NoSuchMethodException, IllegalArgumentException {
        String signature = PrivilegedAccessor.getSignatureWithoutBraces(methodSignature);
        StringTokenizer tokenizer = new StringTokenizer(signature, ", *");
        Class[] typesInSignature = new Class[tokenizer.countTokens()];
        int x = 0;
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                typesInSignature[x] = PrivilegedAccessor.getClassForName(className);
            }
            catch (ClassNotFoundException e) {
                NoSuchMethodException noSuchMethodException = new NoSuchMethodException(methodSignature);
                noSuchMethodException.initCause(e);
                throw noSuchMethodException;
            }
            ++x;
        }
        return typesInSignature;
    }

    private static String getParameterTypesAsString(Class<?>[] classTypes) {
        assert (classTypes != null) : "getParameterTypes() should have been called before this method and should have provided not-null classTypes";
        if (classTypes.length == 0) {
            return "";
        }
        StringBuilder parameterTypes = new StringBuilder();
        for (Class<?> clazz : classTypes) {
            assert (clazz != null) : "getParameterTypes() should have been called before this method and should have provided not-null classTypes";
            parameterTypes.append(clazz.getName()).append(", ");
        }
        return parameterTypes.substring(0, parameterTypes.length() - 2);
    }

    private static String getSignatureWithoutBraces(String methodSignature) {
        try {
            return methodSignature.substring(methodSignature.indexOf(40) + 1, methodSignature.indexOf(41));
        }
        catch (IndexOutOfBoundsException e) {
            assert (false) : "signature must have been checked before this method";
            return null;
        }
    }

    static {
        PRIMITIVE_MAPPER.put("int", Integer.TYPE);
        PRIMITIVE_MAPPER.put("float", Float.TYPE);
        PRIMITIVE_MAPPER.put("double", Double.TYPE);
        PRIMITIVE_MAPPER.put("short", Short.TYPE);
        PRIMITIVE_MAPPER.put("long", Long.TYPE);
        PRIMITIVE_MAPPER.put("byte", Byte.TYPE);
        PRIMITIVE_MAPPER.put("char", Character.TYPE);
        PRIMITIVE_MAPPER.put("boolean", Boolean.TYPE);
    }
}

