/*
 * Decompiled with CFR 0.152.
 */
package com.ea.async.instrumentation;

import com.ea.async.shaded.org.objectweb.asm.Type;
import com.ea.async.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.FrameNode;
import com.ea.async.shaded.org.objectweb.asm.tree.LabelNode;
import com.ea.async.shaded.org.objectweb.asm.tree.MethodInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.MethodNode;
import com.ea.async.shaded.org.objectweb.asm.tree.TypeInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Analyzer;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.BasicInterpreter;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.BasicValue;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Frame;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Interpreter;
import java.util.Arrays;

class FrameAnalyzer
extends Analyzer {
    private static final int FN_TOP = 0;
    private static final int FN_INTEGER = 1;
    private static final int FN_FLOAT = 2;
    private static final int FN_DOUBLE = 3;
    private static final int FN_LONG = 4;
    private static final int FN_NULL = 5;
    private static final int FN_UNINITIALIZED_THIS = 6;
    private final TypeInterpreter interpreter = TypeInterpreter.instance;

    public FrameAnalyzer() {
        super(TypeInterpreter.instance);
    }

    protected Frame newFrame(int nLocals, int nStack) {
        return new ExtendedFrame(nLocals, nStack);
    }

    protected Frame newFrame(Frame src) {
        return new ExtendedFrame(src);
    }

    @Override
    protected void init(String owner, MethodNode m) throws AnalyzerException {
        Frame<V>[] frames = this.getFrames();
        AbstractInsnNode insnNode = m.instructions.getFirst();
        TypeInterpreter interpreter = TypeInterpreter.instance;
        ExtendedFrame lastFrame = frames[0];
        int insnIndex = 0;
        while (insnNode != null) {
            if (insnNode instanceof FrameNode) {
                FrameNode frameNode = (FrameNode)insnNode;
                int frameType = frameNode.type;
                if (frameType == -1 || frameType == 0) {
                    ExtendedFrame frame = (ExtendedFrame)this.newFrame((Frame)lastFrame);
                    frame.force = true;
                    frames[insnIndex] = frame;
                    int iLocal_w = 0;
                    if (frameNode.local != null && frameNode.local.size() > 0) {
                        for (int j = 0; j < frameNode.local.size(); ++j) {
                            BasicValue value = this.convertFrameNodeType(frameNode.local.get(j));
                            frame.setLocal(iLocal_w, value);
                            iLocal_w += value.getSize();
                        }
                    }
                    BasicValue nullValue = interpreter.newValue(null);
                    while (iLocal_w < m.maxLocals) {
                        frame.setLocal(iLocal_w++, nullValue);
                    }
                    frame.clearStack();
                    if (frameNode.stack != null && frameNode.stack.size() > 0) {
                        for (int j = 0; j < frameNode.stack.size(); ++j) {
                            frame.push(this.convertFrameNodeType(frameNode.stack.get(j)));
                        }
                    }
                    lastFrame = frame;
                }
            }
            insnNode = insnNode.getNext();
            ++insnIndex;
        }
    }

    BasicValue convertFrameNodeType(Object v) throws AnalyzerException {
        if (v instanceof String) {
            return this.interpreter.newValue(Type.getObjectType((String)v));
        }
        if (v instanceof Integer) {
            switch ((Integer)v) {
                case 0: {
                    return this.interpreter.newValue(null);
                }
                case 1: {
                    return this.interpreter.newValue(Type.INT_TYPE);
                }
                case 2: {
                    return this.interpreter.newValue(Type.FLOAT_TYPE);
                }
                case 3: {
                    return this.interpreter.newValue(Type.DOUBLE_TYPE);
                }
                case 4: {
                    return this.interpreter.newValue(Type.LONG_TYPE);
                }
                case 5: {
                    return this.interpreter.newValue(BasicValue.REFERENCE_VALUE.getType());
                }
                case 6: {
                    return this.interpreter.newValue(null);
                }
            }
        } else if (v instanceof LabelNode) {
            AbstractInsnNode node = (AbstractInsnNode)v;
            while (node.getOpcode() != 187) {
                node = node.getNext();
            }
            return this.interpreter.newOperation(node);
        }
        return this.interpreter.newValue(null);
    }

    static class TypeInterpreter
    extends BasicInterpreter {
        static TypeInterpreter instance = new TypeInterpreter();

        TypeInterpreter() {
            super(393216);
        }

        @Override
        public BasicValue newValue(Type type) {
            if (type != null && (type.getSort() == 10 || type.getSort() == 9)) {
                return new ExtendedValue(type);
            }
            return super.newValue(type);
        }

        @Override
        public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
            if (insn.getOpcode() == 187) {
                Type type = Type.getObjectType(((TypeInsnNode)insn).desc);
                ExtendedValue extendedValue = new ExtendedValue(type);
                extendedValue.uninitialized = true;
                extendedValue.insnNode = insn;
                return extendedValue;
            }
            return super.newOperation(insn);
        }

        @Override
        public BasicValue merge(BasicValue v, BasicValue w) {
            if (v != w && v != null && w != null && !v.equals(w)) {
                Type t = v.getType();
                Type u = w.getType();
                if (t != null && u != null && t.getSort() == 10 && u.getSort() == 10) {
                    ExtendedValue nv = (ExtendedValue)this.newValue(BasicValue.REFERENCE_VALUE.getType());
                    nv.undecided = new BasicValue[]{v, w};
                    return nv;
                }
            }
            return super.merge(v, w);
        }
    }

    static class ExtendedFrame
    extends Frame<BasicValue> {
        static final BasicValue[] EMPTY_MONITORS = new BasicValue[0];
        boolean force;
        BasicValue[] monitors = EMPTY_MONITORS;

        public ExtendedFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }

        public ExtendedFrame(Frame<? extends BasicValue> src) {
            super(src);
            if (src instanceof ExtendedFrame) {
                this.monitors = ((ExtendedFrame)src).monitors;
            }
        }

        @Override
        public Frame<BasicValue> init(Frame<? extends BasicValue> src) {
            Frame<BasicValue> frame = super.init(src);
            if (frame instanceof ExtendedFrame && src instanceof ExtendedFrame) {
                ((ExtendedFrame)frame).monitors = ((ExtendedFrame)src).monitors;
            }
            return frame;
        }

        @Override
        public void execute(AbstractInsnNode insn, Interpreter<BasicValue> interpreter) throws AnalyzerException {
            switch (insn.getOpcode()) {
                case 194: {
                    this.monitors = Arrays.copyOf(this.monitors, this.monitors.length + 1);
                    this.monitors[this.monitors.length - 1] = (BasicValue)this.pop();
                    return;
                }
                case 195: {
                    BasicValue v = (BasicValue)this.pop();
                    int iv = this.monitors.length;
                    while (--iv >= 0 && this.monitors[iv] != v) {
                    }
                    if (iv != -1) {
                        BasicValue[] newMonitors = Arrays.copyOf(this.monitors, this.monitors.length - 1);
                        if (this.monitors.length - iv > 1) {
                            System.arraycopy(this.monitors, iv + 1, newMonitors, iv, this.monitors.length - iv);
                        }
                        this.monitors = newMonitors;
                    }
                    return;
                }
                case 183: {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                    if (!methodInsnNode.name.equals("<init>")) break;
                    BasicValue target = (BasicValue)this.getStack(this.getStackSize() - (1 + Type.getArgumentTypes(methodInsnNode.desc).length));
                    BasicValue newValue = interpreter.newValue(target.getType());
                    super.execute(insn, interpreter);
                    for (int i = 0; i < this.getLocals(); ++i) {
                        if (!target.equals(this.getLocal(i))) continue;
                        this.setLocal(i, newValue);
                    }
                    int s = this.getStackSize();
                    BasicValue[] stack = new BasicValue[s];
                    int i = s;
                    while (--i >= 0) {
                        BasicValue v = (BasicValue)this.pop();
                        stack[i] = target.equals(v) ? newValue : v;
                    }
                    for (i = 0; i < s; ++i) {
                        this.push(stack[i]);
                    }
                    return;
                }
            }
            super.execute(insn, interpreter);
        }

        @Override
        public boolean merge(Frame<? extends BasicValue> frame, Interpreter<BasicValue> interpreter) throws AnalyzerException {
            if (this.force) {
                return true;
            }
            if (frame instanceof ExtendedFrame && ((ExtendedFrame)frame).force) {
                this.init(frame);
                return true;
            }
            return super.merge(frame, interpreter);
        }
    }

    static class ExtendedValue
    extends BasicValue {
        AbstractInsnNode insnNode;
        boolean uninitialized;
        public BasicValue[] undecided;

        public ExtendedValue(Type type) {
            super(type);
        }

        public boolean isUninitialized() {
            return this.uninitialized;
        }

        @Override
        public boolean equals(Object value) {
            if (this.insnNode != null || this.uninitialized) {
                return value instanceof ExtendedValue && ((ExtendedValue)value).uninitialized == this.uninitialized && ((ExtendedValue)value).insnNode == this.insnNode;
            }
            return super.equals(value);
        }

        @Override
        public String toString() {
            return this.undecided != null ? "?" : (this.uninitialized ? "%" + super.toString() : super.toString());
        }
    }
}

