package com.earldouglas.sprocket

trait Reader[C, A] {
  def apply(c: C): A
  def map[B](g: A => B): C => B
  def flatMap[B](g: A => C => B): C => B
}

class Fn1Reader[T1, R](f: Function1[T1, R]) extends Reader[T1, R] {
  def apply(x: T1): R = f(x)
  def map[R2](g: R => R2): T1 => R2 = x => g(f(x))
  def flatMap[R2](g: R => T1 => R2): T1 => R2 = x => g(f(x))(x)
}

class Closer[C <: java.io.Closeable, A](f: C => A) extends Reader[C, A] {

  def apply(c: C): A = {
    val a = f(c)
    c.close()
    a
  }

  def map[B](g: A => B): C => B = f andThen g
  def flatMap[B](g: A => C => B): C => B = { c => (f andThen g)(c)(c) }
}
