package com.hyphenate.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

import com.hyphenate.helpdesk.util.Log;

/**
 * Created by liyuzhao on 01/12/2016.
 */

class CountDownUtils {

    private static final String TAG = "CountDownUtils";
    private static CountDownUtils instance = new CountDownUtils();

    private static int REQUEST_CODE = 0;
    private static int KEY_HANDLE_WHAT = 1;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            try {
                if (msg.what == KEY_HANDLE_WHAT) {
                    long triggerAtTime = (long) msg.obj;
                    PreferenceUtil.getInstance().setTriggerEventTime(triggerAtTime);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };

    public static CountDownUtils getInstance() {
        return instance;
    }

    private AlarmManager alarmMgr = null;

    private Context mContext;

    private PendingIntent pendingIntent;

    public void init(Context context) {
        this.mContext = context;
        alarmMgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
    }

    public void sendBroadcast(){
        sendBroadcast(0);
    }

    public void sendBroadcast(long willTriggerTime) {
        if (pendingIntent != null) {
            cancel();
        }
        if (!ChatClient.getInstance().isCountDownDisconnect()) {
            return;
        }
        Intent intent = new Intent(CountDownBroadCast.ACTION);
        intent.putExtra("msg", "countdown");
        pendingIntent = PendingIntent.getBroadcast(mContext, REQUEST_CODE, intent, PendingIntent.FLAG_UPDATE_CURRENT);

        if (mHandler.hasMessages(KEY_HANDLE_WHAT)){
            mHandler.removeMessages(KEY_HANDLE_WHAT);
        }
        // interval time: 1000 * 60 * 60 * 48 = 172800000
        // 3600000 * 48 = 172800000
        long triggerAtTime;

        long keepAliveTime = ChatClient.getInstance().getKeepAliveTime();
        if (keepAliveTime > 0) {
            triggerAtTime = SystemClock.elapsedRealtime() + Constants.DNS_DEFAULT_ONE_MINUTE * keepAliveTime;
        } else {
            Log.v(TAG, "keepAliveTime:" + keepAliveTime);
            return;
        }
        Log.v(TAG, "sendBroadcast - triggerAtTime:" + triggerAtTime + ", willTriggerTime:" + willTriggerTime);

        if (willTriggerTime > 0) {
            if (willTriggerTime < SystemClock.elapsedRealtime()) {
                mContext.sendBroadcast(intent);
                return;
            }
            if (willTriggerTime < triggerAtTime) {
                triggerAtTime = willTriggerTime;
            }
        }
        Message message = mHandler.obtainMessage();
        message.what = KEY_HANDLE_WHAT;
        message.obj = triggerAtTime;
        mHandler.sendMessageDelayed(message, 2000);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            alarmMgr.setExactAndAllowWhileIdle(AlarmManager.ELAPSED_REALTIME_WAKEUP, triggerAtTime, pendingIntent);
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            alarmMgr.setExact(AlarmManager.ELAPSED_REALTIME_WAKEUP, triggerAtTime, pendingIntent);
        } else {
            alarmMgr.set(AlarmManager.ELAPSED_REALTIME_WAKEUP, triggerAtTime, pendingIntent);
        }
    }

    public void cancel() {
        if (pendingIntent != null) {
            alarmMgr.cancel(pendingIntent);
        }
    }

}
