package com.hyphenate.chat;

import android.os.Build;
import android.text.TextUtils;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.helpdesk.Error;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpClientException;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.util.EMLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.net.URLEncoder;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by liyuzhao on 16/10/12.
 */
class KefuHttpClient {

    private static final String TAG = "httpclient";
//
//    /** inprogresss 0 , success 1, fail 2*/
//    public static final int MSG_STATE_INPROGRESS = 0;
//    /** inprogresss 0 , success 1, fail 2*/
//    public static final int MSG_STATE_SUCCESS = 1;
//    /** inprogresss 0 , success 1, fail 2*/
//    public static final int MSG_STATE_FAIL = 2;

    public static int DEFAULT_CONNECTION_TIMEOUT = 20 * 1000;
    public static int DEFAULT_READ_TIMEOUT = 20 * 1000;

    private static ExecutorService sendThreadPool = Executors
            .newFixedThreadPool(10);
    private static ExecutorService receiveThreadPool = Executors.newCachedThreadPool();

    public static void sendMessageByKefuRest(final Message message, final EMCallBack callBack){
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            if (callBack != null) {
                callBack.onError(Error.USER_NOT_LOGIN, "user no login");
            }
            return;
        }
        if (TextUtils.isEmpty(ChatClient.getInstance().tenantId())) {
            if (callBack != null) {
                callBack.onError(Error.MESSAGE_INVALID, "tenantId is not set");
            }
            return;
        }

        if (message.getType() == Message.Type.TXT) {
            sendTxtMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.IMAGE) {
            sendImageMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.VOICE){
            sendVoiceMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.FILE){
            sendFileMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.VIDEO){
            sendVideoMessageByKefuRest(message, callBack);
        } else if(message.getType() == Message.Type.CMD){
            sendCmdMessageByKefuRest(message, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(Error.GENERAL_ERROR, "no support message type");
            }
        }
    }



    public static void receiveMessages(final String toUserName, final EMValueCallBack<String> callback){
        receiveThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String remoteUrl = getReceiveMessageUrl(toUserName);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder httpRequestBuilder = httpClient.get(remoteUrl);
                    HttpResponse httpResponse = httpRequestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    if (status_code/100 == 2){
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        if (callback != null) {
                            callback.onSuccess(buffer.toString());
                        }
                    }else{
                        if (callback != null) {
                            callback.onError(status_code, "statusCode is :"
                                    + status_code);
                        }

                    }

                } catch (Exception e) {
                    EMLog.d(TAG, "e: " + e.getMessage());
                    if (callback != null) {
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });

    }

    private static void sendVideoMessageByKefuRest(final Message message, final EMCallBack callback){
        final EMVideoMessageBody videoMessageBody = (EMVideoMessageBody) message.body();
        EMLog.d(TAG, "sendVideoMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                String thumbnailUrl = videoMessageBody.getLocalThumb();
                final File thumbnail = new File(thumbnailUrl);
                if (!thumbnail.exists()){
                    if (callback != null){
                        callback.onError(Error.FILE_NOT_FOUND, "thumbnail file not found");
                    }
                    return;
                }

                String localPath = videoMessageBody.getLocalUrl();
                final File file = new File(localPath);
                if (!file.exists()){
                    if (callback != null){
                        callback.onError(Error.FILE_NOT_FOUND, "file not found");
                    }
                    return;
                }

                String appKey = ChatClient.getInstance().appKey();
                if (appKey == null){
                    EMLog.e(TAG, "appkey is not set");
                    if (callback != null){
                        callback.onError(Error.INVALID_APP_KEY, "appkey is not set");
                    }
                    return;
                }
                final String orgName = appKey.split("#")[0];
                final String appName = appKey.split("#")[1];
                final String currentUserName = ChatClient.getInstance().currentUserName();
                String uploadUrl = getUploadMediaFileUrl(orgName, appName, currentUserName);
                final String[] thumb = new String[1];

                try{
                    uploadAttachment(uploadUrl, thumbnailUrl, new HttpResponseHandler(){
                        @Override
                        public void onTimeout() throws Exception {
                            if (callback != null){
                                callback.onError(Error.SERVER_TIMEOUT, "server timeout.");
                            }
                        }

                        @Override
                        public void onResponse(HttpResponse response, long contentLength) throws Exception {
                            String result = response.getResponseBody();
                            JSONObject jsonObject = new JSONObject(result);
                            thumb[0] = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                        }
                    });
                } catch (Exception e){
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "result :" + e.getMessage());
                    }
                    return;
                }


                try{
                    uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){
                        @Override
                        public void onTimeout() throws Exception {
                            if (callback != null){
                                callback.onError(Error.SERVER_TIMEOUT, "server timeout.");
                            }
                        }

                        @Override
                        public void onResponse(HttpResponse response, long contentLength) throws Exception {
                            if (thumb[0] == null) {
                                if (callback != null){
                                    callback.onError(Error.FILE_UPLOAD_FAILED, "thumb upload failed.");
                                }
                                return;
                            }
                            String result = response.getResponseBody();
                            JSONObject jsonObject = new JSONObject(result);
                            String fileName = jsonObject.getString("fileName");
                            String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                            String messageUrl = getSendMessageUrl();
                            JSONObject bodyJson = new JSONObject();
                            JSONObject extJson = new JSONObject(message.attributes);
                            bodyJson.put("from", currentUserName);
                            bodyJson.put("to", message.to());
                            JSONArray jsonMsgBodyArr = new JSONArray();
                            JSONObject jsonMsgBody = new JSONObject();
                            jsonMsgBody.put("type", "video");
                            jsonMsgBody.put("url", remoteUrl);
                            jsonMsgBody.put("filename", fileName);
                            jsonMsgBody.put("file_length", file.length());
                            jsonMsgBody.put("thumb", thumb[0]);
                            jsonMsgBodyArr.put(jsonMsgBody);
                            bodyJson.put("bodies", jsonMsgBodyArr);
                            bodyJson.put("originType", "app");
                            bodyJson.put("orgName", orgName);
                            bodyJson.put("appName", appName);
                            bodyJson.put("ext", extJson);
                            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                            httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                            httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                            HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                            requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                            HttpResponse msgHttpResponse = requestBuilder1.execute();
                            assert msgHttpResponse != null;
                            String msgResult = msgHttpResponse.getResponseBody();
                            EMLog.d(TAG, "msg result:" + msgResult);
                            JSONObject jsonResult = new JSONObject(msgResult);
                            String statusParam = jsonResult.getString("status");

                            if (statusParam.equalsIgnoreCase("Ok")){
                                if (callback != null){
                                    videoMessageBody.setRemoteUrl(remoteUrl);
                                    callback.onSuccess();
                                    return;
                                }
                            }else if (statusParam.equalsIgnoreCase("FAIL")){
                                if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                    EMLog.d(TAG, "rest status_code: duplicated message");
                                    if (callback != null) {
                                        videoMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_001")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }else if (msgResult.contains("im_routeway_partner_003")){
                                    if (callback != null){
                                        callback.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_004")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_005")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }else{
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "result:" + msgResult);
                                    }
                                    return;
                                }
                            }
                            if (callback != null) {
                                callback.onError(Error.GENERAL_ERROR, "result :" + msgResult);
                            }
                        }
                    });

                }catch (Exception e){
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "result :" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendFileMessageByKefuRest(final Message message, final EMCallBack callback){
        final EMFileMessageBody fileMessageBody = (EMFileMessageBody) message.body();
        EMLog.d(TAG, "sendFileMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                String localPath = fileMessageBody.getLocalUrl();
                final File file = new File(localPath);
                if (!file.exists()){
                    if (callback != null){
                        callback.onError(Error.FILE_NOT_FOUND, "file not found");
                    }
                    return;
                }
                String appKey = ChatClient.getInstance().appKey();
                if (appKey == null){
                    EMLog.e(TAG, "appkey is not set");
                    if (callback != null){
                        callback.onError(Error.INVALID_APP_KEY, "appkey is not set");
                    }
                    return;
                }

                try{

                    final String orgName = appKey.split("#")[0];
                    final String appName = appKey.split("#")[1];

                    final String currentUserName = ChatClient.getInstance().currentUserName();
                    String uploadUrl = getUploadMediaFileUrl(orgName, appName, currentUserName);

                    uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){
                        @Override
                        public void onTimeout() throws Exception {
                            if (callback != null){
                                callback.onError(Error.SERVER_TIMEOUT, "server timeout.");
                            }
                        }

                        @Override
                        public void onResponse(HttpResponse response, long contentLength) throws Exception {
                            String result = response.getResponseBody();
                            JSONObject jsonObject = new JSONObject(result);
                            String fileName = jsonObject.getString("fileName");
                            String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                            String messageUrl = getSendMessageUrl();
                            JSONObject bodyJson = new JSONObject();
                            JSONObject extJson = new JSONObject(message.attributes);
                            bodyJson.put("from", currentUserName);
                            bodyJson.put("to", message.to());
                            JSONArray jsonMsgBodyArr = new JSONArray();
                            JSONObject jsonMsgBody = new JSONObject();
                            jsonMsgBody.put("type", "file");
                            jsonMsgBody.put("url", remoteUrl);
                            jsonMsgBody.put("filename", fileName);
                            jsonMsgBody.put("file_length", file.length());
                            jsonMsgBodyArr.put(jsonMsgBody);
                            bodyJson.put("bodies", jsonMsgBodyArr);
                            bodyJson.put("originType", "app");
                            bodyJson.put("orgName", orgName);
                            bodyJson.put("appName", appName);
                            bodyJson.put("ext", extJson);
                            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                            httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                            httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                            HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                            requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                            HttpResponse msgHttpResponse = requestBuilder1.execute();
                            assert msgHttpResponse != null;
                            String msgResult = msgHttpResponse.getResponseBody();
                            EMLog.d(TAG, "msg result:" + msgResult);
                            JSONObject jsonResult = new JSONObject(msgResult);
                            String statusParam = jsonResult.getString("status");

                            if (statusParam.equalsIgnoreCase("Ok")){
                                if (callback != null){
                                    fileMessageBody.setRemoteUrl(remoteUrl);
                                    callback.onSuccess();
                                    return;
                                }
                            }else if (statusParam.equalsIgnoreCase("FAIL")){
                                if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                    EMLog.d(TAG, "rest status_code: duplicated message");
                                    if (callback != null) {
                                        fileMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_001")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }else if (msgResult.contains("im_routeway_partner_003")){
                                    if (callback != null){
                                        callback.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_004")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_005")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }else{
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "result:" + msgResult);
                                    }
                                    return;
                                }
                            }
                            if (callback != null) {
                                callback.onError(Error.GENERAL_ERROR, "result :" + msgResult);
                            }
                        }
                    });




                }catch (Exception e){
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "result :" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVoiceMessageByKefuRest(final Message message, final EMCallBack callback){
        final EMVoiceMessageBody voiceMessageBody = (EMVoiceMessageBody) message.body();
        EMLog.d(TAG, "sendVoiceMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {

                String localPath = voiceMessageBody.getLocalUrl();
                File file = new File(localPath);
                if (!file.exists()){
                    if (callback != null){
                        callback.onError(Error.FILE_NOT_FOUND, "file not found");
                    }
                    return;
                }
                String appKey = ChatClient.getInstance().appKey();
                if (appKey == null){
                    EMLog.e(TAG, "appkey is not set");
                    if (callback != null){
                        callback.onError(Error.INVALID_APP_KEY, "appkey is not set");
                    }
                    return;
                }

                try{

                    final String orgName = appKey.split("#")[0];
                    final String appName = appKey.split("#")[1];

                    final String currentUserName = ChatClient.getInstance().currentUserName();
                    String uploadUrl = getUploadMediaFileUrl(orgName, appName, currentUserName);
                    uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){
                        @Override
                        public void onTimeout() throws Exception {
                            if (callback != null){
                                callback.onError(Error.SERVER_TIMEOUT, "server timeout.");
                            }
                        }

                        @Override
                        public void onResponse(HttpResponse response, long contentLength) throws Exception {
                            String result = response.getResponseBody();
                            JSONObject jsonObject = new JSONObject(result);
                            String fileName = jsonObject.getString("fileName");
                            String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                            String messageUrl = getSendMessageUrl();
                            JSONObject bodyJson = new JSONObject();
                            JSONObject extJson = new JSONObject(message.attributes);
                            bodyJson.put("from", currentUserName);
                            bodyJson.put("to", message.to());
                            JSONArray jsonMsgBodyArr = new JSONArray();
                            JSONObject jsonMsgBody = new JSONObject();
                            jsonMsgBody.put("type", "audio");
                            jsonMsgBody.put("url", remoteUrl);
                            jsonMsgBody.put("filename", fileName);
                            jsonMsgBody.put("length", voiceMessageBody.getLength());
                            jsonMsgBodyArr.put(jsonMsgBody);
                            bodyJson.put("bodies", jsonMsgBodyArr);
                            bodyJson.put("originType", "app");
                            bodyJson.put("orgName", orgName);
                            bodyJson.put("appName", appName);
                            bodyJson.put("ext", extJson);
                            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                            httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                            httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                            HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                            requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                            HttpResponse msgHttpResponse = requestBuilder1.execute();
                            assert msgHttpResponse != null;
                            String msgResult = msgHttpResponse.getResponseBody();
                            EMLog.d(TAG, "msg result:" + msgResult);
                            JSONObject jsonResult = new JSONObject(msgResult);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("Ok")){
                                if (callback != null){
                                    voiceMessageBody.setRemoteUrl(remoteUrl);
                                    callback.onSuccess();
                                    return;
                                }
                            }else if (statusParam.equalsIgnoreCase("FAIL")){
                                if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                    EMLog.d(TAG, "rest status_code: duplicated message");
                                    if (callback != null) {
                                        voiceMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_001")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }else if (msgResult.contains("im_routeway_partner_003")){
                                    if (callback != null){
                                        callback.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_004")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_005")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }else{
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "result:" + msgResult);
                                    }
                                    return;
                                }
                            }
                            if (callback != null) {
                                callback.onError(Error.GENERAL_ERROR, "result :" + msgResult);
                            }
                        }
                    });

                }catch (Exception e){
                    e.printStackTrace();
                    EMLog.e(TAG, "e:" + e.getMessage());
                    if (callback != null){
                        callback.onError(Error.GENERAL_ERROR, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void uploadAttachment(String remoteUrl, String localPath, HttpResponseHandler handler) throws HttpClientException {
        EMLog.d(TAG, "remoteUrl:" + remoteUrl);
        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
        requestBuilder.header("Authorization","Bearer " + ChatClient.getInstance().accessToken());
        requestBuilder.cookie("tenantId", ChatClient.getInstance().tenantId());
        requestBuilder.contentFromFile(localPath);
        requestBuilder.to(handler);
        requestBuilder.execute();
    }



    private static void sendImageMessageByKefuRest(final Message message, final EMCallBack callback){
        final EMImageMessageBody imageMessageBody = (EMImageMessageBody) message.body();
        EMLog.d(TAG, "sendImageMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                String localPath = imageMessageBody.getLocalUrl();
                File file = new File(localPath);
                if (!file.exists()){
                    if (callback != null){
                        callback.onError(Error.FILE_NOT_FOUND, "file not found");
                    }
                    return;
                }

                String appKey = ChatClient.getInstance().appKey();
                if (appKey == null){
                    EMLog.e(TAG, "appkey is not set");
                    if (callback != null){
                        callback.onError(Error.INVALID_APP_KEY, "appkey is not set");
                    }
                    return;
                }
                try {

                    final String orgName = appKey.split("#")[0];
                    final String appName = appKey.split("#")[1];

                    final String currentUserName = ChatClient.getInstance().currentUserName();
                    String uploadUrl = getUploadMediaFileUrl(orgName, appName, currentUserName);

                    uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){
                        @Override
                        public void onTimeout() throws Exception {
                            if (callback != null){
                                callback.onError(Error.SERVER_TIMEOUT, "server timeout.");
                            }
                        }

                        @Override
                        public void onResponse(HttpResponse response, long contentLength) throws Exception {
                            String result = response.getResponseBody();
                            JSONObject jsonObject = new JSONObject(result);
                            String fileName = jsonObject.getString("fileName");
                            String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                            String messageUrl = getSendMessageUrl();
                            JSONObject bodyJson = new JSONObject();
                            JSONObject extJson = new JSONObject(message.attributes);
                            bodyJson.put("from", currentUserName);
                            bodyJson.put("to", message.to());
                            JSONArray jsonMsgBodyArr = new JSONArray();
                            JSONObject jsonMsgBody = new JSONObject();
                            jsonMsgBody.put("type", "img");
                            jsonMsgBody.put("url", remoteUrl);
                            jsonMsgBody.put("filename", fileName);
                            jsonMsgBody.put("thumb", remoteUrl);
                            jsonMsgBodyArr.put(jsonMsgBody);
                            bodyJson.put("bodies", jsonMsgBodyArr);
                            bodyJson.put("originType", "app");
                            bodyJson.put("orgName", orgName);
                            bodyJson.put("appName", appName);
                            bodyJson.put("ext", extJson);
                            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                            httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                            httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                            HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                            requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                            HttpResponse msgHttpResponse = requestBuilder1.execute();
                            assert msgHttpResponse != null;
                            String msgResult = msgHttpResponse.getResponseBody();
                            EMLog.d(TAG, "msg result:" + msgResult);
                            JSONObject jsonResult = new JSONObject(msgResult);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("Ok")){
                                if (callback != null){
                                    imageMessageBody.setRemoteUrl(remoteUrl);
                                    imageMessageBody.setThumbnailUrl(remoteUrl);
                                    callback.onSuccess();
                                    return;
                                }
                            }else if (statusParam.equalsIgnoreCase("FAIL")){
                                if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                    EMLog.d(TAG, "rest status_code: duplicated message");
                                    if (callback != null) {
                                        imageMessageBody.setThumbnailUrl(remoteUrl);
                                        imageMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_001")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }else if (msgResult.contains("im_routeway_partner_003")){
                                    if (callback != null){
                                        callback.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_004")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                    }
                                    return;
                                }else if(result.contains("im_routeway_partner_005")){
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }else{
                                    if (callback != null) {
                                        callback.onError(Error.GENERAL_ERROR, "result:" + msgResult);
                                    }
                                    return;
                                }
                            }
                            if (callback != null) {
                                callback.onError(Error.GENERAL_ERROR, "result :" + msgResult);
                            }
                        }
                    });
                }catch (Exception e){
                    e.printStackTrace();
                    EMLog.e(TAG, "e:" + e.getMessage());
                    if (callback != null){
                        callback.onError(Error.GENERAL_ERROR, "error:" + e.getMessage());
                    }

                }
            }
        });


    }

    private static void sendCmdMessageByKefuRest(final Message message, final EMCallBack callBack) {
        final EMCmdMessageBody messageBody = (EMCmdMessageBody) message.body();
        EMLog.d(TAG, "sendCmdMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                String remoteUrl = getSendMessageUrl();
                try {
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(TAG, "send message appkey is null");
                        return;
                    }
                    String orgName = appKey.split("#")[0];
                    String appName = appKey.split("#")[1];
                    JSONObject bodyJson = new JSONObject();
                    JSONObject extJson = new JSONObject(message.attributes);
                    bodyJson.put("from", ChatClient.getInstance().currentUserName());
                    bodyJson.put("to", message.to());
                    JSONArray jsonMsgBodyArr = new JSONArray();
                    JSONObject jsonMsgBody = new JSONObject();
                    jsonMsgBody.put("type", "cmd");
                    jsonMsgBody.put("action", messageBody.action());
                    jsonMsgBodyArr.put(jsonMsgBody);
                    bodyJson.put("bodies", jsonMsgBodyArr);
                    bodyJson.put("originType", "app");
                    bodyJson.put("orgName", orgName);
                    bodyJson.put("appName", appName);
                    bodyJson.put("ext", extJson);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                    requestBuilder.header("Content-Type", "application/json");
                    requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null) {
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "cmd rest status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        JSONObject jsonResult = new JSONObject(result);
                        String statusParam = jsonResult.getString("status");
                        if (statusParam.equalsIgnoreCase("OK")) {
                            EMLog.d(TAG, "rest status_code :ok");
                            if (callBack != null) {
                                callBack.onSuccess();
                                return;
                            }
                        } else if (statusParam.equalsIgnoreCase("FAIL")) {
                            if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                EMLog.d(TAG,
                                        "rest status_code: duplicated message");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                }
                                return;
                            } else if (result.contains("im_routeway_partner_001")) {
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                }
                                return;
                            } else if (result.contains("im_routeway_partner_003")) {
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                }
                                return;
                            } else if (result.contains("im_routeway_partner_004")) {
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                }
                                return;
                            } else if (result.contains("im_routeway_partner_005")) {
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                }
                                return;
                            } else {
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "result:" + result);
                                }
                                return;
                            }
                        }
                        EMLog.d(TAG, "rest status_code: FAIL :" + status_code);
                        if (callBack != null) {
                            callBack.onError(Error.GENERAL_ERROR, "statusCode:" + status_code);
                        }

                    }


                } catch (Exception e) {
                    e.printStackTrace();
                    if (callBack != null) {
                        callBack.onError(Error.GENERAL_ERROR, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendTxtMessageByKefuRest(final Message message, final EMCallBack callBack){
        final EMTextMessageBody textMessageBody = (EMTextMessageBody) message.body();
        EMLog.d(TAG, "sendMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                String remoteUrl = getSendMessageUrl();
                try {
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null){
                        EMLog.e(TAG, "send message appkey is null");
                        return;
                    }
                    String orgName = appKey.split("#")[0];
                    String appName = appKey.split("#")[1];
                    JSONObject bodyJson = new JSONObject();
                    JSONObject extJson = new JSONObject(message.attributes);
                    bodyJson.put("from", ChatClient.getInstance().currentUserName());
                    bodyJson.put("to", message.to());
                    JSONArray jsonMsgBodyArr = new JSONArray();
                    JSONObject jsonMsgBody = new JSONObject();
                    jsonMsgBody.put("type", "txt");
                    jsonMsgBody.put("msg", textMessageBody.getMessage());
                    jsonMsgBodyArr.put(jsonMsgBody);
                    bodyJson.put("bodies", jsonMsgBodyArr);
                    bodyJson.put("originType", "app");
                    bodyJson.put("orgName", orgName);
                    bodyJson.put("appName", appName);
                    bodyJson.put("ext", extJson);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                    requestBuilder.header("Content-Type", "application/json");
                    requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code  = httpResponse.getStatusCode();
                    EMLog.d(TAG, "rest status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300){
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        JSONObject jsonResult = new JSONObject(result);
                        String statusParam = jsonResult.getString("status");
                        if(statusParam.equalsIgnoreCase("OK")){
                            EMLog.d(TAG, "rest status_code :ok");
                            if(callBack != null){
                                callBack.onSuccess();
                                return;
                            }
                        }else if (statusParam.equalsIgnoreCase("FAIL")){
                            if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                EMLog.d(TAG,
                                        "rest status_code: duplicated message");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                }
                                return;
                            }else if(result.contains("im_routeway_partner_001")){
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Can not find channel, please check appkey & im service num.");
                                }
                                return;
                            }else if(result.contains("im_routeway_partner_003")){
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Server Got an exception");
                                }
                                return;
                            }else if(result.contains("im_routeway_partner_004")){
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "Got bodies exception");
                                }
                                return;
                            }else if(result.contains("im_routeway_partner_005")){
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "msg_id_for_ack is blank.");
                                }
                                return;
                            }else{
                                if (callBack != null) {
                                    callBack.onError(Error.GENERAL_ERROR, "result:" + result);
                                }
                                return;
                            }
                        }
                        EMLog.d(TAG, "rest status_code: FAIL :" + status_code);
                        if (callBack != null) {
                            callBack.onError(Error.GENERAL_ERROR, "statusCode:" + status_code);
                        }

                    }

                } catch (Exception e) {
                    e.printStackTrace();
                    if (callBack != null) {
                        callBack.onError(Error.GENERAL_ERROR, "error:" + e.getMessage());
                    }

                }


            }
        });


    }


    private static String getSendMessageUrl(){
        String kefuHost = ChatClient.getInstance().kefuRestServer();

        return String.format("%1$s/v1/imgateway/messages?uniqueId=%2$s",
                kefuHost, getUniqueId());
    }

    private static String getUploadMediaFileUrl(String orgName, String appName, String currentUser){
        String kefuHost = ChatClient.getInstance().kefuRestServer();
        String tenantId = ChatClient.getInstance().tenantId();
        return String.format("%1$s/v1/Tenant/%2$s/%3$s/%4$s/%5$s/MediaFiles?uniqueId=%6$s", kefuHost, tenantId, orgName, appName, currentUser, getUniqueId());
    }



    private static String getReceiveMessageUrl(String toUserName){
        String kefuHost = ChatClient.getInstance().kefuRestServer();
        String appKey = ChatClient.getInstance().appKey();
        if (appKey == null){
            EMLog.e(TAG, "receive message url appkey is null");
            return null;
        }
        String orgName = appKey.split("#")[0];
        String appName = appKey.split("#")[1];
        String visitorId = ChatClient.getInstance().currentUserName();
        return String
                .format("%1$s/v1/imgateway/messages?orgName=%2$s&appName=%3$s&easemobId=%4$s&visitorEasemobId=%5$s&uniqueId=%6$s",
                        kefuHost, orgName, appName, toUserName, visitorId, getUniqueId());


    }

    public static void asyncSendDeviceInfo(final String tenantid, final String targetUser, final ValueCallBack<String> callback){
        if (TextUtils.isEmpty(tenantid)){
            if (callback != null){
                callback.onError(-1, "tenantid is empty");
            }
            return ;
        }
    // /v1/tenants/{tenantId}/servicesessions/attributes?visitorUserName={username}&appKey={appkey}&imServiceNumber={toUser}
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String username = ChatClient.getInstance().currentUserName();
                    String appKey = ChatClient.getInstance().appKey();
                    SIMCardInfo simCardInfo = new SIMCardInfo(ChatClient.getInstance().getContext());
                    String providerName = simCardInfo.getProvidersName();
                    JSONObject jsonBody = new JSONObject();
                    jsonBody.put("referer", "" + providerName);
                    jsonBody.put("equipment", "android");
                    jsonBody.put("system", "Android " + Build.VERSION.SDK_INT);
                    jsonBody.put("version", Build.MODEL);
                    jsonBody.put("carrierOperator", Build.MANUFACTURER);
                    String url = ChatClient.getInstance().kefuRestServer() + "/v1/tenants/"+ tenantid + "/servicesessions/attributes?visitorUserName=" + username + "&appKey=" + URLEncoder.encode(appKey, "utf-8") + "&imServiceNumber=" + targetUser + "&uniqueId=" + getUniqueId();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.post(url);
                    requestBuilder.header("Content-Type", "application/json");
                    requestBuilder.content(jsonBody.toString().getBytes(), "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "asyncSendDeviceInfo status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callback != null) {
                            callback.onSuccess(result);
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(-1, "asyncSendDeviceInfo from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callback != null){
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });

    }

    public static void asyncGetInviteEvaluation(String toUser, final ValueCallBack<String> callBack){
        final String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty(tenantId)){
            if (callBack != null){
                callBack.onError(-1, "tenantid is null");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly(tenantId)){
            if (callBack != null){
                callBack.onError(-1, "tenantid isn't digit, IllegalArgumentException");
            }
            return;
        }
        final String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty(currentUser)){
            if (callBack != null){
                callBack.onError(-1, "please login first");
            }
            return;
        }
        final String appkey = ChatClient.getInstance().appKey();
        if (!(appkey != null && appkey.contains("#"))){
            if (callBack != null){
                callBack.onError(-1, "appkey is IllegalArgumentException");
            }
            return;
        }
        final String orgName = appkey.split("#")[0];
        final String appName = appkey.split("#")[1];
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String url = String.format("%1$s/v1/webimplugin/tenants/%2$s/evaluationdegrees", ChatClient.getInstance().kefuRestServer(), tenantId);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    requestBuilder.param("orgName",orgName);
                    requestBuilder.param("appName", appName);
                    requestBuilder.param("userName", currentUser);
                    requestBuilder.param("token", ChatClient.getInstance().accessToken());

                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        if (callBack != null){
                            callBack.onError(-1, "response is null");
                        }
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "asyncGetInviteEvaluation status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    } else {
                        if (callBack != null) {
                            callBack.onError(-1, "asyncGetInviteEvaluation from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callBack != null){
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }
        });


    }

    public static void asyncGetCurrentVisitor(String toUser, final ValueCallBack<String> callBack){
        final String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty(tenantId)){
            if (callBack != null){
                callBack.onError(-1, "tenantid is null");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly(tenantId)){
            if (callBack != null){
                callBack.onError(-1, "tenantid isn't digit, IllegalArgumentException");
            }
            return;
        }
        final String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty(currentUser)){
            if (callBack != null){
                callBack.onError(-1, "please login first");
            }
            return;
        }

        final String appkey = ChatClient.getInstance().appKey();
        if (!(appkey != null && appkey.contains("#"))){
            if (callBack != null){
                callBack.onError(-1, "appkey is IllegalArgumentException");
            }
            return;
        }

        final String orgName = appkey.split("#")[0];
        final String appName = appkey.split("#")[1];
        final String techChannelInfo = (appkey + "#" + toUser).replace("#", "%23");
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String url = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors?uniqueId=%3$s", ChatClient.getInstance().kefuRestServer(), tenantId, getUniqueId());
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    requestBuilder.param("orgName",orgName);
                    requestBuilder.param("appName", appName);
                    requestBuilder.param("userName", currentUser);
                    requestBuilder.param("token", ChatClient.getInstance().accessToken());
                    requestBuilder.param("techChannelInfo", techChannelInfo);

                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        if (callBack != null){
                            callBack.onError(-1, "response is null");
                        }
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "dns status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    } else {
                        if (callBack != null) {
                            callBack.onError(-1, "load dns from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callBack != null){
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }
        });



    }

    private static String urlAppendSdkVersion(String url){
        if (TextUtils.isEmpty(url)){
            return url;
        }
        String tempUrl = url;
        if (!tempUrl.contains("?")){
            tempUrl += "?";
        }else{
            tempUrl += "&";
        }
        tempUrl += "sdkVersion=";
        tempUrl += ChatClient.getInstance().sdkVersion();
        tempUrl += "&appKey=";
        if (ChatClient.getInstance().appKey() != null){
            tempUrl += ChatClient.getInstance().appKey().replace("#", "%23");
        }
        tempUrl += "&uniqueId=";
        tempUrl += getUniqueId();
        return tempUrl;
    }

    private static String uniqueId;

    private static String getUniqueId() {
        if (!TextUtils.isEmpty(uniqueId)){
            return uniqueId;
        }
        try {
            String uuid = PreferenceUtil.getInstance().getUniqueId();
            if (TextUtils.isEmpty(uuid)) {
                uuid = UUID.randomUUID().toString();
                PreferenceUtil.getInstance().setUniqueId(uuid);
            }
            uniqueId = uuid;
            return uuid;
        } catch (Exception e) {
            return "";
        }
    }


    public static void asyncLoadServerDns(final String tenantid, final ValueCallBack<String> callback){
        if (TextUtils.isEmpty(tenantid)){
            if (callback != null){
                callback.onError(-1, "tenantid is empty");
            }
            return ;
        }
        if (!TextUtils.isDigitsOnly(tenantid)){
            if (callback != null){
                callback.onError(-1, "tenantid must be digits");
            }
            return;
        }

        // http://oev49clxj.bkt.clouddn.com/server.json
        sendThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String url = ChatClient.getInstance().kefuRestServer() + "/v1/visitors/tenants/"+ tenantid;
//                    url = "http://o8ugkv090.bkt.clouddn.com/dns.json";
                    url = urlAppendSdkVersion(url);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "dns status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callback != null) {
                            callback.onSuccess(result);
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(-1, "load dns from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callback != null){
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });

    }

    /**
     * 获取机器人欢迎语
     */
    public static void getRobotWelcome(final ValueCallBack<JSONObject> callback){
        receiveThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String host = ChatClient.getInstance().kefuRestServer();
                    String tenantid = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid cannot empty");
                        }
                        return;
                    }
                    if (!TextUtils.isDigitsOnly(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid must is digits");
                        }
                        return;
                    }

                    String url_welcome = "/v1/Tenants/%s/robots/visitor/greetings?tenantId=%s";
                    String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, tenantid, tenantid);
                    url = urlAppendSdkVersion(url);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "getRobotWelcome status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callback != null) {
                            if (TextUtils.isEmpty(result)){
                                callback.onSuccess(null);
                            }else{
                                JSONObject jsonObject = new JSONObject(result);
                                if (jsonObject.has("greetingText")){
                                    String menu = jsonObject.getString("greetingText").replace("&quot;", "\"");
                                    jsonObject = jsonObject.put("greetingText", menu);

                                }
                                callback.onSuccess(jsonObject);
                            }
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(-1, "getRobotWelcome from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callback != null){
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    /**
     * 获取企业欢迎语
     */
    public static void getEnterpriseWelcome(final ValueCallBack<String> callback){
        receiveThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String tenantid = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid cannot empty");
                        }
                        return;
                    }
                    if (!TextUtils.isDigitsOnly(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid must is digits");
                        }
                        return;
                    }
                    String currentUser = ChatClient.getInstance().currentUserName();
                    if (TextUtils.isEmpty(currentUser)){
                        if (callback != null){
                            callback.onError(-1, "please login first");
                        }
                        return;
                    }

                    String appkey = ChatClient.getInstance().appKey();
                    String token = ChatClient.getInstance().accessToken();
                    String url_welcome = "/v1/tenantapi/welcome?tenantId=%s&orgName=%s&appName=%s&userName=%s&token=%s";
                    String orgName = appkey.split("#")[0];
                    String appName = appkey.split("#")[1];

                    String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, tenantid, orgName, appName, currentUser, token);
                    url = urlAppendSdkVersion(url);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "getEnterpriseWelcome status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callback != null) {
                            callback.onSuccess(result);
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(-1, "getEnterpriseWelcome from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callback != null){
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });

    }

    /**
     * 主动取消视频请求
     * @param callBack
     * @param sessionId
     */
    public static void asyncCancelVideoConferences(final String sessionId, final ValueCallBack<String> callBack){
        receiveThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty(sessionId)) {
                        if (callBack != null){
                            callBack.onError(-1, "sessionId cannot be empty");
                        }
                        return;
                    }
                    String tenantid = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty(tenantid)){
                        if (callBack != null){
                            callBack.onError(-1, "tenantid cannot be empty");
                        }
                        return;
                    }
                    if (!TextUtils.isDigitsOnly(tenantid)) {
                        if (callBack != null) {
                            callBack.onError(-1, "tenantid must is digits");
                        }
                        return;
                    }
                    String url_session = "/v1/rtcmedia/serviceSession/%s/conferences";
                    String url = ChatClient.getInstance().kefuRestServer() + String.format(url_session,sessionId);
                    url = urlAppendSdkVersion(url);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.delete(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "getCurrentSessionStatus status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callBack != null){
                        callBack.onError(-1, e.getMessage() + "");
                    }
                }
            }
        });
    }

    /**
     * 获取当前会话状态
     */
    public static void getCurrentSessionStatus(final String toChatUsername, final ValueCallBack<String> callback){
        receiveThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty(toChatUsername)){
                        if (callback != null){
                            callback.onError(-1, "IMServiceNumber cannot be empty");
                        }
                        return;
                    }
                    String tenantid = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid cannot be empty");
                        }
                        return;
                    }
                    if (!TextUtils.isDigitsOnly(tenantid)){
                        if (callback != null){
                            callback.onError(-1, "tenantid must is digits");
                        }
                        return;
                    }
                    String currentUser = ChatClient.getInstance().currentUserName();
                    if (TextUtils.isEmpty(currentUser)){
                        if (callback != null){
                            callback.onError(-1, "please login first");
                        }
                        return;
                    }
                    String appkey = ChatClient.getInstance().appKey();
                    String techChannelInfo = appkey + "#" + toChatUsername;
                    techChannelInfo = techChannelInfo.replace("#", "%23");

                    String token = ChatClient.getInstance().accessToken();
                    String orgName = appkey.split("#")[0];
                    String appName = appkey.split("#")[1];
                    String url_session = "/tenantapi/visitors/%1$s/specificServiceSessionIds?states=Processing,Wait&techChannelInfo=%2$s&tenantId=%3$s&orgName=%4$s&appName=%5$s&userName=%6$s&token=%7$s";
                    String url = ChatClient.getInstance().kefuRestServer() + String.format(url_session,currentUser, techChannelInfo, tenantid, orgName, appName, currentUser, token);
                    url = urlAppendSdkVersion(url);
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(TAG, "getCurrentSessionStatus status_code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callback != null) {
                            callback.onSuccess(result);
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(-1, "getCurrentSessionStatus from server fail");
                        }
                    }

                } catch (Exception e) {
                    if (callback != null){
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });


    }

}
