package com.hyphenate.chat;

import android.text.TextUtils;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.helpdesk.model.MessageHelper;
import com.hyphenate.helpdesk.util.HtmlUtil;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by liyuzhao on 16/10/18.
 */
class KefuPolling {
    private static final String TAG = "kefu service";
    private static final int INTERVAL_SECOND = 10;

    private static ExecutorService singleThreadPool = Executors
            .newSingleThreadExecutor();
    private static volatile boolean isCancel = false;

    private static String getEMMessageExtMsgId(Message message){
        return ChatClient.getInstance().chatManager().getKefuExtMsgId(message);
    }


     static void startPolling(final String toUsername){
        if (TextUtils.isEmpty(toUsername)) {
            return;
        }
        EMLog.d(TAG, "startPolling");
        isCancel = false;
        singleThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                while (!isCancel){
                    try {
                        KefuHttpClient.receiveMessages(toUsername, new EMValueCallBack<String>() {
                            @Override
                            public void onSuccess(String value) {
                                EMLog.d("kefu receive", "message:"
                                        + value);
                                try {
                                    JSONObject jsonValue = new JSONObject(HtmlUtil.htmlspecialchars_decode_END_NOQUOTES(value));
                                    String status = jsonValue
                                            .optString("status", "");
                                    if (!status.equalsIgnoreCase("OK")) {
                                        return;
                                    }
                                    JSONArray jsonEntities = jsonValue
                                            .getJSONArray("entities");
                                    if (jsonEntities == null
                                            || jsonEntities.length() == 0) {
                                        return;
                                    }
                                    List<Message> msgList = new ArrayList<Message>();
                                    List<Message> cmdMsgList = new ArrayList<Message>();
                                    for (int k = 0; k < jsonEntities.length(); k++){
                                        JSONObject jsonEntityOne = jsonEntities.getJSONObject(k);
                                        JSONArray jsonMsgBodys = jsonEntityOne.getJSONArray("bodies");
                                        JSONObject jsonExt = jsonEntityOne.getJSONObject("ext");
                                        String fromParam = jsonEntityOne.getString("from");
                                        String toParam = jsonEntityOne.getString("to");
                                        JSONObject jsonMsgBody = jsonMsgBodys.getJSONObject(0);
                                        String type = jsonMsgBody.getString("type");
                                        long timestamp = jsonMsgBody.optLong("timestamp", System.currentTimeMillis());
                                        if (type.equalsIgnoreCase("txt")) {
                                            String txtMsg = jsonMsgBody.getString("msg");
                                            if (toParam.equals(ChatClient.getInstance().currentUserName())) {
                                                Message message = Message.createReceiveMessage(Message.Type.TXT);
                                                message.setBody(new EMTextMessageBody(txtMsg));
                                                message.attributes = json2Map(jsonExt);
                                                String extMsgId = getEMMessageExtMsgId(message);
                                                message.setMsgId(extMsgId);
                                                message.setKefuReceived(true);
                                                message.setStatus(Message.Status.SUCCESS);
                                                message.setFrom(fromParam);
                                                message.setMessageTime(timestamp);
                                                checkOfficialAccount(message);
                                                if (KefuConversationManager.getInstance().isRecalledMessage(extMsgId)){
                                                    continue;
                                                }
                                                if(extMsgId != null){
                                                    boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                                    EMLog.d(TAG, "msgId: " + extMsgId+ " isExist:" + isExist);
                                                    if(!isExist){
                                                        if(!MessageHelper.isNotificationMessage(message)){
                                                            message.setUnread(true);
                                                            KefuConversationManager.getInstance().saveMessage(message);
                                                        }
                                                        msgList.add(message);
                                                    }
                                                }
                                            }
                                        }else if (type.equalsIgnoreCase("img")){
                                            String url = ChatClient.getInstance().kefuRestServer() + jsonMsgBody.getString("url");
                                            String mediaId = System.currentTimeMillis() + ".png";
                                            if (jsonMsgBody.has("mediaId")) {
                                                mediaId = jsonMsgBody.getString("mediaId");
                                            }
                                            String fileName;
                                            if (jsonMsgBody.has("filename")) {
                                                fileName = jsonMsgBody.getString("filename");
                                            } else {
                                                fileName = mediaId;
                                            }
                                            int width = 0, height = 0;
                                            if (jsonMsgBody.has("size")){
                                                JSONObject jsonSize = jsonMsgBody.getJSONObject("size");
                                                if (jsonSize.has("width") && jsonSize.has("height")){
                                                    width = jsonSize.getInt("width");
                                                    height = jsonSize.getInt("height");
                                                }
                                            }

                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName;

                                            String localPath = new File(PathUtil.getInstance().getImagePath(),localPathName).getPath();
                                            String tempLocalPathName = "thumb_" + localPathName;

                                            String thumbLocalPath = new File(PathUtil.getInstance().getImagePath(),tempLocalPathName).getPath();

                                            EMLog.d(TAG, "img local:" + localPath + ", thumb local" + thumbLocalPath);

                                            if (toParam.equals(ChatClient.getInstance().currentUserName())){
                                                Message message = Message.createReceiveMessage(Message.Type.IMAGE);
                                                message.setFrom(fromParam);
                                                EMImageMessageBody imageMessageBody = new EMImageMessageBody(fileName, url, url);
                                                imageMessageBody.setSize(width, height);
                                                imageMessageBody.setLocalUrl(localPath);
                                                imageMessageBody.setThumbnailLocalPath(thumbLocalPath);
                                                message.setBody(imageMessageBody);
                                                message.attributes = json2Map(jsonExt);
                                                String extMsgId = getEMMessageExtMsgId(message);
                                                message.setMsgId(extMsgId);
                                                message.setKefuReceived(true);
                                                message.setStatus(Message.Status.SUCCESS);
                                                message.setMessageTime(timestamp);
                                                checkOfficialAccount(message);
                                                if (extMsgId != null){
                                                    boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                                    EMLog.d(TAG, "msgId: " + extMsgId+ " isExist:" + isExist);
                                                    if (!isExist){
                                                        if (!MessageHelper.isNotificationMessage(message)){
                                                            ChatClient.getInstance().chatManager().downloadAttachments(message, true);
                                                            message.setUnread(true);
                                                            KefuConversationManager.getInstance().saveMessage(message);
                                                        }
                                                        msgList.add(message);
                                                    }
                                                }
                                            }

                                        }else if (type.equalsIgnoreCase("audio")){
                                            String url = jsonMsgBody.getString("url");
                                            if (!url.startsWith("http")){
                                                url = ChatClient.getInstance().kefuRestServer() + url;
                                            }
                                            String fileName = "";
                                            if (jsonMsgBody.has("filename")){
                                                fileName = jsonMsgBody.getString("filename");
                                            }
                                            int length = 0;
                                            if (jsonMsgBody.has("length")){
                                                length = jsonMsgBody.getInt("length");
                                            }
                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName;
                                            String localPath = new File(PathUtil.getInstance().getVoicePath(),localPathName).getPath();
                                            if (toParam.equals(ChatClient.getInstance().currentUserName())){
                                                Message message = Message.createReceiveMessage(Message.Type.VOICE);
                                                message.setFrom(fromParam);
                                                EMVoiceMessageBody voiceMessageBody = new EMVoiceMessageBody(localPath, url, length);
                                                message.setBody(voiceMessageBody);
                                                message.attributes = json2Map(jsonExt);
                                                String extMsgId = getEMMessageExtMsgId(message);
                                                message.setMsgId(extMsgId);
                                                message.setKefuReceived(true);
                                                message.setStatus(Message.Status.SUCCESS);
                                                message.setMessageTime(timestamp);
                                                checkOfficialAccount(message);
                                                if (extMsgId != null){
                                                    boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                                    EMLog.d(TAG, "msgId: " + extMsgId+ " isExist:" + isExist);
                                                    if (!isExist){
                                                        if (!MessageHelper.isNotificationMessage(message)){
                                                            ChatClient.getInstance().chatManager().downloadAttachments(message, false);
                                                            message.setUnread(true);
                                                            KefuConversationManager.getInstance().saveMessage(message);
                                                        }
                                                        msgList.add(message);
                                                    }
                                                }
                                            }

                                        }else if (type.equalsIgnoreCase("file")){
                                            String url = jsonMsgBody.getString("url");
                                            if (!url.startsWith("http")){
                                                url = ChatClient.getInstance().kefuRestServer() + url;
                                            }
                                            String fileName = "";
                                            if (jsonMsgBody.has("filename")){
                                                fileName = jsonMsgBody.getString("filename");
                                            }
                                            long fileLength = 0;
                                            if (jsonMsgBody.has("file_length")){
                                                fileLength = jsonMsgBody.getLong("file_length");
                                            }
                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName;
                                            String localPath = new File(PathUtil.getInstance().getFilePath(), localPathName).getPath();

                                            if (toParam.equals(ChatClient.getInstance().currentUserName())){
                                                Message message = Message.createReceiveMessage(Message.Type.FILE);
                                                message.setFrom(fromParam);
                                                EMNormalFileMessageBody fileMessageBody = new EMNormalFileMessageBody(localPath, url);
                                                fileMessageBody.setFileLength(fileLength);
                                                fileMessageBody.setFileName(fileName);
                                                message.setBody(fileMessageBody);
                                                message.attributes = json2Map(jsonExt);
                                                String extMsgId = getEMMessageExtMsgId(message);
                                                message.setMsgId(extMsgId);
                                                message.setKefuReceived(true);
                                                message.setStatus(Message.Status.SUCCESS);
                                                message.setMessageTime(timestamp);
                                                checkOfficialAccount(message);
//                                                Message tempMessage =  ChatClient.getInstance().chatManager().checkIsExistMessage(message);
                                                if (extMsgId != null){
                                                    boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                                    EMLog.d(TAG, "msgId: " + extMsgId+ " isExist:" + isExist);
                                                    if (!isExist){
                                                        if (!MessageHelper.isNotificationMessage(message)){
                                                            message.setUnread(true);
                                                            KefuConversationManager.getInstance().saveMessage(message);
                                                        }
                                                        msgList.add(message);
                                                    }
                                                }



                                            }
                                        }else if (type.equalsIgnoreCase("cmd")){
                                            String action = jsonMsgBody.optString("action");
                                            Message message = Message.createReceiveMessage(Message.Type.CMD);
                                            message.setFrom(fromParam);
                                            message.setBody(new EMCmdMessageBody(action));
                                            message.attributes = json2Map(jsonExt);
                                            String extMsgId = getEMMessageExtMsgId(message);
                                            message.setMsgId(extMsgId);
                                            message.setKefuReceived(true);
                                            message.setStatus(Message.Status.SUCCESS);
                                            message.setMessageTime(timestamp);
                                            checkOfficialAccount(message);
                                            if (KefuDBManager.getInstance().isExistCmdMessage(message.messageId())){
                                                continue;
                                            }
                                            boolean isInserted = KefuDBManager.getInstance().insertCmdMessage(message);
                                            if (!isInserted){
                                                Log.e(TAG, "message insert failed:" + message.toString());
                                                continue;
                                            }
                                            //是否为消息撤回的命令消息
                                            if (ChatClient.getInstance().chatManager().isReCallCmdMessage(message)){
                                                ChatClient.getInstance().chatManager().notifyReCallMessage(message);
                                            }else{
                                                cmdMsgList.add(message);
                                            }
                                        }else{
                                            EMLog.e(TAG, "jsonMsgBody-else:" + jsonMsgBody.toString());
                                        }
                                    }
                                    if (msgList.size() > 0){
                                        Collections.reverse(msgList);
                                        asyncSendMarketingDelivered(msgList);
                                        ChatClient.getInstance().chatManager().publishNewMessage(msgList);
                                    }
                                    if (cmdMsgList.size() > 0){
                                        ChatClient.getInstance().chatManager().publishCmdMessage(cmdMsgList);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                    EMLog.e(TAG, "jsonError:" + android.util.Log.getStackTraceString(e));
                                    EMLog.e(TAG, "jsonError:" + value);
                                }
                            }

                            @Override
                            public void onError(int error, String errorMsg) {
                                EMLog.e(TAG, "" + errorMsg);
                            }
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(TAG, "" + e.getMessage());
                    }

                    try {
                        Thread.sleep(((long)INTERVAL_SECOND * 1000));
                        EMLog.v(TAG, "kefu ping...");
                    } catch (InterruptedException ignored) {
                        EMLog.e(TAG, "sleep InterruptedException");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    private static void asyncSendMarketingDelivered(List<Message> msgList){
        for(Message message : msgList){
            String taskId = message.getMarketingTaskId();
            MarketingHttpClient.asyncDelivered(taskId, message.from());
        }
    }

    private static void checkOfficialAccount(Message message){
        try{
            JSONObject weichatJson = message.getJSONObjectAttribute(Message.KEY_WEICHAT);
            if (weichatJson != null &&weichatJson.has(OfficialAccount.KEY_OFFICIAL_ACCOUNT)){
                JSONObject jsonOffAccount = weichatJson.getJSONObject(OfficialAccount.KEY_OFFICIAL_ACCOUNT);
                String offAccountId = jsonOffAccount.getString(OfficialAccount.KEY_ID);
                String type = jsonOffAccount.getString(OfficialAccount.KEY_TYPE);
                if (!TextUtils.isEmpty(offAccountId) && !type.equals("SYSTEM")){
                    message.setFrom(message.from() + OfficialAccount.SEPARATOR + offAccountId);
                }
            }
        }catch (Exception ignored){}
    }

    private static String getExtName(String s, char split){
        int i = s.lastIndexOf(split);
        if (i == -1){
            return "";
        }
        return s.substring(i + 1);
    }


     static void stopPolling(){
        EMLog.d(TAG, "stopPolling");
        isCancel = true;
    }

    private static Hashtable<String, Object> json2Map(JSONObject jsonObj) {
        try {
            Iterator<String> keyIter = jsonObj.keys();
            String key;
            Object value;
            Hashtable<String, Object> valueMap = new Hashtable<String, Object>();
            while (keyIter.hasNext()) {
                key = keyIter.next();
                value = jsonObj.get(key);
                valueMap.put(key, value);
            }
            return valueMap;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }


}
