package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;

import com.hyphenate.util.CryptoUtils;

/**
 * Created by liyuzhao on 01/12/2016.
 */

class PreferenceUtil {

    private static PreferenceUtil instance = new PreferenceUtil();

    private final String SHARED_FILE = "kefuinfo";
    private final String SHARED_KEY_UNAME = "username";
    private final String SHARED_KEY_UPASS = "password";
    private final String SHARED_KEY_ENCRYPTPASS = "encrypt_pass";
    private final String SHARED_KEY_TOKEN = "token";
    private final String SHARED_KEY_LOGIN_WITH_TOKEN = "login_with_token";

    private final String SHARED_KEY_SERVER_JSON = "server_json";
    private final String SHARED_KEY_UNIQUE_ID = "unique_id";
    private final String SHARED_KEY_TRIGGER_EVENT_TIME = "trigger_event_time";

    private Context mContext;

    private SharedPreferences sp;

    private SharedPreferences.Editor editor;

    private CryptoUtils cryptoUtils;

    private PreferenceUtil(){
        cryptoUtils = new CryptoUtils();
        cryptoUtils.initAES();
    }

    public static PreferenceUtil getInstance() {
        return instance;
    }

    public void init(Context context) {
        if (context != null){
            this.mContext = context.getApplicationContext();
        }
        sp = mContext.getSharedPreferences(SHARED_FILE, Context.MODE_PRIVATE);
        editor = sp.edit();
    }

    public void setUsername(String uname) {
        editor.putString(SHARED_KEY_UNAME, uname);
        editor.commit();
    }

     void setUsernameAndPassword(String username, String password){
        editor.putString(SHARED_KEY_UNAME, username);
        String tempPwd = password;
        try {
            tempPwd = cryptoUtils.encryptBase64String(tempPwd);
        } catch (Exception ignored) {
        }
//        editor.putString(SHARED_KEY_UPASS, tempPwd);
        editor.putString(SHARED_KEY_ENCRYPTPASS, tempPwd);
        editor.commit();
    }


     void setToken(String token){
        editor.putString(SHARED_KEY_TOKEN, token);
        editor.commit();
    }

    void saveLoginWithToken(boolean isToken){
        editor.putBoolean(SHARED_KEY_LOGIN_WITH_TOKEN, isToken);
        editor.commit();
    }

     String getPassword() {
        String tempPwd = sp.getString(SHARED_KEY_ENCRYPTPASS, null);
        if (tempPwd == null){
            tempPwd = sp.getString(SHARED_KEY_UPASS, null);
        }
        if (tempPwd == null){
            return null;
        }
        try {
            tempPwd = cryptoUtils.decryptBase64String(tempPwd);
        } catch (Exception ignored) {
        }
        return tempPwd;
    }


    public String getUsername() {
        return sp.getString(SHARED_KEY_UNAME, null);
    }

     String getToken(){
        return sp.getString(SHARED_KEY_TOKEN, null);
    }


     String getServerJson(){
        return sp.getString(SHARED_KEY_SERVER_JSON, null);
    }

    boolean loginWithToken(){
        return sp.getBoolean(SHARED_KEY_LOGIN_WITH_TOKEN, false);
    }

     void setServerJson(String serverJson){
        editor.putString(SHARED_KEY_SERVER_JSON, serverJson);
        editor.commit();
    }

    void setUniqueId(String uuid){
        editor.putString(SHARED_KEY_UNIQUE_ID, uuid);
        editor.commit();
    }

    String getUniqueId(){
        return sp.getString(SHARED_KEY_UNIQUE_ID, null);
    }

    void setTriggerEventTime(long triggerEventTime){
        editor.putLong(SHARED_KEY_TRIGGER_EVENT_TIME, triggerEventTime);
        editor.commit();
    }

    long getTriggerEventTime(){
        return sp.getLong(SHARED_KEY_TRIGGER_EVENT_TIME, -1);
    }

    void removeAll() {
        editor.remove(SHARED_KEY_TRIGGER_EVENT_TIME);
        editor.remove(SHARED_KEY_UNAME);
        editor.remove(SHARED_KEY_UPASS);
        editor.remove(SHARED_KEY_ENCRYPTPASS);
        editor.remove(SHARED_KEY_SERVER_JSON);
        editor.remove(SHARED_KEY_TOKEN);

        editor.commit();
    }


}
