package com.hyphenate.helpdesk.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * {@link InputStream} wrapper which prevents closing.
 */
class UncloseableInputStream extends InputStream {

    private static final InputStream NULL_STREAM = new ByteArrayInputStream(new byte[0]);
    private final InputStream delegate;

    public UncloseableInputStream() {
        this(NULL_STREAM);
    }

    public UncloseableInputStream(final InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int available() throws IOException {
        return delegate.available();
    }

    @Override
    public boolean equals(Object o) {
        return delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return delegate.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        return delegate.read();
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return delegate.read(buffer, byteOffset, byteCount);
    }


    @Override
    public int read(byte[] buffer) throws IOException {
        return delegate.read(buffer);
    }

    @Override
    public synchronized void reset() throws IOException {
        delegate.reset();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        return delegate.skip(byteCount);
    }

    @Override
    public String toString() {
        return delegate.toString();
    }

    @Override
    public void close() throws IOException {
        // Do not close the stream
    }

    public void forceClose(){
        IOUtils.close(delegate);
    }

}
