package com.hyphenate.helpdesk.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by liyuzhao on 03/01/2017.
 * {@link HttpResponseHandler} implementation for writing the response to an
 * {@link java.io.OutputStream} instance.
 */
class WriteToOutputStreamAndProgressHandler extends HttpResponseHandler {

    private final OutputStream out;
    private final ProgressListener listener;
    public WriteToOutputStreamAndProgressHandler(final OutputStream out, ProgressListener listener){
        if (out == null){
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        this.out = out;
        this.listener = listener;
    }

    @Override
    public void onResponse(HttpResponse response, long contentLength) throws Exception {
        InputStream in;
        try{
            in = response.getPayload();
            final byte[] buf = new byte[1024];
            int bytesRead;
            long totalReaded = 0;
            while ((bytesRead = in.read(buf)) != -1){
                if (contentLength > 0){
                    totalReaded += bytesRead;
                    long progress = totalReaded * 100 / contentLength;
                    listener.loadProgress(progress);
                }
                out.write(buf, 0, bytesRead);
            }

        }catch (IOException e){
            throw new HttpClientException("Cannot write Http response to output stream", e);
        }finally {
            IOUtils.close(out);
        }





    }
}
