package com.hyphenate.helpdesk.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * {@link HttpResponseHandler} implementation for writing the response to an
 * {@link java.io.OutputStream} instance.
 */
class WriteToOutputStreamHandler extends HttpResponseHandler {
    private final OutputStream out;

    public WriteToOutputStreamHandler(final OutputStream out) {
        if (out == null){
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        this.out = out;
    }

    @Override
    public void onResponse(HttpResponse response, long contentLength) throws Exception {
        InputStream in;
        try {
            in = response.getPayload();
            final byte[] buf = new byte[1024];
            for (int bytesRead; (bytesRead = in.read(buf)) != -1;){
                out.write(buf, 0, bytesRead);
            }
        } catch (IOException e) {
            throw new HttpClientException("Cannot write Http response to output stream", e);
        } finally {
            IOUtils.close(out);
        }

    }
}
