package com.hyphenate.helpdesk.manager;

import android.text.TextUtils;

import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMClient;
import com.hyphenate.helpdesk.Error;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 留言管理类
 */
public class TicketManager {

    private static TicketManager instance;
    private ExecutorService requestService = Executors.newCachedThreadPool();

    public synchronized static TicketManager getInstance() {
        if (instance == null) {
            instance = new TicketManager();
        }
        return instance;
    }

    /**
     * 获取一条留言
     * @param projectId 留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
     * @param targetUser 接入环信移动客服系统使用的关联的IM服务号
     * @param ticketId 留言的id TicketEntity的id字段
     * @param callback
     */
    public void getLeaveMsgDetail(final String projectId, final String targetUser, final String ticketId, final ValueCallBack<String> callback) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }


                String appkey = ChatClient.getInstance().appKey();
                String loginUser = ChatClient.getInstance().currentUserName();
                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/")
                            .append(projectId).append("/tickets/").append(ticketId).append("?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                    urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                    urlStrBuilder.append("easemob-username=").append(loginUser);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }



            }
        });

    }

    /**
     * 获取所有留言
     * @param projectId  留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
     * @param targetUser    接入环信移动客服系统使用的关联的IM服务号
     * @param page      第几页数据,从0开始
     * @param pageSize  每页显示的条数
     * @param callback
     */
    public void getLeaveMsgs(final String projectId, final String targetUser,final int page, final int pageSize, final ValueCallBack<String> callback){
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }


                String appkey = ChatClient.getInstance().appKey();
                String loginUser = ChatClient.getInstance().currentUserName();
                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/")
                            .append(projectId).append("/tickets?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                    urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                    urlStrBuilder.append("easemob-username=").append(loginUser).append("&");
                    urlStrBuilder.append("page=").append(page).append("&").append("size=").append(pageSize);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }



            }
        });


    }

    @Deprecated
    public void getTickets(final String projectId, final String targetUser,final int page, final int pageSize, final ValueCallBack<String> callback) {
        getLeaveMsgs(projectId, targetUser, page, pageSize, callback);
    }

    /**
	 * 创建一个新的留言
	 *
	 * @param postContent
	 * @param projectId 留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
	 * @param imUser  接入环信移动客服系统使用的关联的IM服务号
	 * @param callback
	 */
    public void createLeaveMsg(final String postContent, final String projectId, final String imUser, final ValueCallBack<String> callback) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }

                String appkey = ChatClient.getInstance().appKey();
                String loginUser = ChatClient.getInstance().currentUserName();
                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/")
                            .append(projectId).append("/tickets?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                    urlStrBuilder.append("easemob-target-username=").append(imUser).append("&");
                    urlStrBuilder.append("easemob-username=").append(loginUser);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    if (postContent != null) {
                        requestBuilder.content(postContent.getBytes(), "application/json");
                    }

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }

            }
        });
    }


    @Deprecated
    public void createLeaveMessage(final String postContent, final String projectId, final String imUser, final ValueCallBack<String> callback) {
        createLeaveMsg(postContent, projectId, imUser, callback);
    }

    /**
	 * 获取一个留言的所有评论 默认100条
	 *
	 * @param projectId 留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
	 * @param ticketId  留言ID
	 * @param targetUser  接入环信移动客服系统使用的关联的IM服务号
	 * @param callback
	 */
    @Deprecated
    public void getComments(final String projectId,final String ticketId,final String targetUser,final ValueCallBack<String> callback) {
        getComments(projectId, ticketId, targetUser, callback, 0, 100);
    }

    /**
     * 获取一个留言的所有评论
     *
     * @param projectId 留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
     * @param ticketId  留言ID
     * @param targetUser  接入环信移动客服系统使用的关联的IM服务号
     * @param callback
     * @param page  第多少页， 从0开始
     * @param size  每页显示多少数据
     */
    public void getLeaveMsgComments(final String projectId,final String ticketId,final String targetUser,final ValueCallBack<String> callback, final int page, final int size) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }

                String appkey = ChatClient.getInstance().appKey();
                String loginUser = ChatClient.getInstance().currentUserName();
                try {
                    //"tenants/{tenantId}/projects/{projectId}/tickets/{ticketId}/comments"
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/")
                            .append(projectId).append("/tickets/").append(ticketId).append("/comments").append("?");
                    urlStrBuilder.append("page=").append(page).append("&size=").append(size).append("&sort=createdAt,desc&");
                    urlStrBuilder.append("easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                    urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                    urlStrBuilder.append("easemob-username=").append(loginUser);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }
            }
        });
    }

    @Deprecated
    public void getComments(final String projectId,final String ticketId,final String targetUser,final ValueCallBack<String> callback, final int page, final int size) {
        getLeaveMsgComments(projectId, ticketId, targetUser, callback, page, size);
    }

    /**
	 * 给一个留言添加评论
	 *
	 * @param projectId         留言ProjectId  进入“管理员模式 → 留言”，可以看到这个Project ID
	 * @param ticketId          留言ID
	 * @param targetUser        接入环信移动客服系统使用的关联的IM服务号
	 * @param newCommentBodyJson
	 * @param callback
	 */
    public void createLeaveMsgComment(final  String projectId, final String ticketId, final String targetUser, final String newCommentBodyJson, final ValueCallBack<String> callback) {

        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }

                String appkey = ChatClient.getInstance().appKey();
                String loginUser = ChatClient.getInstance().currentUserName();
                try {
                    //"tenants/{tenantId}/projects/{projectId}/tickets/{ticketId}/comments
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/tenants/").append(tenantId).append("/projects/")
                            .append(projectId).append("/tickets/").append(ticketId).append("/comments");
                    urlStrBuilder.append("?easemob-appkey=").append(URLEncoder.encode(appkey, "UTF-8")).append("&");
                    urlStrBuilder.append("easemob-target-username=").append(targetUser).append("&");
                    urlStrBuilder.append("easemob-username=").append(loginUser);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    if (newCommentBodyJson != null) {
                        requestBuilder.content(newCommentBodyJson.getBytes(), "application/json");
                    }

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }

            }
        });

    }

    @Deprecated
    public void createComment(final  String projectId, final String ticketId, final String targetUser, final String newCommentBodyJson, final ValueCallBack<String> callback) {
        createLeaveMsgComment(projectId, ticketId, targetUser, newCommentBodyJson, callback);
    }

    /**
     * 是否显示留言信息(一般在上班显示联系客服界面,在下班情况下显示留言界面)
     * 返回true 为下班状态, 返回false为上班状态
     * @param customer_account imServiceNumber号码，demo的获取方法是  Preferences.getInstance().getCustomerAccount();
     * @param callback
     */
    public void getWorkStatus(final String customer_account, final ValueCallBack<String> callback) {
        getChannelsId(new ValueCallBack<String>() {
            @Override
            public void onSuccess(final String value) {
                String tempChannelId;
                String tempImServiceNumber;
                String tempOrgName;
                String tempAppName;

                final String appkey = ChatClient.getInstance().appKey();
                try {
                    JSONArray jsonArray = new JSONArray(value);
                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject obj = jsonArray.getJSONObject(i);
                        tempChannelId = obj.getString("channelId");
                        tempImServiceNumber = obj.getString("imServiceNumber");
                        tempOrgName = obj.getString("orgName");
                        tempAppName = obj.getString("appName");
                        if (tempImServiceNumber.equals(customer_account) && (tempOrgName + "#" + tempAppName).equals(appkey)) {
                            getWorkStatusByChannelId(tempChannelId, callback);
                            return;
                        }
                    }


                } catch (JSONException e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                    return;
                }
                if (callback != null) {
                    callback.onError(Error.GENERAL_ERROR, "customer_account is not correct");
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    @Deprecated
    public void getWorkStatus(final ValueCallBack<String> callback) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }

                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/v1/webimplugin/showMessage?tenantId=").append(tenantId);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }


            }
        });

    }

    void getChannelsId(final ValueCallBack<String> callback) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }
                //https://kefu.easemob.com/v1/webimplugin/targetChannels?tenantId=25115
                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/v1/webimplugin/targetChannels?tenantId=").append(tenantId);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        if (callback != null) {
                            callback.onSuccess(sb.toString());
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }


            }
        });
    }

    void getWorkStatusByChannelId(final String channelId, final ValueCallBack<String> callback) {
        requestService.submit(new Runnable() {
            @Override
            public void run() {
                if (!ChatClient.getInstance().isLoggedInBefore()) {
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "no login");
                    }
                    return;
                }
                String tenantId = ChatClient.getInstance().tenantId();
                if(TextUtils.isEmpty(tenantId)){
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, "tenantId is null");
                    }
                    return;
                }
                //https://kefu.easemob.com/v1/webimplugin/tenants/show-message?channelType=easemob&originType=app&channelId=33375&tenantId=25115
                try {
                    StringBuilder urlStrBuilder = new StringBuilder();
                    String host = ChatClient.getInstance().kefuRestServer();
                    urlStrBuilder.append(host).append("/v1/webimplugin/tenants/show-message?channelType=easemob&originType=app&")
                            .append("channelId=").append(channelId).append("&")
                            .append("tenantId=").append(tenantId);

                    String remoteUrl = urlStrBuilder.toString();
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                    requestBuilder.header("Content-Type", "application/json");

                    HttpResponse httpResponse = requestBuilder.execute();
                    assert httpResponse != null;
                    int statusCode = httpResponse.getStatusCode();
                    if (statusCode == HttpURLConnection.HTTP_OK) {
                        StringBuffer sb = new StringBuffer();
                        httpResponse.read(sb);
                        JSONObject obj = new JSONObject(sb.toString());
                        if (callback != null) {
                            callback.onSuccess(obj.getString("entity"));
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(Error.GENERAL_ERROR, "statusCode:" + statusCode);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.onError(Error.GENERAL_ERROR, e.getMessage());
                    }
                }


            }
        });

    }


}
