package com.hyphenate.helpdesk.model;

import android.text.TextUtils;

import com.hyphenate.chat.ChatClient;
import com.hyphenate.helpdesk.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 图文消息
 */

public class ArticlesInfo extends Content {
	private static final String TAG = "ArticlesInfo";

	static public final String PARENT_NAME = MessageHelper.TAG_MSGTYPE;
	static public final String ITEM_NAME = "articles";

	public ArticlesInfo() {
		super();
	}

	public ArticlesInfo(JSONObject jsonObj) {
		super(jsonObj);
	}

	@Override
	public String getName() {
		return null;
	}

	@Override
	public String getParentName() {
		return PARENT_NAME;
	}

	public List<ArticleItem> getArticles() {
		Collection<JSONObject> objArray = getObjectArray(ITEM_NAME);
		if (objArray == null){
			return null;
		}
		List<ArticleItem> items = new ArrayList<ArticleItem>();
		ArticleItem item;
		for (JSONObject obj : objArray) {
			item = createArticleItem(obj);
			if (item != null) {
				items.add(item);
			}
		}
		return items;
	}

	public ArticleItem createArticleItem(final JSONObject obj) {
		ArticleItem item = null;
		try {
			item = new ArticleItem(obj.getString("date"), obj.getString("description")
					, obj.getString("picurl"), obj.getString("title"), obj.getString("url"));
			item.setContent(obj);

		} catch (JSONException ex) {
			ex.printStackTrace();
			Log.e(TAG, ex.getMessage());
		}
		return item;
	}

	public static class ArticleItem {
		/**
		 * date : 2017-08-29 17:13:23
		 * description : test
		 * <p>
		 * picurl : http://sandbox.kefu.easemob.com/v1/Tenant/28359/MediaFiles/8d5028be-16ef-4af0-93ac-47c06397be1bMS0xNjEyMDQyMzQwMzUuanBn
		 * title : 知识1
		 * url : http://sandbox.kefu.easemob.com/v1/tenants/28359/knowledge/entries/html/62
		 */

		private String date;
		private String description;
		private String picurl;
		private String title;
		private String url;
		private JSONObject jsonObj;

		public ArticleItem(String date, String description, String picurl, String title, String url) {
			this.date = date;
			this.description = description;
			this.picurl = picurl;
			this.title = title;
			this.url = url;
		}

		public void setContent(JSONObject jsonObj) {
			this.jsonObj = jsonObj;
		}

		public String getDate() {
			return date;
		}

		public String getDescription() {
			return description;
		}

		public String getPicurl() {
			if (TextUtils.isEmpty(picurl)){
				return "";
			}
			if (picurl.startsWith("http")){
				return picurl;
			}
			return ChatClient.getInstance().getKefuServerAddress() + picurl;
		}

		public String getTitle() {
			return title;
		}

		public String getUrl() {
			if (TextUtils.isEmpty(url)){
				return "";
			}
			if (url.startsWith("http")){
				return url;
			}
			return ChatClient.getInstance().getKefuServerAddress() + url;
		}
	}
}
