package com.hyphenate.helpdesk.model;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class ContentFactory {
    public static VisitorInfo createVisitorInfo(JSONObject obj) {
        if (obj == null)
            return new VisitorInfo();
        else
            return new VisitorInfo(obj);
    }

    public static VisitorTrack createVisitorTrack(JSONObject obj) {
        if (obj == null)
            return new VisitorTrack();
        else
            return new VisitorTrack(obj);
    }

    public static RobotMenuInfo createRobotMenuInfo(JSONObject obj) {
        if (obj == null)
            return new RobotMenuInfo();
        else
            return new RobotMenuInfo(obj);
    }

    public static OrderInfo createOrderInfo(JSONObject obj) {
        if (obj == null)
            return new OrderInfo();
        else
            return new OrderInfo(obj);
    }

    public static AgentInfo createAgentInfo(JSONObject obj) {
        if (obj == null)
            return new AgentInfo();
        else
            return new AgentInfo(obj);
    }

    public static TransferIndication createTransferIndication(JSONObject obj) {
        if (obj == null)
            return new TransferIndication();
        else
            return new TransferIndication(obj);

    }

    static Event createEvent(JSONObject obj) {
        if (obj == null)
            return new Event();
        else
            return new Event(obj);

    }

    public static ControlMessage createControlMessage(JSONObject obj) {
        if (obj == null)
            return new ControlMessage();
        else
            return new ControlMessage(obj);

    }

    static ControlType createControlType(String value) {
        if (value == null)
            return new ControlType();
        else
            return new ControlType(value);

    }

    static ControlArguments createControlArguments(JSONObject obj) {
        if (obj == null)
            return new ControlArguments();
        else
            return new ControlArguments(obj);
    }

    public static QueueIdentityInfo createQueueIdentityInfo(String value) {
        if (value == null)
            return new QueueIdentityInfo();
        else
            return new QueueIdentityInfo(value);
    }

    public static AgentIdentityInfo createAgentIdentityInfo(String value) {
        if (value == null)
            return new AgentIdentityInfo();
        else
            return new AgentIdentityInfo(value);
    }

    static ToCustomServiceInfo createToCustomeServiceInfo(JSONObject obj) {
        if (obj == null)
            return new ToCustomServiceInfo();
        else
            return new ToCustomServiceInfo(obj);

    }

    public static RobotMenuIdInfo createRobotMenuIdInfo(JSONObject obj){
        if (obj == null){
            return new RobotMenuIdInfo();
        }else{
            return new RobotMenuIdInfo(obj);
        }

    }

    static EvaluationInfo createEvaluationInfo(JSONObject obj){
        if (obj == null){
            return new EvaluationInfo();
        }else{
            return new EvaluationInfo(obj);
        }
    }

    static ArticlesInfo createArticlesInfo(JSONObject obj) {
        if (obj == null) {
            return new ArticlesInfo();
        } else {
            return new ArticlesInfo(obj);
        }
    }

    static FormInfo createFormInfo(JSONObject content) {
        if (content == null) {
            return new FormInfo();
        } else {
            return new FormInfo(content);
        }
    }

    public static ControlMessage createEvaluationResponse(EvaluationInfo evaluationInfo, String detail, int summary, int degreeId, List<EvaluationInfo.TagInfo> appraiseTags){
        ControlMessage controlMessage = new ControlMessage();
        controlMessage.setControlType(ControlMessage.TYPE_EVAL_RESPONSE);
        controlMessage.setArgumentsValue("detail", detail);
        controlMessage.setSummary(summary);
        if (degreeId > 0){
            controlMessage.setArgumentsValue("evaluationDegreeId", degreeId);
        }
        if (evaluationInfo != null) {
            controlMessage.setArgumentsValue("inviteId", evaluationInfo.getInviteId());
            controlMessage.setArgumentsValue("serviceSessionId", evaluationInfo.getSessionId());
        }
        if (appraiseTags != null && !appraiseTags.isEmpty()){
            JSONArray jsonArray = new JSONArray();
            for (EvaluationInfo.TagInfo info : appraiseTags){
                JSONObject jsonItem = new JSONObject();
                try {
                    jsonItem.put("id", info.getId());
                    jsonItem.put("name", info.getName());
                    jsonArray.put(jsonItem);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            controlMessage.setArgumentsValue("appraiseTags", jsonArray);
        }
        return controlMessage;
    }


}