package com.hyphenate.helpdesk.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 满意度
 */

public class EvaluationInfo extends Content {

	private static final String TAG = EvaluationInfo.class.getSimpleName();

	static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
	static public final String NAME = "ctrlType";
	static public final String VALUE = "inviteEnquiry";
	static public final String ARGS = "ctrlArgs";

	public EvaluationInfo() {
		super();
	}

	public EvaluationInfo(String value) {
		super(value);
	}

	public EvaluationInfo(JSONObject argObj){
		if (argObj != null ){
			try {
				if (argObj.has("inviteId")){
					inviteId = argObj.getString("inviteId");
				}
				if (argObj.has("serviceSessionId")){
					sessionId = argObj.getString("serviceSessionId");
				}
				if (argObj.has("evaluationDegree") && !argObj.isNull("evaluationDegree")){
					JSONArray jsonArr = argObj.optJSONArray("evaluationDegree");
					if (jsonArr != null){
						degreeList = new ArrayList<>();
						for (int i = 0; i < jsonArr.length(); i++){
							JSONObject degreeJsonObj = jsonArr.getJSONObject(i);
							if (degreeJsonObj != null){
								Degree degree = new Degree();
								degree.id = degreeJsonObj.getInt("id");
								if (degreeJsonObj.has("name")){
									degree.name = degreeJsonObj.getString("name");
								}
								if (degreeJsonObj.has("score")){
									degree.score = degreeJsonObj.getInt("score");
								}
								if (degreeJsonObj.has("level")){
									degree.level = degreeJsonObj.getInt("level");
								}
								if (degreeJsonObj.has("status")){
									degree.status = degreeJsonObj.getString("status");
								}
								if (degreeJsonObj.has("appraiseTags") && !degreeJsonObj.isNull("appraiseTags")){
									JSONArray tagJsonArr = degreeJsonObj.getJSONArray("appraiseTags");
									degree.appraiseTag = new ArrayList<>();
									for (int j = 0; j < tagJsonArr.length(); j++){
										JSONObject tagJsonObj = tagJsonArr.getJSONObject(j);
										TagInfo tagInfo = new TagInfo();
										tagInfo.id = tagJsonObj.getInt("id");
										if (tagJsonObj.has("name")){
											tagInfo.name = tagJsonObj.getString("name");
										}
										if (tagJsonObj.has("tenantId")){
											tagInfo.tenantId = tagJsonObj.getString("tenantId");
										}
										if (tagJsonObj.has("tagSeqId")){
											tagInfo.tagSeqId = tagJsonObj.getString("tagSeqId");
										}
										if (tagJsonObj.has("evaluationDegreeId")){
											tagInfo.degreeId = tagJsonObj.getString("evaluationDegreeId");
										}
										degree.appraiseTag.add(tagInfo);
									}
								}
								degreeList.add(degree);
							}
						}
					}
				}


			} catch (JSONException e) {
				e.printStackTrace();
			}
		}

	}




	private String inviteId;
	private String sessionId;
	private List<Degree> degreeList;

	public String getInviteId() {
		return inviteId;
	}

	public List<Degree> getDegreeList() {
		return degreeList;
	}

	public String getSessionId() {
		return sessionId;
	}

	public Degree getDegree(int level){
		if (degreeList != null && !degreeList.isEmpty()){
			for (Degree d : degreeList){
				if (d.level == level){
					return d;
				}
			}
		}
		return null;
	}



	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public String getParentName() {
		return PARENT_NAME;
	}

	private String getCtrlType() {
		return get("ctrlType");
	}

	public boolean isEvaluationMessage(){
		if (content.has(NAME) && !content.isNull(NAME)) {
			String ctrlType = getCtrlType();
			return ctrlType != null && ctrlType.equals(VALUE);
		}
		return false;
	}

	public static class Degree{
		private int id;
		private String name;
		private int score;
		private int level;
		private String status;
		private List<TagInfo> appraiseTag;

		public int getId() {
			return id;
		}

		public List<TagInfo> getAppraiseTag() {
			return appraiseTag;
		}

		public int getLevel() {
			return level;
		}

		public String getName() {
			return name;
		}

		public int getScore() {
			return score;
		}

		public String getStatus() {
			return status;
		}

		public void setLevel(int level) {
			this.level = level;
		}
	}

	public static class TagInfo{
		private int id;
		private String name;
		private String tenantId;
		private String tagSeqId;
		private String degreeId;

		public String getDegreeId() {
			return degreeId;
		}

		public int getId() {
			return id;
		}

		public String getName() {
			return name;
		}

		public String getTagSeqId() {
			return tagSeqId;
		}

		public String getTenantId() {
			return tenantId;
		}
	}



}
