package com.hyphenate.helpdesk.util;

import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * 复制文件或文件夹
 * Created by liyuzhao on 17/10/2017.
 */

public class CopyDirectoryUtil {

	// 复制文件
	public static void copyFile(File sourceFile, File targetFile) throws Exception {

		//新建文件输入流并对它进行缓冲
		FileInputStream input = null;
		BufferedInputStream inBuff = null;

		//新建文件输出流并对它进行缓冲
		FileOutputStream output = null;
		BufferedOutputStream outBuff = null;
		try {
			input = new FileInputStream(sourceFile);
			inBuff = new BufferedInputStream(input);

			output = new FileOutputStream(targetFile);
			outBuff = new BufferedOutputStream(output);
			//缓冲数组
			byte[] buffer = new byte[1024 * 4];
			int len;
			while ((len = inBuff.read(buffer)) != -1) {
				outBuff.write(buffer, 0, len);
			}
			//刷新此缓冲的输出流
			outBuff.flush();
		} catch (Exception e) {
			throw e;
		} finally {
			//关闭流
			if (inBuff != null) {
				try {
					inBuff.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (outBuff != null) {
				try {
					outBuff.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (output != null) {
				try {
					output.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (input != null) {
				try {
					input.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	// 复制文件夹
	public static void copyDirectory(String sourceDir, String targetDir) throws Exception {
		try {
			// 新建目标目录
			File targetDirFile = new File(targetDir);
			if (targetDirFile.exists() && targetDirFile.isDirectory()) {
				// pass
			} else {
				targetDirFile.mkdirs();
			}
			// 获取源文件夹下的文件或目录
			File sourceDirFile = new File(sourceDir);
			if (!sourceDirFile.exists()) {
				Log.e("copy", "sourceDir:" + sourceDir + " is not found.");
				return;
			}
			File[] files = sourceDirFile.listFiles();
			for (int i = 0; i < files.length; i++) {
				// 源文件
				File sourceFile = files[i];
				if (sourceFile.isFile()) {
					// 目标文件
					File targetFile = new File(targetDirFile.getAbsolutePath() + File.separator + sourceFile.getName());
					copyFile(sourceFile, targetFile);
				}

				if (sourceFile.isDirectory()) {
					// 准备复制的源文件夹
					String dir1 = sourceDirFile.getAbsolutePath() + File.separator + sourceFile.getName();
					// 准备复制的目标文件夹
					String dir2 = targetDirFile.getAbsolutePath() + File.separator + sourceFile.getName();
					copyDirectory(dir1, dir2);
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}

}
