/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.hyphenate.chat.CallOption;
import com.hyphenate.chat.CallSurfaceView;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.MediaStream;
import com.hyphenate.chat.Message;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.util.EMLog;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.mediamanager.ScreenCaptureManager;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.sdk.VideoViewRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

public final class CallManager {
    static final String TAG = "callcore";
    private EMediaSession currentSession;
    private EMediaManager mediaManager;
    private EMediaSession.EMediaSessionDelegate sessionDelegate;
    private volatile int publishedCount;
    private String oldTicket;
    private JSONObject currentExtendJson;
    private static CallManager sInstance;
    private final Map<String, EMediaStream> currentStreams = Collections.synchronizedMap(new HashMap());
    private final Map<String, EMediaEntities.EMediaMember> mediaMemberMap = Collections.synchronizedMap(new HashMap());
    private final List<CallManagerDelegate> delegates = Collections.synchronizedList(new ArrayList());
    private final Map<String, ReceivedStream> unPublishedStreamMaps = Collections.synchronizedMap(new HashMap());
    private String callNickName;
    private JoinState currentJoinState = JoinState.UNJOIN;
    private ConcurrentLinkedQueue<TicketEntity> ticketQueue = new ConcurrentLinkedQueue();
    private CallSurfaceView localSurfaceView;
    private String currentMemberName;
    private String shareUid;
    private CallOption callOption = new CallOption();
    private static final String IncomingCallAction = ".action.incomingcall";
    final Object mutex = new Object();

    static synchronized CallManager getInstance() {
        if (sInstance == null) {
            sInstance = new CallManager();
        }
        return sInstance;
    }

    public void setCallOption(CallOption callOption) {
        if (callOption != null) {
            this.callOption = callOption;
        }
    }

    public String getIncomingCallBroadcastAction() {
        return ChatClient.getInstance().getContext().getPackageName() + IncomingCallAction;
    }

    private synchronized void addMember(EMediaEntities.EMediaMember eMediaMember) {
        if (!this.mediaMemberMap.containsKey(eMediaMember.memberName)) {
            this.mediaMemberMap.put(eMediaMember.memberName, eMediaMember);
        }
    }

    private synchronized void removeMember(EMediaEntities.EMediaMember eMediaMember) {
        if (this.mediaMemberMap.containsKey(eMediaMember.memberName)) {
            this.mediaMemberMap.remove(eMediaMember.memberName);
        }
    }

    void putTicket(TicketEntity ticket) {
        this.ticketQueue.add(ticket);
        this.notifyJoin();
    }

    private void notifyJoin() {
        this.info("notifyJoin: currentJoinState = " + this.currentJoinState.ordinal());
        if (this.currentJoinState == JoinState.UNJOIN) {
            this.info("ticketQueue: size = " + this.ticketQueue.size());
            if (!this.ticketQueue.isEmpty()) {
                TicketEntity ticket = this.ticketQueue.poll();
                this.dealWithTicket(ticket.ticket, ticket.nickname, ticket.extendJson);
            }
        }
    }

    public EMediaEntities.EMediaMember getEMediaMember(String memberName) {
        if (this.mediaMemberMap.containsKey(memberName)) {
            return this.mediaMemberMap.get(memberName);
        }
        return null;
    }

    @Deprecated
    public void acceptCall(boolean videoOff, boolean mute, Callback callback) {
        this.publish("", callback);
    }

    @Deprecated
    public void acceptCall(Callback callback) {
        this.publish("", callback);
    }

    public void acceptCall(String nickName, Callback callback) {
        this.publish(nickName, callback);
    }

    public void endCall() {
        this.setLocalView(null);
        this.exit(null);
    }

    public void pauseVoice() {
        this.mediaManager.setMuteEnabled(true);
        this.callOption.isMute = true;
    }

    public void resumeVoice() {
        this.mediaManager.setMuteEnabled(false);
        this.callOption.isMute = false;
    }

    public void pauseVideo() {
        this.mediaManager.setVideoEnabled(false);
        this.callOption.isVideoOff = true;
    }

    public void resumeVideo() {
        this.mediaManager.setVideoEnabled(true);
        this.callOption.isVideoOff = false;
    }

    @Deprecated
    public void setCameraFacing(int facing) throws HyphenateException {
    }

    public int getCameraFacing() {
        return this.mediaManager.getCameraFacing();
    }

    public boolean isSupportFlashLight() {
        return this.mediaManager.isSupportFlashLight();
    }

    public synchronized void switchCamera() {
        this.mediaManager.switchCamera();
    }

    public void setVideoMaxKbps(int videoMaxKbps) {
        this.mediaManager.setVideoMaxKbps(videoMaxKbps);
    }

    public void setVideoMinKbps(int videoMinKbps) {
        this.mediaManager.setVideoMinKbps(videoMinKbps);
    }

    public void setAudioMaxKbps(int audioMaxKbps) {
        this.mediaManager.setAudioMaxKbps(audioMaxKbps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dealWithTicket(String ticket, String callNick, JSONObject extendJson) {
        this.callNickName = callNick;
        this.currentJoinState = JoinState.JOINING;
        this.info("current join state is joining");
        this.startJoin(ticket, extendJson, new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess() {
                CallManager.this.currentJoinState = JoinState.JOINED;
                CallManager.this.info("current join state is joined");
                Object object = CallManager.this.mutex;
                synchronized (object) {
                    CallManager.this.mutex.notifyAll();
                }
                try {
                    Intent intent = new Intent(CallManager.this.getIncomingCallBroadcastAction());
                    intent.putExtra("type", "video");
                    intent.putExtra("from", ((CallManager)CallManager.this).currentSession.myName);
                    intent.putExtra("channel", "kefu");
                    ChatClient.getInstance().getContext().sendBroadcast(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int code, String error) {
                CallManager.this.currentJoinState = JoinState.UNJOIN;
                CallManager.this.info("current join state is unjoin");
                Object object = CallManager.this.mutex;
                synchronized (object) {
                    CallManager.this.mutex.notifyAll();
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.mutex.wait(3000L);
            }
            catch (InterruptedException ignored) {
                EMLog.e((String)TAG, (String)"dealWithTicker mutex wait InterruptedException");
                Thread.currentThread().interrupt();
            }
        }
        if (this.currentJoinState == JoinState.JOINING) {
            this.currentJoinState = JoinState.UNJOIN;
        }
    }

    void setSpecificServerUrl(String mediaUrl, String mediaHost) {
        if (this.mediaManager != null) {
            this.mediaManager.setSpecificServerUrl(mediaUrl, mediaHost);
        }
    }

    private CallManager() {
        EMediaManager.initGlobal((Context)ChatClient.getInstance().getContext());
        this.mediaManager = EMediaManager.getInstance();
        EMediaManager.setLoggerDelegate((XClientBridger.Logcallbackfunc)new XClientBridger.Logcallbackfunc(){

            public void onLog(int i, String s) {
                EMLog.d((String)CallManager.TAG, (String)("i->" + i + ", s ->" + s));
            }
        });
        this.sessionDelegate = new EMediaSession.EMediaSessionDelegate(){

            public void joinMember(EMediaSession session, EMediaEntities.EMediaMember eMediaMember) {
                CallManager.this.log("CallDelegate: onMemberJoin: instanceId=" + session.instanceId + ", memberName=" + eMediaMember.memberName);
                CallManager.this.info("C-> joined member [" + eMediaMember.memberName + ",ext=" + eMediaMember.extension + "]");
                if (eMediaMember.memberName.equalsIgnoreCase(CallManager.this.currentMemberName)) {
                    return;
                }
                CallManager.this.addMember(eMediaMember);
            }

            public void exitMember(EMediaSession session, EMediaEntities.EMediaMember eMediaMember) {
                CallManager.this.log("CallDelegate: onMemberExit: instanceId=" + session.instanceId + ", memberName=" + eMediaMember.memberName);
                CallManager.this.info("C-> exited member [" + eMediaMember.memberName + ",ext=" + eMediaMember.extension + "]");
                CallManager.this.removeMember(eMediaMember);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addStream(EMediaSession session, EMediaStream stream) {
                CallManager.this.LOGI("CallDelegate: onAddStream: instanceId=" + session.instanceId + ", [" + stream.memberName + "]-[" + stream.streamId + "]-[" + stream.streamName + "], t=" + stream.streamType + ", v=" + !stream.videoOff + ", a=" + !stream.audioOff + ",ext=" + stream.extension);
                if (stream.memberName.equals(CallManager.this.currentMemberName)) {
                    return;
                }
                if (CallManager.this.currentStreams.containsKey(stream.streamId)) {
                    return;
                }
                CallManager.this.currentStreams.put(stream.streamId, stream);
                if (CallManager.this.publishedCount > 0) {
                    CallManager.this.notifyDelegateAddStream(session, stream);
                } else {
                    Map map = CallManager.this.unPublishedStreamMaps;
                    synchronized (map) {
                        ReceivedStream receivedStream = new ReceivedStream();
                        receivedStream.session = session;
                        receivedStream.stream = stream;
                        CallManager.this.unPublishedStreamMaps.put(stream.streamId, receivedStream);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeStream(EMediaSession session, EMediaStream stream) {
                CallManager.this.LOGI("CallDelegate: removeStreamWithId: instanceId=" + session.instanceId + ", memberName=" + stream.memberName + ", streamId=" + stream.streamId + ",ext=" + stream.extension);
                if (CallManager.this.currentStreams.containsKey(stream.streamId)) {
                    CallManager.this.currentStreams.remove(stream.streamId);
                }
                if (CallManager.this.publishedCount > 0) {
                    CallManager.this.notifyDelegateRemoveStream(session, stream);
                } else {
                    Map map = CallManager.this.unPublishedStreamMaps;
                    synchronized (map) {
                        if (CallManager.this.unPublishedStreamMaps.containsKey(stream.streamId)) {
                            CallManager.this.unPublishedStreamMaps.remove(stream.streamId);
                        }
                    }
                }
                if (CallManager.this.currentStreams.isEmpty() && CallManager.this.currentJoinState == JoinState.JOINED) {
                    CallManager.this.notifyDelegatepassiveCloseReason(session, 1, "no other stream");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStream(EMediaSession session, EMediaStream stream) {
                CallManager.this.log("C-> upd [" + session.myName + "]-[" + stream.streamId + "]-[" + stream.streamName + "], t=" + stream.streamType + ", v=" + !stream.videoOff + ", a=" + !stream.audioOff + ",ext=" + stream.extension);
                if (CallManager.this.publishedCount > 0) {
                    CallManager.this.notifyDelegateUpdateStream(session, stream);
                } else {
                    Map map = CallManager.this.unPublishedStreamMaps;
                    synchronized (map) {
                        if (CallManager.this.unPublishedStreamMaps.containsKey(stream.streamId)) {
                            ReceivedStream receivedStream = new ReceivedStream();
                            receivedStream.session = session;
                            receivedStream.stream = stream;
                            CallManager.this.unPublishedStreamMaps.put(stream.streamId, receivedStream);
                        }
                    }
                }
            }

            public void passiveCloseReason(EMediaSession session, int reason, String desc) {
                CallManager.this.LOGI("CallDelegate: onCallEnd: instanceId=" + session.instanceId + ", reason:" + reason + ",desc:" + desc);
                if (session.instanceId != null && session.instanceId.equals(((CallManager)CallManager.this).currentSession.instanceId)) {
                    CallManager.this.currentJoinState = JoinState.UNJOIN;
                }
                CallManager.this.notifyDelegatepassiveCloseReason(session, reason, desc);
            }

            public void notice(EMediaSession session, EMediaDefines.EMediaNoticeCode code, String arg1, String arg2, Object arg3) {
                CallManager.this.info("C-> notice [" + code + "]-[" + arg1 + "]-[" + arg2 + "]-[" + arg3 + "]");
                if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_PUBLISH_SETUP) {
                    CallManager.this.info("EMEDIA_NOTICE_PUBLISH_SETUP");
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_SUBSCRIPTION_SETUP) {
                    CallManager.this.info("EMEDIA_NOTICE_SUBSCRIPTION_SETUP");
                } else if (code == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_TAKE_CAMERA_PICTURE) {
                    CallManager.this.info("EMEDIA_NOTICE_TAKE_CAMERA_PICTURE url=" + arg3.toString());
                    String toUserName = ChatClient.getInstance().chatManager().currentChatUsername();
                    if (!TextUtils.isEmpty((CharSequence)toUserName)) {
                        Message message = Message.createImageSendMessage(arg3.toString(), true, toUserName);
                        JSONObject weichatJson = ChatClient.getInstance().chatManager().getLatestSendWeichat();
                        if (weichatJson != null) {
                            message.setAttribute("weichat", weichatJson);
                        }
                        ChatClient.getInstance().chatManager().sendMessageWithoutRecord(message);
                    } else {
                        EMLog.e((String)CallManager.TAG, (String)"lastest chat user is null");
                    }
                }
                HMediaNoticeCode hNoticeCode = HMediaNoticeCode.HMediaNoticeNone;
                switch (code) {
                    case EMEDIA_NOTICE_NONE: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeNone;
                        break;
                    }
                    case EMEDIA_NOTICE_STATS: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeStats;
                        break;
                    }
                    case EMEDIA_NOTICE_RECONN: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeReconn;
                        break;
                    }
                    case EMEDIA_NOTICE_DISCONN: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeDisconn;
                        break;
                    }
                    case EMEDIA_NOTICE_CUSTOM_MSG: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeCustomMsg;
                        break;
                    }
                    case EMEDIA_NOTICE_POOR_QUALITY: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticePoorQuality;
                        break;
                    }
                    case EMEDIA_NOTICE_OPEN_MIC_FAIL: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeOpenMicFail;
                        break;
                    }
                    case EMEDIA_NOTICE_PUBLISH_SETUP: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticePublishSetup;
                        break;
                    }
                    case EMEDIA_NOTICE_OPEN_CAMERA_FAIL: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeOpenCameraFail;
                        break;
                    }
                    case EMEDIA_NOTICE_SUBSCRIPTION_SETUP: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeSubscriptionSetup;
                        break;
                    }
                    case EMEDIA_NOTICE_TAKE_CAMERA_PICTURE: {
                        hNoticeCode = HMediaNoticeCode.HMediaNoticeTakeCameraPicture;
                    }
                }
                CallManager.this.notifyDelegateNotice(session, hNoticeCode, arg1, arg2, arg3);
            }

            public void changeRole(EMediaSession eMediaSession) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startJoin(String ticket, JSONObject extendJson, final Callback callback) {
        this.info("startJoin:ticket->" + ticket);
        this.oldTicket = ticket = ticket.replace("&quot;", "\"");
        this.currentExtendJson = extendJson;
        try {
            JSONObject jsonExt = new JSONObject();
            jsonExt.put("identity", (Object)"visitor");
            if (extendJson != null) {
                jsonExt.put("extend", (Object)extendJson);
            }
            this.currentSession = this.mediaManager.newSessionWithTicket(ticket, jsonExt.toString(), this.sessionDelegate);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.currentSession == null) {
            this.currentJoinState = JoinState.UNJOIN;
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
            return;
        }
        this.currentJoinState = JoinState.JOINING;
        this.unPublishedStreamMaps.clear();
        this.mediaManager.join(this.currentSession, null, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (CallManager.this.currentSession == null) {
                    return;
                }
                if (error != null) {
                    CallManager.this.currentJoinState = JoinState.UNJOIN;
                    CallManager.this.log("C-> join error " + error.code + "-[" + error.errorDescription + "]");
                    CallManager.this.info("C-> join error " + error.code + "-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(-1, error.errorDescription);
                    }
                    CallManager.this.notifyJoin();
                } else {
                    CallManager.this.currentJoinState = JoinState.JOINED;
                    CallManager.this.info("me joined Success");
                    CallManager.this.log("C-> joined me");
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }
        });
    }

    public void addDelegate(CallManagerDelegate listener) {
        if (!this.delegates.contains(listener)) {
            this.delegates.add(listener);
        }
    }

    public void removeDelegate(CallManagerDelegate listener) {
        if (this.delegates.contains(listener)) {
            this.delegates.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegateAddStream(EMediaSession session, EMediaStream stream) {
        List<CallManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (CallManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onAddStream(this.convertEMediaStreamToMediaStream(stream));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegateRemoveStream(EMediaSession session, EMediaStream stream) {
        List<CallManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (CallManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onRemoveStream(this.convertEMediaStreamToMediaStream(stream));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegateUpdateStream(EMediaSession session, EMediaStream stream) {
        List<CallManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (CallManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onUpdateStream(this.convertEMediaStreamToMediaStream(stream));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegatepassiveCloseReason(EMediaSession session, int reason, String desc) {
        List<CallManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (CallManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onCallEnd(reason, desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDelegateNotice(EMediaSession session, HMediaNoticeCode code, String arg1, String arg2, Object arg3) {
        List<CallManagerDelegate> list = this.delegates;
        synchronized (list) {
            for (CallManagerDelegate item : this.delegates) {
                if (item == null) continue;
                item.onNotice(code, arg1, arg2, arg3);
            }
        }
    }

    EMediaPublishConfiguration getSharePubConfig(String nickName, View view) {
        EMediaPublishConfiguration pubconfig = new EMediaPublishConfiguration();
        pubconfig.setVideoOff(this.callOption.isVideoOff);
        pubconfig.setMute(this.callOption.isMute);
        pubconfig.setUseBackCamera(this.callOption.useBackCamera);
        pubconfig.setPubType(EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP);
        if (view != null) {
            pubconfig.setPubView(view);
        }
        if (this.callOption.videoHeight > 0) {
            pubconfig.setVheight(this.callOption.videoHeight);
        }
        if (this.callOption.videoWidth > 0) {
            pubconfig.setVwidth(this.callOption.videoWidth);
        }
        JSONObject jsonExt = new JSONObject();
        try {
            jsonExt.put("identity", (Object)"visitor");
            if (TextUtils.isEmpty((CharSequence)nickName)) {
                jsonExt.put("nickname", (Object)ChatClient.getInstance().currentUserName());
            } else {
                jsonExt.put("nickname", (Object)nickName);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        pubconfig.setExtension(jsonExt.toString());
        return pubconfig;
    }

    EMediaPublishConfiguration getPubConfig(String nickName) {
        EMediaPublishConfiguration pubconfig = new EMediaPublishConfiguration();
        pubconfig.setVideoOff(this.callOption.isVideoOff);
        pubconfig.setMute(this.callOption.isMute);
        pubconfig.setUseBackCamera(this.callOption.useBackCamera);
        pubconfig.setPubType(EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL);
        if (this.callOption.videoHeight > 0) {
            pubconfig.setVheight(this.callOption.videoHeight);
        }
        if (this.callOption.videoWidth > 0) {
            pubconfig.setVwidth(this.callOption.videoWidth);
        }
        JSONObject jsonExt = new JSONObject();
        try {
            jsonExt.put("identity", (Object)"visitor");
            if (this.currentExtendJson != null) {
                jsonExt.put("extend", (Object)this.currentExtendJson);
            }
            if (TextUtils.isEmpty((CharSequence)nickName)) {
                jsonExt.put("nickname", (Object)ChatClient.getInstance().currentUserName());
            } else {
                jsonExt.put("nickname", (Object)nickName);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        pubconfig.setExtension(jsonExt.toString());
        return pubconfig;
    }

    void publish(String nickName, final Callback callback) {
        EMediaPublishConfiguration pubconfig = this.getPubConfig(nickName);
        this.mediaManager.publish(this.currentSession, pubconfig, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (error == null) {
                    CallManager.this.info("C-> pub ok");
                    CallManager.this.currentJoinState = JoinState.JOINED;
                    CallManager.this.ticketQueue.clear();
                    CallManager.this.publishedCount++;
                    if (callback != null) {
                        callback.onSuccess();
                    }
                    CallManager.this.notifyUnPublishedStreams();
                } else {
                    CallManager.this.info("C-> pub error [" + error.code + "]-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(error.code.errorcode, error.errorDescription);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnPublishedStreams() {
        Log.e((String)TAG, (String)"notifyUnPublishedStreams input:");
        Map<String, ReceivedStream> map = this.unPublishedStreamMaps;
        synchronized (map) {
            for (ReceivedStream receivedStream : this.unPublishedStreamMaps.values()) {
                this.notifyDelegateAddStream(receivedStream.session, receivedStream.stream);
                Log.e((String)TAG, (String)("nootifyAddStream:" + receivedStream.stream.streamId));
            }
            this.unPublishedStreamMaps.clear();
        }
    }

    void unPublish(String pubId, final Callback callback) {
        this.info("C-> start unpub");
        this.mediaManager.unpublish(this.currentSession, pubId, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (error != null) {
                    CallManager.this.info("C-> unpub error [" + error.code + "]-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(error.code.errorcode, error.errorDescription);
                    }
                } else {
                    CallManager.this.publishedCount--;
                    CallManager.this.info("C-> unpub ok");
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }
        });
    }

    public void unSubscribe(final String streamId, final Callback callback) {
        if (this.currentSession == null) {
            throw new IllegalStateException("currentSession is null, please join first");
        }
        this.mediaManager.unsubscribe(this.currentSession, streamId, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (error != null) {
                    CallManager.this.log("C-> unsub error [" + error.code + "]-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(error.code.errorcode, error.errorDescription);
                    }
                } else {
                    CallManager.this.log("C-> unsub [" + streamId + "]");
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }
        });
    }

    public void unSubscribe(MediaStream stream, Callback callback) {
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        this.unSubscribe(stream.streamId, callback);
    }

    public void subscribe(final MediaStream stream, CallSurfaceView videoView, final Callback callback) {
        if (this.currentSession == null) {
            throw new IllegalStateException("currentSession is null, please join first");
        }
        this.mediaManager.subscribe(this.currentSession, stream.streamId, videoView == null ? null : videoView.getRenderer(), new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (error != null) {
                    CallManager.this.log("C-> fail to subsr [" + stream.memberName + "]-[" + stream.streamId + "]-[" + stream.streamName + "], err=[" + error.code + "]-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(error.code.errorcode, error.errorDescription);
                    }
                    return;
                }
                CallManager.this.info("C-> subsr [" + stream.memberName + "]-[" + stream.streamId + "]-[" + stream.streamName + "]");
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        });
    }

    public void updateSubscribe(final String streamId, CallSurfaceView videoView, final Callback callback) {
        if (this.currentSession == null) {
            throw new IllegalStateException("currentSession is null, please join first");
        }
        this.mediaManager.updateSubscribe(this.currentSession, streamId, videoView == null ? null : videoView.getRenderer(), new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object uid, EMediaEntities.EMediaError error) {
                if (error != null) {
                    CallManager.this.log("C-> fail to updatesub [" + streamId + "], err=[" + error.code + "]-[" + error.errorDescription + "]");
                    if (callback != null) {
                        callback.onError(error.code.errorcode, error.errorDescription);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        });
    }

    public void sendCustomWithRemoteStreamId(String streamId, String message, final Callback callback) {
        if (this.currentSession == null) {
            if (callback != null) {
                callback.onError(-1, "session is null");
            }
            return;
        }
        this.mediaManager.sendCtrlMsgByStreamId(this.currentSession, streamId, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode, null, message, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object o, EMediaEntities.EMediaError eMediaError) {
                if (callback != null) {
                    if (eMediaError != null) {
                        callback.onError(eMediaError.code.errorcode, eMediaError.errorDescription);
                    } else {
                        callback.onSuccess();
                    }
                }
            }
        });
    }

    public void sendCustomWithRemoteMemberId(String memberId, String message, final Callback callback) {
        if (this.currentSession == null) {
            if (callback != null) {
                callback.onError(-1, "session is null");
            }
            return;
        }
        this.mediaManager.sendCtrlMsgByMemberId(this.currentSession, memberId, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode, null, message, new EMediaEntities.EMediaIdBlockType(){

            public void onDone(Object o, EMediaEntities.EMediaError eMediaError) {
                if (callback != null) {
                    if (eMediaError != null) {
                        callback.onError(eMediaError.code.errorcode, eMediaError.errorDescription);
                    } else {
                        callback.onSuccess();
                    }
                }
            }
        });
    }

    public void publishWindow(final Activity activity, final Callback callback) {
        if (this.currentSession == null) {
            if (callback != null) {
                callback.onError(-1, "session is null");
            }
            return;
        }
        final WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (weakActivity.get() == null) {
            this.LOGI("activity is finished");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mediaManager.publish(this.currentSession, this.getSharePubConfig(null, null), new EMediaEntities.EMediaIdBlockType(){

                public void onDone(Object uid, EMediaEntities.EMediaError error) {
                    if (error != null) {
                        CallManager.this.LOGI("Publish failed code=" + error.code + ", desc=" + error.errorDescription);
                        if (callback != null) {
                            callback.onError(error.code.errorcode, error.errorDescription);
                        }
                    } else {
                        CallManager.this.shareUid = String.valueOf(uid);
                        CallManager.this.publishedCount++;
                        CallManager.this.LOGI("Publish success Stream id - " + uid);
                        if (weakActivity.get() == null) {
                            CallManager.this.LOGI("activity is finished");
                            if (callback != null) {
                                callback.onError(-1, "activity is finished");
                            }
                            return;
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                        if (ScreenCaptureManager.getInstance().state == ScreenCaptureManager.State.IDLE) {
                            ScreenCaptureManager.getInstance().init(activity);
                            ScreenCaptureManager.getInstance().setScreenCaptureCallback(new ScreenCaptureManager.ScreenCaptureCallback(){

                                public void onBitmap(Bitmap bitmap) {
                                    CallManager.this.mediaManager.inputExternalVideoData(bitmap);
                                }
                            });
                        }
                    }
                }
            });
        } else {
            this.mediaManager.publish(this.currentSession, this.getSharePubConfig(null, ((Activity)weakActivity.get()).getWindow().getDecorView()), new EMediaEntities.EMediaIdBlockType(){

                public void onDone(Object uid, EMediaEntities.EMediaError error) {
                    if (error != null) {
                        CallManager.this.LOGI("Publish failed code = " + error.code + ", desc=" + error.errorDescription);
                        if (callback != null) {
                            callback.onError(error.code.errorcode, error.errorDescription);
                        }
                    } else {
                        CallManager.this.LOGI("Publish success Stream id - " + uid);
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1 && requestCode == 1000 && Build.VERSION.SDK_INT >= 21) {
            ScreenCaptureManager.getInstance().start(resultCode, data);
        }
    }

    public void unPublishWindow(Callback callback) {
        if (this.shareUid == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ScreenCaptureManager.getInstance().stop();
        }
        this.unPublish(this.shareUid, callback);
    }

    public String getCallNickName() {
        return this.callNickName;
    }

    private void exit(final Callback callback) {
        this.callNickName = null;
        this.callOption.isVideoOff = false;
        this.callOption.isMute = false;
        this.currentJoinState = JoinState.UNJOIN;
        this.info("current join state is unjoin");
        if (this.currentSession != null) {
            this.publishedCount = 0;
            this.unPublishedStreamMaps.clear();
            this.currentStreams.clear();
            this.shareUid = null;
            if (ScreenCaptureManager.getInstance().state != ScreenCaptureManager.State.IDLE) {
                ScreenCaptureManager.getInstance().stop();
            }
            this.log("C-> exiting...");
            this.mediaManager.exit(this.currentSession, new EMediaEntities.EMediaIdBlockType(){

                public void onDone(Object uid, EMediaEntities.EMediaError error) {
                    if (error != null) {
                        CallManager.this.log("C-> exit error " + error.code + "-[" + error.errorDescription + "]");
                        if (callback != null) {
                            callback.onError(error.code.errorcode, error.errorDescription);
                        }
                    } else {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                        CallManager.this.log("C-> exited me");
                    }
                }
            });
        } else {
            this.log("currentSession is null");
        }
    }

    public void setLocalView(CallSurfaceView localSurface) {
        if (localSurface != null) {
            this.mediaManager.setVideoViews(null, localSurface.getRenderer(), null, true);
        } else {
            this.mediaManager.setVideoViews(null, null, null, true);
        }
    }

    public void setRemoteView(String streamId, CallSurfaceView callSurfaceView) {
        if (streamId == null) {
            return;
        }
        if (callSurfaceView != null) {
            this.setOtherVideoView(streamId, callSurfaceView.getRenderer());
        } else {
            this.setOtherVideoView(streamId, null);
            this.unSubscribe(streamId, null);
        }
    }

    private void setOtherVideoView(String streamId, VideoViewRenderer otherVideoViewRenderer) {
        this.mediaManager.setVideoViews(streamId, null, otherVideoViewRenderer, false);
    }

    private void LOGI(String text) {
        EMLog.d((String)TAG, (String)("" + text));
    }

    private void info(String msg) {
        this.log(msg);
    }

    private void log(String msg) {
        this.LOGI(msg);
    }

    private MediaStream convertEMediaStreamToMediaStream(EMediaStream stream) {
        if (stream == null) {
            return null;
        }
        return new MediaStream(stream.streamId, stream.memberName, stream.streamType, stream.streamName, stream.videoOff, stream.audioOff, stream.extension, stream.csrc);
    }

    public void manualFocus(float x, float y, int width, int height) {
        if (this.mediaManager != null) {
            this.mediaManager.manualFocus(x, y, width, height);
        }
    }

    public void manualZoom(boolean isZoomIn, int zoomScale) {
        if (this.mediaManager != null) {
            this.mediaManager.manualZoom(isZoomIn, zoomScale);
        }
    }

    private class ReceivedStream {
        EMediaSession session;
        EMediaStream stream;

        private ReceivedStream() {
        }
    }

    public static interface CallManagerDelegate {
        public void onAddStream(MediaStream var1);

        public void onRemoveStream(MediaStream var1);

        public void onUpdateStream(MediaStream var1);

        public void onCallEnd(int var1, String var2);

        public void onNotice(HMediaNoticeCode var1, String var2, String var3, Object var4);
    }

    static class TicketEntity {
        String ticket;
        String nickname;
        JSONObject extendJson;

        TicketEntity(String ticket, String nick, JSONObject extend) {
            this.ticket = ticket;
            this.nickname = nick;
            this.extendJson = extend;
        }
    }

    public static enum HMediaNoticeCode {
        HMediaNoticeNone(0),
        HMediaNoticeStats(100),
        HMediaNoticeDisconn(120),
        HMediaNoticeReconn(121),
        HMediaNoticePoorQuality(122),
        HMediaNoticePublishSetup(123),
        HMediaNoticeSubscriptionSetup(124),
        HMediaNoticeTakeCameraPicture(125),
        HMediaNoticeCustomMsg(126),
        HMediaNoticeOpenCameraFail(201),
        HMediaNoticeOpenMicFail(202);

        public final int noticeCode;

        private HMediaNoticeCode(int noticeCode) {
            this.noticeCode = noticeCode;
        }
    }

    private static enum JoinState {
        UNJOIN,
        JOINING,
        JOINED;

    }
}

