/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.text.TextUtils;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.chat.CallManager;
import com.hyphenate.chat.ChatConfig;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.CountDownUtils;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.manager.EmojiconManager;
import com.hyphenate.helpdesk.manager.TicketManager;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ChatClient {
    public static final String TAG = "ChatClient";
    private static ChatClient instance = new ChatClient();
    private EMClient _client = null;
    private ChatManager chatManager = null;
    private CallManager callManager = null;
    private TicketManager leaveMsgManager = null;
    private EmojiconManager emojiconManager = null;
    private final List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private String userName = null;
    private boolean isInitialized = false;
    private String tenantId = null;
    public static boolean multiChannel = false;
    private static final String DEFAULT_KEFU_HOST = "https://kefu.easemob.com";
    private String kefuHost;
    boolean hasSecondChannel = true;
    private Context mContext;
    private boolean isDebugMode;
    private static final String sdkVersion = "1.1.9";
    boolean isShowAgentInputState;
    boolean isShowVisitorWaitCount;
    boolean isShowMessagePredict;

    private ChatClient() {
    }

    boolean isCountDownDisconnect() {
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        return dnsConfig != null && dnsConfig.keepAliveTime > 0L;
    }

    long getKeepAliveTime() {
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        if (dnsConfig != null) {
            return dnsConfig.keepAliveTime;
        }
        return -1L;
    }

    public static ChatClient getInstance() {
        return instance;
    }

    Context getContext() {
        if (this.mContext != null) {
            return this.mContext;
        }
        this.mContext = this._client.getContext();
        return this.mContext;
    }

    @Deprecated
    public String getKefuServerAddress() {
        return this.kefuRestServer();
    }

    public String kefuRestServer() {
        if (TextUtils.isEmpty((CharSequence)this.kefuHost)) {
            this.kefuHost = DEFAULT_KEFU_HOST;
        }
        return this.kefuHost;
    }

    public synchronized boolean init(Context context, Options options) {
        String lastLoginUser;
        if (this.isInitialized) {
            android.util.Log.e((String)TAG, (String)"sdk already initialized");
            return false;
        }
        if (context == null) {
            android.util.Log.e((String)TAG, (String)"init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e((String)TAG, (String)"init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)options.appkey)) {
            android.util.Log.e((String)TAG, (String)"init fail, appkey is null");
            return false;
        }
        String processAppName = this.getAppName(context.getApplicationContext());
        this.kefuHost = options.kefuHost;
        android.util.Log.d((String)TAG, (String)("process app name : " + processAppName));
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        this._client = EMClient.getInstance();
        EMOptions emoptions = new EMOptions();
        emoptions.setAppKey(options.appkey);
        emoptions.setUseHttps(false);
        if (!TextUtils.isEmpty((CharSequence)options.mipushAppid) && !TextUtils.isEmpty((CharSequence)options.mipushAppKey)) {
            emoptions.setMipushConfig(options.mipushAppid, options.mipushAppKey);
            Log.d(TAG, "mipush appid:" + options.mipushAppid + ",appkey:" + options.mipushAppKey);
        }
        if (!TextUtils.isEmpty((CharSequence)options.fcmNumber)) {
            emoptions.setFCMNumber(options.fcmNumber);
            Log.d(TAG, "fcm number:" + options.fcmNumber);
        }
        if (!TextUtils.isEmpty((CharSequence)options.restHost)) {
            emoptions.setRestServer(options.restHost);
        }
        if (!TextUtils.isEmpty((CharSequence)options.imHost)) {
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0) {
            emoptions.setImPort(options.imPort);
        }
        this.tenantId = options.tenantId;
        this.isShowAgentInputState = options.showAgentInputState;
        this.isShowVisitorWaitCount = options.showVisitorWaitCount;
        this.isShowMessagePredict = options.showMessagePredict;
        this.isDebugMode = options.consoleLogEnable;
        if (options.isUseFcm) {
            emoptions.setUseFCM(options.isUseFcm);
        }
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        this._client.init(context, emoptions);
        EMLog.d((String)TAG, (String)("im init time(ms):" + (System.currentTimeMillis() - currentTime)));
        this.chatManager = ChatManager.getInstance();
        try {
            if (Class.forName("com.hyphenate.chat.CallManager") != null) {
                this.callManager = CallManager.getInstance();
            }
            if (this.callManager != null && !TextUtils.isEmpty((CharSequence)options.mediaSpecilServer) && !TextUtils.isEmpty((CharSequence)options.mediaHost)) {
                this.callManager.setSpecificServerUrl(options.mediaSpecilServer, options.mediaHost);
            }
        }
        catch (ClassNotFoundException e) {
            EMLog.d((String)TAG, (String)("" + android.util.Log.getStackTraceString((Throwable)e)));
        }
        catch (Exception e) {
            // empty catch block
        }
        ChatConfig.getInstance().loadLocalDnsConfig();
        if (this.isLoggedInBefore() && !TextUtils.isEmpty((CharSequence)(lastLoginUser = this.currentUserName()))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String token = PreferenceUtil.getInstance().getToken();
                        String imToken = ChatClient.this.imAccessToken();
                        if (token == null) {
                            if (imToken != null) {
                                PreferenceUtil.getInstance().setToken(imToken);
                            } else {
                                String password = PreferenceUtil.getInstance().getPassword();
                                if (!TextUtils.isEmpty((CharSequence)password)) {
                                    EMLog.d((String)ChatClient.TAG, (String)"load lastLoginUser");
                                    ChatClient.this.login(lastLoginUser, password, null);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e((String)ChatClient.TAG, (String)android.util.Log.getStackTraceString((Throwable)e));
                    }
                }
            }).start();
            PathUtil.getInstance().initDirs(options.appkey, lastLoginUser, context);
            ChatManager.getInstance().initDB(lastLoginUser);
            ChatManager.getInstance().loadDB();
            this.chatManager().registerCountDown();
            long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
            if (triggerEventTime > 0L) {
                CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
            } else {
                CountDownUtils.getInstance().sendBroadcast();
            }
            this.getEmojiconManager();
        }
        ChatConfig.getInstance().loadDnsConfigFromRemote(false);
        EMChatManager _emChatManager = this._client.chatManager();
        this._client.addConnectionListener(new EMConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnected() {
                List list = ChatClient.this.connectionListeners;
                synchronized (list) {
                    for (ConnectionListener listener : ChatClient.this.connectionListeners) {
                        if (listener == null) continue;
                        listener.onConnected();
                    }
                    MarketingHttpClient.asyncRequest();
                }
            }

            public void onDisconnected(int errorCode) {
                int code = 1;
                switch (errorCode) {
                    case 207: {
                        code = 207;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 200: {
                        code = 200;
                        break;
                    }
                    case 206: {
                        code = 206;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 202: {
                        code = 202;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                    case 204: {
                        code = 204;
                        ChatClient.this.chatManager().kefuLogout();
                        break;
                    }
                }
                ChatClient.this.notifyOnDisconnected(code);
            }
        });
        this.leaveMsgManager = TicketManager.getInstance();
        this.isInitialized = true;
        EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnDisconnected(int errorCode) {
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (ConnectionListener listener : this.connectionListeners) {
                if (listener == null) continue;
                listener.onDisconnected(errorCode);
            }
        }
    }

    private void getEmojiconManager() {
        if (this.emojiconManager == null) {
            this.emojiconManager = EmojiconManager.getInstance();
        }
        this.emojiconManager.reflesh();
    }

    public boolean addEmojiconInfo(String tenantId, String iconsJson, String packagesJson) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().addEmojiconInfo(tenantId, iconsJson, packagesJson);
    }

    public boolean deleteEmojiconInfo(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().deleteEmojiconInfo(tenantId);
    }

    public String getEmojiconInfoIconsJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoIconsJson(tenantId);
    }

    public String getEmojiconInfoPackagesJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoPackagesJson(tenantId);
    }

    private String getAppName(Context appContext) {
        try {
            int pid = Process.myPid();
            String processName = null;
            ActivityManager am = (ActivityManager)appContext.getSystemService("activity");
            assert (am != null);
            List l = am.getRunningAppProcesses();
            if (l == null) {
                Log.e(TAG, "getRunningAppProcesses is null");
                return null;
            }
            Iterator i = l.iterator();
            PackageManager pm = appContext.getPackageManager();
            while (i.hasNext()) {
                ActivityManager.RunningAppProcessInfo info = (ActivityManager.RunningAppProcessInfo)i.next();
                try {
                    if (info.pid != pid) continue;
                    CharSequence c = pm.getApplicationLabel(pm.getApplicationInfo(info.processName, 128));
                    processName = info.processName;
                    return processName;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void login(String userName, String password, final Callback callback) {
        this.chatManager().login(userName, password, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.this.getEmojiconManager();
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    public void loginWithToken(String userName, String token, final Callback callback) {
        this.chatManager().loginWithToken(userName, token, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.this.getEmojiconManager();
                callback.onSuccess();
            }

            @Override
            public void onError(int code, String error) {
                callback.onError(code, error);
            }

            @Override
            public void onProgress(int progress, String status) {
                callback.onProgress(progress, status);
            }
        });
    }

    public void logout(boolean unbindToken, Callback callback) {
        this.chatManager().logout(unbindToken, callback);
    }

    void cleanCache() {
        CountDownUtils.getInstance().cancel();
        this.emojiconManager().clear();
        this.userName = null;
        EMLog.d((String)TAG, (String)"logout and remove all cache");
        PreferenceUtil.getInstance().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loginWithTokenFail() {
        PreferenceUtil.getInstance().removeAll();
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (ConnectionListener listener : this.connectionListeners) {
                if (listener == null) continue;
                listener.onDisconnected(202);
            }
        }
    }

    public boolean isLoggedInBefore() {
        if (this._client == null) {
            EMLog.e((String)TAG, (String)"please first init");
            return false;
        }
        boolean isLogged = this._client.isLoggedInBefore();
        if (this.isCountDownDisconnect() && !isLogged) {
            String username = PreferenceUtil.getInstance().getUsername();
            String password = PreferenceUtil.getInstance().getPassword();
            String token = PreferenceUtil.getInstance().getToken();
            boolean isTokenLogin = PreferenceUtil.getInstance().loginWithToken();
            if (!TextUtils.isEmpty((CharSequence)username)) {
                if (isTokenLogin) {
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        isLogged = true;
                    }
                } else if (!TextUtils.isEmpty((CharSequence)password)) {
                    isLogged = true;
                }
            }
        }
        EMLog.d((String)TAG, (String)("isLoggedIn:" + isLogged));
        return isLogged;
    }

    public void sendFCMTokenToServer(String token) {
        EMClient.getInstance().sendFCMTokenToServer(token);
    }

    @Deprecated
    public boolean isConnected() {
        return this._client != null && this._client.isConnected();
    }

    public boolean setPushNickname(String userNick) {
        return EMClient.getInstance().pushManager().updatePushNickname(userNick);
    }

    @Deprecated
    public boolean updateNickToServer(String userNick) {
        return this.setPushNickname(userNick);
    }

    public void register(final String userName, final String password, final Callback callback) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        ChatClient.this._client.createAccount(userName, password);
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                    catch (HyphenateException ex) {
                        int errorCode = ex.getErrorCode();
                        EMLog.e((String)ChatClient.TAG, (String)("error:" + errorCode + ", errorMsg:" + ex.getMessage()));
                        if (callback == null) break block7;
                        if (errorCode == 203) {
                            callback.onError(203, "user already exist");
                        }
                        if (errorCode == 2) {
                            callback.onError(2, "network is not available");
                        }
                        if (errorCode == 202) {
                            callback.onError(202, "register fail without permission");
                        }
                        if (errorCode == 205) {
                            callback.onError(205, "illegal user name");
                        }
                        callback.onError(1, "general error");
                    }
                }
            }
        });
        thread.start();
    }

    @Deprecated
    public void createAccount(String userName, String password, Callback callback) {
        this.register(userName, password, callback);
    }

    @Deprecated
    public ChatManager getChat() {
        return this.chatManager();
    }

    public CallManager callManager() {
        return this.callManager;
    }

    public ChatManager chatManager() {
        return this.chatManager;
    }

    public TicketManager leaveMsgManager() {
        return this.leaveMsgManager;
    }

    public EmojiconManager emojiconManager() {
        if (this.emojiconManager == null) {
            this.emojiconManager = EmojiconManager.getInstance();
        }
        return this.emojiconManager;
    }

    public String currentUserName() {
        if (TextUtils.isEmpty((CharSequence)this.userName)) {
            if (this._client.isLoggedInBefore()) {
                this.userName = this._client.getCurrentUser();
            } else if (this.isCountDownDisconnect()) {
                this.userName = PreferenceUtil.getInstance().getUsername();
            }
        }
        return this.userName;
    }

    @Deprecated
    public String getCurrentUserName() {
        return this.currentUserName();
    }

    public void changeAppKey(String appKey) throws HyphenateException {
        EMClient.getInstance().changeAppkey(appKey);
    }

    public void changeTenantId(String newTenantId) {
        if (newTenantId == null) {
            EMLog.e((String)TAG, (String)"tenant id is set null");
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)newTenantId)) {
            throw new IllegalArgumentException("tenantid is digit");
        }
        if (this.tenantId == null || !this.tenantId.equals(newTenantId)) {
            this.tenantId = newTenantId;
            ChatConfig.getInstance().loadDnsConfigFromRemote(true);
        }
    }

    @Deprecated
    public void setTenantId(String newTenantId) {
        this.changeTenantId(newTenantId);
    }

    public String tenantId() {
        return this.tenantId;
    }

    @Deprecated
    public String getTenantId() {
        return this.tenantId();
    }

    public String accessToken() {
        if (this._client != null) {
            String token = PreferenceUtil.getInstance().getToken();
            if (token == null) {
                token = this.imAccessToken();
            }
            return token;
        }
        return null;
    }

    private String imAccessToken() {
        if (this._client.isLoggedInBefore()) {
            return this._client.getOptions().getAccessToken();
        }
        return null;
    }

    @Deprecated
    public String getAccessToken() {
        return this.accessToken();
    }

    public String sdkVersion() {
        return sdkVersion;
    }

    @Deprecated
    public String getSDKVersion() {
        return this.sdkVersion();
    }

    public String iMSdkVersion() {
        if (this._client != null) {
            return this._client.getOptions().getVersion();
        }
        return "";
    }

    @Deprecated
    public String getIMSDKVersion() {
        return this.iMSdkVersion();
    }

    public String appKey() {
        if (this._client != null) {
            return this._client.getOptions().getAppKey();
        }
        return null;
    }

    @Deprecated
    public String getAppKey() {
        return this.appKey();
    }

    @Deprecated
    public void setDebugMode(boolean paramBoolean) {
        this.isDebugMode = paramBoolean;
        EMClient.getInstance().setDebugMode(paramBoolean);
    }

    boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.connectionListeners.contains(listener)) {
            this.connectionListeners.remove(listener);
        }
    }

    public void sendHMSPushTokenToServer(String appid, String token) {
        EMClient.getInstance().sendHMSPushTokenToServer(appid, token);
    }

    public static class Options {
        private String appkey = "";
        private String tenantId = "";
        private String mipushAppid = "";
        private String mipushAppKey = "";
        private String kefuHost = "https://kefu.easemob.com";
        private String fcmNumber;
        private boolean showAgentInputState;
        private boolean showVisitorWaitCount;
        private boolean showMessagePredict;
        private String restHost;
        private String imHost;
        private int imPort = -1;
        private boolean consoleLogEnable = false;
        private String mediaHost;
        private String mediaSpecilServer;
        private boolean isUseFcm;
        private EMPushConfig pushConfig;

        public Options setPushConfig(EMPushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        public Options setAppkey(String appkey) {
            this.appkey = appkey;
            return this;
        }

        public Options setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Deprecated
        public Options setMipushConfig(String mipushAppid, String mipushAppKey) {
            this.mipushAppid = mipushAppid;
            this.mipushAppKey = mipushAppKey;
            return this;
        }

        public Options setMediaServer(String mediaHost, String mediaSpecilServer) {
            this.mediaHost = mediaHost;
            this.mediaSpecilServer = mediaSpecilServer;
            return this;
        }

        @Deprecated
        public Options setFCMNumber(String fcmNumber) {
            this.fcmNumber = fcmNumber;
            return this;
        }

        @Deprecated
        public Options setUseFCM(boolean isUseFcm) {
            this.isUseFcm = isUseFcm;
            return this;
        }

        public Options showAgentInputState() {
            this.showAgentInputState = true;
            return this;
        }

        public Options showVisitorWaitCount() {
            this.showVisitorWaitCount = true;
            return this;
        }

        public Options showMessagePredict() {
            this.showMessagePredict = true;
            return this;
        }

        public Options setKefuRestServer(String restServer) {
            this.kefuHost = !restServer.contains("http") ? "http://" + restServer : restServer;
            EMLog.d((String)ChatClient.TAG, (String)("set kefu host:" + this.kefuHost));
            return this;
        }

        @Deprecated
        public Options setKefuServerAddress(String restServer) {
            return this.setKefuRestServer(restServer);
        }

        public Options setRestServer(String restServer) {
            this.restHost = restServer;
            return this;
        }

        public Options setChatServer(String imServer) {
            this.imHost = imServer;
            return this;
        }

        @Deprecated
        public Options setIMServer(String imServer) {
            return this.setChatServer(imServer);
        }

        public Options setChatPort(int imPort) {
            this.imPort = imPort;
            return this;
        }

        @Deprecated
        public Options setIMPort(int imPort) {
            return this.setChatPort(imPort);
        }

        public Options setConsoleLog(boolean enable) {
            this.consoleLogEnable = enable;
            return this;
        }
    }

    public static interface ConnectionListener {
        public void onConnected();

        public void onDisconnected(int var1);
    }
}

