/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.BitmapFactory;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMMessageListener;
import com.hyphenate.chat.CallManager;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatConfig;
import com.hyphenate.chat.Conversation;
import com.hyphenate.chat.ConversationInfo;
import com.hyphenate.chat.CountDownBroadCast;
import com.hyphenate.chat.CountDownUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.KefuConversationManager;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.KefuHttpClient;
import com.hyphenate.chat.KefuPolling;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.httpclient.ProgressListener;
import com.hyphenate.helpdesk.model.MessageHelper;
import com.hyphenate.helpdesk.util.CopyDirectoryUtil;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.helpdesk.util.ZipUtil;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatManager {
    private static final String TAG = "ChatManager";
    private final List<MessageListener> messageListeners = Collections.synchronizedList(new ArrayList());
    private final List<AgentInputListener> agentInputListeners = Collections.synchronizedList(new ArrayList());
    private final List<VisitorWaitListener> visitorWaitCountListeners = Collections.synchronizedList(new ArrayList());
    private ScheduledExecutorService agentInputThread;
    private ScheduledExecutorService visitorWaitThread;
    private static ChatManager instance = new ChatManager();
    private ExecutorService sendMsgThread = Executors.newCachedThreadPool();
    private ExecutorService downloadThreadPool = Executors.newCachedThreadPool();
    private Hashtable<String, Object> sendLocks;
    private static final int WAIT_TIME_OUT = 20;
    private static final int WAIT_TIME_ATTACHMENT_MIN = 20;
    private static final int WAIT_TIME_ATTACHEMENT_MAX = 60;
    private static final int WAIT_TIME_OUT_TYPE_TXT = 10;
    private final String SEND_EXT_MSG_ID_FOR_ACK = "msg_id_for_ack";
    private final String ACK_FOR_MSG_ID = "ack_for_msg_id";
    static volatile String currentChatUsername;
    private ExecutorService loginSingleExecutor = Executors.newSingleThreadExecutor();
    private JSONObject latestSendWeichat;
    private CountDownBroadCast broadCastReceiver;
    private boolean preLogMode;
    private final Object asyncLoginImMutex = new Object();
    private final Object visitorLock = new Object();
    private final Object agentInputLock = new Object();

    String currentChatUsername() {
        return currentChatUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifySendLock(String messageId) {
        if (this.sendLocks == null) {
            return;
        }
        Object lock = this.sendLocks.remove(messageId);
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }
    }

    JSONObject getLatestSendWeichat() {
        return this.latestSendWeichat;
    }

    private synchronized void addSendLock(String messageId, Object lock) {
        if (this.sendLocks == null) {
            this.sendLocks = new Hashtable();
        }
        this.sendLocks.put(messageId, lock);
    }

    private List<Message> convertEMMessagesToMessages(List<EMMessage> emMessages) {
        ArrayList<Message> tempMsgs = new ArrayList<Message>();
        for (EMMessage msg : emMessages) {
            Message tempMsg = this.convertToMessage(msg);
            String taskId = tempMsg.getMarketingTaskId();
            MarketingHttpClient.asyncDelivered(taskId, tempMsg.from());
            tempMsgs.add(tempMsg);
        }
        return tempMsgs;
    }

    private List<Message> siftKefuMessages(List<Message> messages) {
        ArrayList<Message> tempMsgs = new ArrayList<Message>();
        for (Message tempMsg : messages) {
            String ackForMsgId = this.checkKefuMessageAck(tempMsg);
            if (ackForMsgId != null) {
                this.notifySendLock(ackForMsgId);
                continue;
            }
            Message message = this.checkIsExistMessage(tempMsg);
            if (message == null) continue;
            tempMsgs.add(message);
        }
        return tempMsgs;
    }

    synchronized Message checkIsExistMessage(Message message) {
        String kefuExtMsgId = this.getKefuExtMsgId(message);
        if (kefuExtMsgId != null) {
            boolean isExists = true;
            if (KefuDBManager.getInstance() == null) {
                return null;
            }
            isExists = KefuDBManager.getInstance().isMessageExistedByExtMsgId(kefuExtMsgId);
            EMLog.d((String)TAG, (String)("im-msgid:" + message.getIMMsgId() + ", kefuExtMsgId:" + kefuExtMsgId + ",isExists:" + isExists));
            if (!isExists) {
                message.setUnread(true);
                if (!MessageHelper.isNotificationMessage(message)) {
                    message.setStatus(Message.Status.SUCCESS);
                    KefuConversationManager.getInstance().saveMessage(message);
                    return message;
                }
            }
        } else {
            message.setUnread(true);
            if (!MessageHelper.isNotificationMessage(message)) {
                message.setStatus(Message.Status.SUCCESS);
                KefuConversationManager.getInstance().saveMessage(message);
                return message;
            }
            if (MessageHelper.isTicketStatusChangedMessage(message)) {
                message.setStatus(Message.Status.SUCCESS);
                return message;
            }
        }
        return null;
    }

    private ChatManager() {
        EMClient.getInstance().chatManager().addMessageListener(new EMMessageListener(){

            public void onMessageReceived(List<EMMessage> messages) {
                List tempMsgs = ChatManager.this.convertEMMessagesToMessages(messages);
                ChatManager.this.publishNewMessage(ChatManager.this.siftKefuMessages(tempMsgs));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageRead(List<EMMessage> messages) {
                CountDownUtils.getInstance().sendBroadcast();
                List list = ChatManager.this.messageListeners;
                synchronized (list) {
                    for (MessageListener listener : ChatManager.this.messageListeners) {
                        listener.onMessageStatusUpdate();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageDelivered(List<EMMessage> messages) {
                CountDownUtils.getInstance().sendBroadcast();
                List list = ChatManager.this.messageListeners;
                synchronized (list) {
                    for (MessageListener listener : ChatManager.this.messageListeners) {
                        listener.onMessageStatusUpdate();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageRecalled(List<EMMessage> list) {
                CountDownUtils.getInstance().sendBroadcast();
                List list2 = ChatManager.this.messageListeners;
                synchronized (list2) {
                    for (MessageListener listener : ChatManager.this.messageListeners) {
                        listener.onMessageStatusUpdate();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageChanged(EMMessage message, Object change) {
                CountDownUtils.getInstance().sendBroadcast();
                if (message.getBody() instanceof EMFileMessageBody) {
                    Message kefuMessage = ChatManager.this.convertToMessage(message);
                    ChatManager.this.updateMessageState(kefuMessage);
                }
                List list = ChatManager.this.messageListeners;
                synchronized (list) {
                    for (MessageListener listener : ChatManager.this.messageListeners) {
                        listener.onMessageStatusUpdate();
                    }
                }
            }

            public void onCmdMessageReceived(List<EMMessage> messages) {
                ArrayList<Message> tempMsgs = new ArrayList<Message>();
                for (EMMessage msg : messages) {
                    Message tempMsg = ChatManager.this.convertToMessage(msg);
                    if (KefuDBManager.getInstance() == null || KefuDBManager.getInstance().isExistCmdMessage(tempMsg.messageId())) continue;
                    boolean isInserted = KefuDBManager.getInstance().insertCmdMessage(tempMsg);
                    if (!isInserted) {
                        Log.e(ChatManager.TAG, "message insert failed:" + tempMsg.toString());
                        continue;
                    }
                    String ackForMsgId = ChatManager.this.checkKefuMessageAck(tempMsg);
                    if (ackForMsgId != null) {
                        ChatManager.this.notifySendLock(ackForMsgId);
                        continue;
                    }
                    if (ChatManager.this.isReCallCmdMessage(tempMsg)) {
                        ChatManager.this.notifyReCallMessage(tempMsg);
                        continue;
                    }
                    EMCmdMessageBody cmdBody = (EMCmdMessageBody)tempMsg.body();
                    String action = cmdBody.action();
                    if (!TextUtils.isEmpty((CharSequence)action)) {
                        if (action.equals("ServiceSessionOpenedEvent")) {
                            ChatManager.this.sendDeviceInfo(tempMsg.from());
                            if (!TextUtils.isEmpty((CharSequence)currentChatUsername)) {
                                ChatManager.this.showVisitorWaitCountAndAgentInputState(currentChatUsername);
                            }
                        } else if (action.equals("ServiceSessionClosedEvent")) {
                            ChatManager.this.shutdownWaitAndInput();
                            if (!TextUtils.isEmpty((CharSequence)currentChatUsername) && !currentChatUsername.contains("#|")) {
                                ChatManager.this.getConversation(currentChatUsername).clearOfficialAccount();
                            }
                        } else if (action.equalsIgnoreCase("ServiceSessionCreatedEvent")) {
                            if (!TextUtils.isEmpty((CharSequence)currentChatUsername)) {
                                ChatManager.this.showVisitorWaitCountAndAgentInputState(currentChatUsername);
                            }
                        } else if (action.equalsIgnoreCase("ServiceSessionTransferedEvent")) {
                            if (!TextUtils.isEmpty((CharSequence)currentChatUsername)) {
                                ChatManager.this.showVisitorWaitCountAndAgentInputState(currentChatUsername);
                            }
                        } else if (action.equalsIgnoreCase("ServiceSessionAbortedEvent")) {
                            ChatManager.this.shutdownWaitAndInput();
                            if (!TextUtils.isEmpty((CharSequence)currentChatUsername) && !currentChatUsername.contains("#|")) {
                                ChatManager.this.getConversation(currentChatUsername).clearOfficialAccount();
                            }
                        } else if (action.equalsIgnoreCase("ServiceSessionTransferedToAgentQueueEvent") && !TextUtils.isEmpty((CharSequence)currentChatUsername)) {
                            ChatManager.this.showVisitorWaitCountAndAgentInputState(currentChatUsername);
                        }
                    }
                    tempMsgs.add(tempMsg);
                }
                ChatManager.this.publishCmdMessage(tempMsgs);
            }
        });
    }

    private JSONObject getVideoInviteTicket(Message message) {
        try {
            return message.getJSONObjectAttribute("msgtype").getJSONObject("sendVisitorTicket");
        }
        catch (Exception exception) {
            return null;
        }
    }

    boolean isReCallCmdMessage(Message message) {
        EMCmdMessageBody body;
        String action;
        return message.getType() == Message.Type.CMD && !TextUtils.isEmpty((CharSequence)(action = (body = (EMCmdMessageBody)message.body()).action())) && action.equals("KEFU_MESSAGE_RECALL");
    }

    void notifyReCallMessage(Message message) {
        if (message.getType() == Message.Type.CMD) {
            try {
                JSONObject jsonObj = message.getJSONObjectAttribute("weichat");
                if (jsonObj != null && jsonObj.has("recall_msg_id")) {
                    String recallMsgId = jsonObj.getString("recall_msg_id");
                    String msgId = KefuConversationManager.getInstance().getMessageByExtMsgId(recallMsgId);
                    if (!TextUtils.isEmpty((CharSequence)msgId)) {
                        ChatClient.getInstance().chatManager().getConversation(message.from).removeMessage(msgId, false);
                        KefuDBManager.getInstance().recallMessage(msgId);
                    }
                    this.notifyMessageSent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized ChatManager getInstance() {
        return instance;
    }

    void loginWithToken(final String username, String token, final EMCallBack callback) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            ChatClient.getInstance().loginWithTokenFail();
            callback.onError(1, "token is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)username)) {
            ChatClient.getInstance().loginWithTokenFail();
            callback.onError(1, "username is null");
            return;
        }
        this.initDB(username);
        EMClient.getInstance().loginWithToken(username, token, new EMCallBack(){

            public void onSuccess() {
                ChatManager.this.loadDB();
                PreferenceUtil.getInstance().setUsername(username);
                PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                PreferenceUtil.getInstance().saveLoginWithToken(true);
                ChatManager.this.registerCountDown();
                CountDownUtils.getInstance().sendBroadcast();
                ChatConfig.getInstance().loadDnsConfigFromRemote(false);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(int code, String error) {
                ChatClient.getInstance().loginWithTokenFail();
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    void login(final String username, final String password, final EMCallBack callback) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callback != null) {
                callback.onError(-1, "tenantid is null");
                EMLog.e((String)TAG, (String)"tenantid is null, please set in option");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)tenantId)) {
            if (callback != null) {
                callback.onError(-1, "tenantid must be digits");
            }
            EMLog.e((String)TAG, (String)("current tenantid is :" + tenantId + ", tenantid must is digits"));
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)username)) {
            this.initDB(username);
        }
        EMClient.getInstance().login(username, password, new EMCallBack(){

            public void onSuccess() {
                ChatManager.this.loadDB();
                if (KefuDBManager.getInstance() != null) {
                    KefuDBManager.getInstance().deleteCmdMessages(7);
                }
                PreferenceUtil.getInstance().setUsernameAndPassword(username, password);
                PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                PreferenceUtil.getInstance().saveLoginWithToken(false);
                if (TextUtils.isEmpty((CharSequence)PreferenceUtil.getInstance().getUniqueId())) {
                    PreferenceUtil.getInstance().setUniqueId(ChatManager.this.getDeviceId());
                }
                ChatManager.this.registerCountDown();
                CountDownUtils.getInstance().sendBroadcast();
                ChatConfig.getInstance().loadDnsConfigFromRemote(false);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onProgress(int progress, String status) {
                if (callback != null) {
                    callback.onProgress(progress, status);
                }
            }

            public void onError(int code, String error) {
                if (callback != null) {
                    callback.onError(code, error);
                }
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private String getDeviceId() {
        String deviceId = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)ChatClient.getInstance().getContext().getSystemService("phone");
            deviceId = telephonyManager.getDeviceId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = UUID.randomUUID().toString();
        }
        return deviceId;
    }

    private int logout(boolean unbindToken) {
        int error = EMClient.getInstance().logout(unbindToken);
        if (error != 0) {
            return error;
        }
        KefuDBManager.closeDatabase();
        if (this.sendLocks != null) {
            this.sendLocks.clear();
        }
        KefuConversationManager.getInstance().clear();
        this.unbindChat();
        ChatClient.getInstance().cleanCache();
        this.unregisterCountDown();
        return 0;
    }

    void logout(final boolean unbindToken, final EMCallBack callback) {
        new Thread(){

            @Override
            public void run() {
                int error = ChatManager.this.logout(unbindToken);
                if (error != 0) {
                    if (callback != null) {
                        callback.onError(error, "faild to unbind device token");
                    }
                } else {
                    ChatManager.this.unregisterCountDown();
                    ChatManager.this.kefuLogout();
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }
        }.start();
    }

    private void unregisterCountDown() {
        try {
            if (this.broadCastReceiver != null) {
                EMClient.getInstance().getContext().unregisterReceiver((BroadcastReceiver)this.broadCastReceiver);
                this.broadCastReceiver = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void registerCountDown() {
        if (this.broadCastReceiver == null) {
            this.broadCastReceiver = new CountDownBroadCast();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.hyphenate.receive.countdown");
        EMClient.getInstance().getContext().registerReceiver((BroadcastReceiver)this.broadCastReceiver, intentFilter);
    }

    void kefuLogout() {
        KefuDBManager.closeDatabase();
        if (this.sendLocks != null) {
            this.sendLocks.clear();
        }
        KefuConversationManager.getInstance().clear();
        this.unbindChat();
        ChatClient.getInstance().cleanCache();
        EMClient.getInstance().logout(false);
        this.unregisterCountDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishNewMessage(List<Message> messages) {
        CountDownUtils.getInstance().sendBroadcast();
        if (messages != null && messages.size() > 0) {
            List<MessageListener> list = this.messageListeners;
            synchronized (list) {
                for (MessageListener messageListener : this.messageListeners) {
                    messageListener.onMessage(messages);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishCmdMessage(List<Message> allMessages) {
        CountDownUtils.getInstance().sendBroadcast();
        List<Message> messages = this.filterNonofifyCmdMessage(allMessages);
        if (messages != null && messages.size() > 0) {
            List<MessageListener> list = this.messageListeners;
            synchronized (list) {
                for (MessageListener listener : this.messageListeners) {
                    listener.onCmdMessage(messages);
                }
            }
        }
    }

    private List<Message> filterNonofifyCmdMessage(List<Message> allMessages) {
        ArrayList<Message> tempMessages = new ArrayList<Message>();
        for (Message item : allMessages) {
            EMCmdMessageBody body = (EMCmdMessageBody)item.body();
            String action = body.action();
            JSONObject inviteVideoJson = this.getVideoInviteTicket(item);
            if (inviteVideoJson != null) {
                EMLog.d((String)TAG, (String)("inviteVideoJson:" + inviteVideoJson.toString()));
                String ticket = inviteVideoJson.optString("ticket");
                String callNickName = inviteVideoJson.optString("nickname");
                JSONObject extendJson = inviteVideoJson.optJSONObject("extend");
                try {
                    if (ChatClient.getInstance().callManager() == null) continue;
                    ChatClient.getInstance().callManager().putTicket(new CallManager.TicketEntity(ticket, callNickName, extendJson));
                }
                catch (Exception e) {
                    EMLog.e((String)TAG, (String)("e->" + android.util.Log.getStackTraceString((Throwable)e)));
                }
                continue;
            }
            if (!TextUtils.isEmpty((CharSequence)action)) {
                if (action.equals("easemob_exit")) {
                    int code = 207;
                    PreferenceUtil.getInstance().removeAll();
                    ChatClient.getInstance().notifyOnDisconnected(code);
                    continue;
                }
                if (action.equals("easemob_startlog")) {
                    this.preLogMode = ChatClient.getInstance().isDebugMode();
                    ChatClient.getInstance().setDebugMode(true);
                    continue;
                }
                if (action.equals("easemob_stoplog")) {
                    ChatClient.getInstance().setDebugMode(this.preLogMode);
                    continue;
                }
                if (action.equals("easemob_uploadlog")) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String tempLogDir = "/sdcard/easemoblog/";
                                String packageName = ChatClient.getInstance().getContext().getPackageName();
                                String appkey = EMClient.getInstance().getOptions().getAppKey();
                                final File tempZipFile = new File("/sdcard/easemoblog.zip");
                                CopyDirectoryUtil.copyDirectory("/sdcard/Android/data/" + packageName + "/" + appkey + "/core_log", tempLogDir);
                                CopyDirectoryUtil.copyDirectory("/data/data/" + packageName + "/databases/", tempLogDir);
                                ZipUtil.zipFolder(tempLogDir, tempZipFile.getPath());
                                ZipUtil.deleteDirectory(new File(tempLogDir));
                                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                                HttpRequestBuilder requestBuilder = httpClient.post("https://kefu-sdk-log.easemob.com/upload?token=f2dfcdf86fc51be02a6fcb8fef9c703e");
                                requestBuilder.contentFromFile(tempZipFile.getPath());
                                requestBuilder.to(new HttpResponseHandler(){

                                    @Override
                                    public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                        try {
                                            String result = response.getResponseBody();
                                            EMLog.d((String)ChatManager.TAG, (String)("upload log zip :" + result));
                                            JSONObject jsonObject = new JSONObject(result);
                                            String urlMessage = jsonObject.getString("message");
                                            JSONObject jsonBody = new JSONObject();
                                            String username = PreferenceUtil.getInstance().getUsername();
                                            String appkey = EMClient.getInstance().getOptions().getAppKey();
                                            String logUsername = appkey.replace("#", "_") + "_" + username;
                                            EMLog.d((String)ChatManager.TAG, (String)("logUsername:" + logUsername));
                                            jsonBody.put("username", (Object)logUsername);
                                            jsonBody.put("url", (Object)urlMessage);
                                            tempZipFile.delete();
                                            ChatManager.this.uploadLogToServer(jsonBody.toString());
                                        }
                                        catch (Exception ignored) {
                                            ignored.printStackTrace();
                                        }
                                    }
                                });
                                requestBuilder.execute();
                            }
                            catch (Exception ignored) {
                                ignored.printStackTrace();
                            }
                        }
                    }).start();
                    continue;
                }
            }
            tempMessages.add(item);
        }
        return tempMessages;
    }

    private void uploadLogToServer(String jsonBody) {
        try {
            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
            HttpRequestBuilder requestBuilder1 = httpClient1.post("https://kefu-sdk-log.easemob.com/applog/api/v1.0?token=f2dfcdf86fc51be02a6fcb8fef9c703e");
            requestBuilder1.content(jsonBody.getBytes(), "application/json");
            HttpResponse msgHttpResponse = requestBuilder1.execute();
            assert (msgHttpResponse != null);
            int statusCode = msgHttpResponse.getStatusCode();
            if (statusCode / 100 == 2) {
                EMLog.d((String)TAG, (String)"upload log success");
            } else {
                EMLog.d((String)TAG, (String)"upload log failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void sendMessageWithoutRecord(Message msg) {
        this.sendMessage(msg, false, null);
    }

    public void sendMessage(Message msg) {
        this.sendMessage(msg, true, null);
    }

    public void sendMessage(Message message, Callback callback) {
        this.sendMessage(message, true, callback);
    }

    private void sendMessage(Message message, boolean isRecord, Callback callback) {
        EMTextMessageBody txtBody;
        JSONObject jsonWeichat;
        block32: {
            if (TextUtils.isEmpty((CharSequence)currentChatUsername)) {
                EMLog.e((String)TAG, (String)"please invoke ChatClient.getInstance().chatManager().bindChat({imServiceNum}) method in your chat activity!");
            }
            if (message.messageId() == null) {
                message.setMsgId(UUID.randomUUID().toString());
            }
            jsonWeichat = null;
            try {
                jsonWeichat = message.getJSONObjectAttribute("weichat");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jsonWeichat == null) {
                jsonWeichat = new JSONObject();
            }
            this.latestSendWeichat = jsonWeichat;
            try {
                if (ChatClient.getInstance().hasSecondChannel) {
                    jsonWeichat.put("msg_id_for_ack", (Object)message.messageId());
                }
                if (!message.to.contains("#|")) break block32;
                String officialAccountId = message.to.substring(message.to.indexOf("#|") + 2);
                EMLog.d((String)TAG, (String)("officialAccount:" + officialAccountId));
                JSONObject jsonOffAccount = new JSONObject();
                jsonOffAccount.put("official_account_id", (Object)officialAccountId);
                jsonWeichat.put("official_account", (Object)jsonOffAccount);
                MarketingHttpClient.asyncReplied(message.to);
                Conversation conversation = this.getConversation(message.to);
                if (conversation == null || conversation.getMarketings() == null) break block32;
                JSONObject jsonMarketings = new JSONObject(conversation.getMarketings());
                try {
                    JSONObject jsonScheduleInfo = jsonMarketings.getJSONObject("schedule_info");
                    if (jsonScheduleInfo.has("skillgroup_name")) {
                        String skillGroupName = jsonScheduleInfo.getString("skillgroup_name");
                        jsonWeichat.put("queueName", (Object)skillGroupName);
                    }
                    if (jsonScheduleInfo.has("agent_username")) {
                        String agentName = jsonScheduleInfo.getString("agent_username");
                        jsonWeichat.put("agentUsername", (Object)agentName);
                    }
                }
                catch (Exception jsonScheduleInfo) {}
            }
            catch (JSONException officialAccountId) {
                // empty catch block
            }
        }
        message.setAttribute("weichat", jsonWeichat);
        EMMessageBody messageBody = message.body();
        if (messageBody == null) {
            EMLog.e((String)TAG, (String)"messagebody is nulll");
            if (callback != null) {
                callback.onError(1, "body is null");
            }
            if (message.messageStatusCallBack != null) {
                message.messageStatusCallBack.onError(1, "body is null");
            }
            return;
        }
        String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty((CharSequence)currentUser)) {
            EMLog.e((String)TAG, (String)"currentUserName is empty");
            if (callback != null) {
                callback.onError(1, "please login before");
            }
            if (message.messageStatusCallBack != null) {
                message.messageStatusCallBack.onError(1, "please login before");
            }
            return;
        }
        message.setFrom(currentUser);
        if (message.getType() == Message.Type.TXT && (txtBody = (EMTextMessageBody)messageBody).getMessage() != null && txtBody.getMessage().length() > 1500) {
            if (callback != null) {
                callback.onError(502, "text message length could not more than 1500");
            }
            if (message.messageStatusCallBack != null) {
                message.messageStatusCallBack.onError(502, "text message length could not more than 1500");
            }
            return;
        }
        if (isRecord && message.getType() != Message.Type.CMD) {
            KefuConversationManager.getInstance().saveMessage(message);
        }
        String originPath = null;
        if (message.getType() == Message.Type.IMAGE) {
            String scaledImagePath;
            EMImageMessageBody body = (EMImageMessageBody)message.body();
            if (body == null) {
                message.setStatus(Message.Status.FAIL);
                if (callback != null) {
                    callback.onError(1, "Message body cannot be null");
                }
                return;
            }
            String filePath = body.getLocalUrl();
            File file = new File(filePath);
            if (!file.exists() || !file.canRead()) {
                message.setStatus(Message.Status.FAIL);
                if (callback != null) {
                    callback.onError(401, "File not exists or can not be read");
                }
                return;
            }
            if (!body.isSendOriginalImage() && !(scaledImagePath = ImageUtils.getScaledImage((Context)EMClient.getInstance().getContext(), (String)filePath)).equals(filePath)) {
                originPath = filePath;
                File attachment = new File(scaledImagePath);
                long originalSize = new File(filePath).length();
                long scaledSize = attachment.length();
                if (originalSize == 0L) {
                    EMLog.d((String)TAG, (String)("original image size:" + originalSize));
                    message.setStatus(Message.Status.FAIL);
                    if (callback != null) {
                        callback.onError(401, "original image size is 0");
                    }
                    return;
                }
                filePath = scaledImagePath;
                body.setLocalUrl(filePath);
            }
            BitmapFactory.Options options = ImageUtils.getBitmapOptions((String)filePath);
            int width = options.outWidth;
            int height = options.outHeight;
            body.setSize(width, height);
            body.setFileName(new File(filePath).getName());
        }
        message.setStatus(Message.Status.INPROGRESS);
        if (!EMClient.getInstance().isLoggedInBefore() && ChatClient.getInstance().isLoggedInBefore()) {
            this.sendRESTMessage(message, callback);
            this.sendMsgThread.execute(new Runnable(){

                @Override
                public void run() {
                    ChatManager.this.asyncLoginIM();
                }
            });
        } else {
            this.sendIMEMMessage(message, callback);
        }
        this.notifyMessageSent();
        CountDownUtils.getInstance().sendBroadcast();
    }

    private void asyncRealLoginIM() {
        if (EMClient.getInstance().isLoggedInBefore()) {
            EMLog.d((String)TAG, (String)"im isLoggedIn");
            this.notifyAsyncLoginMutex();
            return;
        }
        String uName = PreferenceUtil.getInstance().getUsername();
        String uPwd = PreferenceUtil.getInstance().getPassword();
        String uToken = PreferenceUtil.getInstance().getToken();
        if (TextUtils.isEmpty((CharSequence)uName)) {
            EMLog.d((String)TAG, (String)"asyncLoginIM: userName is empty");
            this.notifyAsyncLoginMutex();
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)uPwd)) {
            EMClient.getInstance().login(uName, uPwd, new EMCallBack(){

                public void onSuccess() {
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    ChatManager.this.registerCountDown();
                    CountDownUtils.getInstance().sendBroadcast();
                    ChatManager.this.notifyAsyncLoginMutex();
                }

                public void onError(int i, String s) {
                    ChatManager.this.notifyAsyncLoginMutex();
                }

                public void onProgress(int i, String s) {
                }
            });
        } else if (!TextUtils.isEmpty((CharSequence)uToken)) {
            EMClient.getInstance().loginWithToken(uName, uToken, new EMCallBack(){

                public void onSuccess() {
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    ChatManager.this.registerCountDown();
                    CountDownUtils.getInstance().sendBroadcast();
                    ChatManager.this.notifyAsyncLoginMutex();
                }

                public void onError(int i, String s) {
                    ChatClient.getInstance().loginWithTokenFail();
                    ChatManager.this.notifyAsyncLoginMutex();
                }

                public void onProgress(int i, String s) {
                }
            });
        } else {
            this.notifyAsyncLoginMutex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAsyncLoginMutex() {
        Object object = this.asyncLoginImMutex;
        synchronized (object) {
            this.asyncLoginImMutex.notifyAll();
        }
    }

    private void asyncLoginIM() {
        this.loginSingleExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChatManager.this.asyncLoginImMutex;
                synchronized (object) {
                    ChatManager.this.asyncRealLoginIM();
                    try {
                        ChatManager.this.asyncLoginImMutex.wait(10000L);
                    }
                    catch (InterruptedException ignored) {
                        EMLog.e((String)ChatManager.TAG, (String)"asyncLoginImMutex wait InterruptedException");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageSent() {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            for (MessageListener listener : this.messageListeners) {
                listener.onMessageSent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EMMessage convertToEMMessage(Message message) {
        Map<String, Object> extAttrs;
        EMMessage imMessage;
        String from = message.from();
        String to = message.to();
        EMMessageBody messageBody = message.body();
        if (message.direct() == Message.Direct.SEND) {
            imMessage = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.valueOf((String)message.getType().name()));
            if (to.contains("#|")) {
                to = to.substring(0, to.indexOf("#|"));
            }
        } else {
            imMessage = EMMessage.createReceiveMessage((EMMessage.Type)EMMessage.Type.valueOf((String)message.getType().name()));
            if (from.contains("#|")) {
                from = from.substring(0, from.indexOf("#|"));
            }
        }
        imMessage.addBody(messageBody);
        imMessage.setFrom(from);
        imMessage.setTo(to);
        imMessage.setMsgTime(message.messageTime());
        Map<String, Object> map = extAttrs = message.ext();
        synchronized (map) {
            for (Map.Entry<String, Object> item : extAttrs.entrySet()) {
                String key = item.getKey();
                Object value = item.getValue();
                if (value instanceof Boolean) {
                    imMessage.setAttribute(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    imMessage.setAttribute(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    imMessage.setAttribute(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof JSONObject) {
                    imMessage.setAttribute(key, (JSONObject)value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    imMessage.setAttribute(key, (JSONArray)value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                imMessage.setAttribute(key, (String)value);
            }
        }
        return imMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message convertToMessage(EMMessage message) {
        OfficialAccount officialAccount;
        Map extAttrs;
        String from = message.getFrom();
        String to = message.getTo();
        EMMessageBody messageBody = message.getBody();
        Message msg = message.direct() == EMMessage.Direct.SEND ? Message.createSendMessage(Message.Type.valueOf(message.getType().name())) : Message.createReceiveMessage(Message.Type.valueOf(message.getType().name()));
        msg.setBody(messageBody);
        msg.setFrom(from);
        msg.setTo(to);
        msg.setIMMsgId(message.getMsgId());
        msg.setMessageTime(message.getMsgTime());
        Map map = extAttrs = message.ext();
        synchronized (map) {
            for (Map.Entry item : extAttrs.entrySet()) {
                String key = (String)item.getKey();
                Object value = item.getValue();
                if (value instanceof Boolean) {
                    msg.setAttribute(key, (Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    msg.setAttribute(key, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    msg.setAttribute(key, (Long)value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    msg.setAttribute(key, (JSONObject)value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    msg.setAttribute(key, (JSONArray)value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                msg.setAttribute(key, (String)value);
            }
        }
        String extMsgId = this.getKefuExtMsgId(msg);
        if (extMsgId != null) {
            msg.setMsgId(extMsgId);
        } else {
            msg.setMsgId(message.getMsgId());
        }
        if (msg.direct() == Message.Direct.RECEIVE) {
            if (msg.from() != null && !msg.from().contains("#|") && (officialAccount = msg.getOfficialAccount()) != null && officialAccount.getId() != null && !officialAccount.getType().equals("SYSTEM")) {
                msg.setFrom(msg.from() + "#|" + officialAccount.getId());
            }
        } else if (msg.to() != null && !msg.to().contains("#|") && (officialAccount = msg.getOfficialAccount()) != null && officialAccount.getId() != null && !officialAccount.getType().equals("SYSTEM")) {
            msg.setTo(msg.to() + "#|" + officialAccount.getId());
        }
        return msg;
    }

    private void sendIMEMMessage(final Message message, final EMCallBack callback) {
        this.sendMsgThread.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EMNormalFileMessageBody fileBody;
                final EMMessage imMessage = ChatManager.this.convertToEMMessage(message);
                imMessage.setMessageStatusCallback(new EMCallBack(){

                    public void onSuccess() {
                        if (!ChatClient.getInstance().hasSecondChannel) {
                            message.setIMMsgId(imMessage.getMsgId());
                            message.setStatus(Message.Status.SUCCESS);
                            message.setMessageTime(imMessage.getMsgTime());
                            ChatManager.this.updateMessageStatusAndMsgId(message);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onSuccess();
                            }
                        }
                    }

                    public void onError(int i, String s) {
                    }

                    public void onProgress(int i, String s) {
                        if (message.status() == Message.Status.INPROGRESS) {
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onProgress(i, s);
                            }
                            if (callback != null) {
                                callback.onProgress(i, s);
                            }
                        }
                    }
                });
                long fileLength = 0L;
                if (imMessage.getType() == EMMessage.Type.FILE) {
                    fileBody = (EMNormalFileMessageBody)imMessage.getBody();
                    fileLength = fileBody.getFileSize();
                }
                if (imMessage.getType() == EMMessage.Type.VIDEO) {
                    fileBody = (EMVideoMessageBody)imMessage.getBody();
                    fileLength = fileBody.getVideoFileLength();
                }
                EMClient.getInstance().chatManager().sendMessage(imMessage);
                if (ChatClient.getInstance().hasSecondChannel) {
                    Object mutex = new Object();
                    String msgId = message.messageId();
                    ChatManager.this.addSendLock(msgId, mutex);
                    Object object = mutex;
                    synchronized (object) {
                        if (ChatManager.this.sendLocks.containsKey(msgId)) {
                            try {
                                if (message.getType() == Message.Type.TXT || message.getType() == Message.Type.CMD || message.getType() == Message.Type.LOCATION) {
                                    mutex.wait(10000L);
                                } else if (message.getType() == Message.Type.IMAGE || message.getType() == Message.Type.VOICE) {
                                    mutex.wait(20000L);
                                } else if (message.getType() == Message.Type.FILE || message.getType() == Message.Type.VIDEO) {
                                    long tempWaitTime = fileLength / 1024L / 1024L * 3L + 20L;
                                    long waitTime = Math.min(tempWaitTime, 60L);
                                    waitTime = Math.max(waitTime, 20L);
                                    mutex.wait(waitTime * 1000L);
                                } else {
                                    mutex.wait(20000L);
                                }
                            }
                            catch (InterruptedException ignored) {
                                EMLog.e((String)ChatManager.TAG, (String)"mutex wait InterruptedException");
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    EMLog.d((String)ChatManager.TAG, (String)("exit from wait msgid:" + message.messageId()));
                    if (ChatManager.this.sendLocks.remove(msgId) != null) {
                        ChatManager.this.sendRESTMessage(message, callback);
                    } else {
                        message.setIMMsgId(imMessage.getMsgId());
                        message.setStatus(Message.Status.SUCCESS);
                        message.setMessageTime(imMessage.getMsgTime());
                        ChatManager.this.updateMessageStatusAndMsgId(message);
                        if (message.messageStatusCallBack != null) {
                            message.messageStatusCallBack.onSuccess();
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                }
            }
        });
    }

    private void sendRESTMessage(final Message mesage, final EMCallBack callback) {
        KefuHttpClient.sendMessageByKefuRest(mesage, new EMCallBack(){

            public void onSuccess() {
                mesage.setStatus(Message.Status.SUCCESS);
                ChatManager.this.updateMessageState(mesage);
                if (mesage.messageStatusCallBack != null) {
                    mesage.messageStatusCallBack.onSuccess();
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(int error, String errorMsg) {
                KefuHttpClient.sendMessageByKefuRest(mesage, new EMCallBack(){

                    public void onSuccess() {
                        EMLog.d((String)ChatManager.TAG, (String)("send kefu message by rest msgid:" + mesage.messageId()));
                        mesage.setStatus(Message.Status.SUCCESS);
                        ChatManager.this.updateMessageState(mesage);
                        if (mesage.messageStatusCallBack != null) {
                            mesage.messageStatusCallBack.onSuccess();
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    public void onError(int error, String errorMsg) {
                        EMLog.d((String)ChatManager.TAG, (String)("send kefu message:" + errorMsg));
                        mesage.setStatus(Message.Status.FAIL);
                        ChatManager.this.updateMessageState(mesage);
                        if (mesage.messageStatusCallBack != null) {
                            mesage.messageStatusCallBack.onError(error, errorMsg);
                        }
                        if (callback != null) {
                            callback.onError(error, errorMsg);
                        }
                    }

                    public void onProgress(int i, String s) {
                    }
                });
            }

            public void onProgress(int i, String s) {
            }
        });
    }

    void initDB(String userName) {
        EMLog.d((String)TAG, (String)("initDB - userName:" + userName));
        Context context = EMClient.getInstance().getContext();
        if (context == null) {
            return;
        }
        KefuDBManager.initDB(userName);
    }

    void loadDB() {
        KefuConversationManager.getInstance().clear();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ChatManager.this.loadAllConversations();
            }
        });
        thread.setPriority(9);
        thread.start();
    }

    public boolean isSilentMessage(Message message) {
        return message.getBooleanAttribute("em_ignore_notification", false);
    }

    @Deprecated
    public void downloadFile(String remoteUrl, String localFilePath, Map<String, String> headers, EMCallBack callback) {
        EMClient.getInstance().chatManager().downloadFile(remoteUrl, localFilePath, headers, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownVisitorWaitThread() {
        if (ChatClient.getInstance().isShowVisitorWaitCount && this.visitorWaitThread != null && !this.visitorWaitThread.isShutdown()) {
            this.visitorWaitThread.shutdownNow();
            this.visitorWaitThread = null;
            if (!this.visitorWaitCountListeners.isEmpty()) {
                List<VisitorWaitListener> list = this.visitorWaitCountListeners;
                synchronized (list) {
                    for (VisitorWaitListener listener : this.visitorWaitCountListeners) {
                        if (listener == null) continue;
                        listener.waitCount(0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAgentInputThread() {
        if (ChatClient.getInstance().isShowAgentInputState && this.agentInputThread != null && !this.agentInputThread.isShutdown()) {
            this.agentInputThread.shutdownNow();
            this.agentInputThread = null;
            if (!this.agentInputListeners.isEmpty()) {
                List<AgentInputListener> list = this.agentInputListeners;
                synchronized (list) {
                    for (AgentInputListener listener : this.agentInputListeners) {
                        if (listener == null) continue;
                        listener.onInputState(null);
                    }
                }
            }
        }
    }

    private void showVisitorWaitCountAndAgentInputState(final String toChatUsername) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChatManager.this.visitorLock;
                synchronized (object) {
                    if (ChatClient.getInstance().isShowVisitorWaitCount) {
                        ChatManager.this.shutdownVisitorWaitThread();
                        if (ChatManager.this.visitorWaitCountListeners.isEmpty()) {
                            return;
                        }
                        OfficialAccount officialAccount = ChatManager.this.getConversation(toChatUsername).officialAccount();
                        if (officialAccount == null) {
                            officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                        }
                        if (officialAccount != null && officialAccount.getId() != null) {
                            final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                            if (info == null || info.session_id == null) {
                                EMLog.d((String)ChatManager.TAG, (String)"sessionid is null");
                            } else if (info.state == null || !info.state.equalsIgnoreCase("wait")) {
                                EMLog.d((String)ChatManager.TAG, (String)"session is not wait state");
                            } else {
                                ChatManager.this.visitorWaitThread = Executors.newSingleThreadScheduledExecutor();
                                ChatManager.this.visitorWaitThread.scheduleAtFixedRate(new Runnable(){

                                    @Override
                                    public void run() {
                                        MarketingHttpClient.asyncGetWaitCount(info, new ValueCallBack<String>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onSuccess(String value) {
                                                block7: {
                                                    try {
                                                        JSONObject jsonObj = new JSONObject(value);
                                                        JSONObject jsonEntty = jsonObj.getJSONObject("entity");
                                                        String number = jsonEntty.getString("visitorUserWaitingNumber");
                                                        if (!TextUtils.isEmpty((CharSequence)number) && TextUtils.isDigitsOnly((CharSequence)number)) {
                                                            List list = ChatManager.this.visitorWaitCountListeners;
                                                            synchronized (list) {
                                                                for (VisitorWaitListener listener : ChatManager.this.visitorWaitCountListeners) {
                                                                    if (listener == null) continue;
                                                                    listener.waitCount(Integer.parseInt(number));
                                                                }
                                                                break block7;
                                                            }
                                                        }
                                                        ChatManager.this.shutdownVisitorWaitThread();
                                                    }
                                                    catch (JSONException e) {
                                                        ChatManager.this.shutdownVisitorWaitThread();
                                                    }
                                                }
                                            }

                                            @Override
                                            public void onError(int error, String errorMsg) {
                                                EMLog.i((String)ChatManager.TAG, (String)("visitor wait error -> " + errorMsg));
                                            }
                                        });
                                    }
                                }, 1000L, 5000L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                }
            }
        });
        thread.start();
        Thread agentThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChatManager.this.agentInputLock;
                synchronized (object) {
                    if (ChatClient.getInstance().isShowAgentInputState) {
                        ChatManager.this.shutdownAgentInputThread();
                        if (ChatManager.this.agentInputListeners.isEmpty()) {
                            return;
                        }
                        OfficialAccount officialAccount = ChatManager.this.getConversation(toChatUsername).officialAccount();
                        if (officialAccount == null) {
                            officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                        }
                        if (officialAccount != null && officialAccount.getId() != null) {
                            final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                            if (info == null || info.session_id == null) {
                                EMLog.i((String)ChatManager.TAG, (String)"sessionid is null");
                            } else {
                                ChatManager.this.agentInputThread = Executors.newScheduledThreadPool(1);
                                ChatManager.this.agentInputThread.scheduleAtFixedRate(new Runnable(){

                                    @Override
                                    public void run() {
                                        MarketingHttpClient.asyncGetAgentState(info, new ValueCallBack<String>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void onSuccess(String value) {
                                                if (!TextUtils.isEmpty((CharSequence)value) && !value.equals("null")) {
                                                    List list = ChatManager.this.agentInputListeners;
                                                    synchronized (list) {
                                                        for (AgentInputListener listener : ChatManager.this.agentInputListeners) {
                                                            if (listener == null) continue;
                                                            listener.onInputState(value);
                                                        }
                                                    }
                                                }
                                                List list = ChatManager.this.agentInputListeners;
                                                synchronized (list) {
                                                    for (AgentInputListener listener : ChatManager.this.agentInputListeners) {
                                                        if (listener == null) continue;
                                                        listener.onInputState(null);
                                                    }
                                                }
                                            }

                                            @Override
                                            public void onError(int error, String errorMsg) {
                                                EMLog.i((String)ChatManager.TAG, (String)("get agent state error->" + errorMsg));
                                            }
                                        });
                                    }
                                }, 3000L, 3000L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                }
            }
        });
        agentThread.start();
    }

    public void postMessagePredict(String content) {
        this.postMessagePredict(content, currentChatUsername);
    }

    public void postMessagePredict(final String content, final String toChatUsername) {
        if (!ChatClient.getInstance().isShowMessagePredict || TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)toChatUsername)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OfficialAccount officialAccount = ChatManager.this.getConversation(toChatUsername).officialAccount();
                if (officialAccount == null) {
                    officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                }
                if (officialAccount != null && officialAccount.getId() != null) {
                    ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                    if (info == null || info.session_id == null) {
                        EMLog.i((String)ChatManager.TAG, (String)"sessionid is null");
                    } else {
                        MarketingHttpClient.postMessagePredict(content, info, new ValueCallBack<String>(){

                            @Override
                            public void onSuccess(String value) {
                            }

                            @Override
                            public void onError(int error, String errorMsg) {
                            }
                        });
                    }
                }
            }
        }).start();
    }

    public void bindChat(String toChatUsername) {
        if (TextUtils.isEmpty((CharSequence)toChatUsername)) {
            return;
        }
        currentChatUsername = toChatUsername;
        KefuPolling.startPolling(toChatUsername);
        this.showVisitorWaitCountAndAgentInputState(toChatUsername);
    }

    @Deprecated
    public void bindChatUI(String toChatUsername) {
        this.bindChat(toChatUsername);
    }

    private void sendDeviceInfo(String target) {
        if (ChatClient.getInstance().tenantId() != null) {
            KefuHttpClient.asyncSendDeviceInfo(ChatClient.getInstance().tenantId(), target, new ValueCallBack<String>(){

                @Override
                public void onSuccess(String value) {
                    Log.d(ChatManager.TAG, "value:" + value);
                }

                @Override
                public void onError(int error, String errorMsg) {
                    Log.e(ChatManager.TAG, "error:" + errorMsg);
                }
            });
        }
    }

    public void unbindChat() {
        KefuPolling.stopPolling();
        this.shutdownWaitAndInput();
        if (!TextUtils.isEmpty((CharSequence)MarketingHttpClient.currentConversationId)) {
            this.getConversation(MarketingHttpClient.currentConversationId).setConversationInfo(null);
        }
        currentChatUsername = null;
    }

    @Deprecated
    public void unBind() {
        this.unbindChat();
    }

    private void shutdownWaitAndInput() {
        this.shutdownVisitorWaitThread();
        this.shutdownAgentInputThread();
    }

    public void addMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.messageListeners.contains(listener)) {
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        if (this.messageListeners.contains(listener)) {
            this.messageListeners.remove(listener);
        }
    }

    public void addAgentInputListener(AgentInputListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.agentInputListeners.contains(listener)) {
            this.agentInputListeners.add(listener);
        }
    }

    public void removeAgentInputListener(AgentInputListener listener) {
        if (listener == null) {
            return;
        }
        if (this.agentInputListeners.contains(listener)) {
            this.agentInputListeners.remove(listener);
        }
    }

    public void addVisitorWaitListener(VisitorWaitListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.visitorWaitCountListeners.contains(listener)) {
            this.visitorWaitCountListeners.add(listener);
        }
    }

    public void removeVisitorWaitListener(VisitorWaitListener listener) {
        if (listener == null) {
            return;
        }
        if (this.visitorWaitCountListeners.contains(listener)) {
            this.visitorWaitCountListeners.remove(listener);
        }
    }

    private String checkKefuMessageAck(Message message) {
        try {
            String msgIdForAck;
            JSONObject jsonExt = message.getJSONObjectAttribute("weichat");
            if (jsonExt != null && !TextUtils.isEmpty((CharSequence)(msgIdForAck = jsonExt.getString("ack_for_msg_id"))) && !msgIdForAck.equals("null")) {
                return msgIdForAck;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    String getKefuExtMsgId(Message message) {
        try {
            String msgIdForAck;
            JSONObject jsonExt = message.getJSONObjectAttribute("weichat");
            if (jsonExt != null && !TextUtils.isEmpty((CharSequence)(msgIdForAck = jsonExt.getString("msgId"))) && !msgIdForAck.equals("null")) {
                return msgIdForAck;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void resendMessage(Message msg) {
        msg.setStatus(Message.Status.CREATE);
        this.sendMessage(msg);
    }

    @Deprecated
    public void reSendMessage(Message msg) {
        this.resendMessage(msg);
    }

    public void setMessageListened(Message message) {
        message.setListened(true);
        KefuDBManager.getInstance().updateMessageListened(message.messageId(), true);
    }

    public Message getMessage(String messageId) {
        return KefuConversationManager.getInstance().getMessage(messageId);
    }

    void addMessage(Message msg) {
        KefuConversationManager.getInstance().addMessage(msg);
    }

    void addMessage(Message msg, boolean unreadCountIncrease) {
        KefuConversationManager.getInstance().addMessage(msg, unreadCountIncrease);
    }

    public Conversation getConversation(String conversationId) {
        return KefuConversationManager.getInstance().getConversation(conversationId);
    }

    public boolean deleteConversation(String username, boolean deleteMessages) {
        EMClient.getInstance().chatManager().deleteConversation(username, deleteMessages);
        return KefuConversationManager.getInstance().removeConversation(username, deleteMessages);
    }

    public void markAllConversationsAsRead() {
        KefuConversationManager.getInstance().resetAllUnreadMsgCount();
    }

    private void loadAllConversations() {
        KefuConversationManager.getInstance().loadAllConversations();
    }

    public Hashtable<String, Conversation> getAllConversations() {
        return KefuConversationManager.getInstance().getAllConversations();
    }

    public int getUnreadMsgsCount() {
        return KefuConversationManager.getInstance().getUnreadMsgsCount();
    }

    public void saveMessage(Message message) {
        KefuConversationManager.getInstance().saveMessage(message);
    }

    public boolean updateMessageBody(Message message) {
        return KefuDBManager.getInstance().updateMessageBody(message);
    }

    private void updateMessageState(Message message) {
        ContentValues cvs = new ContentValues();
        cvs.put("status", message.status().ordinal() + "");
        KefuDBManager.getInstance().updateMessage(message.messageId(), cvs);
    }

    private void updateMessageStatusAndMsgId(Message message) {
        ContentValues cvs = new ContentValues();
        cvs.put("status", message.status().ordinal() + "");
        cvs.put("immsgid", message.getIMMsgId());
        cvs.put("msgtime", Long.valueOf(message.messageTime()));
        KefuDBManager.getInstance().updateMessage(message.messageId(), cvs);
    }

    public void downloadAttachment(final Message message) {
        if (!(message.body() instanceof EMFileMessageBody)) {
            EMLog.d((String)TAG, (String)"download file msg body is not FileMessageBody");
            return;
        }
        EMFileMessageBody msgBody = (EMFileMessageBody)message.body();
        final String remoteUrl = msgBody.getRemoteUrl();
        String localPath = msgBody.getLocalUrl();
        if (TextUtils.isEmpty((CharSequence)remoteUrl) || TextUtils.isEmpty((CharSequence)localPath)) {
            EMLog.d((String)TAG, (String)"download file remoteUrl or localPath is empty");
            return;
        }
        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, false);
        this.downloadThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    try {
                        requestBuilder.to(tempLocalFile, new ProgressListener(){

                            @Override
                            public void loadProgress(long progress) {
                                if (message.messageStatusCallBack != null && progress < 100L) {
                                    message.messageStatusCallBack.onProgress((int)progress, "progress");
                                }
                            }
                        });
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "rfile download failed");
                            }
                            return;
                        }
                        int status = httpResponse.getStatusCode();
                        if (status / 100 == 2) {
                            tempLocalFile.renameTo(localFile);
                            ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, false);
                            ChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onSuccess();
                            }
                        } else {
                            ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                            ChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "file download failed");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                        ChatManager.this.updateMessageBody(message);
                        if (message.messageStatusCallBack == null) break block8;
                        message.messageStatusCallBack.onError(403, "file download failed");
                    }
                }
            }
        });
    }

    void downloadAttachments(Message message, boolean isThumbnail) {
        if (isThumbnail) {
            this.downloadThumbnail(message);
        } else {
            this.downloadAttachment(message);
        }
    }

    public void downloadThumbnail(final Message message) {
        String localPath;
        String remoteUrl;
        EMImageMessageBody msgBody;
        if (message.body() instanceof EMImageMessageBody) {
            msgBody = (EMImageMessageBody)message.body();
            remoteUrl = msgBody.getRemoteUrl();
            localPath = msgBody.thumbnailLocalPath();
        } else if (message.body() instanceof EMVideoMessageBody) {
            msgBody = (EMVideoMessageBody)message.body();
            remoteUrl = msgBody.getThumbnailUrl();
            localPath = msgBody.getLocalThumb();
        } else {
            EMLog.d((String)TAG, (String)"download file msg body is not ImageMessageBody or EMVideoMessageBody");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)remoteUrl) || TextUtils.isEmpty((CharSequence)localPath)) {
            EMLog.d((String)TAG, (String)"download file remoteUrl or localPath is empty");
            return;
        }
        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, true);
        this.downloadThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.param("thumbnail", "true");
                    try {
                        requestBuilder.to(tempLocalFile);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "rfile download failed");
                            }
                            return;
                        }
                        int status = httpResponse.getStatusCode();
                        if (status / 100 == 2) {
                            tempLocalFile.renameTo(localFile);
                            ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, true);
                            ChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onSuccess();
                            }
                        } else {
                            ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                            ChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "file download failed");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                        ChatManager.this.updateMessageBody(message);
                        if (message.messageStatusCallBack == null) break block8;
                        message.messageStatusCallBack.onError(403, "file download failed");
                    }
                }
            }
        });
    }

    private void updateMessageBodyDownloadStatus(Message message, EMFileMessageBody.EMDownloadStatus status, boolean isThumbnail) {
        switch (message.getType()) {
            case FILE: 
            case VOICE: {
                EMFileMessageBody fileBody = (EMFileMessageBody)message.body();
                fileBody.setDownloadStatus(status);
                break;
            }
            case IMAGE: {
                EMImageMessageBody imgBody = (EMImageMessageBody)message.body();
                if (isThumbnail) {
                    imgBody.setThumbnailDownloadStatus(status);
                    break;
                }
                imgBody.setDownloadStatus(status);
                break;
            }
        }
    }

    public void asyncSendInviteEvaluationMessage(final String toUser, final Callback callback) {
        KefuHttpClient.asyncGetInviteEvaluation(toUser, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                block7: {
                    try {
                        JSONObject jsonObject = new JSONObject(value);
                        String status = jsonObject.getString("status");
                        if (!"OK".equalsIgnoreCase(status)) {
                            if (callback != null) {
                                callback.onError(-1, "server is error");
                            }
                            return;
                        }
                        JSONArray jsonEntites = jsonObject.getJSONArray("entities");
                        Message message = Message.createReceiveMessage(Message.Type.TXT);
                        message.addBody((EMMessageBody)new EMTextMessageBody(""));
                        JSONObject weichatJson = new JSONObject();
                        weichatJson.put("ctrlType", (Object)"inviteEnquiry");
                        JSONObject ctrlArgsJson = new JSONObject();
                        ctrlArgsJson.put("inviteId", 0);
                        ConversationInfo conversationInfo = ChatManager.this.getConversation(toUser).getConversationInfo();
                        if (conversationInfo != null) {
                            ctrlArgsJson.put("serviceSessionId", (Object)conversationInfo.session_id);
                        }
                        ctrlArgsJson.put("evaluationDegree", (Object)jsonEntites);
                        weichatJson.put("ctrlArgs", (Object)ctrlArgsJson);
                        JSONObject officialAccountJson = new JSONObject();
                        OfficialAccount officialAccount = ChatManager.this.getConversation(toUser).officialAccount();
                        if (officialAccount != null && officialAccount.getId() != null) {
                            officialAccountJson.put("official_account_id", (Object)officialAccount.getId());
                        }
                        weichatJson.put("official_account", (Object)officialAccountJson);
                        message.setAttribute("weichat", weichatJson);
                        message.setMessageTime(System.currentTimeMillis());
                        message.setMsgId(UUID.randomUUID().toString());
                        message.setFrom(toUser);
                        ChatManager.this.saveMessage(message);
                        ChatManager.this.notifyMessageSent();
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block7;
                        callback.onError(-1, "invite evaluation message error:" + e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    public void clearConversation(String username) {
        KefuConversationManager.getInstance().clearConversation(username);
    }

    public void getEnterpriseWelcome(ValueCallBack<String> callback) {
        KefuHttpClient.getEnterpriseWelcome(callback);
    }

    public void getRobotWelcome(ValueCallBack<JSONObject> callBack) {
        KefuHttpClient.getRobotWelcome(callBack);
    }

    public void getCurrentSessionId(String toChatUsername, final ValueCallBack<String> callback) {
        KefuHttpClient.getCurrentSessionStatus(toChatUsername, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                if (callback != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(value);
                        String status = jsonObject.getString("status");
                        if (status != null && status.equalsIgnoreCase("ok")) {
                            JSONArray entityArr = jsonObject.getJSONArray("entities");
                            if (entityArr != null && entityArr.length() > 0) {
                                callback.onSuccess(entityArr.getString(0));
                            } else {
                                callback.onSuccess("");
                            }
                        } else {
                            String description = jsonObject.getString("errorDescription");
                            callback.onError(-1, description);
                        }
                    }
                    catch (Exception e) {
                        callback.onError(-1, "request failed:" + android.util.Log.getStackTraceString((Throwable)e));
                    }
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    public void cancelVideoConferences(final String toChatUsername, final ValueCallBack<String> callBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OfficialAccount officialAccount = ChatManager.this.getConversation(toChatUsername).officialAccount();
                if (officialAccount == null) {
                    officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                }
                if (officialAccount != null && officialAccount.getId() != null) {
                    ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                    if (info == null || info.session_id == null) {
                        EMLog.e((String)ChatManager.TAG, (String)"sessionid is null");
                        if (callBack != null) {
                            callBack.onError(-1, "session is null");
                        }
                    } else {
                        KefuHttpClient.asyncCancelVideoConferences(info.session_id, callBack);
                    }
                }
            }
        }).start();
    }

    public static interface VisitorWaitListener {
        public void waitCount(int var1);
    }

    public static interface AgentInputListener {
        public void onInputState(String var1);
    }

    public static interface MessageListener {
        public void onMessage(List<Message> var1);

        public void onCmdMessage(List<Message> var1);

        public void onMessageStatusUpdate();

        public void onMessageSent();
    }
}

