/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.util.EMLog;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KefuMessageEncoder {
    private static final String TAG = "kefu encoder";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_MSG = "msg";
    public static final String ATTR_URL = "url";
    public static final String ATTR_LOCALURL = "localurl";
    public static final String ATTR_THUMB_LOCALURL = "thumblocalurl";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_THUMBNAIL = "thumb";
    public static final String ATTR_SECRET = "secret";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_IMG_WIDTH = "width";
    public static final String ATTR_IMG_HEIGHT = "height";
    public static final String ATTR_THUMBNAIL_SECRET = "thumb_secret";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_ADDRESS = "addr";
    public static final String ATTR_LATITUDE = "lat";
    public static final String ATTR_LONGITUDE = "lng";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_FILE_LENGTH = "file_length";
    public static final String ATTR_EXT = "ext";
    private static final String ATTR_TYPE_TXT = "txt";
    private static final String ATTR_TYPE_IMG = "img";
    private static final String ATTR_TYPE_VOICE = "audio";
    private static final String ATTR_TYPE_VIDEO = "video";
    private static final String ATTR_TYPE_LOCATION = "loc";
    private static final String ATTR_TYPE_CMD = "cmd";
    private static final String ATTR_TYPE_file = "file";

    public static String getJSONMsg(Message msg, boolean all) {
        StringBuffer jsonString = new StringBuffer();
        jsonString.append("{");
        jsonString.append("\"from\":\"" + msg.from() + "\",");
        jsonString.append("\"to\":\"" + msg.to() + "\",");
        jsonString.append("\"bodies\":[{");
        if (msg.type == Message.Type.TXT) {
            KefuMessageEncoder.addTextBody(jsonString, msg);
        } else if (msg.type == Message.Type.IMAGE) {
            KefuMessageEncoder.addImageBody(jsonString, msg, all);
        } else if (msg.type == Message.Type.VOICE) {
            KefuMessageEncoder.addVoiceBody(jsonString, msg, all);
        } else if (msg.type == Message.Type.LOCATION) {
            KefuMessageEncoder.addLocationBody(jsonString, msg);
        } else if (msg.type == Message.Type.CMD) {
            KefuMessageEncoder.addCmdBody(jsonString, msg);
        } else if (msg.type == Message.Type.VIDEO) {
            KefuMessageEncoder.addVideoBody(jsonString, msg, all);
        } else if (msg.type == Message.Type.FILE) {
            KefuMessageEncoder.addFileBody(jsonString, msg, all);
        }
        jsonString.append("}]");
        if (msg.attributes != null) {
            KefuMessageEncoder.addExtAttr(jsonString, msg);
        }
        jsonString.append("}");
        return jsonString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addExtAttr(StringBuffer jsonString, Message msg) {
        jsonString.append(",");
        jsonString.append("\"ext\":");
        JSONObject extValueObj = new JSONObject();
        try {
            Hashtable<String, Object> hashtable = msg.attributes;
            synchronized (hashtable) {
                for (String attr : msg.attributes.keySet()) {
                    Object value = msg.attributes.get(attr);
                    if (value instanceof String) {
                        String valStr = (String)value;
                        if (valStr.startsWith("{") && valStr.endsWith("}") && valStr.contains(":")) {
                            value = new JSONObject(valStr);
                        } else if (valStr.startsWith("[{") && valStr.endsWith("}]") && valStr.contains(":")) {
                            value = new JSONArray(valStr);
                        }
                    }
                    extValueObj.put(attr, value);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String extObjStr = extValueObj.toString();
        jsonString.append(extObjStr);
    }

    private static void addImageBody(StringBuffer jsonString, Message msg, boolean all) {
        String secret;
        String thumbnailUrl;
        String fileName;
        jsonString.append("\"type\":\"img\",");
        EMImageMessageBody imgBody = (EMImageMessageBody)msg.body();
        String remoteUrl = imgBody.getRemoteUrl();
        if (remoteUrl != null) {
            jsonString.append("\"url\":\"" + remoteUrl + "\",");
        }
        if (all) {
            String localThumb;
            String localUrl = imgBody.getLocalUrl();
            if (localUrl != null) {
                jsonString.append("\"localurl\":\"" + localUrl + "\",");
            }
            if ((localThumb = imgBody.thumbnailLocalPath()) != null) {
                jsonString.append("\"thumblocalurl\":\"" + localThumb + "\",");
            }
        }
        if ((fileName = imgBody.getFileName()) != null) {
            jsonString.append("\"filename\":\"" + fileName + "\",");
        }
        if ((thumbnailUrl = imgBody.getThumbnailUrl()) != null) {
            jsonString.append("\"thumb\":\"" + thumbnailUrl + "\",");
        }
        if ((secret = imgBody.getSecret()) != null) {
            jsonString.append("\"secret\":\"" + secret + "\",");
        }
        jsonString.append("\"size\":{\"width\":" + imgBody.getWidth() + ",\"" + ATTR_IMG_HEIGHT + "\":" + imgBody.getHeight() + "}");
        String thumbnailSecret = imgBody.getThumbnailSecret();
        if (thumbnailSecret != null) {
            jsonString.append(",\"thumb_secret\":\"" + thumbnailSecret + "\"");
        }
    }

    private static void addVideoBody(StringBuffer jsonString, Message msg, boolean all) {
        String thumbSecret;
        String thumbnailUrl;
        String fileName;
        jsonString.append("\"type\":\"video\",");
        EMVideoMessageBody videoBody = (EMVideoMessageBody)msg.body();
        jsonString.append("\"url\":\"" + videoBody.getRemoteUrl() + "\",");
        if (all) {
            String localUrl = videoBody.getLocalUrl();
            String localThumb = videoBody.getLocalThumb();
            if (localUrl != null) {
                jsonString.append("\"localurl\":\"" + localUrl + "\",");
            }
            if (localThumb != null) {
                jsonString.append("\"thumblocalurl\":\"" + localThumb + "\",");
            }
        }
        if ((fileName = videoBody.getFileName()) != null) {
            jsonString.append("\"filename\":\"" + fileName + "\",");
        }
        if ((thumbnailUrl = videoBody.getThumbnailUrl()) != null) {
            jsonString.append("\"thumb\":\"" + thumbnailUrl + "\",");
        }
        jsonString.append("\"length\":" + videoBody.getDuration() + ",");
        jsonString.append("\"file_length\":" + videoBody.getVideoFileLength() + ",");
        String secret = videoBody.getSecret();
        if (secret != null) {
            jsonString.append("\"secret\":\"" + secret + "\"");
        }
        if ((thumbSecret = videoBody.getThumbnailSecret()) != null) {
            jsonString.append(",\"thumb_secret\":\"" + thumbSecret + "\"");
        }
    }

    private static void addTextBody(StringBuffer jsonString, Message msg) {
        jsonString.append("\"type\":\"txt\",");
        EMTextMessageBody textBody = (EMTextMessageBody)msg.body();
        String msgString = textBody.getMessage();
        msgString = JSONObject.quote((String)msgString);
        if (msgString.startsWith("{") && msgString.endsWith("}") || msgString.startsWith("[") && msgString.endsWith("]")) {
            msgString = msgString.replaceAll("\"", "%22");
            jsonString.append("\"msg\":\"" + msgString + "\"");
        }
        jsonString.append("\"msg\":" + msgString);
    }

    private static void addCmdBody(StringBuffer jsonString, Message msg) {
        jsonString.append("\"type\":\"cmd\",");
        EMCmdMessageBody cmdBody = (EMCmdMessageBody)msg.body();
        jsonString.append("\"action\":\"" + cmdBody.action() + "\"]");
    }

    private static void addVoiceBody(StringBuffer jsonString, Message msg, boolean all) {
        String localUrl;
        jsonString.append("\"type\":\"audio\",");
        EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)msg.body();
        String remoteUrl = voiceBody.getRemoteUrl();
        if (remoteUrl != null) {
            jsonString.append("\"url\":\"" + remoteUrl + "\",");
        }
        if (all && (localUrl = voiceBody.getLocalUrl()) != null) {
            jsonString.append("\"localurl\":\"" + localUrl + "\",");
        }
        jsonString.append("\"filename\":\"" + voiceBody.getFileName() + "\",");
        jsonString.append("\"length\":" + voiceBody.getLength() + ",");
        String secret = voiceBody.getSecret();
        if (secret != null) {
            jsonString.append("\"secret\":\"" + secret + "\"");
        }
    }

    private static void addFileBody(StringBuffer jsonString, Message msg, boolean all) {
        String fileName;
        String localUrl;
        jsonString.append("\"type\":\"file\",");
        EMNormalFileMessageBody fileMessageBody = (EMNormalFileMessageBody)msg.body();
        String remoteUrl = fileMessageBody.getRemoteUrl();
        if (remoteUrl != null) {
            jsonString.append("\"url\":\"" + remoteUrl + "\",");
        }
        if (all && (localUrl = fileMessageBody.getLocalUrl()) != null) {
            jsonString.append("\"localurl\":\"" + localUrl + "\",");
        }
        if ((fileName = fileMessageBody.getFileName()) != null) {
            jsonString.append("\"filename\":\"" + fileName + "\",");
        }
        jsonString.append("\"file_length\":" + fileMessageBody.getFileSize() + ",");
        String secret = fileMessageBody.getSecret();
        if (secret != null) {
            jsonString.append("\"secret\":\"" + secret + "\"");
        }
    }

    private static void addLocationBody(StringBuffer jsonString, Message msg) {
        jsonString.append("\"type\":\"loc\",");
        EMLocationMessageBody locationBody = (EMLocationMessageBody)msg.body();
        String address = locationBody.getAddress();
        if (address != null) {
            jsonString.append("\"addr\":\"" + locationBody.getAddress() + "\",");
        }
        jsonString.append("\"lat\":" + locationBody.getLatitude() + ",");
        jsonString.append("\"lng\":" + locationBody.getLongitude() + "");
    }

    public static Message getMsgFromJson(String jsonString) {
        try {
            String remoteUrl;
            JSONObject jsonPayload = new JSONObject(jsonString);
            String from = jsonPayload.getString(ATTR_FROM);
            String to = jsonPayload.getString(ATTR_TO);
            JSONArray bodies = jsonPayload.getJSONArray("bodies");
            if (bodies.length() < 1) {
                EMLog.d((String)TAG, (String)"wrong msg without body");
                return null;
            }
            JSONObject bodyJson = bodies.getJSONObject(0);
            String type = bodyJson.getString(ATTR_TYPE);
            Message msg = null;
            if (type.equals(ATTR_TYPE_TXT)) {
                msg = new Message(Message.Type.TXT);
                String bodyString = bodyJson.getString(ATTR_MSG);
                String decodeString = bodyString.replaceAll("%22", "\"");
                EMTextMessageBody body = new EMTextMessageBody(decodeString);
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_IMG)) {
                msg = new Message(Message.Type.IMAGE);
                remoteUrl = null;
                String fileName = null;
                if (bodyJson.has(ATTR_URL)) {
                    remoteUrl = bodyJson.getString(ATTR_URL);
                }
                if (bodyJson.has(ATTR_FILENAME)) {
                    fileName = bodyJson.getString(ATTR_FILENAME);
                }
                String thumbnailUrl = remoteUrl;
                if (bodyJson.has(ATTR_THUMBNAIL)) {
                    thumbnailUrl = bodyJson.getString(ATTR_THUMBNAIL);
                }
                EMImageMessageBody body = new EMImageMessageBody(fileName, remoteUrl, thumbnailUrl);
                if (bodyJson.has(ATTR_LOCALURL)) {
                    body.setLocalUrl(bodyJson.getString(ATTR_LOCALURL));
                }
                if (bodyJson.has(ATTR_SECRET)) {
                    body.setSecret(bodyJson.getString(ATTR_SECRET));
                }
                if (bodyJson.has(ATTR_THUMBNAIL_SECRET)) {
                    body.setThumbnailSecret(bodyJson.getString(ATTR_THUMBNAIL_SECRET));
                }
                if (bodyJson.has(ATTR_THUMB_LOCALURL)) {
                    body.setThumbnailLocalPath(bodyJson.getString(ATTR_THUMB_LOCALURL));
                }
                if (bodyJson.has(ATTR_SIZE)) {
                    JSONObject sizeJson = bodyJson.getJSONObject(ATTR_SIZE);
                    int width = 0;
                    int height = 0;
                    if (sizeJson.has(ATTR_IMG_WIDTH)) {
                        width = sizeJson.getInt(ATTR_IMG_WIDTH);
                        height = sizeJson.getInt(ATTR_IMG_HEIGHT);
                    }
                    body.setSize(width, height);
                }
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_file)) {
                msg = new Message(Message.Type.FILE);
                remoteUrl = null;
                String fileName = null;
                if (bodyJson.has(ATTR_URL)) {
                    remoteUrl = bodyJson.getString(ATTR_URL);
                }
                if (bodyJson.has(ATTR_FILENAME)) {
                    fileName = bodyJson.getString(ATTR_FILENAME);
                }
                EMNormalFileMessageBody body = new EMNormalFileMessageBody(fileName, remoteUrl);
                long fileLength = 0L;
                if (bodyJson.has(ATTR_FILE_LENGTH)) {
                    fileLength = bodyJson.getLong(ATTR_FILE_LENGTH);
                }
                body.setFileLength(fileLength);
                String localUrl = null;
                String secret = null;
                if (bodyJson.has(ATTR_LOCALURL)) {
                    localUrl = bodyJson.getString(ATTR_LOCALURL);
                }
                if (bodyJson.has(ATTR_SECRET)) {
                    secret = bodyJson.getString(ATTR_SECRET);
                }
                body.setLocalUrl(localUrl);
                body.setSecret(secret);
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_VIDEO)) {
                msg = new Message(Message.Type.VIDEO);
                remoteUrl = null;
                String fileName = null;
                String thumbnailUrl = null;
                int length = 0;
                if (bodyJson.has(ATTR_URL)) {
                    remoteUrl = bodyJson.getString(ATTR_URL);
                }
                if (bodyJson.has(ATTR_FILENAME)) {
                    fileName = bodyJson.getString(ATTR_FILENAME);
                }
                if (bodyJson.has(ATTR_THUMBNAIL)) {
                    thumbnailUrl = bodyJson.getString(ATTR_THUMBNAIL);
                }
                if (bodyJson.has(ATTR_LENGTH)) {
                    length = bodyJson.getInt(ATTR_LENGTH);
                }
                EMVideoMessageBody body = new EMVideoMessageBody(fileName, remoteUrl, thumbnailUrl, length);
                String localUrl = null;
                String localThumb = null;
                String secret = null;
                String thumbSecret = null;
                long fileLength = 0L;
                if (bodyJson.has(ATTR_LOCALURL)) {
                    localUrl = bodyJson.getString(ATTR_LOCALURL);
                }
                if (bodyJson.has(ATTR_FILE_LENGTH)) {
                    fileLength = bodyJson.getLong(ATTR_FILE_LENGTH);
                }
                if (bodyJson.has(ATTR_THUMB_LOCALURL)) {
                    localThumb = bodyJson.getString(ATTR_THUMB_LOCALURL);
                }
                if (bodyJson.has(ATTR_SECRET)) {
                    secret = bodyJson.getString(ATTR_SECRET);
                }
                if (bodyJson.has(ATTR_THUMBNAIL_SECRET)) {
                    thumbSecret = bodyJson.getString(ATTR_THUMBNAIL_SECRET);
                }
                body.setLocalUrl(localUrl);
                body.setLocalThumb(localThumb);
                body.setFileLength(fileLength);
                body.setSecret(secret);
                body.setThumbnailSecret(thumbSecret);
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_VOICE)) {
                msg = new Message(Message.Type.VOICE);
                remoteUrl = null;
                String fileName = null;
                int length = 0;
                if (bodyJson.has(ATTR_URL)) {
                    remoteUrl = bodyJson.getString(ATTR_URL);
                }
                if (bodyJson.has(ATTR_FILENAME)) {
                    fileName = bodyJson.getString(ATTR_FILENAME);
                }
                if (bodyJson.has(ATTR_LENGTH)) {
                    length = bodyJson.getInt(ATTR_LENGTH);
                }
                EMVoiceMessageBody body = new EMVoiceMessageBody(fileName, remoteUrl, length);
                String localUrl = null;
                String secret = null;
                if (bodyJson.has(ATTR_LOCALURL)) {
                    localUrl = bodyJson.getString(ATTR_LOCALURL);
                }
                if (bodyJson.has(ATTR_SECRET)) {
                    secret = bodyJson.getString(ATTR_SECRET);
                }
                body.setLocalUrl(localUrl);
                body.setSecret(secret);
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_LOCATION)) {
                msg = new Message(Message.Type.LOCATION);
                String address = null;
                double latitude = 0.0;
                double longitude = 0.0;
                if (bodyJson.has(ATTR_ADDRESS)) {
                    address = bodyJson.getString(ATTR_ADDRESS);
                }
                if (bodyJson.has(ATTR_LATITUDE)) {
                    latitude = bodyJson.getDouble(ATTR_LATITUDE);
                }
                if (bodyJson.has(ATTR_LONGITUDE)) {
                    longitude = bodyJson.getDouble(ATTR_LONGITUDE);
                }
                EMLocationMessageBody body = new EMLocationMessageBody(address, latitude, longitude);
                msg.setBody((EMMessageBody)body);
            } else if (type.equals(ATTR_TYPE_CMD)) {
                msg = new Message(Message.Type.CMD);
                String action = "";
                if (bodyJson.has(ATTR_ACTION)) {
                    action = bodyJson.getString(ATTR_ACTION);
                }
                EMCmdMessageBody body = new EMCmdMessageBody(action);
                msg.setBody((EMMessageBody)body);
            }
            if (msg == null) {
                return null;
            }
            msg.setFrom(from);
            msg.setTo(to);
            if (jsonPayload.has(ATTR_EXT)) {
                JSONObject extAttrObj = jsonPayload.getJSONObject(ATTR_EXT);
                Iterator iter = extAttrObj.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object obj = extAttrObj.get(key);
                    if (obj instanceof String) {
                        msg.setAttribute(key, (String)obj);
                        continue;
                    }
                    if (obj instanceof Integer) {
                        msg.setAttribute(key, (Integer)obj);
                        continue;
                    }
                    if (obj instanceof Long) {
                        msg.setAttribute(key, (Long)obj);
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        msg.setAttribute(key, (Boolean)obj);
                        continue;
                    }
                    if (obj instanceof JSONObject) {
                        msg.setAttribute(key, (JSONObject)obj);
                        continue;
                    }
                    if (obj instanceof JSONArray) {
                        msg.setAttribute(key, (JSONArray)obj);
                        continue;
                    }
                    EMLog.e((String)ATTR_MSG, (String)("unknow additonal msg attr:" + obj.getClass().getName()));
                }
            }
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

