/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.KefuConversationManager;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.KefuHttpClient;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.model.MessageHelper;
import com.hyphenate.helpdesk.util.HtmlUtil;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class KefuPolling {
    private static final String TAG = "kefu service";
    private static final int INTERVAL_SECOND = 10;
    private static ExecutorService singleThreadPool = Executors.newSingleThreadExecutor();
    private static volatile boolean isCancel = false;

    KefuPolling() {
    }

    private static String getEMMessageExtMsgId(Message message) {
        return ChatClient.getInstance().chatManager().getKefuExtMsgId(message);
    }

    static void startPolling(final String toUsername) {
        if (TextUtils.isEmpty((CharSequence)toUsername)) {
            return;
        }
        EMLog.d((String)TAG, (String)"startPolling");
        isCancel = false;
        singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                while (!isCancel) {
                    try {
                        KefuHttpClient.receiveMessages(toUsername, new EMValueCallBack<String>(){

                            public void onSuccess(String value) {
                                EMLog.d((String)"kefu receive", (String)("message:" + value));
                                try {
                                    JSONObject jsonValue = new JSONObject(HtmlUtil.htmlspecialchars_decode_END_NOQUOTES(value));
                                    String status = jsonValue.optString("status", "");
                                    if (!status.equalsIgnoreCase("OK")) {
                                        return;
                                    }
                                    JSONArray jsonEntities = jsonValue.getJSONArray("entities");
                                    if (jsonEntities == null || jsonEntities.length() == 0) {
                                        return;
                                    }
                                    ArrayList<Message> msgList = new ArrayList<Message>();
                                    ArrayList<Message> cmdMsgList = new ArrayList<Message>();
                                    for (int k = 0; k < jsonEntities.length(); ++k) {
                                        String fileName;
                                        String url;
                                        Message message;
                                        JSONObject jsonEntityOne = jsonEntities.getJSONObject(k);
                                        JSONArray jsonMsgBodys = jsonEntityOne.getJSONArray("bodies");
                                        JSONObject jsonExt = jsonEntityOne.getJSONObject("ext");
                                        String fromParam = jsonEntityOne.getString("from");
                                        String toParam = jsonEntityOne.getString("to");
                                        JSONObject jsonMsgBody = jsonMsgBodys.getJSONObject(0);
                                        String type = jsonMsgBody.getString("type");
                                        long timestamp = jsonMsgBody.optLong("timestamp", System.currentTimeMillis());
                                        if (type.equalsIgnoreCase("txt")) {
                                            String txtMsg = jsonMsgBody.getString("msg");
                                            if (!toParam.equals(ChatClient.getInstance().currentUserName())) continue;
                                            message = Message.createReceiveMessage(Message.Type.TXT);
                                            message.setBody((EMMessageBody)new EMTextMessageBody(txtMsg));
                                            message.attributes = KefuPolling.json2Map(jsonExt);
                                            String extMsgId = KefuPolling.getEMMessageExtMsgId(message);
                                            message.setMsgId(extMsgId);
                                            message.setKefuReceived(true);
                                            message.setStatus(Message.Status.SUCCESS);
                                            message.setFrom(fromParam);
                                            message.setMessageTime(timestamp);
                                            KefuPolling.checkOfficialAccount(message);
                                            if (KefuConversationManager.getInstance().isRecalledMessage(extMsgId) || extMsgId == null) continue;
                                            boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                            EMLog.d((String)KefuPolling.TAG, (String)("msgId: " + extMsgId + " isExist:" + isExist));
                                            if (isExist) continue;
                                            if (!MessageHelper.isNotificationMessage(message)) {
                                                message.setUnread(true);
                                                KefuConversationManager.getInstance().saveMessage(message);
                                            }
                                            msgList.add(message);
                                            continue;
                                        }
                                        if (type.equalsIgnoreCase("img")) {
                                            JSONObject jsonSize;
                                            url = ChatClient.getInstance().kefuRestServer() + jsonMsgBody.getString("url");
                                            String mediaId = System.currentTimeMillis() + ".png";
                                            if (jsonMsgBody.has("mediaId")) {
                                                mediaId = jsonMsgBody.getString("mediaId");
                                            }
                                            String fileName2 = jsonMsgBody.has("filename") ? jsonMsgBody.getString("filename") : mediaId;
                                            int width = 0;
                                            int height = 0;
                                            if (jsonMsgBody.has("size") && (jsonSize = jsonMsgBody.getJSONObject("size")).has("width") && jsonSize.has("height")) {
                                                width = jsonSize.getInt("width");
                                                height = jsonSize.getInt("height");
                                            }
                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName2;
                                            String localPath = new File(PathUtil.getInstance().getImagePath(), localPathName).getPath();
                                            String tempLocalPathName = "thumb_" + localPathName;
                                            String thumbLocalPath = new File(PathUtil.getInstance().getImagePath(), tempLocalPathName).getPath();
                                            EMLog.d((String)KefuPolling.TAG, (String)("img local:" + localPath + ", thumb local" + thumbLocalPath));
                                            if (!toParam.equals(ChatClient.getInstance().currentUserName())) continue;
                                            Message message2 = Message.createReceiveMessage(Message.Type.IMAGE);
                                            message2.setFrom(fromParam);
                                            EMImageMessageBody imageMessageBody = new EMImageMessageBody(fileName2, url, url);
                                            imageMessageBody.setSize(width, height);
                                            imageMessageBody.setLocalUrl(localPath);
                                            imageMessageBody.setThumbnailLocalPath(thumbLocalPath);
                                            message2.setBody((EMMessageBody)imageMessageBody);
                                            message2.attributes = KefuPolling.json2Map(jsonExt);
                                            String extMsgId = KefuPolling.getEMMessageExtMsgId(message2);
                                            message2.setMsgId(extMsgId);
                                            message2.setKefuReceived(true);
                                            message2.setStatus(Message.Status.SUCCESS);
                                            message2.setMessageTime(timestamp);
                                            KefuPolling.checkOfficialAccount(message2);
                                            if (extMsgId == null) continue;
                                            boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                            EMLog.d((String)KefuPolling.TAG, (String)("msgId: " + extMsgId + " isExist:" + isExist));
                                            if (isExist) continue;
                                            if (!MessageHelper.isNotificationMessage(message2)) {
                                                ChatClient.getInstance().chatManager().downloadAttachments(message2, true);
                                                message2.setUnread(true);
                                                KefuConversationManager.getInstance().saveMessage(message2);
                                            }
                                            msgList.add(message2);
                                            continue;
                                        }
                                        if (type.equalsIgnoreCase("audio")) {
                                            url = jsonMsgBody.getString("url");
                                            if (!url.startsWith("http")) {
                                                url = ChatClient.getInstance().kefuRestServer() + url;
                                            }
                                            fileName = "";
                                            if (jsonMsgBody.has("filename")) {
                                                fileName = jsonMsgBody.getString("filename");
                                            }
                                            int length = 0;
                                            if (jsonMsgBody.has("length")) {
                                                length = jsonMsgBody.getInt("length");
                                            }
                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName;
                                            String localPath = new File(PathUtil.getInstance().getVoicePath(), localPathName).getPath();
                                            if (!toParam.equals(ChatClient.getInstance().currentUserName())) continue;
                                            Message message3 = Message.createReceiveMessage(Message.Type.VOICE);
                                            message3.setFrom(fromParam);
                                            EMVoiceMessageBody voiceMessageBody = new EMVoiceMessageBody(localPath, url, length);
                                            message3.setBody((EMMessageBody)voiceMessageBody);
                                            message3.attributes = KefuPolling.json2Map(jsonExt);
                                            String extMsgId = KefuPolling.getEMMessageExtMsgId(message3);
                                            message3.setMsgId(extMsgId);
                                            message3.setKefuReceived(true);
                                            message3.setStatus(Message.Status.SUCCESS);
                                            message3.setMessageTime(timestamp);
                                            KefuPolling.checkOfficialAccount(message3);
                                            if (extMsgId == null) continue;
                                            boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                            EMLog.d((String)KefuPolling.TAG, (String)("msgId: " + extMsgId + " isExist:" + isExist));
                                            if (isExist) continue;
                                            if (!MessageHelper.isNotificationMessage(message3)) {
                                                ChatClient.getInstance().chatManager().downloadAttachments(message3, false);
                                                message3.setUnread(true);
                                                KefuConversationManager.getInstance().saveMessage(message3);
                                            }
                                            msgList.add(message3);
                                            continue;
                                        }
                                        if (type.equalsIgnoreCase("file")) {
                                            url = jsonMsgBody.getString("url");
                                            if (!url.startsWith("http")) {
                                                url = ChatClient.getInstance().kefuRestServer() + url;
                                            }
                                            fileName = "";
                                            if (jsonMsgBody.has("filename")) {
                                                fileName = jsonMsgBody.getString("filename");
                                            }
                                            long fileLength = 0L;
                                            if (jsonMsgBody.has("file_length")) {
                                                fileLength = jsonMsgBody.getLong("file_length");
                                            }
                                            String localPathName = System.currentTimeMillis() + "_" + fromParam + "_" + fileName;
                                            String localPath = new File(PathUtil.getInstance().getFilePath(), localPathName).getPath();
                                            if (!toParam.equals(ChatClient.getInstance().currentUserName())) continue;
                                            Message message4 = Message.createReceiveMessage(Message.Type.FILE);
                                            message4.setFrom(fromParam);
                                            EMNormalFileMessageBody fileMessageBody = new EMNormalFileMessageBody(localPath, url);
                                            fileMessageBody.setFileLength(fileLength);
                                            fileMessageBody.setFileName(fileName);
                                            message4.setBody((EMMessageBody)fileMessageBody);
                                            message4.attributes = KefuPolling.json2Map(jsonExt);
                                            String extMsgId = KefuPolling.getEMMessageExtMsgId(message4);
                                            message4.setMsgId(extMsgId);
                                            message4.setKefuReceived(true);
                                            message4.setStatus(Message.Status.SUCCESS);
                                            message4.setMessageTime(timestamp);
                                            KefuPolling.checkOfficialAccount(message4);
                                            if (extMsgId == null) continue;
                                            boolean isExist = KefuDBManager.getInstance().isMessageExistedByExtMsgId(extMsgId);
                                            EMLog.d((String)KefuPolling.TAG, (String)("msgId: " + extMsgId + " isExist:" + isExist));
                                            if (isExist) continue;
                                            if (!MessageHelper.isNotificationMessage(message4)) {
                                                message4.setUnread(true);
                                                KefuConversationManager.getInstance().saveMessage(message4);
                                            }
                                            msgList.add(message4);
                                            continue;
                                        }
                                        if (type.equalsIgnoreCase("cmd")) {
                                            String action = jsonMsgBody.optString("action");
                                            message = Message.createReceiveMessage(Message.Type.CMD);
                                            message.setFrom(fromParam);
                                            message.setBody((EMMessageBody)new EMCmdMessageBody(action));
                                            message.attributes = KefuPolling.json2Map(jsonExt);
                                            String extMsgId = KefuPolling.getEMMessageExtMsgId(message);
                                            message.setMsgId(extMsgId);
                                            message.setKefuReceived(true);
                                            message.setStatus(Message.Status.SUCCESS);
                                            message.setMessageTime(timestamp);
                                            KefuPolling.checkOfficialAccount(message);
                                            if (KefuDBManager.getInstance().isExistCmdMessage(message.messageId())) continue;
                                            boolean isInserted = KefuDBManager.getInstance().insertCmdMessage(message);
                                            if (!isInserted) {
                                                Log.e(KefuPolling.TAG, "message insert failed:" + message.toString());
                                                continue;
                                            }
                                            if (ChatClient.getInstance().chatManager().isReCallCmdMessage(message)) {
                                                ChatClient.getInstance().chatManager().notifyReCallMessage(message);
                                                continue;
                                            }
                                            cmdMsgList.add(message);
                                            continue;
                                        }
                                        EMLog.e((String)KefuPolling.TAG, (String)("jsonMsgBody-else:" + jsonMsgBody.toString()));
                                    }
                                    if (msgList.size() > 0) {
                                        Collections.reverse(msgList);
                                        KefuPolling.asyncSendMarketingDelivered(msgList);
                                        ChatClient.getInstance().chatManager().publishNewMessage(msgList);
                                    }
                                    if (cmdMsgList.size() > 0) {
                                        ChatClient.getInstance().chatManager().publishCmdMessage(cmdMsgList);
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    EMLog.e((String)KefuPolling.TAG, (String)("jsonError:" + android.util.Log.getStackTraceString((Throwable)e)));
                                    EMLog.e((String)KefuPolling.TAG, (String)("jsonError:" + value));
                                }
                            }

                            public void onError(int error, String errorMsg) {
                                EMLog.e((String)KefuPolling.TAG, (String)("" + errorMsg));
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e((String)KefuPolling.TAG, (String)("" + e.getMessage()));
                    }
                    try {
                        Thread.sleep(10000L);
                        EMLog.v((String)KefuPolling.TAG, (String)"kefu ping...");
                    }
                    catch (InterruptedException ignored) {
                        EMLog.e((String)KefuPolling.TAG, (String)"sleep InterruptedException");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    private static void asyncSendMarketingDelivered(List<Message> msgList) {
        for (Message message : msgList) {
            String taskId = message.getMarketingTaskId();
            MarketingHttpClient.asyncDelivered(taskId, message.from());
        }
    }

    private static void checkOfficialAccount(Message message) {
        try {
            JSONObject weichatJson = message.getJSONObjectAttribute("weichat");
            if (weichatJson != null && weichatJson.has("official_account")) {
                JSONObject jsonOffAccount = weichatJson.getJSONObject("official_account");
                String offAccountId = jsonOffAccount.getString("official_account_id");
                String type = jsonOffAccount.getString("type");
                if (!TextUtils.isEmpty((CharSequence)offAccountId) && !type.equals("SYSTEM")) {
                    message.setFrom(message.from() + "#|" + offAccountId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getExtName(String s, char split) {
        int i = s.lastIndexOf(split);
        if (i == -1) {
            return "";
        }
        return s.substring(i + 1);
    }

    static void stopPolling() {
        EMLog.d((String)TAG, (String)"stopPolling");
        isCancel = true;
    }

    private static Hashtable<String, Object> json2Map(JSONObject jsonObj) {
        try {
            Iterator keyIter = jsonObj.keys();
            Hashtable<String, Object> valueMap = new Hashtable<String, Object>();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Object value = jsonObj.get(key);
                valueMap.put(key, value);
            }
            return valueMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

