/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.model.CompositeContent;
import com.hyphenate.helpdesk.model.Content;
import com.hyphenate.helpdesk.model.MessageHelper;
import com.hyphenate.helpdesk.model.ToCustomServiceInfo;
import com.hyphenate.util.EMLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Message
implements Parcelable,
Cloneable,
Comparable {
    private static final String TAG = "Message";
    public static final String KEY_WEICHAT = "weichat";
    public static final String KEY_MSGTYPE = "msgtype";
    Callback messageStatusCallBack;
    Type type;
    private Direct direct;
    Status status = Status.CREATE;
    String from;
    String to;
    EMMessageBody body;
    private String msgId;
    private String imMsgId;
    boolean isAcked = false;
    boolean isDelivered = false;
    long msgTime;
    private transient int progress = 0;
    Hashtable<String, Object> attributes = new Hashtable();
    private transient boolean unread = false;
    boolean isListened;
    private boolean kefuReceived;
    private int error = 0;
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel source) {
            return new Message(source);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    public int compareTo(Object another) {
        if (!(another instanceof Message)) {
            return 0;
        }
        if (this.msgTime == 0L || ((Message)another).messageTime() == 0L) {
            return 0;
        }
        if (this.msgTime > ((Message)another).messageTime()) {
            return 1;
        }
        if (this.msgTime < ((Message)another).messageTime()) {
            return -1;
        }
        return 0;
    }

    Message(Type type) {
        this.type = type;
        this.msgTime = System.currentTimeMillis();
    }

    void setKefuReceived(boolean isKefuReceived) {
        this.kefuReceived = isKefuReceived;
    }

    boolean kefuReceived() {
        return this.kefuReceived;
    }

    public Type getType() {
        return this.type;
    }

    public EMMessageBody body() {
        return this.body;
    }

    @Deprecated
    public EMMessageBody getBody() {
        return this.body();
    }

    public long messageTime() {
        return this.msgTime;
    }

    @Deprecated
    public long getMsgTime() {
        return this.messageTime();
    }

    public void setMessageTime(long msgTime) {
        this.msgTime = msgTime;
    }

    @Deprecated
    public void setMsgTime(long msgTime) {
        this.setMessageTime(msgTime);
    }

    public static Message createSendMessage(Type type) {
        Message msg = new Message(type);
        msg.direct = Direct.SEND;
        msg.from = ChatClient.getInstance().currentUserName();
        msg.setMsgId(UUID.randomUUID().toString());
        return msg;
    }

    public static Message createReceiveMessage(Type type) {
        Message msg = new Message(type);
        msg.direct = Direct.RECEIVE;
        msg.to = ChatClient.getInstance().currentUserName();
        return msg;
    }

    public static Message createTxtSendMessage(String content, String toUserName) {
        Message message = Message.createSendMessage(Type.TXT);
        EMTextMessageBody textBody = TextUtils.isEmpty((CharSequence)content) ? new EMTextMessageBody("") : new EMTextMessageBody(content);
        message.setBody((EMMessageBody)textBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createVideoInviteSendMessage(String content, String toUserName) {
        Message message = Message.createSendMessage(Type.TXT);
        EMTextMessageBody textBody = TextUtils.isEmpty((CharSequence)content) ? new EMTextMessageBody("") : new EMTextMessageBody(content);
        message.setBody((EMMessageBody)textBody);
        message.setTo(toUserName);
        JSONObject jsonInvit = new JSONObject();
        try {
            JSONObject jsonMsg = new JSONObject();
            jsonMsg.put("msg", (Object)content);
            String[] appKeyStr = ChatClient.getInstance().appKey().split("#");
            jsonMsg.put("orgName", (Object)appKeyStr[0]);
            jsonMsg.put("appName", (Object)appKeyStr[1]);
            jsonMsg.put("userName", (Object)ChatClient.getInstance().currentUserName());
            jsonMsg.put("resource", (Object)"mobile");
            jsonMsg.put("isNewInvitation", true);
            jsonInvit.put("liveStreamInvitation", (Object)jsonMsg);
            message.setAttribute(KEY_MSGTYPE, jsonInvit);
            message.setAttribute("type", "rtcmedia/video");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return message;
    }

    public static Message createVoiceSendMessage(String filePath, int timeLength, String toUserName) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            EMLog.e((String)TAG, (String)"voice filePath is null or empty");
            return null;
        }
        File voiceFile = new File(filePath);
        if (!voiceFile.exists()) {
            EMLog.e((String)TAG, (String)"voice file does not exists");
            return null;
        }
        Message message = Message.createSendMessage(Type.VOICE);
        EMVoiceMessageBody messageBody = new EMVoiceMessageBody(voiceFile, timeLength);
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createImageSendMessage(String filePath, boolean sendOriginalImage, String toUserName) {
        File imageFile = new File(filePath);
        if (!imageFile.exists()) {
            EMLog.e((String)TAG, (String)"image file does not exist");
            return null;
        }
        Message message = Message.createSendMessage(Type.IMAGE);
        EMImageMessageBody messageBody = new EMImageMessageBody(imageFile);
        messageBody.setSendOriginalImage(sendOriginalImage);
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createCustomEmojiSendMessage(String filePath, String toUserName) {
        Message message = Message.createSendMessage(Type.TXT);
        EMTextMessageBody messageBody = new EMTextMessageBody("");
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        JSONObject jsonEmoji = new JSONObject();
        try {
            JSONObject jsonMsg = new JSONObject();
            jsonMsg.put("url", (Object)filePath);
            jsonEmoji.put("customMagicEmoji", (Object)jsonMsg);
            message.setAttribute(KEY_MSGTYPE, jsonEmoji);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return message;
    }

    public static Message createVideoSendMessage(String filePath, String thumbImagePath, int fileLength, String toUserName) {
        File videoFile = new File(filePath);
        if (!videoFile.exists()) {
            EMLog.e((String)TAG, (String)"video file does not exist");
            return null;
        }
        Message message = Message.createSendMessage(Type.VIDEO);
        EMVideoMessageBody messageBody = new EMVideoMessageBody(filePath, thumbImagePath, fileLength, videoFile.length());
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createLocationSendMessage(double latitude, double longitude, String locAddress, String toUserName) {
        Message message = Message.createSendMessage(Type.LOCATION);
        EMLocationMessageBody messageBody = new EMLocationMessageBody(locAddress, latitude, longitude);
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createFileSendMessage(String filePath, String toUserName) {
        File file = new File(filePath);
        if (!file.exists()) {
            EMLog.e((String)TAG, (String)"file does not exist");
            return null;
        }
        Message message = Message.createSendMessage(Type.FILE);
        EMNormalFileMessageBody messageBody = new EMNormalFileMessageBody(file);
        message.setBody((EMMessageBody)messageBody);
        message.setTo(toUserName);
        return message;
    }

    public static Message createTranferToKefuMessage(String toUserName, ToCustomServiceInfo info) {
        Message cmdMessage = Message.createSendMessage(Type.CMD);
        cmdMessage.setTo(toUserName);
        EMCmdMessageBody cmdMessageBody = new EMCmdMessageBody("TransferToKf");
        cmdMessage.setBody((EMMessageBody)cmdMessageBody);
        cmdMessage.addContent(info);
        return cmdMessage;
    }

    public void addBody(EMMessageBody messageBody) {
        this.setBody(messageBody);
    }

    public void setBody(EMMessageBody messageBody) {
        this.body = messageBody;
    }

    public String from() {
        return this.from;
    }

    @Deprecated
    public String getFrom() {
        return this.from();
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String toUserName) {
        this.to = toUserName;
    }

    public String to() {
        return this.to;
    }

    @Deprecated
    public String getTo() {
        return this.to();
    }

    public String messageId() {
        return this.msgId;
    }

    @Deprecated
    public String getMsgId() {
        return this.messageId();
    }

    String getIMMsgId() {
        return this.imMsgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
        if (this.imMsgId == null) {
            this.imMsgId = msgId;
        }
    }

    void setIMMsgId(String imMsgId) {
        this.imMsgId = imMsgId;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status status() {
        return this.status;
    }

    @Deprecated
    public Status getStatus() {
        return this.status();
    }

    public void setMessageStatusCallback(Callback callBack) {
        this.messageStatusCallBack = callBack;
    }

    public Callback messageStatusCallback() {
        return this.messageStatusCallBack;
    }

    public String toString() {
        String sb = "msg{from:" + this.from + ", to:" + this.to + " body:" + this.body.toString();
        return sb;
    }

    public void setAttribute(String attr, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(attr, value);
    }

    public boolean getBooleanAttribute(String attr) throws HyphenateException {
        Boolean val = null;
        if (this.attributes != null) {
            Object test = this.attributes.get(attr);
            if (test instanceof Boolean) {
                val = (Boolean)test;
            } else if (test instanceof Integer) {
                int ival = (Integer)test;
                val = ival > 0;
            }
        }
        if (val == null) {
            throw new HyphenateException("attribute " + attr + " not found");
        }
        return val;
    }

    public boolean getBooleanAttribute(String attr, boolean defaultVal) {
        Boolean val = null;
        try {
            val = this.getBooleanAttribute(attr);
        }
        catch (HyphenateException hyphenateException) {
            // empty catch block
        }
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public int getIntAttribute(String attr, int defaultVal) {
        long lVal;
        Object val = null;
        if (this.attributes != null) {
            val = this.attributes.get(attr);
        }
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Long && (lVal = ((Long)val).longValue()) <= Integer.MAX_VALUE && lVal >= Integer.MIN_VALUE) {
            return (int)lVal;
        }
        return defaultVal;
    }

    public long getLongAttribute(String attr, long defaultVal) {
        Object val = null;
        if (this.attributes != null) {
            val = this.attributes.get(attr);
        }
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        return defaultVal;
    }

    public int getIntAttribute(String attr) throws HyphenateException {
        long lVal;
        Object val = null;
        if (this.attributes != null) {
            val = this.attributes.get(attr);
        }
        if (val == null) {
            throw new HyphenateException("attribute " + attr + " not found");
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Long && (lVal = ((Long)val).longValue()) <= Integer.MAX_VALUE && lVal >= Integer.MIN_VALUE) {
            return (int)lVal;
        }
        throw new HyphenateException("Value of attribute " + attr + " to int fail");
    }

    public long getLongAttribute(String attr) throws HyphenateException {
        Object val = null;
        if (this.attributes != null) {
            val = this.attributes.get(attr);
        }
        if (val == null) {
            throw new HyphenateException("attribute " + attr + " not found");
        }
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        throw new HyphenateException("Value of attribute " + attr + " to long fail");
    }

    public String getStringAttribute(String attr) throws HyphenateException {
        if (this.attributes != null && this.attributes.containsKey(attr)) {
            Object val = this.attributes.get(attr);
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof JSONObject) {
                return ((JSONObject)val).toString();
            }
            if (val instanceof JSONArray) {
                return ((JSONArray)val).toString();
            }
            throw new HyphenateException("attribute " + attr + " not String type");
        }
        throw new HyphenateException("attribute " + attr + " not found");
    }

    public String getStringAttribute(String attr, String defaultVal) {
        if (this.attributes != null && this.attributes.containsKey(attr)) {
            Object val = this.attributes.get(attr);
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof JSONObject) {
                return ((JSONObject)val).toString();
            }
            if (val instanceof JSONArray) {
                return ((JSONArray)val).toString();
            }
        }
        return defaultVal;
    }

    @Deprecated
    public boolean isNotificationMessage() {
        try {
            JSONObject weichatJson = this.getJSONObjectAttribute(KEY_WEICHAT);
            if (weichatJson != null && weichatJson.has("notification")) {
                return weichatJson.getBoolean("notification");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public JSONObject getJSONObjectAttribute(String attr) throws HyphenateException {
        if (this.attributes != null && this.attributes.containsKey(attr)) {
            Object val = this.attributes.get(attr);
            if (val instanceof JSONObject) {
                return (JSONObject)val;
            }
            if (val instanceof String) {
                try {
                    return new JSONObject((String)val);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            throw new HyphenateException("attribute " + attr + " not JSONObject type");
        }
        throw new HyphenateException("attribute " + attr + "  not found");
    }

    public JSONArray getJSONArrayAttribute(String attr) throws HyphenateException {
        if (this.attributes != null && this.attributes.containsKey(attr)) {
            Object val = this.attributes.get(attr);
            if (val instanceof JSONArray) {
                return (JSONArray)val;
            }
            if (val instanceof String) {
                try {
                    return new JSONArray((String)val);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            throw new HyphenateException("attribute " + attr + " does not JSONArray type");
        }
        throw new HyphenateException("attribute " + attr + " not found.");
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type.name());
        dest.writeString(this.direct.name());
        dest.writeString(this.msgId);
        dest.writeString(this.imMsgId);
        dest.writeLong(this.msgTime);
        dest.writeString(this.from);
        dest.writeString(this.to);
        dest.writeParcelable((Parcelable)this.body, flags);
        ArrayList<Pair> jsonObjects = new ArrayList<Pair>();
        ArrayList<Pair> jsonArrays = new ArrayList<Pair>();
        Hashtable<String, Object> tempAttrs = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof JSONObject) {
                jsonObjects.add(Pair.create((Object)entry.getKey(), (Object)((JSONObject)entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof JSONArray) {
                jsonArrays.add(Pair.create((Object)entry.getKey(), (Object)((JSONArray)entry.getValue())));
                continue;
            }
            tempAttrs.put(entry.getKey(), entry.getValue());
        }
        dest.writeInt(jsonObjects.size());
        for (Pair pair : jsonObjects) {
            dest.writeString((String)pair.first);
            dest.writeString(((JSONObject)pair.second).toString());
        }
        dest.writeInt(jsonArrays.size());
        for (Pair pair : jsonArrays) {
            dest.writeString((String)pair.first);
            dest.writeString(((JSONArray)pair.second).toString());
        }
        dest.writeMap(tempAttrs);
    }

    private Message(Parcel source) {
        this.type = Type.valueOf(source.readString());
        this.direct = Direct.valueOf(source.readString());
        this.msgId = source.readString();
        this.imMsgId = source.readString();
        this.msgTime = source.readLong();
        this.from = source.readString();
        this.to = source.readString();
        this.body = (EMMessageBody)source.readParcelable(Message.class.getClassLoader());
        this.attributes = new Hashtable();
        int jsonObjectCount = source.readInt();
        for (int i = 0; i < jsonObjectCount; ++i) {
            String key = source.readString();
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(source.readString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.attributes.put(key, jsonObject);
        }
        int jsonArrayCount = source.readInt();
        for (int i = 0; i < jsonArrayCount; ++i) {
            String key = source.readString();
            JSONArray jsonArray = null;
            try {
                jsonArray = new JSONArray(source.readString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.attributes.put(key, jsonArray);
        }
        Hashtable tempAttrs = new Hashtable();
        source.readMap(tempAttrs, null);
        this.attributes.putAll(tempAttrs);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    boolean isUnread() {
        return this.unread;
    }

    void setUnread(boolean unread) {
        this.unread = unread;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isListened() {
        return this.isListened;
    }

    public void setListened(boolean isListened) {
        this.isListened = isListened;
    }

    public Direct direct() {
        return this.direct;
    }

    void setDirection(Direct dir) {
        this.direct = dir;
    }

    public String getUserName() {
        String username = this.from() != null && this.from().equals(ChatClient.getInstance().currentUserName()) ? this.to() : this.from();
        return username;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int error() {
        return this.error;
    }

    @Deprecated
    public int getError() {
        return this.error();
    }

    public int describeContents() {
        return 0;
    }

    public Map<String, Object> ext() {
        return this.attributes;
    }

    public synchronized void addContent(Content content) {
        if (content == null) {
            return;
        }
        JSONObject container = MessageHelper.getContainerObject(this, content.getParentName());
        if (container == null) {
            container = new JSONObject();
        }
        try {
            if (content.getString() == null) {
                if (content.getName() != null) {
                    container.put(content.getName(), (Object)content.getContent());
                }
            } else if (content.getName() != null) {
                container.put(content.getName(), (Object)content.getString());
            }
            if (content.getParentName() != null) {
                this.setAttribute(content.getParentName(), container);
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)ex.getMessage());
        }
    }

    public synchronized void addContent(CompositeContent compositeContent) {
        Collection<Content> contents = compositeContent.getContents();
        if (contents != null && contents.size() > 0) {
            for (Content c : contents) {
                this.addContent(c);
            }
        }
    }

    OfficialAccount getOfficialAccount() {
        if (this.attributes != null && this.attributes.containsKey(KEY_WEICHAT)) {
            try {
                JSONObject jsonWeiChat = this.getJSONObjectAttribute(KEY_WEICHAT);
                if (jsonWeiChat != null && jsonWeiChat.has("official_account")) {
                    JSONObject jsonOffAccount = jsonWeiChat.getJSONObject("official_account");
                    OfficialAccount officialAccount = new OfficialAccount();
                    String id = jsonOffAccount.getString("official_account_id");
                    officialAccount.setId(id);
                    if (jsonOffAccount.has("name")) {
                        String name = jsonOffAccount.getString("name");
                        officialAccount.setName(name);
                    }
                    if (jsonOffAccount.has("type")) {
                        String type = jsonOffAccount.getString("type");
                        officialAccount.setType(type);
                    }
                    if (jsonOffAccount.has("img")) {
                        String img = jsonOffAccount.getString("img");
                        officialAccount.setImg(img);
                    }
                    return officialAccount;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    String getMarketingTaskId() {
        String marketings = this.getMarketings();
        if (marketings != null) {
            try {
                JSONObject jsonMarketing = new JSONObject(marketings);
                return jsonMarketing.getString("marketing_task_id");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    String getMarketings() {
        if (this.attributes != null && this.attributes.containsKey(KEY_WEICHAT)) {
            try {
                JSONObject jsonMarketing;
                JSONObject jsonWeiChat = this.getJSONObjectAttribute(KEY_WEICHAT);
                if (jsonWeiChat != null && jsonWeiChat.has("marketing") && (jsonMarketing = jsonWeiChat.getJSONObject("marketing")) != null && jsonMarketing.has("marketing_task_id")) {
                    return jsonMarketing.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public int getProgress() {
        return this.progress;
    }

    @Deprecated
    public void setProgress(int progress) {
        this.progress = progress;
    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD;

    }
}

