/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import com.hyphenate.util.CryptoUtils;

class PreferenceUtil {
    private static PreferenceUtil instance = new PreferenceUtil();
    private final String SHARED_FILE = "kefuinfo";
    private final String SHARED_KEY_UNAME = "username";
    private final String SHARED_KEY_UPASS = "password";
    private final String SHARED_KEY_ENCRYPTPASS = "encrypt_pass";
    private final String SHARED_KEY_TOKEN = "token";
    private final String SHARED_KEY_LOGIN_WITH_TOKEN = "login_with_token";
    private final String SHARED_KEY_SERVER_JSON = "server_json";
    private final String SHARED_KEY_UNIQUE_ID = "unique_id";
    private final String SHARED_KEY_TRIGGER_EVENT_TIME = "trigger_event_time";
    private Context mContext;
    private SharedPreferences sp;
    private SharedPreferences.Editor editor;
    private CryptoUtils cryptoUtils = new CryptoUtils();

    private PreferenceUtil() {
        this.cryptoUtils.initAES();
    }

    public static PreferenceUtil getInstance() {
        return instance;
    }

    public void init(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.sp = this.mContext.getSharedPreferences("kefuinfo", 0);
        this.editor = this.sp.edit();
    }

    public void setUsername(String uname) {
        this.editor.putString("username", uname);
        this.editor.commit();
    }

    void setUsernameAndPassword(String username, String password) {
        this.editor.putString("username", username);
        String tempPwd = password;
        try {
            tempPwd = this.cryptoUtils.encryptBase64String(tempPwd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editor.putString("encrypt_pass", tempPwd);
        this.editor.commit();
    }

    void setToken(String token) {
        this.editor.putString("token", token);
        this.editor.commit();
    }

    void saveLoginWithToken(boolean isToken) {
        this.editor.putBoolean("login_with_token", isToken);
        this.editor.commit();
    }

    String getPassword() {
        String tempPwd = this.sp.getString("encrypt_pass", null);
        if (tempPwd == null) {
            tempPwd = this.sp.getString("password", null);
        }
        if (tempPwd == null) {
            return null;
        }
        try {
            tempPwd = this.cryptoUtils.decryptBase64String(tempPwd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tempPwd;
    }

    public String getUsername() {
        return this.sp.getString("username", null);
    }

    String getToken() {
        return this.sp.getString("token", null);
    }

    String getServerJson() {
        return this.sp.getString("server_json", null);
    }

    boolean loginWithToken() {
        return this.sp.getBoolean("login_with_token", false);
    }

    void setServerJson(String serverJson) {
        this.editor.putString("server_json", serverJson);
        this.editor.commit();
    }

    void setUniqueId(String uuid) {
        this.editor.putString("unique_id", uuid);
        this.editor.commit();
    }

    String getUniqueId() {
        return this.sp.getString("unique_id", null);
    }

    void setTriggerEventTime(long triggerEventTime) {
        this.editor.putLong("trigger_event_time", triggerEventTime);
        this.editor.commit();
    }

    long getTriggerEventTime() {
        return this.sp.getLong("trigger_event_time", -1L);
    }

    void removeAll() {
        this.editor.remove("trigger_event_time");
        this.editor.remove("username");
        this.editor.remove("password");
        this.editor.remove("encrypt_pass");
        this.editor.remove("server_json");
        this.editor.remove("token");
        this.editor.commit();
    }
}

