/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class CustomTrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager;
    private X509TrustManager localTrustManager;
    private X509Certificate[] acceptedIssuers;

    static X509TrustManager findX509TrustManager(TrustManagerFactory tmf) {
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)tms[i];
        }
        return null;
    }

    public CustomTrustManager(KeyStore localKeyStore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            this.defaultTrustManager = CustomTrustManager.findX509TrustManager(tmf);
            if (this.defaultTrustManager == null) {
                throw new IllegalStateException("Couldn't find X509TrustManager");
            }
            this.localTrustManager = new LocalStoreX509TrustManager(localKeyStore);
            ArrayList<X509Certificate> allIssures = new ArrayList<X509Certificate>();
            allIssures.addAll(Arrays.asList(this.defaultTrustManager.getAcceptedIssuers()));
            allIssures.addAll(Arrays.asList(this.localTrustManager.getAcceptedIssuers()));
            this.acceptedIssuers = allIssures.toArray(new X509Certificate[allIssures.size()]);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.localTrustManager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.localTrustManager.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    static class LocalStoreX509TrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        LocalStoreX509TrustManager(KeyStore localTrustStore) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(localTrustStore);
                this.trustManager = CustomTrustManager.findX509TrustManager(tmf);
                if (this.trustManager == null) {
                    throw new IllegalStateException("Couldn't find X509TrustManager");
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

